/* src/bazaar.p/bz-verification-status.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-verification-status.h"



struct _BzVerificationStatus
{
  GObject parent_instance;

  gboolean verified;
  char *method;
  char *website;
  char *login_name;
  char *login_provider;
  char *timestamp;
  gboolean login_is_organization;
};

G_DEFINE_FINAL_TYPE (BzVerificationStatus, bz_verification_status, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_VERIFIED,
  PROP_METHOD,
  PROP_WEBSITE,
  PROP_LOGIN_NAME,
  PROP_LOGIN_PROVIDER,
  PROP_TIMESTAMP,
  PROP_LOGIN_IS_ORGANIZATION,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_verification_status_dispose (GObject *object)
{
  BzVerificationStatus *self = BZ_VERIFICATION_STATUS (object);

  g_clear_pointer (&self->method, g_free);
  g_clear_pointer (&self->website, g_free);
  g_clear_pointer (&self->login_name, g_free);
  g_clear_pointer (&self->login_provider, g_free);
  g_clear_pointer (&self->timestamp, g_free);

  G_OBJECT_CLASS (bz_verification_status_parent_class)->dispose (object);
}

static void
bz_verification_status_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzVerificationStatus *self = BZ_VERIFICATION_STATUS (object);

  switch (prop_id)
    {
    case PROP_VERIFIED:
      g_value_set_boolean (value, bz_verification_status_get_verified (self));
      break;
    case PROP_METHOD:
      g_value_set_string (value, bz_verification_status_get_method (self));
      break;
    case PROP_WEBSITE:
      g_value_set_string (value, bz_verification_status_get_website (self));
      break;
    case PROP_LOGIN_NAME:
      g_value_set_string (value, bz_verification_status_get_login_name (self));
      break;
    case PROP_LOGIN_PROVIDER:
      g_value_set_string (value, bz_verification_status_get_login_provider (self));
      break;
    case PROP_TIMESTAMP:
      g_value_set_string (value, bz_verification_status_get_timestamp (self));
      break;
    case PROP_LOGIN_IS_ORGANIZATION:
      g_value_set_boolean (value, bz_verification_status_get_login_is_organization (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_verification_status_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzVerificationStatus *self = BZ_VERIFICATION_STATUS (object);

  switch (prop_id)
    {
    case PROP_VERIFIED:
      bz_verification_status_set_verified (self, g_value_get_boolean (value));
      break;
    case PROP_METHOD:
      bz_verification_status_set_method (self, g_value_get_string (value));
      break;
    case PROP_WEBSITE:
      bz_verification_status_set_website (self, g_value_get_string (value));
      break;
    case PROP_LOGIN_NAME:
      bz_verification_status_set_login_name (self, g_value_get_string (value));
      break;
    case PROP_LOGIN_PROVIDER:
      bz_verification_status_set_login_provider (self, g_value_get_string (value));
      break;
    case PROP_TIMESTAMP:
      bz_verification_status_set_timestamp (self, g_value_get_string (value));
      break;
    case PROP_LOGIN_IS_ORGANIZATION:
      bz_verification_status_set_login_is_organization (self, g_value_get_boolean (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_verification_status_class_init (BzVerificationStatusClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);



  object_class->set_property = bz_verification_status_set_property;
  object_class->get_property = bz_verification_status_get_property;
  object_class->dispose      = bz_verification_status_dispose;

  props[PROP_VERIFIED] =
      g_param_spec_boolean (
          "verified",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_METHOD] =
      g_param_spec_string (
          "method",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_WEBSITE] =
      g_param_spec_string (
          "website",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_LOGIN_NAME] =
      g_param_spec_string (
          "login-name",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_LOGIN_PROVIDER] =
      g_param_spec_string (
          "login-provider",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_TIMESTAMP] =
      g_param_spec_string (
          "timestamp",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_LOGIN_IS_ORGANIZATION] =
      g_param_spec_boolean (
          "login-is-organization",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_verification_status_init (BzVerificationStatus *self)
{
}

BzVerificationStatus *
bz_verification_status_new (void){
  return g_object_new (BZ_TYPE_VERIFICATION_STATUS, NULL);
}

gboolean
bz_verification_status_get_verified (BzVerificationStatus *self){
  g_return_val_if_fail (BZ_IS_VERIFICATION_STATUS (self), FALSE);
  return self->verified;
}

const char *
bz_verification_status_get_method (BzVerificationStatus *self){
  g_return_val_if_fail (BZ_IS_VERIFICATION_STATUS (self), NULL);
  return self->method;
}

const char *
bz_verification_status_get_website (BzVerificationStatus *self){
  g_return_val_if_fail (BZ_IS_VERIFICATION_STATUS (self), NULL);
  return self->website;
}

const char *
bz_verification_status_get_login_name (BzVerificationStatus *self){
  g_return_val_if_fail (BZ_IS_VERIFICATION_STATUS (self), NULL);
  return self->login_name;
}

const char *
bz_verification_status_get_login_provider (BzVerificationStatus *self){
  g_return_val_if_fail (BZ_IS_VERIFICATION_STATUS (self), NULL);
  return self->login_provider;
}

const char *
bz_verification_status_get_timestamp (BzVerificationStatus *self){
  g_return_val_if_fail (BZ_IS_VERIFICATION_STATUS (self), NULL);
  return self->timestamp;
}

gboolean
bz_verification_status_get_login_is_organization (BzVerificationStatus *self){
  g_return_val_if_fail (BZ_IS_VERIFICATION_STATUS (self), FALSE);
  return self->login_is_organization;
}

void
bz_verification_status_set_verified (BzVerificationStatus *self,
    gboolean verified){
  g_return_if_fail (BZ_IS_VERIFICATION_STATUS (self));

  if (!!verified == !!self->verified)
    return;

  self->verified = verified;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_VERIFIED]);
}

void
bz_verification_status_set_method (BzVerificationStatus *self,
    const char *method){
  g_return_if_fail (BZ_IS_VERIFICATION_STATUS (self));

  if (method == self->method || (method != NULL && self->method != NULL && g_strcmp0(method, self->method) == 0))
    return;

  g_clear_pointer (&self->method, g_free);
  if (method != NULL)
    self->method = g_strdup (method);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_METHOD]);
}

void
bz_verification_status_set_website (BzVerificationStatus *self,
    const char *website){
  g_return_if_fail (BZ_IS_VERIFICATION_STATUS (self));

  if (website == self->website || (website != NULL && self->website != NULL && g_strcmp0(website, self->website) == 0))
    return;

  g_clear_pointer (&self->website, g_free);
  if (website != NULL)
    self->website = g_strdup (website);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_WEBSITE]);
}

void
bz_verification_status_set_login_name (BzVerificationStatus *self,
    const char *login_name){
  g_return_if_fail (BZ_IS_VERIFICATION_STATUS (self));

  if (login_name == self->login_name || (login_name != NULL && self->login_name != NULL && g_strcmp0(login_name, self->login_name) == 0))
    return;

  g_clear_pointer (&self->login_name, g_free);
  if (login_name != NULL)
    self->login_name = g_strdup (login_name);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_LOGIN_NAME]);
}

void
bz_verification_status_set_login_provider (BzVerificationStatus *self,
    const char *login_provider){
  g_return_if_fail (BZ_IS_VERIFICATION_STATUS (self));

  if (login_provider == self->login_provider || (login_provider != NULL && self->login_provider != NULL && g_strcmp0(login_provider, self->login_provider) == 0))
    return;

  g_clear_pointer (&self->login_provider, g_free);
  if (login_provider != NULL)
    self->login_provider = g_strdup (login_provider);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_LOGIN_PROVIDER]);
}

void
bz_verification_status_set_timestamp (BzVerificationStatus *self,
    const char *timestamp){
  g_return_if_fail (BZ_IS_VERIFICATION_STATUS (self));

  if (timestamp == self->timestamp || (timestamp != NULL && self->timestamp != NULL && g_strcmp0(timestamp, self->timestamp) == 0))
    return;

  g_clear_pointer (&self->timestamp, g_free);
  if (timestamp != NULL)
    self->timestamp = g_strdup (timestamp);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_TIMESTAMP]);
}

void
bz_verification_status_set_login_is_organization (BzVerificationStatus *self,
    gboolean login_is_organization){
  g_return_if_fail (BZ_IS_VERIFICATION_STATUS (self));

  if (!!login_is_organization == !!self->login_is_organization)
    return;

  self->login_is_organization = login_is_organization;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_LOGIN_IS_ORGANIZATION]);
}

/* End of src/bazaar.p/bz-verification-status.c */
