/* baobab-location-list.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-location-list.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "baobab.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <adwaita.h>

#define BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS 5
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define BAOBAB_TYPE_LOCATION_ROW (baobab_location_row_get_type ())
#define BAOBAB_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow))
#define BAOBAB_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowClass))
#define BAOBAB_IS_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION_ROW))
#define BAOBAB_IS_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION_ROW))
#define BAOBAB_LOCATION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRowClass))

typedef struct _BaobabLocationRow BaobabLocationRow;
typedef struct _BaobabLocationRowClass BaobabLocationRowClass;
typedef struct _BaobabLocationRowPrivate BaobabLocationRowPrivate;
enum  {
	BAOBAB_LOCATION_ROW_0_PROPERTY,
	BAOBAB_LOCATION_ROW_LOCATION_PROPERTY,
	BAOBAB_LOCATION_ROW_NUM_PROPERTIES
};
static GParamSpec* baobab_location_row_properties[BAOBAB_LOCATION_ROW_NUM_PROPERTIES];
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BAOBAB_LOCATION_LIST_0_PROPERTY,
	BAOBAB_LOCATION_LIST_NUM_PROPERTIES
};
static GParamSpec* baobab_location_list_properties[BAOBAB_LOCATION_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _gtk_recent_info_unref0(var) ((var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	BAOBAB_LOCATION_LIST_LOCATION_ACTIVATED_SIGNAL,
	BAOBAB_LOCATION_LIST_NUM_SIGNALS
};
static guint baobab_location_list_signals[BAOBAB_LOCATION_LIST_NUM_SIGNALS] = {0};

struct _BaobabLocationRow {
	GtkListBoxRow parent_instance;
	BaobabLocationRowPrivate * priv;
};

struct _BaobabLocationRowClass {
	GtkListBoxRowClass parent_class;
};

struct _BaobabLocationRowPrivate {
	GtkImage* image;
	GtkLabel* name_label;
	GtkLabel* path_label;
	GtkLabel* available_label;
	GtkLabel* total_size_label;
	GtkLevelBar* usage_bar;
	BaobabLocation* _location;
};

struct _BaobabLocationListPrivate {
	GtkListBox* local_list_box;
	GtkListBox* remote_list_box;
	AdwPreferencesGroup* remote_group;
	GVolumeMonitor* monitor;
	GList* locations;
};

struct _Block2Data {
	int _ref_count_;
	BaobabLocationList* self;
	GVolume* volume;
};

static gint BaobabLocationRow_private_offset;
static gpointer baobab_location_row_parent_class = NULL;
static gint BaobabLocationList_private_offset;
static gpointer baobab_location_list_parent_class = NULL;

VALA_EXTERN GType baobab_location_row_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BaobabLocationRow* baobab_location_row_new (BaobabLocation* l);
VALA_EXTERN BaobabLocationRow* baobab_location_row_construct (GType object_type,
                                                  BaobabLocation* l);
static void baobab_location_row_set_location (BaobabLocationRow* self,
                                       BaobabLocation* value);
VALA_EXTERN BaobabLocation* baobab_location_row_get_location (BaobabLocationRow* self);
static void baobab_location_row_update_fs_usage_info (BaobabLocationRow* self);
static void __lambda8_ (BaobabLocationRow* self);
static void ___lambda8__baobab_location_changed (BaobabLocation* _sender,
                                          gpointer self);
static guint64* _uint64_dup (guint64* self);
static void baobab_location_row_finalize (GObject * obj);
static GType baobab_location_row_get_type_once (void);
static void _vala_baobab_location_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_baobab_location_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _baobab_location_unref0_ (gpointer var);
static inline void _g_list_free__baobab_location_unref0_ (GList* self);
static void baobab_location_list_queue_query_fs_usage (BaobabLocationList* self);
static gboolean baobab_location_list_already_present (BaobabLocationList* self,
                                               GFile* file);
static void baobab_location_list_volume_changed (BaobabLocationList* self,
                                          GVolume* volume);
static void baobab_location_list_volume_removed (BaobabLocationList* self,
                                          GVolume* volume);
static void baobab_location_list_volume_added (BaobabLocationList* self,
                                        GVolume* volume);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda9_ (Block2Data* _data2_);
static void ___lambda9__g_volume_changed (GVolume* _sender,
                                   gpointer self);
static void baobab_location_list_mount_changed (BaobabLocationList* self,
                                         GMount* mount);
static void baobab_location_list_mount_removed (BaobabLocationList* self,
                                         GMount* mount);
static void baobab_location_list_mount_added (BaobabLocationList* self,
                                       GMount* mount);
static void baobab_location_list_populate (BaobabLocationList* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void baobab_location_list_populate_recent (BaobabLocationList* self);
static gint __lambda10_ (GtkRecentInfo* a,
                  GtkRecentInfo* b);
static gint ___lambda10__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void _gtk_recent_info_unref0_ (gpointer var);
static inline void _g_list_free__gtk_recent_info_unref0_ (GList* self);
static void baobab_location_list_row_activated (BaobabLocationList* self,
                                         GtkListBoxRow* row);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void gtk_recent_data_destroy (GtkRecentData * self);
static void g_cclosure_user_marshal_VOID__BAOBAB_LOCATION (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static GObject * baobab_location_list_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender,
                                                                         GMount* mount,
                                                                         gpointer self);
static void _baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                         GMount* mount,
                                                                         gpointer self);
static void _baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                     GMount* mount,
                                                                     gpointer self);
static void _baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                           GVolume* volume,
                                                                           gpointer self);
static void _baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                           GVolume* volume,
                                                                           gpointer self);
static void _baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                       GVolume* volume,
                                                                       gpointer self);
static void _baobab_location_list_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                     GtkListBoxRow* row,
                                                                     gpointer self);
static gboolean _baobab_location_list___lambda11_ (BaobabLocationList* self);
static gboolean __baobab_location_list___lambda11__gsource_func (gpointer self);
static void baobab_location_list_finalize (GObject * obj);
static GType baobab_location_list_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
baobab_location_row_get_instance_private (BaobabLocationRow* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabLocationRow_private_offset);
}

static void
__lambda8_ (BaobabLocationRow* self)
{
	baobab_location_row_update_fs_usage_info (self);
}

static void
___lambda8__baobab_location_changed (BaobabLocation* _sender,
                                     gpointer self)
{
	__lambda8_ ((BaobabLocationRow*) self);
}

BaobabLocationRow*
baobab_location_row_construct (GType object_type,
                               BaobabLocation* l)
{
	BaobabLocationRow * self = NULL;
	GtkImage* _tmp0_;
	BaobabLocation* _tmp1_;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	gchar* escaped = NULL;
	BaobabLocation* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkLabel* _tmp12_;
	BaobabLocation* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	PangoEllipsizeMode _tmp25_ = 0;
	BaobabLocation* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	GtkLabel* _tmp29_;
	BaobabLocation* _tmp30_;
	g_return_val_if_fail (l != NULL, NULL);
	self = (BaobabLocationRow*) g_object_new (object_type, NULL);
	baobab_location_row_set_location (self, l);
	_tmp0_ = self->priv->image;
	_tmp1_ = self->priv->_location;
	_tmp2_ = baobab_location_get_symbolic_icon (_tmp1_);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gicon", _tmp3_, NULL);
	_tmp4_ = self->priv->_location;
	_tmp5_ = baobab_location_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
	escaped = _tmp7_;
	_tmp8_ = self->priv->name_label;
	_tmp9_ = escaped;
	_tmp10_ = g_strdup_printf ("<b>%s</b>", _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp8_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = self->priv->path_label;
	gtk_widget_hide ((GtkWidget*) _tmp12_);
	_tmp13_ = self->priv->_location;
	_tmp14_ = baobab_location_get_file (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		GtkLabel* _tmp16_;
		BaobabLocation* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		GtkLabel* _tmp24_;
		_tmp16_ = self->priv->path_label;
		_tmp17_ = self->priv->_location;
		_tmp18_ = baobab_location_get_file (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_get_parse_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_markup_escape_text (_tmp21_, (gssize) -1);
		_tmp23_ = _tmp22_;
		gtk_label_set_label (_tmp16_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_tmp24_ = self->priv->path_label;
		gtk_widget_show ((GtkWidget*) _tmp24_);
	}
	_tmp26_ = self->priv->_location;
	_tmp27_ = baobab_location_get_is_remote (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		_tmp25_ = PANGO_ELLIPSIZE_END;
	} else {
		_tmp25_ = PANGO_ELLIPSIZE_START;
	}
	_tmp29_ = self->priv->path_label;
	gtk_label_set_ellipsize (_tmp29_, _tmp25_);
	baobab_location_row_update_fs_usage_info (self);
	_tmp30_ = self->priv->_location;
	g_signal_connect_object (_tmp30_, "changed", (GCallback) ___lambda8__baobab_location_changed, self, 0);
	_g_free0 (escaped);
	return self;
}

BaobabLocationRow*
baobab_location_row_new (BaobabLocation* l)
{
	return baobab_location_row_construct (BAOBAB_TYPE_LOCATION_ROW, l);
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

static void
baobab_location_row_update_fs_usage_info (BaobabLocationRow* self)
{
	GtkLabel* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	BaobabLocation* _tmp3_;
	GVolume* _tmp4_;
	GVolume* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->total_size_label;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp3_ = self->priv->_location;
	_tmp4_ = baobab_location_get_volume (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		BaobabLocation* _tmp6_;
		GMount* _tmp7_;
		GMount* _tmp8_;
		_tmp6_ = self->priv->_location;
		_tmp7_ = baobab_location_get_mount (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ != NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		BaobabLocation* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->_location;
		_tmp10_ = baobab_location_get_is_main_volume (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp1_ = _tmp11_;
	}
	if (_tmp1_) {
		BaobabLocation* _tmp12_;
		guint64* _tmp13_;
		guint64* _tmp14_;
		_tmp12_ = self->priv->_location;
		_tmp13_ = baobab_location_get_size (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ != NULL) {
			GtkLabel* _tmp15_;
			BaobabLocation* _tmp16_;
			guint64* _tmp17_;
			guint64* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GtkLabel* _tmp23_;
			BaobabLocation* _tmp24_;
			guint64* _tmp25_;
			guint64* _tmp26_;
			_tmp15_ = self->priv->total_size_label;
			_tmp16_ = self->priv->_location;
			_tmp17_ = baobab_location_get_size (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_format_size_full (*_tmp18_, G_FORMAT_SIZE_DEFAULT);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf (_ ("%s Total"), _tmp20_);
			_tmp22_ = _tmp21_;
			gtk_label_set_label (_tmp15_, _tmp22_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp23_ = self->priv->total_size_label;
			gtk_widget_show ((GtkWidget*) _tmp23_);
			_tmp24_ = self->priv->_location;
			_tmp25_ = baobab_location_get_used (_tmp24_);
			_tmp26_ = _tmp25_;
			if (_tmp26_ != NULL) {
				guint64* _tmp27_ = NULL;
				BaobabLocation* _tmp28_;
				guint64* _tmp29_;
				guint64* _tmp30_;
				guint64* _tmp31_;
				guint64 actually_used = 0ULL;
				BaobabLocation* _tmp34_;
				guint64* _tmp35_;
				guint64* _tmp36_;
				GtkLabel* _tmp37_;
				BaobabLocation* _tmp38_;
				guint64* _tmp39_;
				guint64* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				GtkLevelBar* _tmp45_;
				BaobabLocation* _tmp46_;
				guint64* _tmp47_;
				guint64* _tmp48_;
				GtkLevelBar* _tmp49_;
				BaobabLocation* _tmp50_;
				guint64* _tmp51_;
				guint64* _tmp52_;
				GtkLevelBar* _tmp53_;
				GtkLevelBar* _tmp54_;
				_tmp28_ = self->priv->_location;
				_tmp29_ = baobab_location_get_reserved (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = __uint64_dup0 (_tmp30_);
				_tmp27_ = _tmp31_;
				if (_tmp27_ == NULL) {
					guint64 _tmp32_;
					guint64* _tmp33_;
					_tmp32_ = (guint64) 0;
					_tmp33_ = __uint64_dup0 (&_tmp32_);
					_g_free0 (_tmp27_);
					_tmp27_ = _tmp33_;
				}
				_tmp34_ = self->priv->_location;
				_tmp35_ = baobab_location_get_used (_tmp34_);
				_tmp36_ = _tmp35_;
				actually_used = (*_tmp36_) + (*_tmp27_);
				_tmp37_ = self->priv->available_label;
				_tmp38_ = self->priv->_location;
				_tmp39_ = baobab_location_get_size (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_format_size_full ((*_tmp40_) - actually_used, G_FORMAT_SIZE_DEFAULT);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf (_ ("%s Available"), _tmp42_);
				_tmp44_ = _tmp43_;
				gtk_label_set_label (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_tmp45_ = self->priv->usage_bar;
				_tmp46_ = self->priv->_location;
				_tmp47_ = baobab_location_get_size (_tmp46_);
				_tmp48_ = _tmp47_;
				gtk_level_bar_set_max_value (_tmp45_, *_tmp48_);
				_tmp49_ = self->priv->usage_bar;
				_tmp50_ = self->priv->_location;
				_tmp51_ = baobab_location_get_size (_tmp50_);
				_tmp52_ = _tmp51_;
				gtk_level_bar_add_offset_value (_tmp49_, GTK_LEVEL_BAR_OFFSET_LOW, 0.9 * (*_tmp52_));
				_tmp53_ = self->priv->usage_bar;
				gtk_level_bar_set_value (_tmp53_, (gdouble) actually_used);
				_tmp54_ = self->priv->usage_bar;
				gtk_widget_show ((GtkWidget*) _tmp54_);
				_g_free0 (_tmp27_);
			} else {
				GtkLabel* _tmp55_;
				_tmp55_ = self->priv->available_label;
				gtk_label_set_label (_tmp55_, _ ("Unknown"));
			}
		} else {
			BaobabLocation* _tmp56_;
			guint64* _tmp57_;
			guint64* _tmp58_;
			_tmp56_ = self->priv->_location;
			_tmp57_ = baobab_location_get_used (_tmp56_);
			_tmp58_ = _tmp57_;
			if (_tmp58_ != NULL) {
				GtkLabel* _tmp59_;
				BaobabLocation* _tmp60_;
				guint64* _tmp61_;
				guint64* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				_tmp59_ = self->priv->available_label;
				_tmp60_ = self->priv->_location;
				_tmp61_ = baobab_location_get_used (_tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_format_size_full (*_tmp62_, G_FORMAT_SIZE_DEFAULT);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup_printf (_ ("%s Used"), _tmp64_);
				_tmp66_ = _tmp65_;
				gtk_label_set_label (_tmp59_, _tmp66_);
				_g_free0 (_tmp66_);
				_g_free0 (_tmp64_);
			} else {
				gboolean _tmp67_ = FALSE;
				gboolean _tmp68_ = FALSE;
				BaobabLocation* _tmp69_;
				GVolume* _tmp70_;
				GVolume* _tmp71_;
				_tmp69_ = self->priv->_location;
				_tmp70_ = baobab_location_get_volume (_tmp69_);
				_tmp71_ = _tmp70_;
				if (_tmp71_ != NULL) {
					BaobabLocation* _tmp72_;
					GMount* _tmp73_;
					GMount* _tmp74_;
					_tmp72_ = self->priv->_location;
					_tmp73_ = baobab_location_get_mount (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp68_ = _tmp74_ == NULL;
				} else {
					_tmp68_ = FALSE;
				}
				if (_tmp68_) {
					BaobabLocation* _tmp75_;
					GVolume* _tmp76_;
					GVolume* _tmp77_;
					_tmp75_ = self->priv->_location;
					_tmp76_ = baobab_location_get_volume (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp67_ = g_volume_can_mount (_tmp77_);
				} else {
					_tmp67_ = FALSE;
				}
				if (_tmp67_) {
					GtkLabel* _tmp78_;
					_tmp78_ = self->priv->available_label;
					gtk_label_set_label (_tmp78_, _ ("Unmounted"));
				}
			}
		}
	}
}

BaobabLocation*
baobab_location_row_get_location (BaobabLocationRow* self)
{
	BaobabLocation* result;
	BaobabLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static gpointer
_baobab_location_ref0 (gpointer self)
{
	return self ? baobab_location_ref (self) : NULL;
}

static void
baobab_location_row_set_location (BaobabLocationRow* self,
                                  BaobabLocation* value)
{
	BaobabLocation* old_value;
	g_return_if_fail (self != NULL);
	old_value = baobab_location_row_get_location (self);
	if (old_value != value) {
		BaobabLocation* _tmp0_;
		_tmp0_ = _baobab_location_ref0 (value);
		_baobab_location_unref0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, baobab_location_row_properties[BAOBAB_LOCATION_ROW_LOCATION_PROPERTY]);
	}
}

static void
baobab_location_row_class_init (BaobabLocationRowClass * klass,
                                gpointer klass_data)
{
	baobab_location_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabLocationRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_location_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_location_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_location_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_LOCATION_ROW_LOCATION_PROPERTY, baobab_location_row_properties[BAOBAB_LOCATION_ROW_LOCATION_PROPERTY] = baobab_param_spec_location ("location", "location", "location", BAOBAB_TYPE_LOCATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-location-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "path_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, path_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "available_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, available_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "total_size_label", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, total_size_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "usage_bar", FALSE, BaobabLocationRow_private_offset + G_STRUCT_OFFSET (BaobabLocationRowPrivate, usage_bar));
}

static void
baobab_location_row_instance_init (BaobabLocationRow * self,
                                   gpointer klass)
{
	self->priv = baobab_location_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
baobab_location_row_finalize (GObject * obj)
{
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	_baobab_location_unref0 (self->priv->_location);
	G_OBJECT_CLASS (baobab_location_row_parent_class)->finalize (obj);
}

static GType
baobab_location_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocationRow), 0, (GInstanceInitFunc) baobab_location_row_instance_init, NULL };
	GType baobab_location_row_type_id;
	baobab_location_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "BaobabLocationRow", &g_define_type_info, 0);
	BaobabLocationRow_private_offset = g_type_add_instance_private (baobab_location_row_type_id, sizeof (BaobabLocationRowPrivate));
	return baobab_location_row_type_id;
}

GType
baobab_location_row_get_type (void)
{
	static volatile gsize baobab_location_row_type_id__once = 0;
	if (g_once_init_enter (&baobab_location_row_type_id__once)) {
		GType baobab_location_row_type_id;
		baobab_location_row_type_id = baobab_location_row_get_type_once ();
		g_once_init_leave (&baobab_location_row_type_id__once, baobab_location_row_type_id);
	}
	return baobab_location_row_type_id__once;
}

static void
_vala_baobab_location_row_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	switch (property_id) {
		case BAOBAB_LOCATION_ROW_LOCATION_PROPERTY:
		baobab_value_set_location (value, baobab_location_row_get_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_location_row_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BaobabLocationRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_LOCATION_ROW, BaobabLocationRow);
	switch (property_id) {
		case BAOBAB_LOCATION_ROW_LOCATION_PROPERTY:
		baobab_location_row_set_location (self, baobab_value_get_location (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
baobab_location_list_get_instance_private (BaobabLocationList* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabLocationList_private_offset);
}

static void
_baobab_location_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL));
}

static inline void
_g_list_free__baobab_location_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _baobab_location_unref0_);
}

static void
baobab_location_list_queue_query_fs_usage (BaobabLocationList* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				_tmp2_ = location;
				baobab_location_queue_query_fs_usage (_tmp2_);
				_baobab_location_unref0 (location);
			}
		}
	}
}

static gboolean
baobab_location_list_already_present (BaobabLocationList* self,
                                      GFile* file)
{
	GList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp0_ = self->priv->locations;
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
		l_collection = _tmp0_;
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* l = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) l_it->data);
			l = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				BaobabLocation* _tmp3_;
				GFile* _tmp4_;
				GFile* _tmp5_;
				_tmp3_ = l;
				_tmp4_ = baobab_location_get_file (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ != NULL) {
					BaobabLocation* _tmp6_;
					GFile* _tmp7_;
					GFile* _tmp8_;
					_tmp6_ = l;
					_tmp7_ = baobab_location_get_file (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp2_ = g_file_equal (_tmp8_, file);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					result = TRUE;
					_baobab_location_unref0 (l);
					return result;
				}
				_baobab_location_unref0 (l);
			}
		}
	}
	result = FALSE;
	return result;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
baobab_location_list_volume_changed (BaobabLocationList* self,
                                     GVolume* volume)
{
	GList* _tmp0_;
	GMount* mount = NULL;
	GMount* _tmp6_;
	GMount* _tmp7_;
	GList* remove_list = NULL;
	GList* _tmp8_;
	GList* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				GVolume* _tmp3_;
				GVolume* _tmp4_;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_volume (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == volume) {
					BaobabLocation* _tmp5_;
					_tmp5_ = location;
					baobab_location_update_volume_info (_tmp5_);
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	_tmp6_ = g_volume_get_mount (volume);
	mount = _tmp6_;
	_tmp7_ = mount;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (mount);
		return;
	}
	remove_list = NULL;
	_tmp8_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp8_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp9_;
			BaobabLocation* location = NULL;
			_tmp9_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp9_;
			{
				gboolean _tmp10_ = FALSE;
				BaobabLocation* _tmp11_;
				GMount* _tmp12_;
				GMount* _tmp13_;
				gboolean same_mount = FALSE;
				gboolean _tmp22_ = FALSE;
				_tmp11_ = location;
				_tmp12_ = baobab_location_get_mount (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ != NULL) {
					BaobabLocation* _tmp14_;
					GMount* _tmp15_;
					GMount* _tmp16_;
					GFile* _tmp17_;
					GFile* _tmp18_;
					GMount* _tmp19_;
					GFile* _tmp20_;
					GFile* _tmp21_;
					_tmp14_ = location;
					_tmp15_ = baobab_location_get_mount (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_mount_get_root (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = mount;
					_tmp20_ = g_mount_get_root (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp10_ = g_file_equal (_tmp18_, _tmp21_);
					_g_object_unref0 (_tmp21_);
					_g_object_unref0 (_tmp18_);
				} else {
					_tmp10_ = FALSE;
				}
				same_mount = _tmp10_;
				if (same_mount) {
					BaobabLocation* _tmp23_;
					GVolume* _tmp24_;
					GVolume* _tmp25_;
					_tmp23_ = location;
					_tmp24_ = baobab_location_get_volume (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp22_ = _tmp25_ != volume;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					BaobabLocation* _tmp26_;
					BaobabLocation* _tmp27_;
					_tmp26_ = location;
					_tmp27_ = _baobab_location_ref0 (_tmp26_);
					remove_list = g_list_append (remove_list, _tmp27_);
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	_tmp28_ = remove_list;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp28_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp29_;
			BaobabLocation* location = NULL;
			_tmp29_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp29_;
			{
				BaobabLocation* _tmp30_;
				_tmp30_ = location;
				self->priv->locations = vala_g_list_remove_full (self->priv->locations, _tmp30_, _baobab_location_unref0_);
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
	(remove_list == NULL) ? NULL : (remove_list = (_g_list_free__baobab_location_unref0_ (remove_list), NULL));
	_g_object_unref0 (mount);
}

static void
baobab_location_list_volume_removed (BaobabLocationList* self,
                                     GVolume* volume)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp0_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp1_;
			BaobabLocation* location = NULL;
			_tmp1_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp1_;
			{
				BaobabLocation* _tmp2_;
				GVolume* _tmp3_;
				GVolume* _tmp4_;
				_tmp2_ = location;
				_tmp3_ = baobab_location_get_volume (_tmp2_);
				_tmp4_ = _tmp3_;
				if (_tmp4_ == volume) {
					BaobabLocation* _tmp5_;
					_tmp5_ = location;
					self->priv->locations = vala_g_list_remove_full (self->priv->locations, _tmp5_, _baobab_location_unref0_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BaobabLocationList* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->volume);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda9_ (Block2Data* _data2_)
{
	BaobabLocationList* self;
	self = _data2_->self;
	baobab_location_list_volume_changed (self, _data2_->volume);
}

static void
___lambda9__g_volume_changed (GVolume* _sender,
                              gpointer self)
{
	__lambda9_ (self);
}

static void
baobab_location_list_volume_added (BaobabLocationList* self,
                                   GVolume* volume)
{
	Block2Data* _data2_;
	GVolume* _tmp0_;
	BaobabLocation* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (volume);
	_g_object_unref0 (_data2_->volume);
	_data2_->volume = _tmp0_;
	_tmp1_ = baobab_location_new_from_volume (_data2_->volume);
	self->priv->locations = g_list_append (self->priv->locations, _tmp1_);
	g_signal_connect_data (_data2_->volume, "changed", (GCallback) ___lambda9__g_volume_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	baobab_location_list_update (self);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
baobab_location_list_mount_changed (BaobabLocationList* self,
                                    GMount* mount)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
}

static void
baobab_location_list_mount_removed (BaobabLocationList* self,
                                    GMount* mount)
{
	GVolume* volume = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = g_mount_get_volume (mount);
	volume = _tmp0_;
	_tmp1_ = volume;
	if (_tmp1_ != NULL) {
		GVolume* _tmp2_;
		_tmp2_ = volume;
		baobab_location_list_volume_changed (self, _tmp2_);
	}
	_tmp3_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp3_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp4_;
			BaobabLocation* location = NULL;
			_tmp4_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				BaobabLocation* _tmp6_;
				GMount* _tmp7_;
				GMount* _tmp8_;
				_tmp6_ = location;
				_tmp7_ = baobab_location_get_mount (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ == mount) {
					BaobabLocation* _tmp9_;
					GVolume* _tmp10_;
					GVolume* _tmp11_;
					_tmp9_ = location;
					_tmp10_ = baobab_location_get_volume (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp5_ = _tmp11_ == NULL;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					BaobabLocation* _tmp12_;
					_tmp12_ = location;
					self->priv->locations = vala_g_list_remove_full (self->priv->locations, _tmp12_, _baobab_location_unref0_);
					_baobab_location_unref0 (location);
					break;
				}
				_baobab_location_unref0 (location);
			}
		}
	}
	baobab_location_list_update (self);
	_g_object_unref0 (volume);
}

static void
baobab_location_list_mount_added (BaobabLocationList* self,
                                  GMount* mount)
{
	GVolume* volume = NULL;
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = g_mount_get_volume (mount);
	volume = _tmp0_;
	_tmp1_ = volume;
	if (_tmp1_ == NULL) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = g_mount_get_root (mount);
		_tmp3_ = _tmp2_;
		_tmp4_ = !baobab_location_list_already_present (self, _tmp3_);
		_g_object_unref0 (_tmp3_);
		if (_tmp4_) {
			BaobabLocation* _tmp5_;
			_tmp5_ = baobab_location_new_from_mount (mount);
			self->priv->locations = g_list_append (self->priv->locations, _tmp5_);
		}
	} else {
		GVolume* _tmp6_;
		_tmp6_ = volume;
		baobab_location_list_volume_changed (self, _tmp6_);
	}
	baobab_location_list_update (self);
	_g_object_unref0 (volume);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
baobab_location_list_populate (BaobabLocationList* self)
{
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GList* _tmp3_;
	GVolumeMonitor* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_location_new_for_home_folder ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp0_);
	_tmp1_ = baobab_location_new_for_main_volume ();
	self->priv->locations = g_list_append (self->priv->locations, _tmp1_);
	_tmp2_ = self->priv->monitor;
	_tmp3_ = g_volume_monitor_get_volumes (_tmp2_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp3_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp4_;
			GVolume* volume = NULL;
			_tmp4_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp4_;
			{
				GVolume* _tmp5_;
				_tmp5_ = volume;
				baobab_location_list_volume_added (self, _tmp5_);
				_g_object_unref0 (volume);
			}
		}
		(volume_collection == NULL) ? NULL : (volume_collection = (_g_list_free__g_object_unref0_ (volume_collection), NULL));
	}
	_tmp6_ = self->priv->monitor;
	_tmp7_ = g_volume_monitor_get_mounts (_tmp6_);
	{
		GList* mount_collection = NULL;
		GList* mount_it = NULL;
		mount_collection = _tmp7_;
		for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
			GMount* _tmp8_;
			GMount* mount = NULL;
			_tmp8_ = _g_object_ref0 ((GMount*) mount_it->data);
			mount = _tmp8_;
			{
				GMount* _tmp9_;
				_tmp9_ = mount;
				baobab_location_list_mount_added (self, _tmp9_);
				_g_object_unref0 (mount);
			}
		}
		(mount_collection == NULL) ? NULL : (mount_collection = (_g_list_free__g_object_unref0_ (mount_collection), NULL));
	}
	baobab_location_list_populate_recent (self);
	baobab_location_list_update (self);
}

static gint
__lambda10_ (GtkRecentInfo* a,
             GtkRecentInfo* b)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = gtk_recent_info_get_modified (b);
	_tmp1_ = gtk_recent_info_get_modified (a);
	result = (gint) g_date_time_difference (_tmp0_, _tmp1_);
	return result;
}

static gint
___lambda10__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda10_ ((GtkRecentInfo*) a, (GtkRecentInfo*) b);
	return result;
}

static void
_gtk_recent_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gtk_recent_info_unref (var), NULL));
}

static inline void
_g_list_free__gtk_recent_info_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gtk_recent_info_unref0_);
}

static gpointer
_gtk_recent_info_ref0 (gpointer self)
{
	return self ? gtk_recent_info_ref (self) : NULL;
}

static void
baobab_location_list_populate_recent (BaobabLocationList* self)
{
	GtkRecentManager* recent_manager = NULL;
	GtkRecentManager* _tmp0_;
	GtkRecentManager* _tmp1_;
	GList* recent_items = NULL;
	GtkRecentManager* _tmp2_;
	GList* _tmp3_;
	GList* iter = NULL;
	GList* _tmp4_;
	GList* last = NULL;
	GList* _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	GList* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_recent_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	recent_manager = _tmp1_;
	_tmp2_ = recent_manager;
	_tmp3_ = gtk_recent_manager_get_items (_tmp2_);
	recent_items = _tmp3_;
	_tmp4_ = recent_items;
	iter = _tmp4_;
	while (TRUE) {
		GList* _tmp5_;
		GList* next = NULL;
		GList* _tmp6_;
		GList* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		GList* _tmp20_;
		_tmp5_ = iter;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = iter;
		_tmp7_ = _tmp6_->next;
		next = _tmp7_;
		_tmp10_ = iter;
		_tmp11_ = _tmp10_->data;
		if (!gtk_recent_info_has_group ((GtkRecentInfo*) _tmp11_, "baobab")) {
			_tmp9_ = TRUE;
		} else {
			GList* _tmp12_;
			gconstpointer _tmp13_;
			_tmp12_ = iter;
			_tmp13_ = _tmp12_->data;
			_tmp9_ = !gtk_recent_info_exists ((GtkRecentInfo*) _tmp13_);
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			GList* _tmp14_;
			gconstpointer _tmp15_;
			const gchar* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			_tmp14_ = iter;
			_tmp15_ = _tmp14_->data;
			_tmp16_ = gtk_recent_info_get_uri ((GtkRecentInfo*) _tmp15_);
			_tmp17_ = g_file_new_for_uri (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp8_ = baobab_location_list_already_present (self, _tmp18_);
			_g_object_unref0 (_tmp18_);
		}
		if (_tmp8_) {
			GList* _tmp19_;
			_tmp19_ = iter;
			recent_items = g_list_remove_link (recent_items, _tmp19_);
		}
		_tmp20_ = next;
		iter = _tmp20_;
	}
	recent_items = g_list_sort (recent_items, ___lambda10__gcompare_func);
	_tmp21_ = recent_items;
	_tmp22_ = g_list_nth (_tmp21_, (guint) (BAOBAB_LOCATION_LIST_MAX_RECENT_LOCATIONS - 1));
	last = _tmp22_;
	_tmp23_ = last;
	if (_tmp23_ != NULL) {
		GList* _tmp24_;
		_tmp24_ = last;
		(_tmp24_->next == NULL) ? NULL : (_tmp24_->next = (_g_list_free__gtk_recent_info_unref0_ (_tmp24_->next), NULL));
		_tmp24_->next = NULL;
	}
	_tmp25_ = recent_items;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp25_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GtkRecentInfo* _tmp26_;
			GtkRecentInfo* info = NULL;
			_tmp26_ = _gtk_recent_info_ref0 ((GtkRecentInfo*) info_it->data);
			info = _tmp26_;
			{
				GtkRecentInfo* _tmp27_;
				BaobabLocation* _tmp28_;
				_tmp27_ = info;
				_tmp28_ = baobab_location_new_for_recent_info (_tmp27_);
				self->priv->locations = g_list_append (self->priv->locations, _tmp28_);
				_gtk_recent_info_unref0 (info);
			}
		}
	}
	(recent_items == NULL) ? NULL : (recent_items = (_g_list_free__gtk_recent_info_unref0_ (recent_items), NULL));
	_g_object_unref0 (recent_manager);
}

static void
baobab_location_list_row_activated (BaobabLocationList* self,
                                    GtkListBoxRow* row)
{
	BaobabLocationRow* location_widget = NULL;
	BaobabLocationRow* _tmp0_;
	BaobabLocation* _tmp1_;
	BaobabLocation* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (BAOBAB_IS_LOCATION_ROW (row) ? ((BaobabLocationRow*) row) : NULL);
	location_widget = _tmp0_;
	_tmp1_ = baobab_location_row_get_location (location_widget);
	_tmp2_ = _tmp1_;
	g_signal_emit (self, baobab_location_list_signals[BAOBAB_LOCATION_LIST_LOCATION_ACTIVATED_SIGNAL], 0, _tmp2_);
	_g_object_unref0 (location_widget);
}

void
baobab_location_list_update (BaobabLocationList* self)
{
	AdwPreferencesGroup* _tmp20_;
	GList* _tmp21_;
	g_return_if_fail (self != NULL);
	{
		GtkWidget* child = NULL;
		GtkListBox* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = self->priv->local_list_box;
		_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		child = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp7_;
				GtkListBox* _tmp8_;
				GtkWidget* _tmp9_;
				if (!_tmp3_) {
					GtkListBox* _tmp4_;
					GtkWidget* _tmp5_;
					GtkWidget* _tmp6_;
					_tmp4_ = self->priv->local_list_box;
					_tmp5_ = gtk_widget_get_first_child ((GtkWidget*) _tmp4_);
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (child);
					child = _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = child;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = self->priv->local_list_box;
				_tmp9_ = child;
				gtk_list_box_remove (_tmp8_, _tmp9_);
			}
		}
		_g_object_unref0 (child);
	}
	{
		GtkWidget* child = NULL;
		GtkListBox* _tmp10_;
		GtkWidget* _tmp11_;
		GtkWidget* _tmp12_;
		_tmp10_ = self->priv->remote_list_box;
		_tmp11_ = gtk_widget_get_first_child ((GtkWidget*) _tmp10_);
		_tmp12_ = _g_object_ref0 (_tmp11_);
		child = _tmp12_;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp17_;
				GtkListBox* _tmp18_;
				GtkWidget* _tmp19_;
				if (!_tmp13_) {
					GtkListBox* _tmp14_;
					GtkWidget* _tmp15_;
					GtkWidget* _tmp16_;
					_tmp14_ = self->priv->remote_list_box;
					_tmp15_ = gtk_widget_get_first_child ((GtkWidget*) _tmp14_);
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (child);
					child = _tmp16_;
				}
				_tmp13_ = FALSE;
				_tmp17_ = child;
				if (!(_tmp17_ != NULL)) {
					break;
				}
				_tmp18_ = self->priv->remote_list_box;
				_tmp19_ = child;
				gtk_list_box_remove (_tmp18_, _tmp19_);
			}
		}
		_g_object_unref0 (child);
	}
	_tmp20_ = self->priv->remote_group;
	gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
	_tmp21_ = self->priv->locations;
	{
		GList* location_collection = NULL;
		GList* location_it = NULL;
		location_collection = _tmp21_;
		for (location_it = location_collection; location_it != NULL; location_it = location_it->next) {
			BaobabLocation* _tmp22_;
			BaobabLocation* location = NULL;
			_tmp22_ = _baobab_location_ref0 ((BaobabLocation*) location_it->data);
			location = _tmp22_;
			{
				BaobabLocation* _tmp23_;
				gboolean _tmp24_;
				gboolean _tmp25_;
				_tmp23_ = location;
				_tmp24_ = baobab_location_get_is_remote (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_) {
					GtkListBox* _tmp26_;
					BaobabLocation* _tmp27_;
					BaobabLocationRow* _tmp28_;
					BaobabLocationRow* _tmp29_;
					AdwPreferencesGroup* _tmp30_;
					_tmp26_ = self->priv->remote_list_box;
					_tmp27_ = location;
					_tmp28_ = baobab_location_row_new (_tmp27_);
					g_object_ref_sink (_tmp28_);
					_tmp29_ = _tmp28_;
					gtk_list_box_append (_tmp26_, (GtkWidget*) _tmp29_);
					_g_object_unref0 (_tmp29_);
					_tmp30_ = self->priv->remote_group;
					gtk_widget_set_visible ((GtkWidget*) _tmp30_, TRUE);
				} else {
					GtkListBox* _tmp31_;
					BaobabLocation* _tmp32_;
					BaobabLocationRow* _tmp33_;
					BaobabLocationRow* _tmp34_;
					_tmp31_ = self->priv->local_list_box;
					_tmp32_ = location;
					_tmp33_ = baobab_location_row_new (_tmp32_);
					g_object_ref_sink (_tmp33_);
					_tmp34_ = _tmp33_;
					gtk_list_box_append (_tmp31_, (GtkWidget*) _tmp34_);
					_g_object_unref0 (_tmp34_);
				}
				_baobab_location_unref0 (location);
			}
		}
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
gtk_recent_data_destroy (GtkRecentData * self)
{
	_g_free0 ((*self).display_name);
	_g_free0 ((*self).description);
	_g_free0 ((*self).mime_type);
	_g_free0 ((*self).app_name);
	_g_free0 ((*self).app_exec);
	(*self).groups = (_vala_array_free ((*self).groups, _vala_array_length ((*self).groups), (GDestroyNotify) g_free), NULL);
}

void
baobab_location_list_add_location (BaobabLocationList* self,
                                   BaobabLocation* location)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GtkRecentData data = {0};
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** groups = NULL;
	gchar** _tmp7_;
	gint groups_length1;
	gint _groups_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GtkRecentManager* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GtkRecentData _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = baobab_location_get_file (location);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	memset (&data, 0, sizeof (GtkRecentData));
	_g_free0 (data.display_name);
	data.display_name = NULL;
	_g_free0 (data.description);
	data.description = NULL;
	_tmp2_ = g_strdup ("inode/directory");
	_g_free0 (data.mime_type);
	data.mime_type = _tmp2_;
	_tmp3_ = g_get_application_name ();
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (data.app_name);
	data.app_name = _tmp4_;
	_tmp5_ = g_get_prgname ();
	_tmp6_ = g_strdup_printf ("%s %%u", _tmp5_);
	_g_free0 (data.app_exec);
	data.app_exec = _tmp6_;
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	groups = _tmp7_;
	groups_length1 = 2;
	_groups_size_ = groups_length1;
	_tmp8_ = groups;
	_tmp8__length1 = groups_length1;
	_tmp9_ = g_strdup ("baobab");
	_g_free0 (_tmp8_[0]);
	_tmp8_[0] = _tmp9_;
	_tmp10_ = groups;
	_tmp10__length1 = groups_length1;
	_g_free0 (_tmp10_[1]);
	_tmp10_[1] = NULL;
	_tmp11_ = groups;
	_tmp11__length1 = groups_length1;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup1 (_tmp11_, _tmp11__length1) : _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	data.groups = (_vala_array_free (data.groups, _vala_array_length (data.groups), (GDestroyNotify) g_free), NULL);
	data.groups = _tmp12_;
	_tmp13_ = gtk_recent_manager_get_default ();
	_tmp14_ = baobab_location_get_file (location);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_file_get_uri (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = data;
	gtk_recent_manager_add_full (_tmp13_, _tmp17_, &_tmp18_);
	_g_free0 (_tmp17_);
	baobab_location_list_clear_recent (self, FALSE);
	baobab_location_list_populate_recent (self);
	baobab_location_list_update (self);
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_free), NULL);
	gtk_recent_data_destroy (&data);
}

void
baobab_location_list_clear_recent (BaobabLocationList* self,
                                   gboolean remove_from_recent_manager)
{
	GList* iter = NULL;
	GList* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->locations;
	iter = _tmp0_;
	while (TRUE) {
		GList* _tmp1_;
		GList* next = NULL;
		GList* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		GList* _tmp18_;
		_tmp1_ = iter;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = iter;
		_tmp3_ = _tmp2_->next;
		next = _tmp3_;
		_tmp4_ = iter;
		_tmp5_ = _tmp4_->data;
		_tmp6_ = baobab_location_get_is_recent ((BaobabLocation*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			{
				GList* _tmp15_;
				if (remove_from_recent_manager) {
					GtkRecentManager* _tmp8_;
					GList* _tmp9_;
					gconstpointer _tmp10_;
					GFile* _tmp11_;
					GFile* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp8_ = gtk_recent_manager_get_default ();
					_tmp9_ = iter;
					_tmp10_ = _tmp9_->data;
					_tmp11_ = baobab_location_get_file ((BaobabLocation*) _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_file_get_uri (_tmp12_);
					_tmp14_ = _tmp13_;
					gtk_recent_manager_remove_item (_tmp8_, _tmp14_, &_inner_error0_);
					_g_free0 (_tmp14_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				_tmp15_ = iter;
				self->priv->locations = g_list_remove_link (self->priv->locations, _tmp15_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp16_;
				const gchar* _tmp17_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp16_ = e;
				_tmp17_ = _tmp16_->message;
				g_warning ("baobab-location-list.vala:336: Attempting to remove an item from recen" \
"t locations, but failed: %s", _tmp17_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp18_ = next;
		iter = _tmp18_;
	}
	baobab_location_list_update (self);
}

BaobabLocationList*
baobab_location_list_construct (GType object_type)
{
	BaobabLocationList * self = NULL;
	self = (BaobabLocationList*) g_object_new (object_type, NULL);
	return self;
}

BaobabLocationList*
baobab_location_list_new (void)
{
	return baobab_location_list_construct (BAOBAB_TYPE_LOCATION_LIST);
}

static void
g_cclosure_user_marshal_VOID__BAOBAB_LOCATION (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BAOBAB_LOCATION) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BAOBAB_LOCATION callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BAOBAB_LOCATION) (marshal_data ? marshal_data : cc->callback);
	callback (data1, baobab_value_get_location (param_values + 1), data2);
}

static void
_baobab_location_list_mount_changed_g_volume_monitor_mount_changed (GVolumeMonitor* _sender,
                                                                    GMount* mount,
                                                                    gpointer self)
{
	baobab_location_list_mount_changed ((BaobabLocationList*) self, mount);
}

static void
_baobab_location_list_mount_removed_g_volume_monitor_mount_removed (GVolumeMonitor* _sender,
                                                                    GMount* mount,
                                                                    gpointer self)
{
	baobab_location_list_mount_removed ((BaobabLocationList*) self, mount);
}

static void
_baobab_location_list_mount_added_g_volume_monitor_mount_added (GVolumeMonitor* _sender,
                                                                GMount* mount,
                                                                gpointer self)
{
	baobab_location_list_mount_added ((BaobabLocationList*) self, mount);
}

static void
_baobab_location_list_volume_changed_g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                      GVolume* volume,
                                                                      gpointer self)
{
	baobab_location_list_volume_changed ((BaobabLocationList*) self, volume);
}

static void
_baobab_location_list_volume_removed_g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                      GVolume* volume,
                                                                      gpointer self)
{
	baobab_location_list_volume_removed ((BaobabLocationList*) self, volume);
}

static void
_baobab_location_list_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                  GVolume* volume,
                                                                  gpointer self)
{
	baobab_location_list_volume_added ((BaobabLocationList*) self, volume);
}

static void
_baobab_location_list_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                GtkListBoxRow* row,
                                                                gpointer self)
{
	baobab_location_list_row_activated ((BaobabLocationList*) self, row);
}

static gboolean
_baobab_location_list___lambda11_ (BaobabLocationList* self)
{
	gboolean result;
	baobab_location_list_queue_query_fs_usage (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
__baobab_location_list___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = _baobab_location_list___lambda11_ ((BaobabLocationList*) self);
	return result;
}

static GObject *
baobab_location_list_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BaobabLocationList * self;
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* _tmp4_;
	GVolumeMonitor* _tmp5_;
	GVolumeMonitor* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	parent_class = G_OBJECT_CLASS (baobab_location_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp0_;
	_tmp1_ = self->priv->monitor;
	g_signal_connect_object (_tmp1_, "mount-changed", (GCallback) _baobab_location_list_mount_changed_g_volume_monitor_mount_changed, self, 0);
	_tmp2_ = self->priv->monitor;
	g_signal_connect_object (_tmp2_, "mount-removed", (GCallback) _baobab_location_list_mount_removed_g_volume_monitor_mount_removed, self, 0);
	_tmp3_ = self->priv->monitor;
	g_signal_connect_object (_tmp3_, "mount-added", (GCallback) _baobab_location_list_mount_added_g_volume_monitor_mount_added, self, 0);
	_tmp4_ = self->priv->monitor;
	g_signal_connect_object (_tmp4_, "volume-changed", (GCallback) _baobab_location_list_volume_changed_g_volume_monitor_volume_changed, self, 0);
	_tmp5_ = self->priv->monitor;
	g_signal_connect_object (_tmp5_, "volume-removed", (GCallback) _baobab_location_list_volume_removed_g_volume_monitor_volume_removed, self, 0);
	_tmp6_ = self->priv->monitor;
	g_signal_connect_object (_tmp6_, "volume-added", (GCallback) _baobab_location_list_volume_added_g_volume_monitor_volume_added, self, 0);
	_tmp7_ = self->priv->local_list_box;
	g_signal_connect_object (_tmp7_, "row-activated", (GCallback) _baobab_location_list_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp8_ = self->priv->remote_list_box;
	g_signal_connect_object (_tmp8_, "row-activated", (GCallback) _baobab_location_list_row_activated_gtk_list_box_row_activated, self, 0);
	baobab_location_list_populate (self);
	baobab_location_list_queue_query_fs_usage (self);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, __baobab_location_list___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
baobab_location_list_class_init (BaobabLocationListClass * klass,
                                 gpointer klass_data)
{
	baobab_location_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabLocationList_private_offset);
	G_OBJECT_CLASS (klass)->constructor = baobab_location_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_location_list_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-location-list.ui");
	baobab_location_list_signals[BAOBAB_LOCATION_LIST_LOCATION_ACTIVATED_SIGNAL] = g_signal_new ("location-activated", BAOBAB_TYPE_LOCATION_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BAOBAB_LOCATION, G_TYPE_NONE, 1, BAOBAB_TYPE_LOCATION);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "local_list_box", FALSE, BaobabLocationList_private_offset + G_STRUCT_OFFSET (BaobabLocationListPrivate, local_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remote_list_box", FALSE, BaobabLocationList_private_offset + G_STRUCT_OFFSET (BaobabLocationListPrivate, remote_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remote_group", FALSE, BaobabLocationList_private_offset + G_STRUCT_OFFSET (BaobabLocationListPrivate, remote_group));
}

static void
baobab_location_list_instance_init (BaobabLocationList * self,
                                    gpointer klass)
{
	self->priv = baobab_location_list_get_instance_private (self);
	self->priv->locations = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
baobab_location_list_finalize (GObject * obj)
{
	BaobabLocationList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION_LIST, BaobabLocationList);
	_g_object_unref0 (self->priv->monitor);
	(self->priv->locations == NULL) ? NULL : (self->priv->locations = (_g_list_free__baobab_location_unref0_ (self->priv->locations), NULL));
	G_OBJECT_CLASS (baobab_location_list_parent_class)->finalize (obj);
}

static GType
baobab_location_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocationList), 0, (GInstanceInitFunc) baobab_location_list_instance_init, NULL };
	GType baobab_location_list_type_id;
	baobab_location_list_type_id = g_type_register_static (adw_preferences_page_get_type (), "BaobabLocationList", &g_define_type_info, 0);
	BaobabLocationList_private_offset = g_type_add_instance_private (baobab_location_list_type_id, sizeof (BaobabLocationListPrivate));
	return baobab_location_list_type_id;
}

GType
baobab_location_list_get_type (void)
{
	static volatile gsize baobab_location_list_type_id__once = 0;
	if (g_once_init_enter (&baobab_location_list_type_id__once)) {
		GType baobab_location_list_type_id;
		baobab_location_list_type_id = baobab_location_list_get_type_once ();
		g_once_init_leave (&baobab_location_list_type_id__once, baobab_location_list_type_id);
	}
	return baobab_location_list_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

