/* unified-privacy.c generated by valac 0.56.17, the Vala compiler
 * generated from unified-privacy.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; intend-tabs-mode: t -*- */
/* alm
 * Copyright (C) 2012 Stefano Candori <scandori@gnome.org>
 *               2013 Manish Sinha <manishsinha@ubuntu.com>
 *
 * alm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * alm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <zeitgeist-datamodel.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <zeitgeist.h>

#define ALM_EXCEPTION_CELL_RENDERER_PIXBUF_SIZE 24
#define ALM_EXCEPTION_CELL_RENDERER_xspacing 3
#define ALM_EXCEPTION_CELL_RENDERER_default_width 60
#define ALM_EXCEPTION_CELL_RENDERER_renderer_height 30
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	ALM_ITEM_TYPE_FILE,
	ALM_ITEM_TYPE_APPLICATION
} AlmItemType;

#define ALM_TYPE_ITEM_TYPE (alm_item_type_get_type ())

#define ALM_TYPE_PRIVACY_WIDGET (alm_privacy_widget_get_type ())
#define ALM_PRIVACY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_PRIVACY_WIDGET, AlmPrivacyWidget))
#define ALM_PRIVACY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_PRIVACY_WIDGET, AlmPrivacyWidgetClass))
#define ALM_IS_PRIVACY_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_PRIVACY_WIDGET))
#define ALM_IS_PRIVACY_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_PRIVACY_WIDGET))
#define ALM_PRIVACY_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_PRIVACY_WIDGET, AlmPrivacyWidgetClass))

typedef struct _AlmPrivacyWidget AlmPrivacyWidget;
typedef struct _AlmPrivacyWidgetClass AlmPrivacyWidgetClass;
typedef struct _AlmPrivacyWidgetPrivate AlmPrivacyWidgetPrivate;

#define ALM_TYPE_BLACKLIST (alm_blacklist_get_type ())
#define ALM_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_BLACKLIST, AlmBlacklist))
#define ALM_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_BLACKLIST, AlmBlacklistClass))
#define ALM_IS_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_BLACKLIST))
#define ALM_IS_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_BLACKLIST))
#define ALM_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_BLACKLIST, AlmBlacklistClass))

typedef struct _AlmBlacklist AlmBlacklist;
typedef struct _AlmBlacklistClass AlmBlacklistClass;

#define ALM_TYPE_FILE_TYPE_BLACKLIST (alm_file_type_blacklist_get_type ())
#define ALM_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklist))
#define ALM_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))
#define ALM_IS_FILE_TYPE_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_IS_FILE_TYPE_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_FILE_TYPE_BLACKLIST))
#define ALM_FILE_TYPE_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_FILE_TYPE_BLACKLIST, AlmFileTypeBlacklistClass))

typedef struct _AlmFileTypeBlacklist AlmFileTypeBlacklist;
typedef struct _AlmFileTypeBlacklistClass AlmFileTypeBlacklistClass;

#define ALM_TYPE_PATH_BLACKLIST (alm_path_blacklist_get_type ())
#define ALM_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklist))
#define ALM_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))
#define ALM_IS_PATH_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_PATH_BLACKLIST))
#define ALM_IS_PATH_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_PATH_BLACKLIST))
#define ALM_PATH_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_PATH_BLACKLIST, AlmPathBlacklistClass))

typedef struct _AlmPathBlacklist AlmPathBlacklist;
typedef struct _AlmPathBlacklistClass AlmPathBlacklistClass;

#define ALM_TYPE_APPLICATION_BLACKLIST (alm_application_blacklist_get_type ())
#define ALM_APPLICATION_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_APPLICATION_BLACKLIST, AlmApplicationBlacklist))
#define ALM_APPLICATION_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_APPLICATION_BLACKLIST, AlmApplicationBlacklistClass))
#define ALM_IS_APPLICATION_BLACKLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_APPLICATION_BLACKLIST))
#define ALM_IS_APPLICATION_BLACKLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_APPLICATION_BLACKLIST))
#define ALM_APPLICATION_BLACKLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_APPLICATION_BLACKLIST, AlmApplicationBlacklistClass))

typedef struct _AlmApplicationBlacklist AlmApplicationBlacklist;
typedef struct _AlmApplicationBlacklistClass AlmApplicationBlacklistClass;

#define ALM_TYPE_APPLICATIONS_CHOOSER_DIALOG (alm_applications_chooser_dialog_get_type ())
#define ALM_APPLICATIONS_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_APPLICATIONS_CHOOSER_DIALOG, AlmApplicationsChooserDialog))
#define ALM_APPLICATIONS_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_APPLICATIONS_CHOOSER_DIALOG, AlmApplicationsChooserDialogClass))
#define ALM_IS_APPLICATIONS_CHOOSER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_APPLICATIONS_CHOOSER_DIALOG))
#define ALM_IS_APPLICATIONS_CHOOSER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_APPLICATIONS_CHOOSER_DIALOG))
#define ALM_APPLICATIONS_CHOOSER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_APPLICATIONS_CHOOSER_DIALOG, AlmApplicationsChooserDialogClass))

typedef struct _AlmApplicationsChooserDialog AlmApplicationsChooserDialog;
typedef struct _AlmApplicationsChooserDialogClass AlmApplicationsChooserDialogClass;

#define ALM_TYPE_APPLICATIONS_TREE_VIEW (alm_applications_tree_view_get_type ())
#define ALM_APPLICATIONS_TREE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_APPLICATIONS_TREE_VIEW, AlmApplicationsTreeView))
#define ALM_APPLICATIONS_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_APPLICATIONS_TREE_VIEW, AlmApplicationsTreeViewClass))
#define ALM_IS_APPLICATIONS_TREE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_APPLICATIONS_TREE_VIEW))
#define ALM_IS_APPLICATIONS_TREE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_APPLICATIONS_TREE_VIEW))
#define ALM_APPLICATIONS_TREE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_APPLICATIONS_TREE_VIEW, AlmApplicationsTreeViewClass))

typedef struct _AlmApplicationsTreeView AlmApplicationsTreeView;
typedef struct _AlmApplicationsTreeViewClass AlmApplicationsTreeViewClass;

#define ALM_TYPE_APP_CHOOSE_INFO (alm_app_choose_info_get_type ())
#define ALM_APP_CHOOSE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_APP_CHOOSE_INFO, AlmAppChooseInfo))
#define ALM_APP_CHOOSE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_APP_CHOOSE_INFO, AlmAppChooseInfoClass))
#define ALM_IS_APP_CHOOSE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_APP_CHOOSE_INFO))
#define ALM_IS_APP_CHOOSE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_APP_CHOOSE_INFO))
#define ALM_APP_CHOOSE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_APP_CHOOSE_INFO, AlmAppChooseInfoClass))

typedef struct _AlmAppChooseInfo AlmAppChooseInfo;
typedef struct _AlmAppChooseInfoClass AlmAppChooseInfoClass;

#define ALM_TYPE_DELETE_HISTORY_DIALOG (alm_delete_history_dialog_get_type ())
#define ALM_DELETE_HISTORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_DELETE_HISTORY_DIALOG, AlmDeleteHistoryDialog))
#define ALM_DELETE_HISTORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_DELETE_HISTORY_DIALOG, AlmDeleteHistoryDialogClass))
#define ALM_IS_DELETE_HISTORY_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_DELETE_HISTORY_DIALOG))
#define ALM_IS_DELETE_HISTORY_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_DELETE_HISTORY_DIALOG))
#define ALM_DELETE_HISTORY_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_DELETE_HISTORY_DIALOG, AlmDeleteHistoryDialogClass))

typedef struct _AlmDeleteHistoryDialog AlmDeleteHistoryDialog;
typedef struct _AlmDeleteHistoryDialogClass AlmDeleteHistoryDialogClass;
enum  {
	ALM_PRIVACY_WIDGET_0_PROPERTY,
	ALM_PRIVACY_WIDGET_NUM_PROPERTIES
};
static GParamSpec* alm_privacy_widget_properties[ALM_PRIVACY_WIDGET_NUM_PROPERTIES];
#define _alm_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_blacklist_unref (var), NULL)))
#define _alm_file_type_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_file_type_blacklist_unref (var), NULL)))
#define _alm_path_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_path_blacklist_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _alm_application_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (alm_application_blacklist_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

#define ALM_TYPE_EXCEPTION_CELL_RENDERER (alm_exception_cell_renderer_get_type ())
#define ALM_EXCEPTION_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_EXCEPTION_CELL_RENDERER, AlmExceptionCellRenderer))
#define ALM_EXCEPTION_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_EXCEPTION_CELL_RENDERER, AlmExceptionCellRendererClass))
#define ALM_IS_EXCEPTION_CELL_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_EXCEPTION_CELL_RENDERER))
#define ALM_IS_EXCEPTION_CELL_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_EXCEPTION_CELL_RENDERER))
#define ALM_EXCEPTION_CELL_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_EXCEPTION_CELL_RENDERER, AlmExceptionCellRendererClass))

typedef struct _AlmExceptionCellRenderer AlmExceptionCellRenderer;
typedef struct _AlmExceptionCellRendererClass AlmExceptionCellRendererClass;
#define _alm_app_choose_info_unref0(var) ((var == NULL) ? NULL : (var = (alm_app_choose_info_unref (var), NULL)))
typedef struct _AlmExceptionCellRendererPrivate AlmExceptionCellRendererPrivate;
enum  {
	ALM_EXCEPTION_CELL_RENDERER_0_PROPERTY,
	ALM_EXCEPTION_CELL_RENDERER_PIXBUF_PROPERTY,
	ALM_EXCEPTION_CELL_RENDERER_TEXT_PROPERTY,
	ALM_EXCEPTION_CELL_RENDERER_NUM_PROPERTIES
};
static GParamSpec* alm_exception_cell_renderer_properties[ALM_EXCEPTION_CELL_RENDERER_NUM_PROPERTIES];
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _AlmDeleteHistoryDialogPrivate AlmDeleteHistoryDialogPrivate;

#define ALM_TYPE_CALENDAR_WIDGET (alm_calendar_widget_get_type ())
#define ALM_CALENDAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALM_TYPE_CALENDAR_WIDGET, AlmCalendarWidget))
#define ALM_CALENDAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALM_TYPE_CALENDAR_WIDGET, AlmCalendarWidgetClass))
#define ALM_IS_CALENDAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALM_TYPE_CALENDAR_WIDGET))
#define ALM_IS_CALENDAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALM_TYPE_CALENDAR_WIDGET))
#define ALM_CALENDAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALM_TYPE_CALENDAR_WIDGET, AlmCalendarWidgetClass))

typedef struct _AlmCalendarWidget AlmCalendarWidget;
typedef struct _AlmCalendarWidgetClass AlmCalendarWidgetClass;
enum  {
	ALM_DELETE_HISTORY_DIALOG_0_PROPERTY,
	ALM_DELETE_HISTORY_DIALOG_NUM_PROPERTIES
};
static GParamSpec* alm_delete_history_dialog_properties[ALM_DELETE_HISTORY_DIALOG_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _AlmDeleteHistoryDialogGetHistoryData AlmDeleteHistoryDialogGetHistoryData;
typedef struct _AlmDeleteHistoryDialogDeleteHistoryData AlmDeleteHistoryDialogDeleteHistoryData;

struct _AlmPrivacyWidget {
	GtkBox parent_instance;
	AlmPrivacyWidgetPrivate * priv;
};

struct _AlmPrivacyWidgetClass {
	GtkBoxClass parent_class;
};

struct _AlmPrivacyWidgetPrivate {
	AlmBlacklist* blacklist;
	gboolean file_type_fire_signal;
	AlmFileTypeBlacklist* files_type_blacklist;
	AlmPathBlacklist* path_blacklist;
	GeeHashMap* mime_dict;
	GeeHashMap* checkboxes;
	GeeHashSet* button_list;
	GeeHashMap* defined_dirs;
	AlmApplicationBlacklist* app_blacklist;
	AlmApplicationsChooserDialog* app_dialog;
	AlmApplicationsTreeView* app_treeview;
	GtkBox* container_box;
	GHashTable* blocked_list;
	GHashTable* unblocked_list;
	gboolean app_change_recursive;
	GtkTreeView* exception_list;
	GtkListStore* exception_list_store;
	GtkSwitch* record_button;
	GtkButton* del_button;
	AlmDeleteHistoryDialog* delete_dialog;
	GdkPixbuf* stock_folder_icon;
	GtkMenu* exception_menu;
	GSettings* privacy_settings;
};

struct _Block4Data {
	int _ref_count_;
	AlmPrivacyWidget* self;
	GtkCheckButton* check_button;
};

struct _AlmExceptionCellRenderer {
	GtkCellRenderer parent_instance;
	AlmExceptionCellRendererPrivate * priv;
};

struct _AlmExceptionCellRendererClass {
	GtkCellRendererClass parent_class;
};

struct _AlmExceptionCellRendererPrivate {
	GtkWidget* current_widget;
	GdkPixbuf* pixbuf_;
	gchar* text_;
};

struct _AlmDeleteHistoryDialog {
	GtkDialog parent_instance;
	AlmDeleteHistoryDialogPrivate * priv;
};

struct _AlmDeleteHistoryDialogClass {
	GtkDialogClass parent_class;
};

struct _AlmDeleteHistoryDialogPrivate {
	GtkRadioButton* r_hour;
	GtkRadioButton* r_day;
	GtkRadioButton* r_week;
	GtkRadioButton* r_calendar;
	GtkRadioButton* r_ever;
	ZeitgeistLog* zg_log;
	AlmCalendarWidget* calendar_box;
};

struct _AlmDeleteHistoryDialogGetHistoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AlmDeleteHistoryDialog* self;
	ZeitgeistTimeRange* tr;
	GtkDialog* dialog;
	GtkDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkLabel* label;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkDialog* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkDialog* _tmp11_;
	GtkWidget* _tmp12_;
	GtkDialog* _tmp13_;
	GtkDialog* _tmp14_;
	gint res;
	GtkDialog* _tmp15_;
	GtkDialog* _tmp16_;
	GPtrArray* events;
	GPtrArray* _tmp17_;
	GPtrArray* _tmp18_;
	ZeitgeistEvent* _tmp19_;
	guint32* ids;
	ZeitgeistLog* _tmp20_;
	GPtrArray* _tmp21_;
	gint _tmp22_;
	guint32* _tmp23_;
	gint ids_length1;
	gint _ids_size_;
	GArray* del_ids;
	GArray* _tmp24_;
	GArray* _tmp25_;
	guint32* _tmp26_;
	gint _tmp26__length1;
	guint32* _tmp27_;
	gint _tmp27__length1;
	GArray* _tmp28_;
	GError* err;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError* _inner_error0_;
};

struct _AlmDeleteHistoryDialogDeleteHistoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AlmDeleteHistoryDialog* self;
	GArray* ids;
	ZeitgeistTimeRange* rs;
	ZeitgeistLog* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	GError* err;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

static gint AlmPrivacyWidget_private_offset;
static gpointer alm_privacy_widget_parent_class = NULL;
VALA_EXTERN gchar* alm_file_type_blacklist_interpretation_prefix;
static gint AlmExceptionCellRenderer_private_offset;
static gpointer alm_exception_cell_renderer_parent_class = NULL;
static gint AlmDeleteHistoryDialog_private_offset;
static gpointer alm_delete_history_dialog_parent_class = NULL;

VALA_EXTERN GType alm_item_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType alm_privacy_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmPrivacyWidget, g_object_unref)
VALA_EXTERN gpointer alm_blacklist_ref (gpointer instance);
VALA_EXTERN void alm_blacklist_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_blacklist (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void alm_value_set_blacklist (GValue* value,
                              gpointer v_object);
VALA_EXTERN void alm_value_take_blacklist (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer alm_value_get_blacklist (const GValue* value);
VALA_EXTERN GType alm_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmBlacklist, alm_blacklist_unref)
VALA_EXTERN gpointer alm_file_type_blacklist_ref (gpointer instance);
VALA_EXTERN void alm_file_type_blacklist_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_file_type_blacklist (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void alm_value_set_file_type_blacklist (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void alm_value_take_file_type_blacklist (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer alm_value_get_file_type_blacklist (const GValue* value);
VALA_EXTERN GType alm_file_type_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmFileTypeBlacklist, alm_file_type_blacklist_unref)
VALA_EXTERN gpointer alm_path_blacklist_ref (gpointer instance);
VALA_EXTERN void alm_path_blacklist_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_path_blacklist (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void alm_value_set_path_blacklist (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void alm_value_take_path_blacklist (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer alm_value_get_path_blacklist (const GValue* value);
VALA_EXTERN GType alm_path_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmPathBlacklist, alm_path_blacklist_unref)
VALA_EXTERN gpointer alm_application_blacklist_ref (gpointer instance);
VALA_EXTERN void alm_application_blacklist_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_application_blacklist (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void alm_value_set_application_blacklist (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void alm_value_take_application_blacklist (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer alm_value_get_application_blacklist (const GValue* value);
VALA_EXTERN GType alm_application_blacklist_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmApplicationBlacklist, alm_application_blacklist_unref)
VALA_EXTERN GType alm_applications_chooser_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmApplicationsChooserDialog, g_object_unref)
VALA_EXTERN GType alm_applications_tree_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmApplicationsTreeView, g_object_unref)
VALA_EXTERN gpointer alm_app_choose_info_ref (gpointer instance);
VALA_EXTERN void alm_app_choose_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* alm_param_spec_app_choose_info (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void alm_value_set_app_choose_info (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void alm_value_take_app_choose_info (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer alm_value_get_app_choose_info (const GValue* value);
VALA_EXTERN GType alm_app_choose_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmAppChooseInfo, alm_app_choose_info_unref)
VALA_EXTERN GType alm_delete_history_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmDeleteHistoryDialog, g_object_unref)
VALA_EXTERN AlmPrivacyWidget* alm_privacy_widget_new (AlmBlacklist* blacklist_interface);
VALA_EXTERN AlmPrivacyWidget* alm_privacy_widget_construct (GType object_type,
                                                AlmBlacklist* blacklist_interface);
VALA_EXTERN AlmFileTypeBlacklist* alm_file_type_blacklist_new (AlmBlacklist* blacklist_inter,
                                                   GeeHashMap* all_checkboxes);
VALA_EXTERN AlmFileTypeBlacklist* alm_file_type_blacklist_construct (GType object_type,
                                                         AlmBlacklist* blacklist_inter,
                                                         GeeHashMap* all_checkboxes);
VALA_EXTERN AlmPathBlacklist* alm_path_blacklist_new (AlmBlacklist* blacklist_inter);
VALA_EXTERN AlmPathBlacklist* alm_path_blacklist_construct (GType object_type,
                                                AlmBlacklist* blacklist_inter);
static void __lambda12_ (AlmPrivacyWidget* self,
                  const gchar* blacklist_id,
                  ZeitgeistEvent* blacklist_template);
static void ___lambda12__alm_blacklist_template_added (AlmBlacklist* _sender,
                                                const gchar* blacklist_id,
                                                ZeitgeistEvent* blacklist_template,
                                                gpointer self);
static void __lambda13_ (AlmPrivacyWidget* self,
                  const gchar* blacklist_id,
                  ZeitgeistEvent* blacklist_template);
static void ___lambda13__alm_blacklist_template_removed (AlmBlacklist* _sender,
                                                  const gchar* blacklist_id,
                                                  ZeitgeistEvent* blacklist_template,
                                                  gpointer self);
static void __lambda14_ (AlmPrivacyWidget* self,
                  const gchar* folder);
VALA_EXTERN gboolean alm_path_blacklist_is_duplicate (AlmPathBlacklist* self,
                                          const gchar* path);
static void alm_privacy_widget_add_folder_to_view (AlmPrivacyWidget* self,
                                            const gchar* folder);
static void ___lambda14__alm_path_blacklist_folder_added (AlmPathBlacklist* _sender,
                                                   const gchar* path,
                                                   gpointer self);
static void __lambda15_ (AlmPrivacyWidget* self,
                  const gchar* folder);
static gboolean alm_privacy_widget_remove_folder_from_view (AlmPrivacyWidget* self,
                                                     const gchar* folder);
static void ___lambda15__alm_path_blacklist_folder_removed (AlmPathBlacklist* _sender,
                                                     const gchar* path,
                                                     gpointer self);
static void _g_free0_ (gpointer var);
static void _alm_app_choose_info_unref0_ (gpointer var);
VALA_EXTERN AlmApplicationBlacklist* alm_application_blacklist_new (AlmBlacklist* blacklist);
VALA_EXTERN AlmApplicationBlacklist* alm_application_blacklist_construct (GType object_type,
                                                              AlmBlacklist* blacklist);
VALA_EXTERN AlmApplicationsTreeView* alm_applications_tree_view_new (AlmApplicationBlacklist* app_blacklist,
                                                         GHashTable* blocked,
                                                         GHashTable* unblocked);
VALA_EXTERN AlmApplicationsTreeView* alm_applications_tree_view_construct (GType object_type,
                                                               AlmApplicationBlacklist* app_blacklist,
                                                               GHashTable* blocked,
                                                               GHashTable* unblocked);
static void __lambda16_ (AlmPrivacyWidget* self,
                  const gchar* app,
                  ZeitgeistEvent* event);
static void alm_privacy_widget_remove_app_from_view (AlmPrivacyWidget* self,
                                              const gchar* app);
static void ___lambda16__alm_application_blacklist_application_removed (AlmApplicationBlacklist* _sender,
                                                                 const gchar* app,
                                                                 ZeitgeistEvent* ev,
                                                                 gpointer self);
static void __lambda17_ (AlmPrivacyWidget* self,
                  const gchar* app,
                  ZeitgeistEvent* event);
static void alm_privacy_widget_add_app_to_view (AlmPrivacyWidget* self,
                                         const gchar* app);
static void ___lambda17__alm_application_blacklist_application_added (AlmApplicationBlacklist* _sender,
                                                               const gchar* app,
                                                               ZeitgeistEvent* ev,
                                                               gpointer self);
static void alm_privacy_widget_setup_ui (AlmPrivacyWidget* self);
VALA_EXTERN gboolean alm_blacklist_get_incognito (AlmBlacklist* self);
static void __lambda18_ (AlmPrivacyWidget* self,
                  gboolean status);
static void ___lambda18__alm_blacklist_incognito_toggled (AlmBlacklist* _sender,
                                                   gboolean status,
                                                   gpointer self);
static void __lambda19_ (AlmPrivacyWidget* self);
VALA_EXTERN void alm_blacklist_set_incognito (AlmBlacklist* self,
                                  gboolean status);
static void ___lambda19__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda20_ (AlmPrivacyWidget* self);
VALA_EXTERN void alm_delete_history_dialog_on_delete_history (AlmDeleteHistoryDialog* self);
static void ___lambda20__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gint __lambda21_ (AlmPrivacyWidget* self,
                  const gchar* s1,
                  const gchar* s2);
static gint ___lambda21__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN void alm_file_type_blacklist_populate_file_types (AlmFileTypeBlacklist* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda22_ (Block4Data* _data4_);
VALA_EXTERN void alm_file_type_blacklist_unblock (AlmFileTypeBlacklist* self,
                                      const gchar* interpretation);
VALA_EXTERN void alm_file_type_blacklist_block (AlmFileTypeBlacklist* self,
                                    const gchar* interpretation);
static void _____lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                               gpointer self);
VALA_EXTERN GType alm_exception_cell_renderer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmExceptionCellRenderer, g_object_unref)
VALA_EXTERN AlmExceptionCellRenderer* alm_exception_cell_renderer_new (void);
VALA_EXTERN AlmExceptionCellRenderer* alm_exception_cell_renderer_construct (GType object_type);
static void alm_privacy_widget_on_remove_exception (AlmPrivacyWidget* self);
static void _alm_privacy_widget_on_remove_exception_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                                      gpointer self);
static void alm_privacy_widget_on_add_folder (AlmPrivacyWidget* self);
static void _alm_privacy_widget_on_add_folder_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self);
static void alm_privacy_widget_on_add_application (AlmPrivacyWidget* self);
static void _alm_privacy_widget_on_add_application_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                    gpointer self);
VALA_EXTERN AlmApplicationsChooserDialog* alm_applications_chooser_dialog_new (AlmApplicationBlacklist* app_blacklist,
                                                                   GHashTable* blocked_list,
                                                                   GHashTable* unblocked_list);
VALA_EXTERN AlmApplicationsChooserDialog* alm_applications_chooser_dialog_construct (GType object_type,
                                                                         AlmApplicationBlacklist* app_blacklist,
                                                                         GHashTable* blocked_list,
                                                                         GHashTable* unblocked_list);
VALA_EXTERN AlmDeleteHistoryDialog* alm_delete_history_dialog_new (GtkButton* del_button);
VALA_EXTERN AlmDeleteHistoryDialog* alm_delete_history_dialog_construct (GType object_type,
                                                             GtkButton* del_button);
static void alm_privacy_widget_folders_populate (AlmPrivacyWidget* self);
static void alm_privacy_widget_app_populate (AlmPrivacyWidget* self);
VALA_EXTERN gint alm_privacy_widget_compare_mimes (AlmPrivacyWidget* self,
                                       const gchar* s1,
                                       const gchar* s2);
VALA_EXTERN GeeHashSet* alm_path_blacklist_get_all_folders (AlmPathBlacklist* self);
VALA_EXTERN GeeHashSet* alm_application_blacklist_get_all_apps (AlmApplicationBlacklist* self);
VALA_EXTERN void alm_path_blacklist_unblock (AlmPathBlacklist* self,
                                 const gchar* folder);
VALA_EXTERN void alm_application_blacklist_unblock (AlmApplicationBlacklist* self,
                                        const gchar* application);
VALA_EXTERN void alm_path_blacklist_block (AlmPathBlacklist* self,
                               const gchar* folder);
static void alm_privacy_widget_on_add_file (AlmPrivacyWidget* self);
VALA_EXTERN GtkTreeView* alm_applications_chooser_dialog_get_tree (AlmApplicationsChooserDialog* self);
VALA_EXTERN GtkListStore* alm_applications_chooser_dialog_get_liststore (AlmApplicationsChooserDialog* self);
VALA_EXTERN void alm_application_blacklist_block (AlmApplicationBlacklist* self,
                                      const gchar* application);
static const char* _g_user_directory_to_string (GUserDirectory value);
VALA_EXTERN GdkPixbuf* alm_applications_tree_view_get_pixbuf_from_gio_icon (GIcon* icon,
                                                                gint size);
VALA_EXTERN gchar* alm_applications_tree_view_markup_for_app (GDesktopAppInfo* app_info);
VALA_EXTERN AlmAppChooseInfo* alm_app_choose_info_new (const gchar* id,
                                           const gchar* app_name,
                                           GdkPixbuf* app_icon,
                                           const gchar* last_accessed_time_s,
                                           gint64 last_accessed_time_i,
                                           guint usage_rating);
VALA_EXTERN AlmAppChooseInfo* alm_app_choose_info_construct (GType object_type,
                                                 const gchar* id,
                                                 const gchar* app_name,
                                                 GdkPixbuf* app_icon,
                                                 const gchar* last_accessed_time_s,
                                                 gint64 last_accessed_time_i,
                                                 guint usage_rating);
static void alm_privacy_widget_finalize (GObject * obj);
static GType alm_privacy_widget_get_type_once (void);
static PangoLayout* alm_exception_cell_renderer_get_text_layout (AlmExceptionCellRenderer* self,
                                                          GtkWidget* widget,
                                                          GdkRectangle* cell_area,
                                                          GtkCellRendererState flags,
                                                          const gchar* text,
                                                          gboolean bold,
                                                          gint size);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void alm_exception_cell_renderer_real_get_size (GtkCellRenderer* base,
                                                GtkWidget* widget,
                                                GdkRectangle* cell_area,
                                                gint* x_offset,
                                                gint* y_offset,
                                                gint* width,
                                                gint* height);
static void alm_exception_cell_renderer_do_get_size (AlmExceptionCellRenderer* self,
                                              GtkWidget* widget,
                                              GdkRectangle* cell_area,
                                              PangoLayout* layout,
                                              gint* x_offset,
                                              gint* y_offset);
static void alm_exception_cell_renderer_real_render (GtkCellRenderer* base,
                                              cairo_t* cr,
                                              GtkWidget* widget,
                                              GdkRectangle* background_area,
                                              GdkRectangle* cell_area,
                                              GtkCellRendererState flags);
VALA_EXTERN const gchar* alm_exception_cell_renderer_get_text (AlmExceptionCellRenderer* self);
VALA_EXTERN GdkPixbuf* alm_exception_cell_renderer_get_pixbuf (AlmExceptionCellRenderer* self);
static void alm_exception_cell_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                                           GtkWidget* widget,
                                                           gint* min_width,
                                                           gint* nat_width);
static void alm_exception_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                      GtkWidget* widget,
                                                                      gint width,
                                                                      gint* minimum_height,
                                                                      gint* natural_height);
static void alm_exception_cell_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                                            GtkWidget* widget,
                                                            gint* minimum_size,
                                                            gint* natural_size);
VALA_EXTERN void alm_exception_cell_renderer_set_pixbuf (AlmExceptionCellRenderer* self,
                                             GdkPixbuf* value);
VALA_EXTERN void alm_exception_cell_renderer_set_text (AlmExceptionCellRenderer* self,
                                           const gchar* value);
static void alm_exception_cell_renderer_finalize (GObject * obj);
static GType alm_exception_cell_renderer_get_type_once (void);
static void _vala_alm_exception_cell_renderer_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_alm_exception_cell_renderer_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
VALA_EXTERN GType alm_calendar_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AlmCalendarWidget, g_object_unref)
VALA_EXTERN AlmCalendarWidget* alm_calendar_widget_new (GtkButton* button);
VALA_EXTERN AlmCalendarWidget* alm_calendar_widget_construct (GType object_type,
                                                  GtkButton* button);
static void alm_delete_history_dialog_set_up_ui (AlmDeleteHistoryDialog* self);
VALA_EXTERN gint alm_delete_history_dialog_get_active_radio_button (AlmDeleteHistoryDialog* self);
static void alm_delete_history_dialog_get_history (AlmDeleteHistoryDialog* self,
                                            ZeitgeistTimeRange* tr,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void alm_delete_history_dialog_get_history_finish (AlmDeleteHistoryDialog* self,
                                                   GAsyncResult* _res_);
VALA_EXTERN ZeitgeistTimeRange* alm_calendar_widget_get_range (AlmCalendarWidget* self);
static void alm_delete_history_dialog_get_history_data_free (gpointer _data);
static gboolean alm_delete_history_dialog_get_history_co (AlmDeleteHistoryDialogGetHistoryData* _data_);
static gboolean _alm_delete_history_dialog_get_history_co_gsource_func (gpointer self);
static void _g_object_unref0_ (gpointer var);
static void alm_delete_history_dialog_get_history_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void alm_delete_history_dialog_delete_history (AlmDeleteHistoryDialog* self,
                                               GArray* ids,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void alm_delete_history_dialog_delete_history_finish (AlmDeleteHistoryDialog* self,
                                                      GAsyncResult* _res_);
static void alm_delete_history_dialog_delete_history_data_free (gpointer _data);
static gboolean alm_delete_history_dialog_delete_history_co (AlmDeleteHistoryDialogDeleteHistoryData* _data_);
static gboolean _alm_delete_history_dialog_delete_history_co_gsource_func (gpointer self);
static void alm_delete_history_dialog_delete_history_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void alm_delete_history_dialog_finalize (GObject * obj);
static GType alm_delete_history_dialog_get_type_once (void);

static GType
alm_item_type_get_type_once (void)
{
	static const GEnumValue values[] = {{ALM_ITEM_TYPE_FILE, "ALM_ITEM_TYPE_FILE", "file"}, {ALM_ITEM_TYPE_APPLICATION, "ALM_ITEM_TYPE_APPLICATION", "application"}, {0, NULL, NULL}};
	GType alm_item_type_type_id;
	alm_item_type_type_id = g_enum_register_static ("AlmItemType", values);
	return alm_item_type_type_id;
}

GType
alm_item_type_get_type (void)
{
	static volatile gsize alm_item_type_type_id__once = 0;
	if (g_once_init_enter (&alm_item_type_type_id__once)) {
		GType alm_item_type_type_id;
		alm_item_type_type_id = alm_item_type_get_type_once ();
		g_once_init_leave (&alm_item_type_type_id__once, alm_item_type_type_id);
	}
	return alm_item_type_type_id__once;
}

static inline gpointer
alm_privacy_widget_get_instance_private (AlmPrivacyWidget* self)
{
	return G_STRUCT_MEMBER_P (self, AlmPrivacyWidget_private_offset);
}

static gpointer
_alm_blacklist_ref0 (gpointer self)
{
	return self ? alm_blacklist_ref (self) : NULL;
}

static void
__lambda12_ (AlmPrivacyWidget* self,
             const gchar* blacklist_id,
             ZeitgeistEvent* blacklist_template)
{
	const gchar* _tmp0_;
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (blacklist_template != NULL);
	_tmp0_ = alm_file_type_blacklist_interpretation_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		gchar* inter = NULL;
		ZeitgeistSubject* _tmp1_;
		ZeitgeistSubject* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		self->priv->file_type_fire_signal = FALSE;
		_tmp1_ = zeitgeist_event_get_subject (blacklist_template, 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = zeitgeist_subject_get_interpretation (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp2_);
		inter = _tmp6_;
		_tmp7_ = self->priv->checkboxes;
		_tmp8_ = inter;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_)) {
			GeeHashMap* _tmp9_;
			const gchar* _tmp10_;
			gpointer _tmp11_;
			GtkCheckButton* _tmp12_;
			_tmp9_ = self->priv->checkboxes;
			_tmp10_ = inter;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
			_tmp12_ = (GtkCheckButton*) _tmp11_;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp12_, FALSE);
			_g_object_unref0 (_tmp12_);
		}
		self->priv->file_type_fire_signal = TRUE;
		_g_free0 (inter);
	}
}

static void
___lambda12__alm_blacklist_template_added (AlmBlacklist* _sender,
                                           const gchar* blacklist_id,
                                           ZeitgeistEvent* blacklist_template,
                                           gpointer self)
{
	__lambda12_ ((AlmPrivacyWidget*) self, blacklist_id, blacklist_template);
}

static void
__lambda13_ (AlmPrivacyWidget* self,
             const gchar* blacklist_id,
             ZeitgeistEvent* blacklist_template)
{
	const gchar* _tmp0_;
	g_return_if_fail (blacklist_id != NULL);
	g_return_if_fail (blacklist_template != NULL);
	_tmp0_ = alm_file_type_blacklist_interpretation_prefix;
	if (g_str_has_prefix (blacklist_id, _tmp0_)) {
		gchar* inter = NULL;
		ZeitgeistSubject* _tmp1_;
		ZeitgeistSubject* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GeeHashMap* _tmp7_;
		const gchar* _tmp8_;
		self->priv->file_type_fire_signal = FALSE;
		_tmp1_ = zeitgeist_event_get_subject (blacklist_template, 0);
		_tmp2_ = _tmp1_;
		_tmp3_ = zeitgeist_subject_get_interpretation (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp2_);
		inter = _tmp6_;
		_tmp7_ = self->priv->checkboxes;
		_tmp8_ = inter;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp7_, _tmp8_)) {
			GeeHashMap* _tmp9_;
			const gchar* _tmp10_;
			gpointer _tmp11_;
			GtkCheckButton* _tmp12_;
			_tmp9_ = self->priv->checkboxes;
			_tmp10_ = inter;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
			_tmp12_ = (GtkCheckButton*) _tmp11_;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp12_, TRUE);
			_g_object_unref0 (_tmp12_);
		}
		self->priv->file_type_fire_signal = TRUE;
		_g_free0 (inter);
	}
}

static void
___lambda13__alm_blacklist_template_removed (AlmBlacklist* _sender,
                                             const gchar* blacklist_id,
                                             ZeitgeistEvent* blacklist_template,
                                             gpointer self)
{
	__lambda13_ ((AlmPrivacyWidget*) self, blacklist_id, blacklist_template);
}

static void
__lambda14_ (AlmPrivacyWidget* self,
             const gchar* folder)
{
	AlmPathBlacklist* _tmp0_;
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->path_blacklist;
	if (!alm_path_blacklist_is_duplicate (_tmp0_, folder)) {
		alm_privacy_widget_add_folder_to_view (self, folder);
	}
}

static void
___lambda14__alm_path_blacklist_folder_added (AlmPathBlacklist* _sender,
                                              const gchar* path,
                                              gpointer self)
{
	__lambda14_ ((AlmPrivacyWidget*) self, path);
}

static void
__lambda15_ (AlmPrivacyWidget* self,
             const gchar* folder)
{
	g_return_if_fail (folder != NULL);
	alm_privacy_widget_remove_folder_from_view (self, folder);
}

static void
___lambda15__alm_path_blacklist_folder_removed (AlmPathBlacklist* _sender,
                                                const gchar* path,
                                                gpointer self)
{
	__lambda15_ ((AlmPrivacyWidget*) self, path);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_alm_app_choose_info_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (alm_app_choose_info_unref (var), NULL));
}

static void
__lambda16_ (AlmPrivacyWidget* self,
             const gchar* app,
             ZeitgeistEvent* event)
{
	g_return_if_fail (app != NULL);
	g_return_if_fail (event != NULL);
	if (!self->priv->app_change_recursive) {
		alm_privacy_widget_remove_app_from_view (self, app);
	}
	self->priv->app_change_recursive = FALSE;
}

static void
___lambda16__alm_application_blacklist_application_removed (AlmApplicationBlacklist* _sender,
                                                            const gchar* app,
                                                            ZeitgeistEvent* ev,
                                                            gpointer self)
{
	__lambda16_ ((AlmPrivacyWidget*) self, app, ev);
}

static void
__lambda17_ (AlmPrivacyWidget* self,
             const gchar* app,
             ZeitgeistEvent* event)
{
	g_return_if_fail (app != NULL);
	g_return_if_fail (event != NULL);
	if (!self->priv->app_change_recursive) {
		alm_privacy_widget_add_app_to_view (self, app);
	}
	self->priv->app_change_recursive = FALSE;
}

static void
___lambda17__alm_application_blacklist_application_added (AlmApplicationBlacklist* _sender,
                                                          const gchar* app,
                                                          ZeitgeistEvent* ev,
                                                          gpointer self)
{
	__lambda17_ ((AlmPrivacyWidget*) self, app, ev);
}

AlmPrivacyWidget*
alm_privacy_widget_construct (GType object_type,
                              AlmBlacklist* blacklist_interface)
{
	AlmPrivacyWidget * self = NULL;
	GSettings* _tmp0_;
	AlmBlacklist* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashSet* _tmp3_;
	GeeHashMap* _tmp4_;
	AlmFileTypeBlacklist* _tmp5_;
	AlmPathBlacklist* _tmp6_;
	AlmPathBlacklist* _tmp7_;
	AlmPathBlacklist* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GeeHashMap* _tmp11_;
	GeeHashMap* _tmp12_;
	GeeHashMap* _tmp13_;
	GeeHashMap* _tmp14_;
	GeeHashMap* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	GeeHashMap* _tmp18_;
	GeeHashMap* _tmp19_;
	GeeHashMap* _tmp20_;
	GUserDirectory* special_dirs = NULL;
	GUserDirectory* _tmp21_;
	gint special_dirs_length1;
	gint _special_dirs_size_;
	GdkPixbuf* _tmp34_;
	GHashFunc _tmp35_;
	GEqualFunc _tmp36_;
	GHashTable* _tmp37_;
	GHashFunc _tmp38_;
	GEqualFunc _tmp39_;
	GHashTable* _tmp40_;
	AlmApplicationBlacklist* _tmp41_;
	AlmApplicationBlacklist* _tmp42_;
	GHashTable* _tmp43_;
	GHashTable* _tmp44_;
	AlmApplicationsTreeView* _tmp45_;
	AlmApplicationBlacklist* _tmp46_;
	AlmApplicationBlacklist* _tmp47_;
	g_return_val_if_fail (blacklist_interface != NULL, NULL);
	self = (AlmPrivacyWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 10, NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.privacy");
	_g_object_unref0 (self->priv->privacy_settings);
	self->priv->privacy_settings = _tmp0_;
	_tmp1_ = _alm_blacklist_ref0 (blacklist_interface);
	_alm_blacklist_unref0 (self->priv->blacklist);
	self->priv->blacklist = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_check_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->checkboxes);
	self->priv->checkboxes = _tmp2_;
	_tmp3_ = gee_hash_set_new (gtk_check_button_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->button_list);
	self->priv->button_list = _tmp3_;
	_tmp4_ = self->priv->checkboxes;
	_tmp5_ = alm_file_type_blacklist_new (blacklist_interface, _tmp4_);
	_alm_file_type_blacklist_unref0 (self->priv->files_type_blacklist);
	self->priv->files_type_blacklist = _tmp5_;
	_tmp6_ = alm_path_blacklist_new (blacklist_interface);
	_alm_path_blacklist_unref0 (self->priv->path_blacklist);
	self->priv->path_blacklist = _tmp6_;
	g_signal_connect_object (blacklist_interface, "template-added", (GCallback) ___lambda12__alm_blacklist_template_added, self, 0);
	g_signal_connect_object (blacklist_interface, "template-removed", (GCallback) ___lambda13__alm_blacklist_template_removed, self, 0);
	_tmp7_ = self->priv->path_blacklist;
	g_signal_connect_object (_tmp7_, "folder-added", (GCallback) ___lambda14__alm_path_blacklist_folder_added, self, 0);
	_tmp8_ = self->priv->path_blacklist;
	g_signal_connect_object (_tmp8_, "folder-removed", (GCallback) ___lambda15__alm_path_blacklist_folder_removed, self, 0);
	_tmp9_ = g_str_hash;
	_tmp10_ = g_str_equal;
	_tmp11_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GeeHashDataFunc) _tmp9_, NULL, NULL, (GeeEqualDataFunc) _tmp10_, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->mime_dict);
	self->priv->mime_dict = _tmp11_;
	_tmp12_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _ ("Music"), ZEITGEIST_NFO_AUDIO);
	_tmp13_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _ ("Videos"), ZEITGEIST_NFO_VIDEO);
	_tmp14_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _ ("Pictures"), ZEITGEIST_NFO_IMAGE);
	_tmp15_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _ ("Documents"), ZEITGEIST_NFO_DOCUMENT);
	_tmp16_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _ ("Presentations"), ZEITGEIST_NFO_PRESENTATION);
	_tmp17_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _ ("Spreadsheets"), ZEITGEIST_NFO_SPREADSHEET);
	_tmp18_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _ ("Chat Logs"), ZEITGEIST_NMO_IMMESSAGE);
	_tmp19_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _ ("Emails"), ZEITGEIST_NMO_EMAIL);
	_tmp20_ = self->priv->mime_dict;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _ ("Websites"), ZEITGEIST_NFO_WEBSITE);
	_tmp21_ = g_new0 (GUserDirectory, 8);
	_tmp21_[0] = G_USER_DIRECTORY_DESKTOP;
	_tmp21_[1] = G_USER_DIRECTORY_DOCUMENTS;
	_tmp21_[2] = G_USER_DIRECTORY_DOWNLOAD;
	_tmp21_[3] = G_USER_DIRECTORY_MUSIC;
	_tmp21_[4] = G_USER_DIRECTORY_PICTURES;
	_tmp21_[5] = G_USER_DIRECTORY_PUBLIC_SHARE;
	_tmp21_[6] = G_USER_DIRECTORY_TEMPLATES;
	_tmp21_[7] = G_USER_DIRECTORY_VIDEOS;
	special_dirs = _tmp21_;
	special_dirs_length1 = 8;
	_special_dirs_size_ = special_dirs_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp22_ = FALSE;
			_tmp22_ = TRUE;
			while (TRUE) {
				GUserDirectory* _tmp24_;
				gint _tmp24__length1;
				gchar* dir_path = NULL;
				GUserDirectory* _tmp25_;
				gint _tmp25__length1;
				GUserDirectory _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				const gchar* _tmp29_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				_tmp24_ = special_dirs;
				_tmp24__length1 = special_dirs_length1;
				if (!(i < _tmp24__length1)) {
					break;
				}
				_tmp25_ = special_dirs;
				_tmp25__length1 = special_dirs_length1;
				_tmp26_ = _tmp25_[i];
				_tmp27_ = g_get_user_special_dir (_tmp26_);
				_tmp28_ = g_strdup (_tmp27_);
				dir_path = _tmp28_;
				_tmp29_ = dir_path;
				if (_tmp29_ != NULL) {
					GeeHashMap* _tmp30_;
					const gchar* _tmp31_;
					GUserDirectory* _tmp32_;
					gint _tmp32__length1;
					GUserDirectory _tmp33_;
					_tmp30_ = self->priv->defined_dirs;
					_tmp31_ = dir_path;
					_tmp32_ = special_dirs;
					_tmp32__length1 = special_dirs_length1;
					_tmp33_ = _tmp32_[i];
					gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, _tmp31_, (gpointer) ((gintptr) _tmp33_));
				}
				_g_free0 (dir_path);
			}
		}
	}
	_tmp34_ = gtk_widget_render_icon_pixbuf ((GtkWidget*) self, GTK_STOCK_DIRECTORY, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	_g_object_unref0 (self->priv->stock_folder_icon);
	self->priv->stock_folder_icon = _tmp34_;
	_tmp35_ = g_str_hash;
	_tmp36_ = g_str_equal;
	_tmp37_ = g_hash_table_new_full (_tmp35_, _tmp36_, _g_free0_, _alm_app_choose_info_unref0_);
	_g_hash_table_unref0 (self->priv->blocked_list);
	self->priv->blocked_list = _tmp37_;
	_tmp38_ = g_str_hash;
	_tmp39_ = g_str_equal;
	_tmp40_ = g_hash_table_new_full (_tmp38_, _tmp39_, _g_free0_, _alm_app_choose_info_unref0_);
	_g_hash_table_unref0 (self->priv->unblocked_list);
	self->priv->unblocked_list = _tmp40_;
	_tmp41_ = alm_application_blacklist_new (blacklist_interface);
	_alm_application_blacklist_unref0 (self->priv->app_blacklist);
	self->priv->app_blacklist = _tmp41_;
	_tmp42_ = self->priv->app_blacklist;
	_tmp43_ = self->priv->blocked_list;
	_tmp44_ = self->priv->unblocked_list;
	_tmp45_ = alm_applications_tree_view_new (_tmp42_, _tmp43_, _tmp44_);
	g_object_ref_sink (_tmp45_);
	_g_object_unref0 (self->priv->app_treeview);
	self->priv->app_treeview = _tmp45_;
	_tmp46_ = self->priv->app_blacklist;
	g_signal_connect_object (_tmp46_, "application-removed", (GCallback) ___lambda16__alm_application_blacklist_application_removed, self, 0);
	_tmp47_ = self->priv->app_blacklist;
	g_signal_connect_object (_tmp47_, "application-added", (GCallback) ___lambda17__alm_application_blacklist_application_added, self, 0);
	alm_privacy_widget_setup_ui (self);
	special_dirs = (g_free (special_dirs), NULL);
	return self;
}

AlmPrivacyWidget*
alm_privacy_widget_new (AlmBlacklist* blacklist_interface)
{
	return alm_privacy_widget_construct (ALM_TYPE_PRIVACY_WIDGET, blacklist_interface);
}

static void
__lambda18_ (AlmPrivacyWidget* self,
             gboolean status)
{
	GtkSwitch* _tmp0_;
	_tmp0_ = self->priv->record_button;
	gtk_switch_set_active (_tmp0_, !status);
}

static void
___lambda18__alm_blacklist_incognito_toggled (AlmBlacklist* _sender,
                                              gboolean status,
                                              gpointer self)
{
	__lambda18_ ((AlmPrivacyWidget*) self, status);
}

static void
__lambda19_ (AlmPrivacyWidget* self)
{
	gboolean recording = FALSE;
	AlmBlacklist* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->blacklist;
	recording = !alm_blacklist_get_incognito (_tmp0_);
	_tmp1_ = self->priv->record_button;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != recording) {
		AlmBlacklist* _tmp4_;
		GSettings* _tmp5_;
		GtkSwitch* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp4_ = self->priv->blacklist;
		alm_blacklist_set_incognito (_tmp4_, recording);
		_tmp5_ = self->priv->privacy_settings;
		_tmp6_ = self->priv->record_button;
		_tmp7_ = gtk_switch_get_active (_tmp6_);
		_tmp8_ = _tmp7_;
		g_settings_set_boolean (_tmp5_, "remember-recent-files", _tmp8_);
	}
}

static void
___lambda19__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda19_ ((AlmPrivacyWidget*) self);
}

static void
__lambda20_ (AlmPrivacyWidget* self)
{
	AlmDeleteHistoryDialog* _tmp0_;
	_tmp0_ = self->priv->delete_dialog;
	alm_delete_history_dialog_on_delete_history (_tmp0_);
}

static void
___lambda20__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda20_ ((AlmPrivacyWidget*) self);
}

static gint
__lambda21_ (AlmPrivacyWidget* self,
             const gchar* s1,
             const gchar* s2)
{
	gint result;
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	result = g_utf8_collate (s1, s2);
	return result;
}

static gint
___lambda21__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda21_ ((AlmPrivacyWidget*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		AlmPrivacyWidget* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->check_button);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda22_ (Block4Data* _data4_)
{
	AlmPrivacyWidget* self;
	self = _data4_->self;
	if (self->priv->file_type_fire_signal) {
		GtkCheckButton* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		self->priv->file_type_fire_signal = FALSE;
		_tmp0_ = _data4_->check_button;
		_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			AlmFileTypeBlacklist* _tmp3_;
			GeeHashMap* _tmp4_;
			GtkCheckButton* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gpointer _tmp8_;
			gchar* _tmp9_;
			_tmp3_ = self->priv->files_type_blacklist;
			_tmp4_ = self->priv->mime_dict;
			_tmp5_ = _data4_->check_button;
			_tmp6_ = gtk_button_get_label ((GtkButton*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp7_);
			_tmp9_ = (gchar*) _tmp8_;
			alm_file_type_blacklist_unblock (_tmp3_, _tmp9_);
			_g_free0 (_tmp9_);
		} else {
			AlmFileTypeBlacklist* _tmp10_;
			GeeHashMap* _tmp11_;
			GtkCheckButton* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gpointer _tmp15_;
			gchar* _tmp16_;
			_tmp10_ = self->priv->files_type_blacklist;
			_tmp11_ = self->priv->mime_dict;
			_tmp12_ = _data4_->check_button;
			_tmp13_ = gtk_button_get_label ((GtkButton*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp14_);
			_tmp16_ = (gchar*) _tmp15_;
			alm_file_type_blacklist_block (_tmp10_, _tmp16_);
			_g_free0 (_tmp16_);
		}
		self->priv->file_type_fire_signal = TRUE;
	}
}

static void
_____lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                          gpointer self)
{
	____lambda22_ (self);
}

static void
_alm_privacy_widget_on_remove_exception_gtk_tool_button_clicked (GtkToolButton* _sender,
                                                                 gpointer self)
{
	alm_privacy_widget_on_remove_exception ((AlmPrivacyWidget*) self);
}

static void
_alm_privacy_widget_on_add_folder_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self)
{
	alm_privacy_widget_on_add_folder ((AlmPrivacyWidget*) self);
}

static void
_alm_privacy_widget_on_add_application_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                               gpointer self)
{
	alm_privacy_widget_on_add_application ((AlmPrivacyWidget*) self);
}

static void
alm_privacy_widget_setup_ui (AlmPrivacyWidget* self)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkSwitch* _tmp10_;
	GtkLabel* record_label = NULL;
	GtkLabel* _tmp11_;
	GtkSwitch* _tmp12_;
	AlmBlacklist* _tmp13_;
	AlmBlacklist* _tmp14_;
	GtkSwitch* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkSwitch* _tmp21_;
	GtkBox* _tmp22_;
	GtkLabel* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkBox* _tmp27_;
	GtkButton* _tmp28_;
	GtkBox* _tmp29_;
	GtkBox* checkbox_hbox = NULL;
	GtkBox* _tmp30_;
	GCompareDataFunc mime_compare = NULL;
	gpointer mime_compare_target;
	GDestroyNotify mime_compare_target_destroy_notify;
	GeeArrayList* keys = NULL;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	GeeHashMap* _tmp33_;
	GeeSet* _tmp34_;
	GeeSet* _tmp35_;
	GeeSet* _tmp36_;
	GeeArrayList* _tmp37_;
	GCompareDataFunc _tmp38_;
	gpointer _tmp38__target;
	AlmFileTypeBlacklist* _tmp60_;
	GtkLabel* checkbox_label = NULL;
	GtkLabel* _tmp67_;
	GtkAlignment* al = NULL;
	GtkAlignment* _tmp68_;
	GtkBox* checkbox_vbox = NULL;
	GtkBox* _tmp69_;
	GtkBox* _tmp70_;
	GtkBox* exception_vbox = NULL;
	GtkBox* _tmp71_;
	GtkLabel* exception_label = NULL;
	GtkLabel* _tmp72_;
	GtkAlignment* al2 = NULL;
	GtkAlignment* _tmp73_;
	GtkListStore* _tmp74_;
	GtkListStore* _tmp75_;
	GtkTreeView* _tmp76_;
	GtkTreeView* _tmp77_;
	GtkTreeView* _tmp78_;
	GtkTreeViewColumn* column_pix_name = NULL;
	GtkTreeViewColumn* _tmp79_;
	GtkTreeView* _tmp80_;
	AlmExceptionCellRenderer* pix_rend = NULL;
	AlmExceptionCellRenderer* _tmp81_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp82_;
	GtkTreeView* _tmp83_;
	GtkToolbar* exception_toolbar = NULL;
	GtkToolbar* _tmp84_;
	GtkStyleContext* _tmp85_;
	GtkStyleContext* _tmp86_;
	GtkStyleContext* _tmp87_;
	GtkToolItem* container_add = NULL;
	GtkToolItem* _tmp88_;
	GtkMenuButton* exception_add = NULL;
	GtkMenuButton* _tmp89_;
	GtkImage* icon = NULL;
	GtkImage* _tmp90_;
	GtkToolButton* exception_remove = NULL;
	GtkToolButton* _tmp91_;
	GtkMenu* _tmp92_;
	GtkMenuItem* folder_menu = NULL;
	GtkMenuItem* _tmp93_;
	GtkMenuItem* app_menu = NULL;
	GtkMenuItem* _tmp94_;
	GtkMenu* _tmp95_;
	GtkMenu* _tmp96_;
	GtkMenu* _tmp97_;
	GtkMenu* _tmp98_;
	GtkBox* general_hbox = NULL;
	GtkBox* _tmp99_;
	AlmApplicationBlacklist* _tmp100_;
	GHashTable* _tmp101_;
	GHashTable* _tmp102_;
	AlmApplicationsChooserDialog* _tmp103_;
	GtkButton* _tmp104_;
	AlmDeleteHistoryDialog* _tmp105_;
	g_return_if_fail (self != NULL);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
	_tmp0_ = g_strdup (_ ("This Operating System keeps track of Files and Applications you've use" \
"d to provide extra functionality. If other people can see or access yo" \
"ur user account, you may wish to limit which items are recorded."));
	text = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = label;
	_tmp3_ = text;
	_tmp4_ = g_strdup_printf ("%s", _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_markup (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = label;
	gtk_label_set_line_wrap (_tmp6_, TRUE);
	_tmp7_ = label;
	gtk_label_set_line_wrap_mode (_tmp7_, PANGO_WRAP_WORD);
	_tmp8_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp8_, (gfloat) 0, 0.5f);
	_tmp9_ = label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp9_, FALSE, TRUE, (guint) 0);
	_tmp10_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->record_button);
	self->priv->record_button = _tmp10_;
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Record file and application usage"));
	g_object_ref_sink (_tmp11_);
	record_label = _tmp11_;
	_tmp12_ = self->priv->record_button;
	_tmp13_ = self->priv->blacklist;
	gtk_switch_set_active (_tmp12_, !alm_blacklist_get_incognito (_tmp13_));
	_tmp14_ = self->priv->blacklist;
	g_signal_connect_object (_tmp14_, "incognito-toggled", (GCallback) ___lambda18__alm_blacklist_incognito_toggled, self, 0);
	_tmp15_ = self->priv->record_button;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::active", (GCallback) ___lambda19__g_object_notify, self, 0);
	_tmp16_ = (GtkButton*) gtk_button_new_from_stock (GTK_STOCK_DELETE);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->del_button);
	self->priv->del_button = _tmp16_;
	_tmp17_ = self->priv->del_button;
	gtk_button_set_label (_tmp17_, _ ("Clear Usage Data…"));
	_tmp18_ = self->priv->del_button;
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) ___lambda20__gtk_button_clicked, self, 0);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	g_object_ref_sink (_tmp19_);
	hbox = _tmp19_;
	_tmp20_ = hbox;
	_tmp21_ = self->priv->record_button;
	gtk_box_pack_start (_tmp20_, (GtkWidget*) _tmp21_, FALSE, FALSE, (guint) 3);
	_tmp22_ = hbox;
	_tmp23_ = record_label;
	gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, FALSE, FALSE, (guint) 3);
	_tmp24_ = hbox;
	_tmp25_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	gtk_box_pack_start (_tmp24_, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 3);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = hbox;
	_tmp28_ = self->priv->del_button;
	gtk_box_pack_start (_tmp27_, (GtkWidget*) _tmp28_, FALSE, FALSE, (guint) 3);
	_tmp29_ = hbox;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp29_, FALSE, TRUE, (guint) 0);
	_tmp30_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp30_);
	checkbox_hbox = _tmp30_;
	mime_compare = ___lambda21__gcompare_data_func;
	mime_compare_target = g_object_ref (self);
	mime_compare_target_destroy_notify = g_object_unref;
	_tmp31_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	keys = _tmp31_;
	_tmp32_ = keys;
	_tmp33_ = self->priv->mime_dict;
	_tmp34_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	gee_array_list_add_all (_tmp32_, (GeeCollection*) _tmp36_);
	_g_object_unref0 (_tmp36_);
	_tmp37_ = keys;
	_tmp38_ = mime_compare;
	_tmp38__target = mime_compare_target;
	gee_list_sort ((GeeList*) _tmp37_, _tmp38_, _tmp38__target, NULL);
	{
		GeeArrayList* _key_list = NULL;
		GeeArrayList* _tmp39_;
		gint _key_size = 0;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _key_index = 0;
		_tmp39_ = keys;
		_key_list = _tmp39_;
		_tmp40_ = _key_list;
		_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_key_size = _tmp42_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gchar* key = NULL;
			GeeArrayList* _tmp45_;
			gpointer _tmp46_;
			GtkCheckButton* check_button = NULL;
			const gchar* _tmp47_;
			GtkCheckButton* _tmp48_;
			GtkCheckButton* _tmp49_;
			GeeHashSet* _tmp50_;
			GtkCheckButton* _tmp51_;
			GeeHashMap* _tmp52_;
			GeeHashMap* _tmp53_;
			const gchar* _tmp54_;
			gpointer _tmp55_;
			gchar* _tmp56_;
			GtkCheckButton* _tmp57_;
			GtkBox* _tmp58_;
			GtkCheckButton* _tmp59_;
			_key_index = _key_index + 1;
			_tmp43_ = _key_index;
			_tmp44_ = _key_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _key_list;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _key_index);
			key = (gchar*) _tmp46_;
			_tmp47_ = key;
			_tmp48_ = (GtkCheckButton*) gtk_check_button_new_with_label (_tmp47_);
			g_object_ref_sink (_tmp48_);
			check_button = _tmp48_;
			_tmp49_ = check_button;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp49_, TRUE);
			_tmp50_ = self->priv->button_list;
			_tmp51_ = check_button;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp51_);
			_tmp52_ = self->priv->checkboxes;
			_tmp53_ = self->priv->mime_dict;
			_tmp54_ = key;
			_tmp55_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp53_, _tmp54_);
			_tmp56_ = (gchar*) _tmp55_;
			_tmp57_ = check_button;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp52_, _tmp56_, _tmp57_);
			_g_free0 (_tmp56_);
			_tmp58_ = checkbox_hbox;
			_tmp59_ = check_button;
			gtk_box_pack_start (_tmp58_, (GtkWidget*) _tmp59_, FALSE, FALSE, (guint) 0);
			_g_object_unref0 (check_button);
			_g_free0 (key);
		}
	}
	_tmp60_ = self->priv->files_type_blacklist;
	alm_file_type_blacklist_populate_file_types (_tmp60_);
	{
		GeeIterator* _check_button_it = NULL;
		GeeHashSet* _tmp61_;
		GeeIterator* _tmp62_;
		_tmp61_ = self->priv->button_list;
		_tmp62_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp61_);
		_check_button_it = _tmp62_;
		while (TRUE) {
			Block4Data* _data4_;
			GeeIterator* _tmp63_;
			GeeIterator* _tmp64_;
			gpointer _tmp65_;
			GtkCheckButton* _tmp66_;
			_data4_ = g_slice_new0 (Block4Data);
			_data4_->_ref_count_ = 1;
			_data4_->self = g_object_ref (self);
			_tmp63_ = _check_button_it;
			if (!gee_iterator_next (_tmp63_)) {
				block4_data_unref (_data4_);
				_data4_ = NULL;
				break;
			}
			_tmp64_ = _check_button_it;
			_tmp65_ = gee_iterator_get (_tmp64_);
			_data4_->check_button = (GtkCheckButton*) _tmp65_;
			_tmp66_ = _data4_->check_button;
			g_signal_connect_data ((GtkToggleButton*) _tmp66_, "toggled", (GCallback) _____lambda22__gtk_toggle_button_toggled, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
			block4_data_unref (_data4_);
			_data4_ = NULL;
		}
		_g_object_unref0 (_check_button_it);
	}
	_tmp67_ = (GtkLabel*) gtk_label_new (_ ("Include:"));
	g_object_ref_sink (_tmp67_);
	checkbox_label = _tmp67_;
	_tmp68_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, 0.5f, (gfloat) 0, (gfloat) 0);
	g_object_ref_sink (_tmp68_);
	al = _tmp68_;
	gtk_container_add ((GtkContainer*) al, (GtkWidget*) checkbox_label);
	_tmp69_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp69_);
	checkbox_vbox = _tmp69_;
	gtk_box_pack_start (checkbox_vbox, (GtkWidget*) al, FALSE, TRUE, (guint) 0);
	_tmp70_ = checkbox_hbox;
	gtk_box_pack_start (checkbox_vbox, (GtkWidget*) _tmp70_, TRUE, TRUE, (guint) 0);
	_tmp71_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp71_);
	exception_vbox = _tmp71_;
	_tmp72_ = (GtkLabel*) gtk_label_new (_ ("Exclude:"));
	g_object_ref_sink (_tmp72_);
	exception_label = _tmp72_;
	_tmp73_ = (GtkAlignment*) gtk_alignment_new ((gfloat) 0, 0.5f, (gfloat) 0, (gfloat) 0);
	g_object_ref_sink (_tmp73_);
	al2 = _tmp73_;
	gtk_container_add ((GtkContainer*) al2, (GtkWidget*) exception_label);
	gtk_box_pack_start (exception_vbox, (GtkWidget*) al2, FALSE, FALSE, (guint) 5);
	_tmp74_ = gtk_list_store_new (4, G_TYPE_STRING, gdk_pixbuf_get_type (), G_TYPE_STRING, ALM_TYPE_ITEM_TYPE, -1);
	_g_object_unref0 (self->priv->exception_list_store);
	self->priv->exception_list_store = _tmp74_;
	_tmp75_ = self->priv->exception_list_store;
	_tmp76_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp75_);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->exception_list);
	self->priv->exception_list = _tmp76_;
	_tmp77_ = self->priv->exception_list;
	gtk_tree_view_set_headers_visible (_tmp77_, FALSE);
	_tmp78_ = self->priv->exception_list;
	gtk_tree_view_set_rules_hint (_tmp78_, TRUE);
	_tmp79_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp79_);
	column_pix_name = _tmp79_;
	gtk_tree_view_column_set_title (column_pix_name, _ ("Name"));
	_tmp80_ = self->priv->exception_list;
	gtk_tree_view_append_column (_tmp80_, column_pix_name);
	_tmp81_ = alm_exception_cell_renderer_new ();
	g_object_ref_sink (_tmp81_);
	pix_rend = _tmp81_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column_pix_name, (GtkCellRenderer*) pix_rend, FALSE);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_pix_name, (GtkCellRenderer*) pix_rend, "pixbuf", 1);
	gtk_cell_layout_add_attribute ((GtkCellLayout*) column_pix_name, (GtkCellRenderer*) pix_rend, "text", 2);
	_tmp82_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp82_);
	scroll = _tmp82_;
	_tmp83_ = self->priv->exception_list;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp83_);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
	gtk_container_set_border_width ((GtkContainer*) scroll, (guint) 1);
	gtk_box_pack_start (exception_vbox, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	_tmp84_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp84_);
	exception_toolbar = _tmp84_;
	g_object_set (exception_toolbar, "toolbar-style", GTK_TOOLBAR_ICONS, NULL);
	gtk_toolbar_set_icon_size (exception_toolbar, GTK_ICON_SIZE_MENU);
	g_object_set (exception_toolbar, "icon-size-set", TRUE, NULL);
	gtk_widget_set_visible ((GtkWidget*) exception_toolbar, TRUE);
	_tmp85_ = gtk_widget_get_style_context ((GtkWidget*) scroll);
	gtk_style_context_set_junction_sides (_tmp85_, GTK_JUNCTION_BOTTOM);
	_tmp86_ = gtk_widget_get_style_context ((GtkWidget*) exception_toolbar);
	gtk_style_context_add_class (_tmp86_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp87_ = gtk_widget_get_style_context ((GtkWidget*) exception_toolbar);
	gtk_style_context_set_junction_sides (_tmp87_, GTK_JUNCTION_TOP);
	_tmp88_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp88_);
	container_add = _tmp88_;
	_tmp89_ = (GtkMenuButton*) gtk_menu_button_new ();
	g_object_ref_sink (_tmp89_);
	exception_add = _tmp89_;
	_tmp90_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp90_);
	icon = _tmp90_;
	gtk_button_set_image ((GtkButton*) exception_add, G_TYPE_CHECK_INSTANCE_CAST (icon, gtk_widget_get_type (), GtkWidget));
	_tmp91_ = (GtkToolButton*) gtk_tool_button_new (NULL, _ ("Remove Item"));
	g_object_ref_sink (_tmp91_);
	exception_remove = _tmp91_;
	gtk_tool_button_set_icon_name (exception_remove, "list-remove-symbolic");
	g_signal_connect_object (exception_remove, "clicked", (GCallback) _alm_privacy_widget_on_remove_exception_gtk_tool_button_clicked, self, 0);
	gtk_container_add ((GtkContainer*) container_add, (GtkWidget*) exception_add);
	gtk_widget_show_all ((GtkWidget*) container_add);
	gtk_toolbar_insert (exception_toolbar, container_add, 0);
	gtk_toolbar_insert (exception_toolbar, (GtkToolItem*) exception_remove, 1);
	_tmp92_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->exception_menu);
	self->priv->exception_menu = _tmp92_;
	_tmp93_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Add Folder…");
	g_object_ref_sink (_tmp93_);
	folder_menu = _tmp93_;
	g_signal_connect_object (folder_menu, "activate", (GCallback) _alm_privacy_widget_on_add_folder_gtk_menu_item_activate, self, 0);
	_tmp94_ = (GtkMenuItem*) gtk_menu_item_new_with_label ("Add Application…");
	g_object_ref_sink (_tmp94_);
	app_menu = _tmp94_;
	g_signal_connect_object (app_menu, "activate", (GCallback) _alm_privacy_widget_on_add_application_gtk_menu_item_activate, self, 0);
	_tmp95_ = self->priv->exception_menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp95_, folder_menu);
	_tmp96_ = self->priv->exception_menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp96_, app_menu);
	_tmp97_ = self->priv->exception_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp97_);
	_tmp98_ = self->priv->exception_menu;
	gtk_menu_button_set_popup (exception_add, (GtkWidget*) _tmp98_);
	gtk_box_pack_start (exception_vbox, (GtkWidget*) exception_toolbar, FALSE, FALSE, (guint) 0);
	_tmp99_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp99_);
	general_hbox = _tmp99_;
	gtk_box_pack_start (general_hbox, (GtkWidget*) checkbox_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start (general_hbox, (GtkWidget*) exception_vbox, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) general_hbox, FALSE, TRUE, (guint) 0);
	_tmp100_ = self->priv->app_blacklist;
	_tmp101_ = self->priv->blocked_list;
	_tmp102_ = self->priv->unblocked_list;
	_tmp103_ = alm_applications_chooser_dialog_new (_tmp100_, _tmp101_, _tmp102_);
	g_object_ref_sink (_tmp103_);
	_g_object_unref0 (self->priv->app_dialog);
	self->priv->app_dialog = _tmp103_;
	_tmp104_ = self->priv->del_button;
	_tmp105_ = alm_delete_history_dialog_new (_tmp104_);
	g_object_ref_sink (_tmp105_);
	_g_object_unref0 (self->priv->delete_dialog);
	self->priv->delete_dialog = _tmp105_;
	alm_privacy_widget_folders_populate (self);
	alm_privacy_widget_app_populate (self);
	_g_object_unref0 (general_hbox);
	_g_object_unref0 (app_menu);
	_g_object_unref0 (folder_menu);
	_g_object_unref0 (exception_remove);
	_g_object_unref0 (icon);
	_g_object_unref0 (exception_add);
	_g_object_unref0 (container_add);
	_g_object_unref0 (exception_toolbar);
	_g_object_unref0 (scroll);
	_g_object_unref0 (pix_rend);
	_g_object_unref0 (column_pix_name);
	_g_object_unref0 (al2);
	_g_object_unref0 (exception_label);
	_g_object_unref0 (exception_vbox);
	_g_object_unref0 (checkbox_vbox);
	_g_object_unref0 (al);
	_g_object_unref0 (checkbox_label);
	_g_object_unref0 (keys);
	(mime_compare_target_destroy_notify == NULL) ? NULL : (mime_compare_target_destroy_notify (mime_compare_target), NULL);
	mime_compare = NULL;
	mime_compare_target = NULL;
	mime_compare_target_destroy_notify = NULL;
	_g_object_unref0 (checkbox_hbox);
	_g_object_unref0 (hbox);
	_g_object_unref0 (record_label);
	_g_object_unref0 (label);
	_g_free0 (text);
}

gint
alm_privacy_widget_compare_mimes (AlmPrivacyWidget* self,
                                  const gchar* s1,
                                  const gchar* s2)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	result = g_utf8_collate (s1, s2);
	return result;
}

static void
alm_privacy_widget_folders_populate (AlmPrivacyWidget* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _folder_it = NULL;
		AlmPathBlacklist* _tmp0_;
		GeeHashSet* _tmp1_;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->priv->path_blacklist;
		_tmp1_ = alm_path_blacklist_get_all_folders (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp2_);
		_folder_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gchar* folder = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = _folder_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _folder_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			folder = (gchar*) _tmp6_;
			_tmp7_ = folder;
			alm_privacy_widget_add_folder_to_view (self, _tmp7_);
			_g_free0 (folder);
		}
		_g_object_unref0 (_folder_it);
	}
}

static void
alm_privacy_widget_app_populate (AlmPrivacyWidget* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _app_it = NULL;
		AlmApplicationBlacklist* _tmp0_;
		GeeHashSet* _tmp1_;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->priv->app_blacklist;
		_tmp1_ = alm_application_blacklist_get_all_apps (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp2_);
		_app_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gchar* app = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = _app_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _app_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			app = (gchar*) _tmp6_;
			_tmp7_ = app;
			alm_privacy_widget_add_app_to_view (self, _tmp7_);
			_g_free0 (app);
		}
		_g_object_unref0 (_app_it);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
alm_privacy_widget_on_remove_exception (AlmPrivacyWidget* self)
{
	GtkTreeSelection* sel = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->exception_list;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	sel = _tmp2_;
	_tmp3_ = sel;
	if (_tmp3_ != NULL) {
		GtkTreeModel* model = NULL;
		GtkTreeIter iter = {0};
		GtkTreeSelection* _tmp4_;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gboolean _tmp7_;
		GtkTreeModel* _tmp8_;
		_tmp4_ = sel;
		_tmp7_ = gtk_tree_selection_get_selected (_tmp4_, &_tmp5_, &_tmp6_);
		_g_object_unref0 (model);
		_tmp8_ = _g_object_ref0 (_tmp5_);
		model = _tmp8_;
		iter = _tmp6_;
		if (_tmp7_) {
			gchar* name = NULL;
			AlmItemType type = 0;
			GtkTreeModel* _tmp9_;
			GtkTreeIter _tmp10_;
			gchar* _tmp11_ = NULL;
			AlmItemType _tmp12_ = 0;
			const gchar* _tmp13_;
			_tmp9_ = model;
			_tmp10_ = iter;
			gtk_tree_model_get (_tmp9_, &_tmp10_, 0, &_tmp11_, 3, &_tmp12_, -1);
			_g_free0 (name);
			name = _tmp11_;
			type = _tmp12_;
			_tmp13_ = name;
			if (_tmp13_ != NULL) {
				GtkListStore* _tmp14_;
				_tmp14_ = self->priv->exception_list_store;
				gtk_list_store_remove (_tmp14_, &iter);
				if (type == ALM_ITEM_TYPE_FILE) {
					AlmPathBlacklist* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = self->priv->path_blacklist;
					_tmp16_ = name;
					alm_path_blacklist_unblock (_tmp15_, _tmp16_);
				} else {
					AlmApplicationBlacklist* _tmp17_;
					const gchar* _tmp18_;
					_tmp17_ = self->priv->app_blacklist;
					_tmp18_ = name;
					alm_application_blacklist_unblock (_tmp17_, _tmp18_);
				}
			}
			_g_free0 (name);
		}
		_g_object_unref0 (model);
	}
	_g_object_unref0 (sel);
}

static void
alm_privacy_widget_on_add_folder (AlmPrivacyWidget* self)
{
	GtkFileChooserDialog* chooser = NULL;
	GtkFileChooserDialog* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	gint res = 0;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Select a folder to blacklist"), NULL, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER, NULL);
	g_object_ref_sink (_tmp0_);
	chooser = _tmp0_;
	_tmp1_ = chooser;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp1_, GTK_STOCK_OK, GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
	_tmp2_ = chooser;
	res = gtk_dialog_run ((GtkDialog*) _tmp2_);
	_tmp3_ = chooser;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		gchar* folder = NULL;
		GtkFileChooserDialog* _tmp4_;
		gchar* _tmp5_;
		AlmPathBlacklist* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = chooser;
		_tmp5_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp4_);
		folder = _tmp5_;
		_tmp6_ = self->priv->path_blacklist;
		_tmp7_ = folder;
		if (!alm_path_blacklist_is_duplicate (_tmp6_, _tmp7_)) {
			const gchar* _tmp8_;
			AlmPathBlacklist* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = folder;
			alm_privacy_widget_add_folder_to_view (self, _tmp8_);
			_tmp9_ = self->priv->path_blacklist;
			_tmp10_ = folder;
			alm_path_blacklist_block (_tmp9_, _tmp10_);
		}
		_g_free0 (folder);
	}
	_g_object_unref0 (chooser);
}

static void
alm_privacy_widget_on_add_file (AlmPrivacyWidget* self)
{
	GtkFileChooserDialog* chooser = NULL;
	GtkFileChooserDialog* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	gint res = 0;
	GtkFileChooserDialog* _tmp2_;
	GtkFileChooserDialog* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Select a file to blacklist"), NULL, GTK_FILE_CHOOSER_ACTION_OPEN, NULL);
	g_object_ref_sink (_tmp0_);
	chooser = _tmp0_;
	_tmp1_ = chooser;
	gtk_dialog_add_buttons ((GtkDialog*) _tmp1_, GTK_STOCK_OK, GTK_RESPONSE_OK, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, NULL);
	_tmp2_ = chooser;
	res = gtk_dialog_run ((GtkDialog*) _tmp2_);
	_tmp3_ = chooser;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		gchar* filename = NULL;
		GtkFileChooserDialog* _tmp4_;
		gchar* _tmp5_;
		AlmPathBlacklist* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = chooser;
		_tmp5_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp4_);
		filename = _tmp5_;
		_tmp6_ = self->priv->path_blacklist;
		_tmp7_ = filename;
		if (!alm_path_blacklist_is_duplicate (_tmp6_, _tmp7_)) {
			const gchar* _tmp8_;
			AlmPathBlacklist* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = filename;
			alm_privacy_widget_add_folder_to_view (self, _tmp8_);
			_tmp9_ = self->priv->path_blacklist;
			_tmp10_ = filename;
			alm_path_blacklist_block (_tmp9_, _tmp10_);
		}
		_g_free0 (filename);
	}
	_g_object_unref0 (chooser);
}

static gpointer
_alm_app_choose_info_ref0 (gpointer self)
{
	return self ? alm_app_choose_info_ref (self) : NULL;
}

static void
alm_privacy_widget_on_add_application (AlmPrivacyWidget* self)
{
	AlmApplicationsChooserDialog* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AlmApplicationsChooserDialog* _tmp3_;
	AlmApplicationsChooserDialog* _tmp4_;
	gint res = 0;
	AlmApplicationsChooserDialog* _tmp5_;
	GtkWidget* _tmp6_;
	AlmApplicationsChooserDialog* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app_dialog;
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_window_set_transient_for ((GtkWindow*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_set_sensitive (_tmp2_, FALSE);
	_tmp3_ = self->priv->app_dialog;
	gtk_window_set_modal ((GtkWindow*) _tmp3_, TRUE);
	_tmp4_ = self->priv->app_dialog;
	gtk_window_set_title ((GtkWindow*) _tmp4_, _ ("Select Application"));
	_tmp5_ = self->priv->app_dialog;
	res = gtk_dialog_run ((GtkDialog*) _tmp5_);
	_tmp6_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_set_sensitive (_tmp6_, TRUE);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		GtkTreeSelection* sel = NULL;
		AlmApplicationsChooserDialog* _tmp7_;
		GtkTreeView* _tmp8_;
		GtkTreeView* _tmp9_;
		GtkTreeSelection* _tmp10_;
		GtkTreeSelection* _tmp11_;
		GtkTreeModel* model = NULL;
		GtkTreeIter iter = {0};
		GtkTreeSelection* _tmp12_;
		GtkTreeModel* _tmp13_ = NULL;
		GtkTreeIter _tmp14_ = {0};
		GtkTreeModel* _tmp15_;
		gchar* app = NULL;
		GtkTreeModel* _tmp16_;
		GtkTreeIter _tmp17_;
		gchar* _tmp18_ = NULL;
		AlmApplicationsChooserDialog* _tmp19_;
		GtkListStore* _tmp20_;
		GtkListStore* _tmp21_;
		const gchar* _tmp22_;
		AlmApplicationBlacklist* _tmp23_;
		const gchar* _tmp24_;
		AlmAppChooseInfo* info = NULL;
		GHashTable* _tmp25_;
		const gchar* _tmp26_;
		gconstpointer _tmp27_;
		AlmAppChooseInfo* _tmp28_;
		AlmAppChooseInfo* _tmp29_;
		_tmp7_ = self->priv->app_dialog;
		_tmp8_ = alm_applications_chooser_dialog_get_tree (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gtk_tree_view_get_selection (_tmp9_);
		_tmp11_ = _g_object_ref0 (_tmp10_);
		sel = _tmp11_;
		_tmp12_ = sel;
		gtk_tree_selection_get_selected (_tmp12_, &_tmp13_, &_tmp14_);
		_g_object_unref0 (model);
		_tmp15_ = _g_object_ref0 (_tmp13_);
		model = _tmp15_;
		iter = _tmp14_;
		_tmp16_ = model;
		_tmp17_ = iter;
		gtk_tree_model_get (_tmp16_, &_tmp17_, 2, &_tmp18_, -1);
		_g_free0 (app);
		app = _tmp18_;
		_tmp19_ = self->priv->app_dialog;
		_tmp20_ = alm_applications_chooser_dialog_get_liststore (_tmp19_);
		_tmp21_ = _tmp20_;
		gtk_list_store_remove (_tmp21_, &iter);
		self->priv->app_change_recursive = TRUE;
		_tmp22_ = app;
		alm_privacy_widget_add_app_to_view (self, _tmp22_);
		_tmp23_ = self->priv->app_blacklist;
		_tmp24_ = app;
		alm_application_blacklist_block (_tmp23_, _tmp24_);
		_tmp25_ = self->priv->unblocked_list;
		_tmp26_ = app;
		_tmp27_ = g_hash_table_lookup (_tmp25_, _tmp26_);
		_tmp28_ = _alm_app_choose_info_ref0 ((AlmAppChooseInfo*) _tmp27_);
		info = _tmp28_;
		_tmp29_ = info;
		if (_tmp29_ != NULL) {
			GHashTable* _tmp30_;
			const gchar* _tmp31_;
			GHashTable* _tmp32_;
			const gchar* _tmp33_;
			gconstpointer _tmp34_;
			_tmp30_ = self->priv->unblocked_list;
			_tmp31_ = app;
			g_hash_table_remove (_tmp30_, _tmp31_);
			_tmp32_ = self->priv->blocked_list;
			_tmp33_ = app;
			_tmp34_ = g_hash_table_lookup (_tmp32_, _tmp33_);
			if (((AlmAppChooseInfo*) _tmp34_) == NULL) {
				GHashTable* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				AlmAppChooseInfo* _tmp38_;
				AlmAppChooseInfo* _tmp39_;
				_tmp35_ = self->priv->blocked_list;
				_tmp36_ = app;
				_tmp37_ = g_strdup (_tmp36_);
				_tmp38_ = info;
				_tmp39_ = _alm_app_choose_info_ref0 (_tmp38_);
				g_hash_table_insert (_tmp35_, _tmp37_, _tmp39_);
			} else {
				GHashTable* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				AlmAppChooseInfo* _tmp43_;
				AlmAppChooseInfo* _tmp44_;
				_tmp40_ = self->priv->blocked_list;
				_tmp41_ = app;
				_tmp42_ = g_strdup (_tmp41_);
				_tmp43_ = info;
				_tmp44_ = _alm_app_choose_info_ref0 (_tmp43_);
				g_hash_table_replace (_tmp40_, _tmp42_, _tmp44_);
			}
		}
		_alm_app_choose_info_unref0 (info);
		_g_free0 (app);
		_g_object_unref0 (model);
		_g_object_unref0 (sel);
	}
	_tmp45_ = self->priv->app_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp45_);
}

static const char*
_g_user_directory_to_string (GUserDirectory value)
{
	switch (value) {
		case G_USER_DIRECTORY_DESKTOP:
		return "G_USER_DIRECTORY_DESKTOP";
		case G_USER_DIRECTORY_DOCUMENTS:
		return "G_USER_DIRECTORY_DOCUMENTS";
		case G_USER_DIRECTORY_DOWNLOAD:
		return "G_USER_DIRECTORY_DOWNLOAD";
		case G_USER_DIRECTORY_MUSIC:
		return "G_USER_DIRECTORY_MUSIC";
		case G_USER_DIRECTORY_PICTURES:
		return "G_USER_DIRECTORY_PICTURES";
		case G_USER_DIRECTORY_PUBLIC_SHARE:
		return "G_USER_DIRECTORY_PUBLIC_SHARE";
		case G_USER_DIRECTORY_TEMPLATES:
		return "G_USER_DIRECTORY_TEMPLATES";
		case G_USER_DIRECTORY_VIDEOS:
		return "G_USER_DIRECTORY_VIDEOS";
		case G_USER_N_DIRECTORIES:
		return "G_USER_N_DIRECTORIES";
	}
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
alm_privacy_widget_add_folder_to_view (AlmPrivacyWidget* self,
                                       const gchar* folder)
{
	GdkPixbuf* icon = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GThemedIcon* nautilus_icon = NULL;
	GeeHashMap* _tmp2_;
	gchar* name = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp31_;
	GtkTreeIter _tmp32_ = {0};
	GtkListStore* _tmp33_;
	GtkTreeIter _tmp34_;
	GdkPixbuf* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->stock_folder_icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	icon = _tmp1_;
	nautilus_icon = NULL;
	_tmp2_ = self->priv->defined_dirs;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, folder)) {
		GUserDirectory dir = 0;
		GeeHashMap* _tmp3_;
		gpointer _tmp4_;
		const gchar* _tmp5_;
		GThemedIcon* _tmp21_;
		_tmp3_ = self->priv->defined_dirs;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, folder);
		dir = (GUserDirectory) ((gintptr) _tmp4_);
		_tmp5_ = _g_user_directory_to_string (dir);
		if (g_strcmp0 (_tmp5_, "G_USER_DIRECTORY_DOCUMENTS") == 0) {
			GThemedIcon* _tmp6_;
			_tmp6_ = (GThemedIcon*) g_themed_icon_new ("folder-documents");
			_g_object_unref0 (nautilus_icon);
			nautilus_icon = _tmp6_;
		} else {
			const gchar* _tmp7_;
			_tmp7_ = _g_user_directory_to_string (dir);
			if (g_strcmp0 (_tmp7_, "G_USER_DIRECTORY_DOWNLOAD") == 0) {
				GThemedIcon* _tmp8_;
				_tmp8_ = (GThemedIcon*) g_themed_icon_new ("folder-download");
				_g_object_unref0 (nautilus_icon);
				nautilus_icon = _tmp8_;
			} else {
				const gchar* _tmp9_;
				_tmp9_ = _g_user_directory_to_string (dir);
				if (g_strcmp0 (_tmp9_, "G_USER_DIRECTORY_MUSIC") == 0) {
					GThemedIcon* _tmp10_;
					_tmp10_ = (GThemedIcon*) g_themed_icon_new ("folder-music");
					_g_object_unref0 (nautilus_icon);
					nautilus_icon = _tmp10_;
				} else {
					const gchar* _tmp11_;
					_tmp11_ = _g_user_directory_to_string (dir);
					if (g_strcmp0 (_tmp11_, "G_USER_DIRECTORY_DESKTOP") == 0) {
						GThemedIcon* _tmp12_;
						_tmp12_ = (GThemedIcon*) g_themed_icon_new ("user-desktop");
						_g_object_unref0 (nautilus_icon);
						nautilus_icon = _tmp12_;
					} else {
						const gchar* _tmp13_;
						_tmp13_ = _g_user_directory_to_string (dir);
						if (g_strcmp0 (_tmp13_, "G_USER_DIRECTORY_PICTURES") == 0) {
							GThemedIcon* _tmp14_;
							_tmp14_ = (GThemedIcon*) g_themed_icon_new ("folder-pictures");
							_g_object_unref0 (nautilus_icon);
							nautilus_icon = _tmp14_;
						} else {
							const gchar* _tmp15_;
							_tmp15_ = _g_user_directory_to_string (dir);
							if (g_strcmp0 (_tmp15_, "G_USER_DIRECTORY_VIDEOS") == 0) {
								GThemedIcon* _tmp16_;
								_tmp16_ = (GThemedIcon*) g_themed_icon_new ("folder-videos");
								_g_object_unref0 (nautilus_icon);
								nautilus_icon = _tmp16_;
							} else {
								const gchar* _tmp17_;
								_tmp17_ = _g_user_directory_to_string (dir);
								if (g_strcmp0 (_tmp17_, "G_USER_DIRECTORY_TEMPLATES") == 0) {
									GThemedIcon* _tmp18_;
									_tmp18_ = (GThemedIcon*) g_themed_icon_new ("folder-templates");
									_g_object_unref0 (nautilus_icon);
									nautilus_icon = _tmp18_;
								} else {
									const gchar* _tmp19_;
									_tmp19_ = _g_user_directory_to_string (dir);
									if (g_strcmp0 (_tmp19_, "G_USER_DIRECTORY_PUBLIC_SHARE") == 0) {
										GThemedIcon* _tmp20_;
										_tmp20_ = (GThemedIcon*) g_themed_icon_new ("folder-publicshare");
										_g_object_unref0 (nautilus_icon);
										nautilus_icon = _tmp20_;
									}
								}
							}
						}
					}
				}
			}
		}
		_tmp21_ = nautilus_icon;
		if (_tmp21_ != NULL) {
			GdkPixbuf* pixbuf = NULL;
			GThemedIcon* _tmp22_;
			GdkPixbuf* _tmp23_;
			GdkPixbuf* _tmp24_;
			_tmp22_ = nautilus_icon;
			_tmp23_ = alm_applications_tree_view_get_pixbuf_from_gio_icon ((GIcon*) _tmp22_, 24);
			pixbuf = _tmp23_;
			_tmp24_ = pixbuf;
			if (_tmp24_ != NULL) {
				GdkPixbuf* _tmp25_;
				GdkPixbuf* _tmp26_;
				_tmp25_ = pixbuf;
				_tmp26_ = _g_object_ref0 (_tmp25_);
				_g_object_unref0 (icon);
				icon = _tmp26_;
			}
			_g_object_unref0 (pixbuf);
		}
	}
	_tmp27_ = string_strip (folder);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_path_get_basename (_tmp28_);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	name = _tmp30_;
	_tmp31_ = self->priv->exception_list_store;
	gtk_list_store_append (_tmp31_, &_tmp32_);
	iter = _tmp32_;
	_tmp33_ = self->priv->exception_list_store;
	_tmp34_ = iter;
	_tmp35_ = icon;
	gtk_list_store_set (_tmp33_, &_tmp34_, 0, folder, 1, _tmp35_, 2, name, 3, ALM_ITEM_TYPE_FILE, -1, -1);
	_g_free0 (name);
	_g_object_unref0 (nautilus_icon);
	_g_object_unref0 (icon);
}

static gboolean
alm_privacy_widget_remove_folder_from_view (AlmPrivacyWidget* self,
                                            const gchar* folder)
{
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (folder != NULL, FALSE);
	_tmp0_ = self->priv->exception_list;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	while (TRUE) {
		GValue can_app_value = {0};
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		GValue _tmp7_ = {0};
		gchar* cand_folder = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean more_entires = FALSE;
		GtkTreeModel* _tmp12_;
		gboolean _tmp13_;
		_tmp5_ = model;
		_tmp6_ = iter;
		gtk_tree_model_get_value (_tmp5_, &_tmp6_, 0, &_tmp7_);
		G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
		can_app_value = _tmp7_;
		_tmp8_ = g_value_get_string (&can_app_value);
		_tmp9_ = g_strdup (_tmp8_);
		cand_folder = _tmp9_;
		_tmp10_ = cand_folder;
		if (g_strcmp0 (folder, _tmp10_) == 0) {
			GtkListStore* _tmp11_;
			_tmp11_ = self->priv->exception_list_store;
			gtk_list_store_remove (_tmp11_, &iter);
			result = TRUE;
			_g_free0 (cand_folder);
			G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
			_g_object_unref0 (model);
			return result;
		}
		_tmp12_ = model;
		_tmp13_ = gtk_tree_model_iter_next (_tmp12_, &iter);
		more_entires = _tmp13_;
		if (!more_entires) {
			result = FALSE;
			_g_free0 (cand_folder);
			G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
			_g_object_unref0 (model);
			return result;
		}
		_g_free0 (cand_folder);
		G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
	}
}

static void
alm_privacy_widget_add_app_to_view (AlmPrivacyWidget* self,
                                    const gchar* app)
{
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = g_desktop_app_info_new (app);
	app_info = _tmp0_;
	_tmp1_ = app_info;
	if (_tmp1_ != NULL) {
		GdkPixbuf* pix = NULL;
		GDesktopAppInfo* _tmp2_;
		GIcon* _tmp3_;
		GdkPixbuf* _tmp4_;
		gchar* markup = NULL;
		GDesktopAppInfo* _tmp5_;
		gchar* _tmp6_;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp7_;
		GtkTreeIter _tmp8_ = {0};
		GtkListStore* _tmp9_;
		GtkTreeIter _tmp10_;
		GdkPixbuf* _tmp11_;
		GDesktopAppInfo* _tmp12_;
		const gchar* _tmp13_;
		GHashTable* _tmp14_;
		gconstpointer _tmp15_;
		_tmp2_ = app_info;
		_tmp3_ = g_app_info_get_icon ((GAppInfo*) _tmp2_);
		_tmp4_ = alm_applications_tree_view_get_pixbuf_from_gio_icon (_tmp3_, 24);
		pix = _tmp4_;
		_tmp5_ = app_info;
		_tmp6_ = alm_applications_tree_view_markup_for_app (_tmp5_);
		markup = _tmp6_;
		_tmp7_ = self->priv->exception_list_store;
		gtk_list_store_append (_tmp7_, &_tmp8_);
		iter = _tmp8_;
		_tmp9_ = self->priv->exception_list_store;
		_tmp10_ = iter;
		_tmp11_ = pix;
		_tmp12_ = app_info;
		_tmp13_ = g_app_info_get_name ((GAppInfo*) _tmp12_);
		gtk_list_store_set (_tmp9_, &_tmp10_, 0, app, 1, _tmp11_, 2, _tmp13_, 3, ALM_ITEM_TYPE_APPLICATION, -1, -1);
		_tmp14_ = self->priv->blocked_list;
		_tmp15_ = g_hash_table_lookup (_tmp14_, app);
		if (((AlmAppChooseInfo*) _tmp15_) == NULL) {
			GHashTable* _tmp16_;
			gchar* _tmp17_;
			GDesktopAppInfo* _tmp18_;
			const gchar* _tmp19_;
			GDesktopAppInfo* _tmp20_;
			const gchar* _tmp21_;
			GdkPixbuf* _tmp22_;
			AlmAppChooseInfo* _tmp23_;
			_tmp16_ = self->priv->blocked_list;
			_tmp17_ = g_strdup (app);
			_tmp18_ = app_info;
			_tmp19_ = g_app_info_get_id ((GAppInfo*) _tmp18_);
			_tmp20_ = app_info;
			_tmp21_ = g_app_info_get_name ((GAppInfo*) _tmp20_);
			_tmp22_ = pix;
			_tmp23_ = alm_app_choose_info_new (_tmp19_, _tmp21_, _tmp22_, "", (gint64) 0, (guint) 0);
			g_hash_table_insert (_tmp16_, _tmp17_, _tmp23_);
		}
		_g_free0 (markup);
		_g_object_unref0 (pix);
	}
	_g_object_unref0 (app_info);
}

static void
alm_privacy_widget_remove_app_from_view (AlmPrivacyWidget* self,
                                         const gchar* app)
{
	GtkTreeModel* model = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	_tmp0_ = self->priv->exception_list;
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = model;
	gtk_tree_model_get_iter_first (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	while (TRUE) {
		GValue can_app_value = {0};
		GtkTreeModel* _tmp5_;
		GtkTreeIter _tmp6_;
		GValue _tmp7_ = {0};
		gchar* can_app = NULL;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean more_entires = FALSE;
		GtkTreeModel* _tmp12_;
		gboolean _tmp13_;
		_tmp5_ = model;
		_tmp6_ = iter;
		gtk_tree_model_get_value (_tmp5_, &_tmp6_, 2, &_tmp7_);
		G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
		can_app_value = _tmp7_;
		_tmp8_ = g_value_get_string (&can_app_value);
		_tmp9_ = g_strdup (_tmp8_);
		can_app = _tmp9_;
		_tmp10_ = can_app;
		if (g_strcmp0 (app, _tmp10_) == 0) {
			GtkListStore* _tmp11_;
			_tmp11_ = self->priv->exception_list_store;
			gtk_list_store_remove (_tmp11_, &iter);
			_g_free0 (can_app);
			G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
			break;
		}
		_tmp12_ = model;
		_tmp13_ = gtk_tree_model_iter_next (_tmp12_, &iter);
		more_entires = _tmp13_;
		if (!more_entires) {
			_g_free0 (can_app);
			G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
			break;
		}
		_g_free0 (can_app);
		G_IS_VALUE (&can_app_value) ? (g_value_unset (&can_app_value), NULL) : NULL;
	}
	_g_object_unref0 (model);
}

static void
alm_privacy_widget_class_init (AlmPrivacyWidgetClass * klass,
                               gpointer klass_data)
{
	alm_privacy_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AlmPrivacyWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = alm_privacy_widget_finalize;
}

static void
alm_privacy_widget_instance_init (AlmPrivacyWidget * self,
                                  gpointer klass)
{
	self->priv = alm_privacy_widget_get_instance_private (self);
	self->priv->file_type_fire_signal = TRUE;
}

static void
alm_privacy_widget_finalize (GObject * obj)
{
	AlmPrivacyWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_PRIVACY_WIDGET, AlmPrivacyWidget);
	_alm_blacklist_unref0 (self->priv->blacklist);
	_alm_file_type_blacklist_unref0 (self->priv->files_type_blacklist);
	_alm_path_blacklist_unref0 (self->priv->path_blacklist);
	_g_object_unref0 (self->priv->mime_dict);
	_g_object_unref0 (self->priv->checkboxes);
	_g_object_unref0 (self->priv->button_list);
	_g_object_unref0 (self->priv->defined_dirs);
	_alm_application_blacklist_unref0 (self->priv->app_blacklist);
	_g_object_unref0 (self->priv->app_dialog);
	_g_object_unref0 (self->priv->app_treeview);
	_g_object_unref0 (self->priv->container_box);
	_g_hash_table_unref0 (self->priv->blocked_list);
	_g_hash_table_unref0 (self->priv->unblocked_list);
	_g_object_unref0 (self->priv->exception_list);
	_g_object_unref0 (self->priv->exception_list_store);
	_g_object_unref0 (self->priv->record_button);
	_g_object_unref0 (self->priv->del_button);
	_g_object_unref0 (self->priv->delete_dialog);
	_g_object_unref0 (self->priv->stock_folder_icon);
	_g_object_unref0 (self->priv->exception_menu);
	_g_object_unref0 (self->priv->privacy_settings);
	G_OBJECT_CLASS (alm_privacy_widget_parent_class)->finalize (obj);
}

static GType
alm_privacy_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AlmPrivacyWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_privacy_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmPrivacyWidget), 0, (GInstanceInitFunc) alm_privacy_widget_instance_init, NULL };
	GType alm_privacy_widget_type_id;
	alm_privacy_widget_type_id = g_type_register_static (gtk_box_get_type (), "AlmPrivacyWidget", &g_define_type_info, 0);
	AlmPrivacyWidget_private_offset = g_type_add_instance_private (alm_privacy_widget_type_id, sizeof (AlmPrivacyWidgetPrivate));
	return alm_privacy_widget_type_id;
}

GType
alm_privacy_widget_get_type (void)
{
	static volatile gsize alm_privacy_widget_type_id__once = 0;
	if (g_once_init_enter (&alm_privacy_widget_type_id__once)) {
		GType alm_privacy_widget_type_id;
		alm_privacy_widget_type_id = alm_privacy_widget_get_type_once ();
		g_once_init_leave (&alm_privacy_widget_type_id__once, alm_privacy_widget_type_id);
	}
	return alm_privacy_widget_type_id__once;
}

static inline gpointer
alm_exception_cell_renderer_get_instance_private (AlmExceptionCellRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, AlmExceptionCellRenderer_private_offset);
}

AlmExceptionCellRenderer*
alm_exception_cell_renderer_construct (GType object_type)
{
	AlmExceptionCellRenderer * self = NULL;
	self = (AlmExceptionCellRenderer*) g_object_new (object_type, NULL);
	return self;
}

AlmExceptionCellRenderer*
alm_exception_cell_renderer_new (void)
{
	return alm_exception_cell_renderer_construct (ALM_TYPE_EXCEPTION_CELL_RENDERER);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static PangoLayout*
alm_exception_cell_renderer_get_text_layout (AlmExceptionCellRenderer* self,
                                             GtkWidget* widget,
                                             GdkRectangle* cell_area,
                                             GtkCellRendererState flags,
                                             const gchar* text,
                                             gboolean bold,
                                             gint size)
{
	PangoLayout* layout = NULL;
	gint xpad = 0;
	PangoAttrList* attr_list = NULL;
	PangoAttrList* _tmp0_;
	PangoLayout* _tmp1_;
	PangoAttrSize* attr = NULL;
	PangoAttrSize* _tmp2_;
	PangoAttrSize* _tmp3_;
	PangoAttrSize* _tmp4_;
	PangoAttrSize* _tmp5_;
	PangoAttrSize* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	PangoAttrList* _tmp9_;
	PangoAttrSize* _tmp10_;
	PangoLayout* _tmp16_;
	PangoAttrList* _tmp17_;
	gint _tmp18_ = 0;
	PangoLayout* _tmp19_;
	PangoRectangle rect = {0};
	gint width = 0;
	gint text_width = 0;
	PangoLayout* _tmp20_;
	PangoRectangle _tmp21_ = {0};
	PangoRectangle _tmp22_;
	PangoLayout* _tmp23_;
	PangoAlignment align = 0;
	PangoLayout* _tmp24_;
	PangoLayout* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = pango_attr_list_new ();
	attr_list = _tmp0_;
	_tmp1_ = gtk_widget_create_pango_layout (widget, text);
	_g_object_unref0 (layout);
	layout = _tmp1_;
	_tmp2_ = (PangoAttrSize*) pango_attr_size_new (size * PANGO_SCALE);
	attr = _tmp2_;
	_tmp3_ = attr;
	_tmp3_->absolute = (guint) 1;
	_tmp4_ = attr;
	((PangoAttribute*) _tmp4_)->start_index = (guint) 0;
	_tmp5_ = attr;
	_tmp6_ = attr;
	_tmp7_ = strlen (text);
	_tmp8_ = _tmp7_;
	((PangoAttribute*) _tmp5_)->end_index = ((PangoAttribute*) _tmp6_)->start_index + _tmp8_;
	_tmp9_ = attr_list;
	_tmp10_ = attr;
	attr = NULL;
	pango_attr_list_insert (_tmp9_, (PangoAttribute*) _tmp10_);
	if (bold) {
		PangoFontDescription* desc = NULL;
		PangoFontDescription* _tmp11_;
		PangoAttrFontDesc* attr_f = NULL;
		PangoFontDescription* _tmp12_;
		PangoAttrFontDesc* _tmp13_;
		PangoAttrList* _tmp14_;
		PangoAttrFontDesc* _tmp15_;
		_tmp11_ = pango_font_description_new ();
		desc = _tmp11_;
		_tmp12_ = desc;
		_tmp13_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (_tmp12_);
		attr_f = _tmp13_;
		_tmp14_ = attr_list;
		_tmp15_ = attr_f;
		attr_f = NULL;
		pango_attr_list_insert (_tmp14_, (PangoAttribute*) _tmp15_);
		_pango_attribute_destroy0 (attr_f);
		__vala_PangoFontDescription_free0 (desc);
	}
	_tmp16_ = layout;
	_tmp17_ = attr_list;
	pango_layout_set_attributes (_tmp16_, _tmp17_);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp18_, NULL);
	xpad = _tmp18_;
	_tmp19_ = layout;
	pango_layout_set_ellipsize (_tmp19_, PANGO_ELLIPSIZE_END);
	_tmp20_ = layout;
	pango_layout_get_extents (_tmp20_, NULL, &_tmp21_);
	rect = _tmp21_;
	_tmp22_ = rect;
	text_width = _tmp22_.width;
	if (cell_area != NULL) {
		width = ((*cell_area).width - xpad) * PANGO_SCALE;
	} else {
		width = ALM_EXCEPTION_CELL_RENDERER_default_width * PANGO_SCALE;
	}
	width = MIN (width, text_width);
	_tmp23_ = layout;
	pango_layout_set_width (_tmp23_, width);
	if (gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL) {
		align = PANGO_ALIGN_RIGHT;
	} else {
		align = PANGO_ALIGN_LEFT;
	}
	_tmp24_ = layout;
	pango_layout_set_alignment (_tmp24_, align);
	result = layout;
	_pango_attribute_destroy0 (attr);
	_pango_attr_list_unref0 (attr_list);
	return result;
}

static void
alm_exception_cell_renderer_real_get_size (GtkCellRenderer* base,
                                           GtkWidget* widget,
                                           GdkRectangle* cell_area,
                                           gint* x_offset,
                                           gint* y_offset,
                                           gint* width,
                                           gint* height)
{
	AlmExceptionCellRenderer * self;
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	gint _vala_width = 0;
	gint _vala_height = 0;
	self = (AlmExceptionCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	_vala_height = 0;
	_vala_width = _vala_height;
	_vala_y_offset = _vala_width;
	_vala_x_offset = _vala_y_offset;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
alm_exception_cell_renderer_do_get_size (AlmExceptionCellRenderer* self,
                                         GtkWidget* widget,
                                         GdkRectangle* cell_area,
                                         PangoLayout* layout,
                                         gint* x_offset,
                                         gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoRectangle rect = {0};
	gint xpad = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoRectangle _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, &_tmp1_);
	xpad = _tmp0_;
	ypad = _tmp1_;
	pango_layout_get_pixel_extents (layout, NULL, &_tmp2_);
	rect = _tmp2_;
	if (cell_area != NULL) {
		PangoRectangle _tmp3_;
		_tmp3_ = rect;
		rect.width = MIN (_tmp3_.width, ((*cell_area).width - (2 * xpad)) + ALM_EXCEPTION_CELL_RENDERER_xspacing);
		if (gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL) {
			PangoRectangle _tmp4_;
			_tmp4_ = rect;
			_vala_x_offset = (*cell_area).width - (_tmp4_.width + xpad);
		} else {
			_vala_x_offset = xpad;
		}
		_vala_x_offset = MAX (_vala_x_offset, 0);
	} else {
		_vala_x_offset = 0;
	}
	_vala_y_offset = ypad;
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

static void
alm_exception_cell_renderer_real_render (GtkCellRenderer* base,
                                         cairo_t* cr,
                                         GtkWidget* widget,
                                         GdkRectangle* background_area,
                                         GdkRectangle* cell_area,
                                         GtkCellRendererState flags)
{
	AlmExceptionCellRenderer * self;
	GtkStyleContext* context = NULL;
	PangoLayout* text_layout = NULL;
	gint text_x_offset = 0;
	gint text_y_offset = 0;
	gint xpad = 0;
	PangoRectangle text_rect = {0};
	GtkWidget* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	gint font_size = 0;
	PangoFontDescription* _tmp3_;
	gint _tmp4_ = 0;
	GdkRectangle _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	PangoLayout* _tmp8_;
	GdkRectangle _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	PangoRectangle _tmp12_ = {0};
	PangoRectangle _tmp13_;
	GdkRectangle _tmp14_;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* _tmp16_;
	GdkRectangle _tmp17_;
	GdkRectangle _tmp18_;
	GdkRectangle _tmp19_;
	GdkPixbuf* _tmp20_;
	GdkPixbuf* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	GdkRectangle _tmp24_;
	self = (AlmExceptionCellRenderer*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (background_area != NULL);
	g_return_if_fail (cell_area != NULL);
	text_x_offset = 0;
	text_y_offset = 0;
	_tmp0_ = _g_object_ref0 (widget);
	_g_object_unref0 (self->priv->current_widget);
	self->priv->current_widget = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context (widget);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (context);
	context = _tmp2_;
	_tmp3_ = gtk_style_context_get_font (context, GTK_STATE_FLAG_NORMAL);
	font_size = pango_font_description_get_size (_tmp3_) / PANGO_SCALE;
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp4_, NULL);
	xpad = _tmp4_;
	_tmp5_ = *cell_area;
	_tmp6_ = alm_exception_cell_renderer_get_text (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = alm_exception_cell_renderer_get_text_layout (self, widget, &_tmp5_, flags, _tmp7_, TRUE, font_size);
	_g_object_unref0 (text_layout);
	text_layout = _tmp8_;
	_tmp9_ = *cell_area;
	alm_exception_cell_renderer_do_get_size (self, widget, &_tmp9_, text_layout, &_tmp10_, &_tmp11_);
	text_x_offset = _tmp10_;
	text_y_offset = _tmp11_;
	pango_layout_get_pixel_extents (text_layout, NULL, &_tmp12_);
	text_rect = _tmp12_;
	_tmp13_ = text_rect;
	text_x_offset = text_x_offset - _tmp13_.x;
	cairo_save (cr);
	_tmp14_ = *cell_area;
	gdk_cairo_rectangle (cr, &_tmp14_);
	cairo_clip (cr);
	_tmp15_ = alm_exception_cell_renderer_get_pixbuf (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = *cell_area;
	_tmp18_ = *cell_area;
	gdk_cairo_set_source_pixbuf (cr, _tmp16_, (gdouble) _tmp17_.x, (gdouble) _tmp18_.y);
	cairo_paint (cr);
	_tmp19_ = *cell_area;
	_tmp20_ = alm_exception_cell_renderer_get_pixbuf (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = gdk_pixbuf_get_width (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = *cell_area;
	gtk_render_layout (context, cr, (gdouble) (((_tmp19_.x + text_x_offset) + _tmp23_) + ALM_EXCEPTION_CELL_RENDERER_xspacing), (gdouble) ((_tmp24_.y + text_y_offset) + 2), text_layout);
	cairo_restore (cr);
	_g_object_unref0 (text_layout);
	_g_object_unref0 (context);
}

static void
alm_exception_cell_renderer_real_get_preferred_width (GtkCellRenderer* base,
                                                      GtkWidget* widget,
                                                      gint* min_width,
                                                      gint* nat_width)
{
	AlmExceptionCellRenderer * self;
	gint _vala_min_width = 0;
	gint _vala_nat_width = 0;
	gint xpad = 0;
	gint _tmp0_ = 0;
	self = (AlmExceptionCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, &_tmp0_, NULL);
	xpad = _tmp0_;
	_vala_min_width = xpad + ALM_EXCEPTION_CELL_RENDERER_default_width;
	_vala_nat_width = _vala_min_width;
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (nat_width) {
		*nat_width = _vala_nat_width;
	}
}

static void
alm_exception_cell_renderer_real_get_preferred_height_for_width (GtkCellRenderer* base,
                                                                 GtkWidget* widget,
                                                                 gint width,
                                                                 gint* minimum_height,
                                                                 gint* natural_height)
{
	AlmExceptionCellRenderer * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	gint ypad = 0;
	gint _tmp0_ = 0;
	self = (AlmExceptionCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_padding ((GtkCellRenderer*) self, NULL, &_tmp0_);
	ypad = _tmp0_;
	_vala_minimum_height = ALM_EXCEPTION_CELL_RENDERER_renderer_height + ypad;
	_vala_natural_height = ALM_EXCEPTION_CELL_RENDERER_renderer_height + ypad;
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static void
alm_exception_cell_renderer_real_get_preferred_height (GtkCellRenderer* base,
                                                       GtkWidget* widget,
                                                       gint* minimum_size,
                                                       gint* natural_size)
{
	AlmExceptionCellRenderer * self;
	gint _vala_minimum_size = 0;
	gint _vala_natural_size = 0;
	gint min_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (AlmExceptionCellRenderer*) base;
	g_return_if_fail (widget != NULL);
	gtk_cell_renderer_get_preferred_width ((GtkCellRenderer*) self, widget, &_tmp0_, NULL);
	min_width = _tmp0_;
	gtk_cell_renderer_get_preferred_height_for_width ((GtkCellRenderer*) self, widget, min_width, &_tmp1_, &_tmp2_);
	_vala_minimum_size = _tmp1_;
	_vala_natural_size = _tmp2_;
	if (minimum_size) {
		*minimum_size = _vala_minimum_size;
	}
	if (natural_size) {
		*natural_size = _vala_natural_size;
	}
}

GdkPixbuf*
alm_exception_cell_renderer_get_pixbuf (AlmExceptionCellRenderer* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->pixbuf_;
	result = _tmp0_;
	return result;
}

void
alm_exception_cell_renderer_set_pixbuf (AlmExceptionCellRenderer* self,
                                        GdkPixbuf* value)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->pixbuf_);
	self->priv->pixbuf_ = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, alm_exception_cell_renderer_properties[ALM_EXCEPTION_CELL_RENDERER_PIXBUF_PROPERTY]);
}

const gchar*
alm_exception_cell_renderer_get_text (AlmExceptionCellRenderer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->text_;
	result = _tmp0_;
	return result;
}

void
alm_exception_cell_renderer_set_text (AlmExceptionCellRenderer* self,
                                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->text_);
	self->priv->text_ = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, alm_exception_cell_renderer_properties[ALM_EXCEPTION_CELL_RENDERER_TEXT_PROPERTY]);
}

static void
alm_exception_cell_renderer_class_init (AlmExceptionCellRendererClass * klass,
                                        gpointer klass_data)
{
	alm_exception_cell_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AlmExceptionCellRenderer_private_offset);
	((GtkCellRendererClass *) klass)->get_size = (void (*) (GtkCellRenderer*, GtkWidget*, GdkRectangle*, gint*, gint*, gint*, gint*)) alm_exception_cell_renderer_real_get_size;
	((GtkCellRendererClass *) klass)->render = (void (*) (GtkCellRenderer*, cairo_t*, GtkWidget*, GdkRectangle*, GdkRectangle*, GtkCellRendererState)) alm_exception_cell_renderer_real_render;
	((GtkCellRendererClass *) klass)->get_preferred_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) alm_exception_cell_renderer_real_get_preferred_width;
	((GtkCellRendererClass *) klass)->get_preferred_height_for_width = (void (*) (GtkCellRenderer*, GtkWidget*, gint, gint*, gint*)) alm_exception_cell_renderer_real_get_preferred_height_for_width;
	((GtkCellRendererClass *) klass)->get_preferred_height = (void (*) (GtkCellRenderer*, GtkWidget*, gint*, gint*)) alm_exception_cell_renderer_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_alm_exception_cell_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_alm_exception_cell_renderer_set_property;
	G_OBJECT_CLASS (klass)->finalize = alm_exception_cell_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_EXCEPTION_CELL_RENDERER_PIXBUF_PROPERTY, alm_exception_cell_renderer_properties[ALM_EXCEPTION_CELL_RENDERER_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALM_EXCEPTION_CELL_RENDERER_TEXT_PROPERTY, alm_exception_cell_renderer_properties[ALM_EXCEPTION_CELL_RENDERER_TEXT_PROPERTY] = g_param_spec_string ("text", "text", "text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
alm_exception_cell_renderer_instance_init (AlmExceptionCellRenderer * self,
                                           gpointer klass)
{
	self->priv = alm_exception_cell_renderer_get_instance_private (self);
}

static void
alm_exception_cell_renderer_finalize (GObject * obj)
{
	AlmExceptionCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_EXCEPTION_CELL_RENDERER, AlmExceptionCellRenderer);
	_g_object_unref0 (self->priv->current_widget);
	_g_object_unref0 (self->priv->pixbuf_);
	_g_free0 (self->priv->text_);
	G_OBJECT_CLASS (alm_exception_cell_renderer_parent_class)->finalize (obj);
}

static GType
alm_exception_cell_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AlmExceptionCellRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_exception_cell_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmExceptionCellRenderer), 0, (GInstanceInitFunc) alm_exception_cell_renderer_instance_init, NULL };
	GType alm_exception_cell_renderer_type_id;
	alm_exception_cell_renderer_type_id = g_type_register_static (gtk_cell_renderer_get_type (), "AlmExceptionCellRenderer", &g_define_type_info, 0);
	AlmExceptionCellRenderer_private_offset = g_type_add_instance_private (alm_exception_cell_renderer_type_id, sizeof (AlmExceptionCellRendererPrivate));
	return alm_exception_cell_renderer_type_id;
}

GType
alm_exception_cell_renderer_get_type (void)
{
	static volatile gsize alm_exception_cell_renderer_type_id__once = 0;
	if (g_once_init_enter (&alm_exception_cell_renderer_type_id__once)) {
		GType alm_exception_cell_renderer_type_id;
		alm_exception_cell_renderer_type_id = alm_exception_cell_renderer_get_type_once ();
		g_once_init_leave (&alm_exception_cell_renderer_type_id__once, alm_exception_cell_renderer_type_id);
	}
	return alm_exception_cell_renderer_type_id__once;
}

static void
_vala_alm_exception_cell_renderer_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	AlmExceptionCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ALM_TYPE_EXCEPTION_CELL_RENDERER, AlmExceptionCellRenderer);
	switch (property_id) {
		case ALM_EXCEPTION_CELL_RENDERER_PIXBUF_PROPERTY:
		g_value_set_object (value, alm_exception_cell_renderer_get_pixbuf (self));
		break;
		case ALM_EXCEPTION_CELL_RENDERER_TEXT_PROPERTY:
		g_value_set_string (value, alm_exception_cell_renderer_get_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_alm_exception_cell_renderer_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	AlmExceptionCellRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ALM_TYPE_EXCEPTION_CELL_RENDERER, AlmExceptionCellRenderer);
	switch (property_id) {
		case ALM_EXCEPTION_CELL_RENDERER_PIXBUF_PROPERTY:
		alm_exception_cell_renderer_set_pixbuf (self, g_value_get_object (value));
		break;
		case ALM_EXCEPTION_CELL_RENDERER_TEXT_PROPERTY:
		alm_exception_cell_renderer_set_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
alm_delete_history_dialog_get_instance_private (AlmDeleteHistoryDialog* self)
{
	return G_STRUCT_MEMBER_P (self, AlmDeleteHistoryDialog_private_offset);
}

AlmDeleteHistoryDialog*
alm_delete_history_dialog_construct (GType object_type,
                                     GtkButton* del_button)
{
	AlmDeleteHistoryDialog * self = NULL;
	ZeitgeistLog* _tmp0_;
	AlmCalendarWidget* _tmp1_;
	g_return_val_if_fail (del_button != NULL, NULL);
	self = (AlmDeleteHistoryDialog*) g_object_new (object_type, NULL);
	gtk_window_set_title ((GtkWindow*) self, _ ("Clear Usage Data"));
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self, TRUE);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
	_tmp0_ = zeitgeist_log_new ();
	_g_object_unref0 (self->priv->zg_log);
	self->priv->zg_log = _tmp0_;
	_tmp1_ = alm_calendar_widget_new (del_button);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->calendar_box);
	self->priv->calendar_box = _tmp1_;
	alm_delete_history_dialog_set_up_ui (self);
	return self;
}

AlmDeleteHistoryDialog*
alm_delete_history_dialog_new (GtkButton* del_button)
{
	return alm_delete_history_dialog_construct (ALM_TYPE_DELETE_HISTORY_DIALOG, del_button);
}

static void
alm_delete_history_dialog_set_up_ui (AlmDeleteHistoryDialog* self)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	GSList* _tmp3_;
	GtkRadioButton* _tmp4_;
	GtkRadioButton* _tmp5_;
	GSList* _tmp6_;
	GtkRadioButton* _tmp7_;
	GtkRadioButton* _tmp8_;
	GtkRadioButton* _tmp9_;
	GtkRadioButton* _tmp10_;
	GtkRadioButton* _tmp11_;
	GtkBox* hbox_calendar = NULL;
	GtkBox* _tmp12_;
	GtkRadioButton* _tmp13_;
	AlmCalendarWidget* _tmp14_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp15_;
	GtkRadioButton* _tmp16_;
	GtkRadioButton* _tmp17_;
	GtkRadioButton* _tmp18_;
	GtkRadioButton* _tmp19_;
	GtkBox* area = NULL;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Delete records of which files and applications were used:"));
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_label_set_line_wrap (label, TRUE);
	gtk_label_set_line_wrap_mode (label, PANGO_WRAP_WORD);
	gtk_misc_set_alignment ((GtkMisc*) label, (gfloat) 0, 0.5f);
	_tmp1_ = (GtkRadioButton*) gtk_radio_button_new_with_label (NULL, _ ("In the past hour"));
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->r_hour);
	self->priv->r_hour = _tmp1_;
	_tmp2_ = self->priv->r_hour;
	_tmp3_ = gtk_radio_button_get_group (_tmp2_);
	_tmp4_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp3_, _ ("In the past day"));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->r_day);
	self->priv->r_day = _tmp4_;
	_tmp5_ = self->priv->r_hour;
	_tmp6_ = gtk_radio_button_get_group (_tmp5_);
	_tmp7_ = (GtkRadioButton*) gtk_radio_button_new_with_label (_tmp6_, _ ("In the past week"));
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->r_week);
	self->priv->r_week = _tmp7_;
	_tmp8_ = self->priv->r_hour;
	_tmp9_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp8_, _ ("From:"));
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->r_calendar);
	self->priv->r_calendar = _tmp9_;
	_tmp10_ = self->priv->r_hour;
	_tmp11_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp10_, _ ("From all time"));
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->r_ever);
	self->priv->r_ever = _tmp11_;
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp12_);
	hbox_calendar = _tmp12_;
	_tmp13_ = self->priv->r_calendar;
	gtk_box_pack_start (hbox_calendar, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	_tmp14_ = self->priv->calendar_box;
	gtk_box_pack_start (hbox_calendar, (GtkWidget*) _tmp14_, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 5);
	g_object_ref_sink (_tmp15_);
	vbox = _tmp15_;
	gtk_box_pack_start (vbox, (GtkWidget*) label, FALSE, TRUE, (guint) 0);
	_tmp16_ = self->priv->r_hour;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp16_, FALSE, TRUE, (guint) 0);
	_tmp17_ = self->priv->r_day;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp17_, FALSE, TRUE, (guint) 0);
	_tmp18_ = self->priv->r_week;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp18_, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start (vbox, (GtkWidget*) hbox_calendar, FALSE, TRUE, (guint) 0);
	_tmp19_ = self->priv->r_ever;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp19_, FALSE, TRUE, (guint) 0);
	_tmp20_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, gtk_box_get_type ()) ? ((GtkBox*) _tmp20_) : NULL);
	area = _tmp21_;
	gtk_box_pack_start (area, (GtkWidget*) vbox, FALSE, FALSE, (guint) 0);
	gtk_dialog_add_buttons ((GtkDialog*) self, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);
	_g_object_unref0 (area);
	_g_object_unref0 (vbox);
	_g_object_unref0 (hbox_calendar);
	_g_object_unref0 (label);
}

gint
alm_delete_history_dialog_get_active_radio_button (AlmDeleteHistoryDialog* self)
{
	GtkRadioButton* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->r_hour;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		result = 0;
		return result;
	} else {
		GtkRadioButton* _tmp1_;
		_tmp1_ = self->priv->r_day;
		if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_)) {
			result = 1;
			return result;
		} else {
			GtkRadioButton* _tmp2_;
			_tmp2_ = self->priv->r_week;
			if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_)) {
				result = 2;
				return result;
			} else {
				GtkRadioButton* _tmp3_;
				_tmp3_ = self->priv->r_calendar;
				if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp3_)) {
					result = 3;
					return result;
				} else {
					GtkRadioButton* _tmp4_;
					_tmp4_ = self->priv->r_ever;
					if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp4_)) {
						result = 4;
						return result;
					} else {
						result = -1;
						return result;
					}
				}
			}
		}
	}
}

void
alm_delete_history_dialog_on_delete_history (AlmDeleteHistoryDialog* self)
{
	gint res = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	res = gtk_dialog_run ((GtkDialog*) self);
	if (res == ((gint) GTK_RESPONSE_OK)) {
		ZeitgeistTimeRange* tr = NULL;
		GtkRecentManager* recent = NULL;
		GtkRecentManager* _tmp0_;
		gint index = 0;
		_tmp0_ = gtk_recent_manager_new ();
		recent = _tmp0_;
		index = alm_delete_history_dialog_get_active_radio_button (self);
		if (index < 3) {
			gint range = 0;
			gint64 end = 0LL;
			gint64 start = 0LL;
			ZeitgeistTimeRange* _tmp1_;
			ZeitgeistTimeRange* _tmp2_;
			range = (60 * 60) * 1000;
			if (index == 0) {
				range = 1 * range;
			} else {
				if (index == 1) {
					range = range * 24;
				} else {
					if (index == 2) {
						range = (range * 24) * 7;
					}
				}
			}
			end = zeitgeist_timestamp_from_now ();
			start = end - range;
			_tmp1_ = zeitgeist_time_range_new (start, end);
			_g_object_unref0 (tr);
			tr = _tmp1_;
			_tmp2_ = tr;
			alm_delete_history_dialog_get_history (self, _tmp2_, NULL, NULL);
		} else {
			if (index == 3) {
				AlmCalendarWidget* _tmp3_;
				ZeitgeistTimeRange* _tmp4_;
				ZeitgeistTimeRange* _tmp5_;
				_tmp3_ = self->priv->calendar_box;
				_tmp4_ = alm_calendar_widget_get_range (_tmp3_);
				_g_object_unref0 (tr);
				tr = _tmp4_;
				_tmp5_ = tr;
				alm_delete_history_dialog_get_history (self, _tmp5_, NULL, NULL);
			} else {
				if (index == 4) {
					ZeitgeistTimeRange* _tmp6_;
					ZeitgeistTimeRange* _tmp7_;
					_tmp6_ = zeitgeist_time_range_new_anytime ();
					_g_object_unref0 (tr);
					tr = _tmp6_;
					_tmp7_ = tr;
					alm_delete_history_dialog_get_history (self, _tmp7_, NULL, NULL);
					{
						GtkRecentManager* _tmp8_;
						_tmp8_ = recent;
						gtk_recent_manager_purge_items (_tmp8_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* err = NULL;
						GError* _tmp9_;
						const gchar* _tmp10_;
						err = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp9_ = err;
						_tmp10_ = _tmp9_->message;
						g_warning ("unified-privacy.vala:859: %s", _tmp10_);
						_g_error_free0 (err);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (recent);
						_g_object_unref0 (tr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
			}
		}
		_g_object_unref0 (recent);
		_g_object_unref0 (tr);
	}
	gtk_widget_hide ((GtkWidget*) self);
}

static void
alm_delete_history_dialog_get_history_data_free (gpointer _data)
{
	AlmDeleteHistoryDialogGetHistoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->tr);
	_g_object_unref0 (_data_->self);
	g_slice_free (AlmDeleteHistoryDialogGetHistoryData, _data_);
}

static void
alm_delete_history_dialog_get_history (AlmDeleteHistoryDialog* self,
                                       ZeitgeistTimeRange* tr,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	AlmDeleteHistoryDialogGetHistoryData* _data_;
	AlmDeleteHistoryDialog* _tmp0_;
	ZeitgeistTimeRange* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tr != NULL);
	_data_ = g_slice_new0 (AlmDeleteHistoryDialogGetHistoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, alm_delete_history_dialog_get_history_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (tr);
	_g_object_unref0 (_data_->tr);
	_data_->tr = _tmp1_;
	alm_delete_history_dialog_get_history_co (_data_);
}

static void
alm_delete_history_dialog_get_history_finish (AlmDeleteHistoryDialog* self,
                                              GAsyncResult* _res_)
{
	AlmDeleteHistoryDialogGetHistoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_alm_delete_history_dialog_get_history_co_gsource_func (gpointer self)
{
	gboolean result;
	result = alm_delete_history_dialog_get_history_co (self);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
alm_delete_history_dialog_get_history_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	AlmDeleteHistoryDialogGetHistoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	alm_delete_history_dialog_get_history_co (_data_);
}

static gboolean
alm_delete_history_dialog_get_history_co (AlmDeleteHistoryDialogGetHistoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _alm_delete_history_dialog_get_history_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = (GtkDialog*) gtk_dialog_new ();
	g_object_ref_sink (_data_->_tmp0_);
	_data_->dialog = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dialog;
	gtk_dialog_add_button (_data_->_tmp1_, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	_data_->_tmp2_ = _data_->dialog;
	gtk_dialog_add_button (_data_->_tmp2_, GTK_STOCK_YES, (gint) GTK_RESPONSE_OK);
	_data_->_tmp3_ = _data_->dialog;
	gtk_window_set_title ((GtkWindow*) _data_->_tmp3_, "");
	_data_->_tmp4_ = (GtkLabel*) gtk_label_new (_ ("This operation cannot be undone, are you sure you want to delete this " \
"activity?"));
	g_object_ref_sink (_data_->_tmp4_);
	_data_->label = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->label;
	gtk_label_set_line_wrap (_data_->_tmp5_, TRUE);
	_data_->_tmp6_ = _data_->label;
	gtk_label_set_line_wrap_mode (_data_->_tmp6_, PANGO_WRAP_WORD);
	_data_->_tmp7_ = _data_->label;
	gtk_misc_set_padding ((GtkMisc*) _data_->_tmp7_, 9, 9);
	_data_->_tmp8_ = _data_->dialog;
	_data_->_tmp9_ = gtk_dialog_get_content_area (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, gtk_container_get_type (), GtkContainer), (GtkWidget*) _data_->_tmp10_);
	_data_->_tmp11_ = _data_->dialog;
	_data_->_tmp12_ = gtk_widget_get_toplevel ((GtkWidget*) _data_->self);
	gtk_window_set_transient_for ((GtkWindow*) _data_->_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, gtk_window_get_type (), GtkWindow));
	_data_->_tmp13_ = _data_->dialog;
	gtk_window_set_modal ((GtkWindow*) _data_->_tmp13_, TRUE);
	_data_->_tmp14_ = _data_->dialog;
	gtk_widget_show_all ((GtkWidget*) _data_->_tmp14_);
	_data_->_tmp15_ = _data_->dialog;
	_data_->res = gtk_dialog_run (_data_->_tmp15_);
	_data_->_tmp16_ = _data_->dialog;
	gtk_widget_destroy ((GtkWidget*) _data_->_tmp16_);
	if (_data_->res == ((gint) GTK_RESPONSE_OK)) {
		_data_->_tmp17_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
		_data_->events = _data_->_tmp17_;
		_data_->_tmp18_ = _data_->events;
		_data_->_tmp19_ = zeitgeist_event_new ();
		g_ptr_array_add (_data_->_tmp18_, _data_->_tmp19_);
		{
			_data_->_tmp20_ = _data_->self->priv->zg_log;
			_data_->_tmp21_ = _data_->events;
			_data_->_tmp22_ = 0;
			_data_->_state_ = 2;
			zeitgeist_log_find_event_ids (_data_->_tmp20_, _data_->tr, _data_->_tmp21_, ZEITGEIST_STORAGE_STATE_ANY, (guint32) 0, 0, NULL, alm_delete_history_dialog_get_history_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp23_ = zeitgeist_log_find_event_ids_finish (_data_->_tmp20_, _data_->_res_, &_data_->_tmp22_, &_data_->_inner_error0_);
			_data_->ids = _data_->_tmp23_;
			_data_->ids_length1 = _data_->_tmp22_;
			_data_->_ids_size_ = _data_->ids_length1;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp24_ = g_array_new (TRUE, TRUE, sizeof (gint));
			_data_->del_ids = _data_->_tmp24_;
			_data_->_tmp25_ = _data_->del_ids;
			_data_->_tmp26_ = _data_->ids;
			_data_->_tmp26__length1 = _data_->ids_length1;
			_data_->_tmp27_ = _data_->ids;
			_data_->_tmp27__length1 = _data_->ids_length1;
			g_array_append_vals (_data_->_tmp25_, _data_->_tmp26_, (guint) _data_->_tmp27__length1);
			_data_->_tmp28_ = _data_->del_ids;
			alm_delete_history_dialog_delete_history (_data_->self, _data_->_tmp28_, NULL, NULL);
			_g_array_unref0 (_data_->del_ids);
			_data_->ids = (g_free (_data_->ids), NULL);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp29_ = _data_->err;
			_data_->_tmp30_ = _data_->_tmp29_->message;
			g_warning ("unified-privacy.vala:899: %s", _data_->_tmp30_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_ptr_array_unref0 (_data_->events);
			_g_object_unref0 (_data_->label);
			_g_object_unref0 (_data_->dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_ptr_array_unref0 (_data_->events);
	}
	_g_object_unref0 (_data_->label);
	_g_object_unref0 (_data_->dialog);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
alm_delete_history_dialog_delete_history_data_free (gpointer _data)
{
	AlmDeleteHistoryDialogDeleteHistoryData* _data_;
	_data_ = _data;
	_g_array_unref0 (_data_->ids);
	_g_object_unref0 (_data_->self);
	g_slice_free (AlmDeleteHistoryDialogDeleteHistoryData, _data_);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static void
alm_delete_history_dialog_delete_history (AlmDeleteHistoryDialog* self,
                                          GArray* ids,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	AlmDeleteHistoryDialogDeleteHistoryData* _data_;
	AlmDeleteHistoryDialog* _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AlmDeleteHistoryDialogDeleteHistoryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, alm_delete_history_dialog_delete_history_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_array_ref0 (ids);
	_g_array_unref0 (_data_->ids);
	_data_->ids = _tmp1_;
	alm_delete_history_dialog_delete_history_co (_data_);
}

static void
alm_delete_history_dialog_delete_history_finish (AlmDeleteHistoryDialog* self,
                                                 GAsyncResult* _res_)
{
	AlmDeleteHistoryDialogDeleteHistoryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_alm_delete_history_dialog_delete_history_co_gsource_func (gpointer self)
{
	gboolean result;
	result = alm_delete_history_dialog_delete_history_co (self);
	return result;
}

static void
alm_delete_history_dialog_delete_history_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	AlmDeleteHistoryDialogDeleteHistoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	alm_delete_history_dialog_delete_history_co (_data_);
}

static gboolean
alm_delete_history_dialog_delete_history_co (AlmDeleteHistoryDialogDeleteHistoryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_LOW, _alm_delete_history_dialog_delete_history_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	{
		_data_->_tmp0_ = _data_->self->priv->zg_log;
		_data_->_state_ = 2;
		zeitgeist_log_delete_events (_data_->_tmp0_, _data_->ids, NULL, alm_delete_history_dialog_delete_history_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp1_ = zeitgeist_log_delete_events_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		_data_->rs = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->rs);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->err;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_warning ("unified-privacy.vala:912: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
alm_delete_history_dialog_class_init (AlmDeleteHistoryDialogClass * klass,
                                      gpointer klass_data)
{
	alm_delete_history_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AlmDeleteHistoryDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = alm_delete_history_dialog_finalize;
}

static void
alm_delete_history_dialog_instance_init (AlmDeleteHistoryDialog * self,
                                         gpointer klass)
{
	self->priv = alm_delete_history_dialog_get_instance_private (self);
}

static void
alm_delete_history_dialog_finalize (GObject * obj)
{
	AlmDeleteHistoryDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ALM_TYPE_DELETE_HISTORY_DIALOG, AlmDeleteHistoryDialog);
	_g_object_unref0 (self->priv->r_hour);
	_g_object_unref0 (self->priv->r_day);
	_g_object_unref0 (self->priv->r_week);
	_g_object_unref0 (self->priv->r_calendar);
	_g_object_unref0 (self->priv->r_ever);
	_g_object_unref0 (self->priv->zg_log);
	_g_object_unref0 (self->priv->calendar_box);
	G_OBJECT_CLASS (alm_delete_history_dialog_parent_class)->finalize (obj);
}

static GType
alm_delete_history_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AlmDeleteHistoryDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) alm_delete_history_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AlmDeleteHistoryDialog), 0, (GInstanceInitFunc) alm_delete_history_dialog_instance_init, NULL };
	GType alm_delete_history_dialog_type_id;
	alm_delete_history_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "AlmDeleteHistoryDialog", &g_define_type_info, 0);
	AlmDeleteHistoryDialog_private_offset = g_type_add_instance_private (alm_delete_history_dialog_type_id, sizeof (AlmDeleteHistoryDialogPrivate));
	return alm_delete_history_dialog_type_id;
}

GType
alm_delete_history_dialog_get_type (void)
{
	static volatile gsize alm_delete_history_dialog_type_id__once = 0;
	if (g_once_init_enter (&alm_delete_history_dialog_type_id__once)) {
		GType alm_delete_history_dialog_type_id;
		alm_delete_history_dialog_type_id = alm_delete_history_dialog_get_type_once ();
		g_once_init_leave (&alm_delete_history_dialog_type_id__once, alm_delete_history_dialog_type_id);
	}
	return alm_delete_history_dialog_type_id__once;
}

