/*
 * Copyright (c) 2019, Intel Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __S10_MEMORYCONTROLLER_H__
#define __S10_MEMORYCONTROLLER_H__

#define S10_MPFE_IOHMC_REG_DRAMADDRW			0xf80100a8
#define S10_MPFE_IOHMC_CTRLCFG0				0xf8010028
#define S10_MPFE_IOHMC_CTRLCFG1				0xf801002c
#define S10_MPFE_IOHMC_DRAMADDRW			0xf80100a8
#define S10_MPFE_IOHMC_DRAMTIMING0			0xf8010050
#define S10_MPFE_IOHMC_CALTIMING0			0xf801007c
#define S10_MPFE_IOHMC_CALTIMING1			0xf8010080
#define S10_MPFE_IOHMC_CALTIMING2			0xf8010084
#define S10_MPFE_IOHMC_CALTIMING3			0xf8010088
#define S10_MPFE_IOHMC_CALTIMING4			0xf801008c
#define S10_MPFE_IOHMC_CALTIMING9			0xf80100a0
#define S10_MPFE_IOHMC_CALTIMING9_ACT_TO_ACT(x) (((x) & 0x000000ff) >> 0)
#define S10_MPFE_IOHMC_CTRLCFG1_CFG_ADDR_ORDER(value)	\
						(((value) & 0x00000060) >> 5)

#define S10_RSTMGR_BRGMODRST				0xffd1102c
#define S10_RSTMGR_BRGMODRST_DDRSCH			0x00000040

#define S10_MPFE_HMC_ADP_ECCCTRL1			0xf8011100
#define S10_MPFE_HMC_ADP_ECCCTRL2			0xf8011104
#define S10_MPFE_HMC_ADP_RSTHANDSHAKESTAT		0xf8011218
#define S10_MPFE_HMC_ADP_RSTHANDSHAKESTAT_SEQ2CORE	0x000000ff
#define S10_MPFE_HMC_ADP_RSTHANDSHAKECTRL		0xf8011214


#define S10_MPFE_IOHMC_REG_CTRLCFG1			0xf801002c

#define S10_MPFE_IOHMC_REG_NIOSRESERVE0_OFST		0xf8010110

#define IOHMC_DRAMADDRW_COL_ADDR_WIDTH(x)	(((x) & 0x0000001f) >> 0)
#define IOHMC_DRAMADDRW_ROW_ADDR_WIDTH(x)	(((x) & 0x000003e0) >> 5)
#define IOHMC_DRAMADDRW_CS_ADDR_WIDTH(x)	(((x) & 0x00070000) >> 16)
#define IOHMC_DRAMADDRW_BANK_GRP_ADDR_WIDTH(x)	(((x) & 0x0000c000) >> 14)
#define IOHMC_DRAMADDRW_BANK_ADDR_WIDTH(x)	(((x) & 0x00003c00) >> 10)

#define S10_MPFE_DDR(x)					(0xf8000000 + x)
#define S10_MPFE_HMC_ADP_DDRCALSTAT			0xf801100c
#define S10_MPFE_DDR_MAIN_SCHED				0xf8000400
#define S10_MPFE_DDR_MAIN_SCHED_DDRCONF			0xf8000408
#define S10_MPFE_DDR_MAIN_SCHED_DDRTIMING		0xf800040c
#define S10_MPFE_DDR_MAIN_SCHED_DDRCONF_SET_MSK		0x0000001f
#define S10_MPFE_DDR_MAIN_SCHED_DDRMODE			0xf8000410
#define S10_MPFE_DDR_MAIN_SCHED_DEVTODEV		0xf800043c
#define S10_MPFE_DDR_MAIN_SCHED_READLATENCY		0xf8000414
#define S10_MPFE_DDR_MAIN_SCHED_ACTIVATE		0xf8000438
#define S10_MPFE_DDR_MAIN_SCHED_ACTIVATE_FAWBANK_OFST	10
#define S10_MPFE_DDR_MAIN_SCHED_ACTIVATE_FAW_OFST	4
#define S10_MPFE_DDR_MAIN_SCHED_ACTIVATE_RRD_OFST	0
#define S10_MPFE_DDR_MAIN_SCHED_DDRCONF_SET(x)	(((x) << 0) & 0x0000001f)
#define S10_MPFE_DDR_MAIN_SCHED_DEVTODEV_BUSRDTORD_OFST	0
#define S10_MPFE_DDR_MAIN_SCHED_DEVTODEV_BUSRDTORD_MSK	(BIT(0) | BIT(1))
#define S10_MPFE_DDR_MAIN_SCHED_DEVTODEV_BUSRDTOWR_OFST	2
#define S10_MPFE_DDR_MAIN_SCHED_DEVTODEV_BUSRDTOWR_MSK	(BIT(2) | BIT(3))
#define S10_MPFE_DDR_MAIN_SCHED_DEVTODEV_BUSWRTORD_OFST	4
#define S10_MPFE_DDR_MAIN_SCHED_DEVTODEV_BUSWRTORD_MSK	(BIT(4) | BIT(5))

#define S10_MPFE_HMC_ADP(x)			(0xf8011000 + (x))
#define S10_MPFE_HMC_ADP_HPSINTFCSEL		0xf8011210
#define S10_MPFE_HMC_ADP_DDRIOCTRL		0xf8011008
#define HMC_ADP_DDRIOCTRL			0x8
#define HMC_ADP_DDRIOCTRL_IO_SIZE(x)		(((x) & 0x00000003) >> 0)
#define HMC_ADP_DDRIOCTRL_CTRL_BURST_LENGTH(x)	(((x) & 0x00003e00) >> 9)
#define ADP_DRAMADDRWIDTH			0xe0

#define ACT_TO_ACT_DIFF_BANK(value) (((value) & 0x00fc0000) >> 18)
#define ACT_TO_ACT(value) (((value) & 0x0003f000) >> 12)
#define ACT_TO_RDWR(value) (((value) & 0x0000003f) >> 0)
#define ACT_TO_ACT(value) (((value) & 0x0003f000) >> 12)

/* timing 2 */
#define RD_TO_RD_DIFF_CHIP(value) (((value) & 0x00000fc0) >> 6)
#define RD_TO_WR_DIFF_CHIP(value) (((value) & 0x3f000000) >> 24)
#define RD_TO_WR(value) (((value) & 0x00fc0000) >> 18)
#define RD_TO_PCH(value) (((value) & 0x00000fc0) >> 6)

/* timing 3 */
#define CALTIMING3_WR_TO_RD_DIFF_CHIP(value) (((value) & 0x0003f000) >> 12)
#define CALTIMING3_WR_TO_RD(value) (((value) & 0x00000fc0) >> 6)

/* timing 4 */
#define PCH_TO_VALID(value) (((value) & 0x00000fc0) >> 6)

#define DDRTIMING_BWRATIO_OFST		31
#define DDRTIMING_WRTORD_OFST			26
#define DDRTIMING_RDTOWR_OFST			21
#define DDRTIMING_BURSTLEN_OFST		18
#define DDRTIMING_WRTOMISS_OFST		12
#define DDRTIMING_RDTOMISS_OFST		6
#define DDRTIMING_ACTTOACT_OFST		0

#define ADP_DDRIOCTRL_IO_SIZE(x)	(((x) & 0x00000003) >> 0)

#define DDRMODE_AUTOPRECHARGE_OFST 1
#define DDRMODE_BWRATIOEXTENDED_OFST 0


#define S10_MPFE_IOHMC_REG_DRAMTIMING0_CFG_TCL(x) (((x) & 0x0000007f) >> 0)
#define S10_MPFE_IOHMC_REG_CTRLCFG0_CFG_MEM_TYPE(x) (((x) & 0x0000000f) >> 0)

#define S10_CCU_CPU0_MPRT_DDR		0xf7004400
#define S10_CCU_CPU0_MPRT_MEM0		0xf70045c0
#define S10_CCU_CPU0_MPRT_MEM1A		0xf70045e0
#define S10_CCU_CPU0_MPRT_MEM1B		0xf7004600
#define S10_CCU_CPU0_MPRT_MEM1C		0xf7004620
#define S10_CCU_CPU0_MPRT_MEM1D		0xf7004640
#define S10_CCU_CPU0_MPRT_MEM1E		0xf7004660
#define S10_CCU_IOM_MPRT_MEM0		0xf7018560
#define S10_CCU_IOM_MPRT_MEM1A		0xf7018580
#define	S10_CCU_IOM_MPRT_MEM1B		0xf70185a0
#define	S10_CCU_IOM_MPRT_MEM1C		0xf70185c0
#define	S10_CCU_IOM_MPRT_MEM1D		0xf70185e0
#define	S10_CCU_IOM_MPRT_MEM1E		0xf7018600

#define S10_NOC_FW_DDR_SCR				0xf8020100
#define S10_NOC_FW_DDR_SCR_MPUREGION0ADDR_LIMITEXT	0xf802011c
#define S10_NOC_FW_DDR_SCR_MPUREGION0ADDR_LIMIT		0xf8020118
#define S10_NOC_FW_DDR_SCR_NONMPUREGION0ADDR_LIMITEXT	0xf802019c
#define S10_NOC_FW_DDR_SCR_NONMPUREGION0ADDR_LIMIT	0xf8020198

#define S10_SOC_NOC_FW_DDR_SCR_ENABLE			0xf8020100
#define S10_CCU_NOC_DI_SET_MSK			0x10

#define S10_SYSMGR_CORE_HMC_CLK			0xffd120b4
#define S10_SYSMGR_CORE_HMC_CLK_STATUS		0x00000001

#define S10_MPFE_IOHMC_NIOSRESERVE0_NIOS_RESERVE0(x) (((x) & 0x0000ffff) >> 0)
#define S10_MPFE_HMC_ADP_DDRIOCTRL_IO_SIZE_MSK    0x00000003
#define S10_MPFE_HMC_ADP_DDRIOCTRL_IO_SIZE_OFST    0
#define S10_MPFE_HMC_ADP_HPSINTFCSEL_ENABLE 0x001f1f1f
#define S10_IOHMC_CTRLCFG1_ENABLE_ECC_OFST 7

#define S10_MPFE_HMC_ADP_ECCCTRL1_AUTOWB_CNT_RST_SET_MSK    0x00010000
#define S10_MPFE_HMC_ADP_ECCCTRL1_CNT_RST_SET_MSK    0x00000100
#define S10_MPFE_HMC_ADP_ECCCTRL1_ECC_EN_SET_MSK    0x00000001

#define S10_MPFE_HMC_ADP_ECCCTRL2_AUTOWB_EN_SET_MSK    0x00000001
#define S10_MPFE_HMC_ADP_ECCCTRL2_OVRW_RB_ECC_EN_SET_MSK    0x00010000
#define S10_MPFE_HMC_ADP_ECCCTRL2_RMW_EN_SET_MSK    0x00000100
#define S10_MPFE_HMC_ADP_DDRCALSTAT_CAL(value) (((value) & 0x00000001) >> 0)


#define S10_MPFE_HMC_ADP_DDRIOCTRL_IO_SIZE(x)	(((x) & 0x00000003) >> 0)
#define IOHMC_DRAMADDRW_CFG_BANK_ADDR_WIDTH(x) (((x) & 0x00003c00) >> 10)
#define IOHMC_DRAMADDRW_CFG_BANK_GROUP_ADDR_WIDTH(x) (((x) & 0x0000c000) >> 14)
#define IOHMC_DRAMADDRW_CFG_COL_ADDR_WIDTH(x) (((x) & 0x0000001f) >> 0)
#define IOHMC_DRAMADDRW_CFG_CS_ADDR_WIDTH(x) (((x) & 0x00070000) >> 16)
#define IOHMC_DRAMADDRW_CFG_ROW_ADDR_WIDTH(x) (((x) & 0x000003e0) >> 5)

#define S10_SDRAM_0_LB_ADDR 0x0

int init_hard_memory_controller(void);

#endif
