/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERTaggedObject;

public class BERTaggedObject
extends DERTaggedObject {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void encode(DEROutputStream out) throws IOException {
        if (out instanceof ASN1OutputStream || out instanceof BEROutputStream) {
            out.write(0xA0 | this.tagNo);
            out.write(128);
            if (!this.empty) {
                if (!this.explicit) {
                    if (this.obj instanceof BERConstructedOctetString) {
                        Enumeration e = ((BERConstructedOctetString)this.obj).getObjects();
                        while (e.hasMoreElements()) {
                            out.writeObject(e.nextElement());
                        }
                    } else if (this.obj instanceof ASN1Sequence) {
                        Enumeration e = ((ASN1Sequence)this.obj).getObjects();
                        while (e.hasMoreElements()) {
                            out.writeObject(e.nextElement());
                        }
                    } else {
                        if (!(this.obj instanceof ASN1Set)) throw new RuntimeException("not implemented: " + this.obj.getClass().getName());
                        Enumeration e = ((ASN1Set)this.obj).getObjects();
                        while (e.hasMoreElements()) {
                            out.writeObject(e.nextElement());
                        }
                    }
                } else {
                    out.writeObject(this.obj);
                }
            }
            out.write(0);
            out.write(0);
            return;
        } else {
            super.encode(out);
        }
    }

    public BERTaggedObject(int tagNo, DEREncodable obj) {
        super(tagNo, obj);
    }

    public BERTaggedObject(boolean explicit, int tagNo, DEREncodable obj) {
        super(explicit, tagNo, obj);
    }

    public BERTaggedObject(int tagNo) {
        super(false, tagNo, new BERConstructedSequence());
    }
}

