---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur, dépassement, mode brouillon
---

# Que signifie le message : "Overfull ⟨objet⟩" ?

:Message: `Overfull ⟨objet⟩`
:Origine: TeX

Ce message est un avertissement et, la plupart du temps, ne prête pas à conséquence. 
Lorsque LaTeX n'arrive pas à satisfaire tous ses critères de qualité de mise en forme, 
il peut avoir à dégrader un. Il signale alors cette entorse par ce message 
dans le fichier `.log`.

En voici un exemple utilisant le fait que la commande `\hbox` n'autorise pas un retour 
à la ligne :

```
\documentclass[draft,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Pour obtenir le message, mettez \hbox{une phrase trop longue que \LaTeX{}
n'a pas le droit de couper}
\end{document}
```

Celui-ci précise le type de dépassement, sa valeur (71pt de longueur) 
et sa localisation :

```text
Overfull \hbox (71.46896pt too wide) in paragraph at lines 8--10
[]\T1/lmr/m/n/10 Pour ob-te-nir le mes-sage, met-tez [] |
```

Notez ici que l'option de classe `draft`, utilisée dans cet exemple, 
permet de visualiser ces dépassements par un carré noir dans la marge, 
pour éventuellement corriger le texte, par exemple en indiquant une césure possible 
non connue de LaTeX.