/*************************************************************************
** psdefs.cpp                                                           **
**                                                                      **
** This file is part of dvisvgm -- a fast DVI to SVG converter          **
** Copyright (C) 2005-2023 Martin Gieseking <martin.gieseking@uos.de>   **
**                                                                      **
** This program is free software; you can redistribute it and/or        **
** modify it under the terms of the GNU General Public License as       **
** published by the Free Software Foundation; either version 3 of       **
** the License, or (at your option) any later version.                  **
**                                                                      **
** This program is distributed in the hope that it will be useful, but  **
** WITHOUT ANY WARRANTY; without even the implied warranty of           **
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the         **
** GNU General Public License for more details.                         **
**                                                                      **
** You should have received a copy of the GNU General Public License    **
** along with this program; if not, see <http://www.gnu.org/licenses/>. **
*************************************************************************/

#if defined(MIKTEX)
#include <config.h>
#endif
#include "PSInterpreter.hpp"

const char *PSInterpreter::PSDEFS =
"<</Install{matrix setmatrix}/HWResolution[72 72]/PageSize[10000 10000]/Imaging"
"BBox null>>setpagedevice/@dodraw true store/@GD globaldict def/@SD systemdict "
"def/@UD userdict def @GD/@nulldev false put @GD/@patcnt 0 put true setglobal @"
"SD/:save @SD/save get put @SD/:restore @SD/restore get put @SD/:gsave @SD/gsav"
"e get put @SD/:grestore @SD/grestore get put @SD/:grestoreall @SD/grestoreall "
"get put @SD/:newpath @SD/newpath get put @SD/:stroke @SD/stroke get put @SD/:f"
"ill @SD/fill get put @SD/:eofill @SD/eofill get put @SD/:clip @SD/clip get put"
" @SD/:eoclip @SD/eoclip get put @SD/:charpath @SD/charpath get put @SD/:show @"
"SD/show get put @SD/:stringwidth @SD/stringwidth get put @SD/:nulldevice @SD/n"
"ulldevice get put @SD/:image @SD/image get put @SD/:colorimage @SD/colorimage "
"get put @SD/.setopacityalpha known not{@SD/.setopacityalpha{pop}put}if @SD/.se"
"tshapealpha known not{@SD/.setshapealpha{pop}put}if @SD/.setblendmode known no"
"t{@SD/.setblendmode{pop}put}if @SD/prseq{-1 1{-1 roll =only( )print}for(\\n)pr"
"int}put @SD/prcmd{( )exch(\\ndvi.)3{print}repeat prseq}put @SD/cvxall{{cvx}for"
"all}put @SD/defpr{[exch/copy cvx @SD 4 index[/get/exec]cvxall 5 index 3 index "
"dup length string cvs/prcmd cvx]cvx bind def}put @SD/querypos{{currentpoint}st"
"opped{$error/newerror false put}{2(querypos)prcmd}ifelse}put @SD/applyscaleval"
"s{1 0 dtransform exch dup mul exch dup mul add sqrt 0 1 dtransform exch dup mu"
"l exch dup mul add sqrt 1 0 dtransform dup mul exch dup dup mul 3 -1 roll add "
"dup 0 eq{pop}{sqrt div}ifelse 3(applyscalevals)prcmd}put @SD/prpath{{2(moveto)"
"prcmd}{2(lineto)prcmd}{6(curveto)prcmd}{0(closepath)prcmd}pathforall}put @SD/n"
"ulldevice{@GD/@nulldev true put :nulldevice 1 1(setnulldevice)prcmd}put @SD/ch"
"arpath{/@dodraw false store :charpath/@dodraw true store}put @SD/stringwidth{/"
"@dodraw false store :stringwidth/@dodraw true store}put @SD/show{@dodraw @GD/@"
"nulldev get not and{dup :gsave currentpoint 2{50 mul exch}repeat :newpath move"
"to 50 50/scale sysexec true charpath fill :grestore/@dodraw false store :show/"
"@dodraw true store}{:show}ifelse}put @SD/varxyshow{dup 0 ge{<</chr 3 -1 roll s"
"tring/prc 5 -1 roll/arr 7 -1 roll/str 9 -1 roll/idx 0>>begin 0 chr length str "
"length 1 sub{str exch chr length getinterval/chr exch store :gsave chr show :g"
"restore currentpoint prc moveto/idx idx 1 add store}for end}{pop pop show}ifel"
"se}put @SD/xyshow{dup dup type/arraytype eq exch length 0 gt and{dup length 2 "
"idiv 2 index length exch idiv}{-1}ifelse{exch arr idx 2 mul get add exch arr i"
"dx 2 mul 1 add get add}exch varxyshow}put @SD/xshow{dup dup type/arraytype eq "
"exch length 0 gt and{dup length 2 index length exch idiv}{-1}ifelse{exch arr i"
"dx get add exch}exch varxyshow}put @SD/yshow{dup dup type/arraytype eq exch le"
"ngth 0 gt and{dup length 2 index length exch idiv}{-1}ifelse{arr idx get add}e"
"xch varxyshow}put @SD/awidthshow{{1 string dup 0 5 index put :gsave show :gres"
"tore pop 0 rmoveto 3 index eq{4 index 4 index rmoveto}if 1 index 1 index rmove"
"to}exch cshow 5{pop}repeat}put @SD/widthshow{0 0 3 -1 roll awidthshow}put @SD/"
"ashow{0 0 0 6 3 roll awidthshow}put @SD/newpath{:newpath 1 1(newpath)prcmd}put"
" @SD/stroke{@dodraw @GD/@nulldev get not and{prcolor 0 1(newpath)prcmd prpath "
"0(stroke)prcmd :newpath}{:stroke}ifelse}put @SD/fill{@dodraw @GD/@nulldev get "
"not and{prcolor 0 1(newpath)prcmd prpath 0(fill)prcmd :newpath}{:fill}ifelse}p"
"ut @SD/eofill{@dodraw @GD/@nulldev get not and{prcolor 0 1(newpath)prcmd prpat"
"h 0(eofill)prcmd :newpath}{:eofill}ifelse}put/.fillstroke{:gsave fill :grestor"
"e .swapcolors stroke .swapcolors}bind def/.eofillstroke{:gsave eofill :grestor"
"e .swapcolors stroke .swapcolors}bind def @SD/clip{:clip @GD/@nulldev get not{"
"0 1(newpath)prcmd prpath 0(clip)prcmd}if}put @SD/eoclip{:eoclip @GD/@nulldev g"
"et not{0 1(newpath)prcmd prpath 0(eoclip)prcmd}if}put @SD/shfill{begin current"
"dict/ShadingType known currentdict/ColorSpace known and currentdict/DataSource"
" known and currentdict/Function known not and ShadingType 4 ge{DataSource type"
"/arraytype eq{<</DeviceGray 1/DeviceRGB 3/DeviceCMYK 4/bgknown currentdict/Bac"
"kground known/bbknown currentdict/BBox known>>begin currentdict ColorSpace kno"
"wn{ShadingType ColorSpace load bgknown{1 Background aload pop}{0}ifelse bbknow"
"n{1 BBox aload pop}{0}ifelse ShadingType 5 eq{VerticesPerRow}if DataSource alo"
"ad length 4 add bgknown{ColorSpace load add}if bbknown{4 add}if ShadingType 5 "
"eq{1 add}if(shfill)prcmd}if end}if}if end}put @SD/image{dup type/dicttype eq{d"
"up}{<</Width 6 index/Height 7 index/colorimg false>>}ifelse @execimg}put @SD/c"
"olorimage{<<2 index{/Width 2 index 8 add index/Height 4 index 9 add index}{/Wi"
"dth 8 index/Height 9 index}ifelse/colorimg true>>@execimg}put/@imgbase(./)def/"
"@imgdevice(jpeg)def/@execimg{@GD/@imgcnt 2 copy .knownget{1 add}{1}ifelse put "
"begin<</imgdev null/imgid @GD/@imgcnt get/ispng @imgdevice 0 3 getinterval(png"
")eq dup/suffix exch{(.png)}{(.jpg)}ifelse/colorimg currentdict/colorimg .known"
"get dup{pop}if/colordev 1 index currentcolorspace dup length 1 ne exch 0 get/D"
"eviceGray ne or or>>begin @imgdevice(png)ne @imgdevice(jpeg)ne and{@imgdevice "
"cvn}{colordev{ispng{/png16m}{/jpeg}ifelse}{ispng{/pnggray}{/jpeggray}ifelse}if"
"else}ifelse dup devicedict exch known{:gsave/imgdev exch finddevice def mark/O"
"utputFile @imgbase imgid 20 string cvs strconcat suffix strconcat/PageSize[Wid"
"th Height]/UseFastColor true ispng{@imgdevice(pngmonod)eq{/MinFeatureSize wher"
"e{pop/MinFeatureSize MinFeatureSize}if}if}{/JPEGQ where{pop/JPEGQ JPEGQ}if}ife"
"lse imgdev putdeviceprops setdevice[Width 0 0 Height neg 0 Height]/setmatrix s"
"ysexec colorimg{:colorimage}{:image}ifelse/copypage sysexec mark/OutputFile()i"
"mgdev putdeviceprops pop :grestore imgid Width Height 3(image)prcmd}{pop color"
"img{:colorimage}{:image}ifelse}ifelse end end}def/@rect{4 -2 roll moveto exch "
"dup 0 rlineto exch 0 exch rlineto neg 0 rlineto closepath}bind def/@rectcc{4 -"
"2 roll moveto 2 copy 0 lt exch 0 lt xor{dup 0 exch rlineto exch 0 rlineto neg "
"0 exch rlineto}{exch dup 0 rlineto exch 0 exch rlineto neg 0 rlineto}ifelse cl"
"osepath}bind def @SD/rectclip{:newpath dup type/arraytype eq{aload length 4 id"
"iv{@rectcc}repeat}{@rectcc}ifelse clip :newpath}put @SD/rectfill{:gsave :newpa"
"th dup type/arraytype eq{aload length 4 idiv{@rectcc}repeat}{@rectcc}ifelse fi"
"ll :grestore}put @SD/rectstroke{gsave :newpath dup type/arraytype eq{aload len"
"gth 4 idiv{@rect}repeat}{@rect}ifelse stroke grestore}put false setglobal @SD "
"readonly pop/initclip 0 defpr/clippath 0 defpr/sysexec{@SD exch get exec}def/a"
"dddot{dup length 1 add string dup 0 46 put dup 3 -1 roll 1 exch putinterval}de"
"f/setlinewidth{dup/setlinewidth sysexec 1(setlinewidth)prcmd}def/setlinecap 1 "
"defpr/setlinejoin 1 defpr/setmiterlimit 1 defpr/setdash{mark 3 1 roll 2 copy/s"
"etdash sysexec exch aload length 1 add -1 roll counttomark(setdash)prcmd pop}d"
"ef/@setpagedevice{pop<<>>/setpagedevice sysexec matrix setmatrix newpath 0(set"
"pagedevice)prcmd}def/@checknulldev{@GD/@nulldev get{currentpagedevice maxlengt"
"h 0 ne{@GD/@nulldev false put 0 1(setnulldevice)prcmd}if}if}def/prcolor{curren"
"tcolorspace @setcolorspace currentrgbcolor 3(setrgbcolor)prcmd}def/printgstate"
"{@dodraw @GD/@nulldev get not and{matrix currentmatrix aload pop 6(setmatrix)p"
"rcmd applyscalevals currentlinewidth 1(setlinewidth)prcmd currentlinecap 1(set"
"linecap)prcmd currentlinejoin 1(setlinejoin)prcmd currentmiterlimit 1(setmiter"
"limit)prcmd revision dup 952 lt{pop}{.currentblendmode .setblendmode 952 eq{.c"
"urrentopacityalpha .setopacityalpha .currentshapealpha .setshapealpha}{.curren"
"talphaisshape{1}{0}ifelse 1(setalphaisshape)prcmd .currentstrokeconstantalpha "
"1(setstrokeconstantalpha)prcmd .currentfillconstantalpha 1(setfillconstantalph"
"a)prcmd}ifelse}ifelse prcolor currentdash mark 3 1 roll exch aload length 1 ad"
"d -1 roll counttomark(setdash)prcmd pop}if}def/strconcat{exch dup length 2 ind"
"ex length add string dup dup 4 2 roll copy length 4 -1 roll putinterval}def/se"
"tgstate{/setgstate sysexec printgstate}def/save{@UD begin/@saveID vmstatus pop"
" pop def end :save @saveID 1(save)prcmd}def/restore{:restore @checknulldev pri"
"ntgstate @UD/@saveID known{@UD begin @saveID end}{0}ifelse 1(restore)prcmd}def"
"/gsave 0 defpr/grestore{:grestore @checknulldev printgstate 0(grestore)prcmd}d"
"ef/grestoreall{:grestoreall @checknulldev setstate 0(grestoreall)prcmd}def/rot"
"ate{dup type/arraytype ne @dodraw and{dup 1(rotate)prcmd}if/rotate sysexec app"
"lyscalevals}def/scale{dup type/arraytype ne @dodraw and{2 copy 2(scale)prcmd}i"
"f/scale sysexec applyscalevals}def/translate{dup type/arraytype ne @dodraw and"
"{2 copy 2(translate)prcmd}if/translate sysexec}def/setmatrix{dup/setmatrix sys"
"exec @dodraw{aload pop 6(setmatrix)prcmd applyscalevals}{pop}ifelse}def/initma"
"trix{matrix setmatrix}def/concat{matrix currentmatrix matrix concatmatrix setm"
"atrix}def/makepattern{gsave<</mx 3 -1 roll>>begin<</XUID[1000000 @patcnt]>>cop"
"y mx/makepattern sysexec dup begin PatternType 2 lt{PatternType @patcnt BBox a"
"load pop XStep YStep PaintType mx aload pop 15(makepattern)prcmd :newpath matr"
"ix setmatrix dup PaintProc 0 1(makepattern)prcmd @GD/@patcnt @patcnt 1 add put"
"}if end end grestore}def/setpattern{dup begin PatternType end 1 eq{begin Paint"
"Type 1 eq{XUID aload pop exch pop 1}{:gsave[currentcolorspace aload length -1 "
"roll pop]/setcolorspace sysexec/setcolor sysexec XUID aload pop exch pop curre"
"ntrgbcolor :grestore 4}ifelse(setpattern)prcmd currentcolorspace 0 get/Pattern"
" ne{[/Pattern currentcolorspace]/setcolorspace sysexec}if currentcolorspace @s"
"etcolorspace end}{/setpattern sysexec}ifelse}def/setcolor{dup type/dicttype eq"
"{setpattern}{/setcolor sysexec/currentrgbcolor sysexec setrgbcolor}ifelse}def/"
"setcolorspace{dup/setcolorspace sysexec @setcolorspace}def/@setcolorspace{dup "
"type/arraytype eq{0 get}if/Pattern eq{1}{0}ifelse 1(setcolorspace)prcmd}def/se"
"tgray 1 defpr/setcmykcolor 4 defpr/sethsbcolor 3 defpr/setrgbcolor 3 defpr/.se"
"talphaisshape{@SD/.setalphaisshape known{dup/.setalphaisshape sysexec}if{1}{0}"
"ifelse 1(setalphaisshape)prcmd}bind def/.setfillconstantalpha{@SD/.setfillcons"
"tantalpha known{dup/.setfillconstantalpha sysexec}if 1(setfillconstantalpha)pr"
"cmd}bind def/.setstrokeconstantalpha{@SD/.setstrokeconstantalpha known{dup/.se"
"tstrokeconstantalpha sysexec}if 1(setstrokeconstantalpha)prcmd}bind def/.setop"
"acityalpha{false .setalphaisshape dup .setfillconstantalpha .setstrokeconstant"
"alpha}bind def/.setshapealpha{true .setalphaisshape dup .setfillconstantalpha "
".setstrokeconstantalpha}bind def/.setblendmode{dup/.setblendmode sysexec<</Nor"
"mal 0/Compatible 0/Multiply 1/Screen 2/Overlay 3/SoftLight 4/HardLight 5/Color"
"Dodge 6/ColorBurn 7/Darken 8/Lighten 9/Difference 10/Exclusion 11/Hue 12/Satur"
"ation 13/Color 14/Luminosity 15/CompatibleOverprint 16>>exch get 1(setblendmod"
"e)prcmd}def/@pdfpagecount{(r)file runpdfbegin pdfpagecount runpdfend}def/@pdfp"
"agebox{(r)file runpdfbegin dup dup 1 lt exch pdfpagecount gt or{pop}{pdfgetpag"
"e/MediaBox pget pop aload pop}ifelse runpdfend}def DELAYBIND{.bindnow}if ";

