            title   EXECSWAP

; swapping of a programs memory to allow child program execution
; Copyright (C) 1996,98 by Peter Breitenlohner
; Distributed under terms of GNU General Public License

; to be included into main program (for details see dostp.web)

DATA        segment word
            extrn   prefixseg:word     ; psp segment
            extrn   swapseg:word       ; bot of memory to be freed
            extrn   heapptr:dword      ; top of heap (ofs and seg)
            extrn   cmderror:word      ; dos error code
            extrn   cmdexit:word       ; child exit code
            extrn   cmdname:byte       ; command to be executed
            extrn   cmdparm:byte       ; command line
            extrn   hasxms:byte        ; shall we try XMS?
            extrn   hasems:byte        ; shall we try EMS?
            extrn   xmscontrol:dword   ; XMS handler
DATA        ends

CODE        segment word
            assume  cs:CODE, ds:DATA

            public  execswap

; procedure exec_swap(o:Word;f:Pointer);
;           saves and releases some memory,
;           then starts a child process,
;           and finally reclaims and restores memory

execswap    proc    far
            push    bp
            mov     bp,sp

o           equ     word ptr [bp+10]   ; ofs of ASCIIZ string
f           equ     dword ptr [bp+6]   ; ptr to free list

progerror   equ     word ptr [bp-2]    ; Dos error code
progexit    equ     word ptr [bp-4]    ; child return code

blk_off     equ     word ptr [bp+di+2] ; para offset in XMS/EMS/file
blk_seg     equ     word ptr [bp+di]   ; starting segment
blk_cnt     equ     word ptr [bp+di-2] ; para count
blk_1       equ     -8                 ; di for first 16 kB
blk_2       equ     -12                ; di for bulk part
blk_3       equ     -18                ; di for (optional) free list
tot_para    equ     word ptr [bp-22]   ; total para count minus 1

oldmem      equ     word ptr [bp-24]   ; original memory size
prefix      equ     word ptr [bp-26]   ; prefix segment
sw_type     equ     byte ptr [bp-27]   ; swap type 0=XMS, 1=EMS, 2=file
io_cmd      equ     byte ptr [bp-28]   ; 3f=read, 40=write

; 14 byte control block for load and execute
loadparm    equ     word ptr [bp-42]
fcb2_seg    equ     word ptr [bp-30]
fcb2_ofs    equ     word ptr [bp-32]
fcb1_seg    equ     word ptr [bp-34]
fcb1_ofs    equ     word ptr [bp-36]
parm_seg    equ     word ptr [bp-38]
parm_ofs    equ     word ptr [bp-40]
parm_env    equ     word ptr [bp-42]

fcb2        equ     byte ptr [bp-58]
fcb1        equ     byte ptr [bp-74]
progarg     equ     byte ptr [bp-202]  ; command arguments
progname    equ     byte ptr [bp-282]  ; command name

; end of common variables

;           local variables for XMS/EMS swapping

xmsblk      struc
  xmsh      dw      ?                  ; XMS handle or zero
  xmso      dw      ?                  ; (lo part of) offset
  xmss      dw      ?                  ; hi part of offset or segment
xmsblk      ends

xmscall     equ     dword ptr [bp-286] ; XMS handler
xmsdst      equ     xmsblk ptr [bp-292]
xmssrc      equ     xmsblk ptr [bp-298]

emsblk      struc
  emst      db      ?                  ; type: 1=EMS, 0=mem
  emsh      dw      ?                  ; EMS handle or zero
  emso      dw      ?                  ; offset
  emsp      dw      ?                  ; page or segment
emsblk      ends

emsdst      equ     emsblk ptr [bp-291]
emssrc      equ     emsblk ptr [bp-298]

xems_h      equ     word ptr [bp-300]  ; hi part of XMS/EMS count
xems_l      equ     word ptr [bp-302]  ; lo part of XMS/EMS count

xems_free   equ     60                 ; bytes not used for XMS/EMS

;           local variables for file swapping

tempname    equ     byte ptr [bp-362]  ; temp file name

; end of local variables

            xor     ax,ax
            push    ax                 ; progerror
            mov     cmderror,ax
            push    ax                 ; progexit
            mov     cmdexit,ax
            push    ax                 ; blk_1_off
            mov     cx,16              ; conversion byte to para
            les     ax,heapptr         ; es:ax = top of heap
            xor     dx,dx
            div     cx
            or      dx,dx
            jz      heap_para
            inc     ax
heap_para:  mov     dx,es
            add     dx,ax              ; top seg of heap
            mov     di,swapseg
            push    di                 ; blk_1_seg
            sub     dx,di
            mov     ax,0400h
            push    ax                 ; blk_1_cnt = blk_2_off
            add     di,ax
            push    di                 ; blk_2_seg
            mov     si,dx
            sub     dx,ax
            push    dx                 ; blk_2_cnt
            push    si                 ; blk_3_off
            mov     dx,ds
            dec     ax                 ; ax = 03ffh (just in case)
            cmp     dx,di
            jb      err0               ; less than 16kB below ds
            les     ax,f               ; es:ax = free list ptr or nil
            xor     dx,dx
            or      ax,ax
            jz      f0                 ; no free list
            div     cx
            mov     dx,es
            add     dx,ax
            neg     ax
            add     ax,1000h
f0:         push    dx                 ; blk_3_seg
            push    ax                 ; blk_3_cnt
            add     ax,si
            dec     ax
            push    ax                 ; tot_para
            sub     sp,340             ; remaining local variables

            push    ss
            pop     es
            cld

            mov     si,offset cmdname
            lea     di,progname
            lodsb
            cmp     al,4fh
            jb      ok0
            mov     al,4fh
ok0:        cbw
            xchg    cx,ax
            rep movsb
            xor     al,al
            stosb

            mov     si,offset cmdparm
            lea     di,progarg
            lodsb
            cmp     al,7eh
            jb      ok1
            mov     al,7eh
ok1:        stosb
            cbw
            xchg    cx,ax
            rep movsb
            mov     al,0dh
            stosb

            call    sw_init            ; initialize swapping
            jnc     ok2
err0:       jmp     error

ok2:        mov     di,blk_1
            push    ds
            call    sw_out             ; swap out first 16kB
            pop     ds
            jnc     new_stack
            mov     cmderror,ax
            jmp     close

new_stack:  push    ss                 ; save original
            push    bp                 ;               stack frame
            mov     ax,swapseg         ; establish
            push    ax                 ;           2kB
            mov     ax,0800h           ;               new
            push    ax                 ;                   stack
            call    move_stack         ;                         frame

            mov     ax,prefixseg
            mov     prefix,ax
            mov     ds,ax              ; psp segment
            assume  ds:NOTHING
            mov     cx,[ds:2ch]        ; env segment
            mov     parm_env,cx
            dec     ax
            mov     es,ax              ; memory control block
            mov     ax,[es:03h]
            mov     oldmem,ax

            mov     di,blk_2
            call    sw_out             ; swap out bulk part
            jc      give_up
            mov     di,blk_3
            call    sw_out             ; swap out free list
            jc      give_up
            call    sw_clos            ; temporarily close swap device
            jnc     release
give_up:    mov     progerror,ax
            jmp     short old_data

; release most of our memory

release:    mov     es,prefix
            mov     bx,ss
            mov     ax,es
            sub     bx,ax
            add     bx,0080h      ; size of temp stack seg in para
            mov     ah,4ah        ; resize memory block
            int     21h
            jnc     load
            mov     progerror,ax
            jmp     short open

; execute the child process

load:       lea     si,progarg
            mov     parm_ofs,si
            mov     parm_seg,ss
            inc     si
            push    ss
            pop     ds
            push    ss
            pop     es
            lea     di,fcb1
            mov     fcb1_ofs,di
            mov     fcb1_seg,es
            mov     ax,2901h           ; parse filename
            int     21h
            lea     di,fcb2
            mov     fcb2_ofs,di
            mov     fcb2_seg,es
            mov     ax,2901h           ; parse filename
            int     21h
            lea     dx,progname
            lea     bx,loadparm
            mov     ax,4b00h           ; load and execute
            int     21h
            jnc     child_ok
            mov     progerror,ax
child_ok:   mov     ah,4dh             ; get return code
            int     21h
            mov     progexit,ax

; reclaim of our memory

            mov     es,prefix
            mov     bx,oldmem
            mov     ah,4ah             ; resize memory block
            int     21h
            jc      abort

open:       call    sw_open            ; reopen swap device
            jc      abort
            mov     di,blk_2
            call    sw_in              ; swap in bulk part
            jc      abort
            mov     di,blk_3
            call    sw_in              ; swap in free list
            jc      abort

old_data:   mov     dx,DATA
            mov     ds,dx              ; original data segment
            assume  ds:DATA
            mov     ax,progerror
            mov     cmderror,ax
            mov     ax,progexit
            mov     cmdexit,ax

            call    move_stack         ; restore original stack frame

            mov     di,blk_1
            push    ds
            call    sw_in              ; swap in first 16kB
            pop     ds
            jnc     close
abort:      mov     ax,4cffh           ; terminate with return code
            int     21h

close:      call    sw_done            ; close and release swap device
            jnc     done
error:      mov     cmderror,ax
done:       mov     sp,bp
            pop     bp
            ret     6

execswap    endp

move_stack  proc    near

            push    bp
            mov     bp,sp

;           establish new stack frame and copy data

new_ss      equ     word ptr [bp+6]
new_bp      equ     word ptr [bp+4]
cur_bp      equ     word ptr [bp]

            push    cx
            push    si
            push    di
            push    es
            mov     es,new_ss
            mov     di,new_bp
            mov     cx,cur_bp
            mov     cur_bp,di
            sub     cx,sp
            sub     di,cx
            mov     bp,di              ; future sp
            shr     cx,1
            mov     si,sp
            push    ds
            push    ss
            pop     ds
            cld
            rep movsw
            pop     ds
            push    es
            cli
            pop     ss
            mov     sp,bp
            sti
            pop     es
            pop     di
            pop     si
            pop     cx
            pop     bp
            ret     4

move_stack  endp

sw_init     proc    near

;           select swap type and initialize swapping

            xor     ax,ax              ; clear XMS/EMS parameter block
            lea     di,xmssrc
            mov     cl,6               ; we still have ch=0
            rep stosw

; first try XMS swapping
            cmp     hasxms,0
            je      e_init
            lea     si,xmscontrol
            movsw
            movsw
            mov     ax,tot_para
            xor     dx,dx
            mov     cl,40h             ; we still have ch=0
            div     cx                 ; para to kB
            inc     ax
            mov     dx,ax              ; size in kB
            mov     ah,09h             ; XMS allocate
            call    xmscall
            mov     xmsdst.xmsh,dx     ; XMS handle (just in case)
            or      al,al              ; success: ax=1, failure: ax=0
            jnz     xe_init            ; ah=0 indicates XMS swapping

; next try EMS swapping
e_init:     cmp     hasems,0
            je      f_init
            mov     ax,tot_para
            xor     dx,dx
            mov     cx,0400h
            div     cx                 ; para to 16kB pages
            inc     ax
            mov     bx,ax              ; num pages
            mov     ah,43h             ; EMS allocate
            int     67h
            or      ah,ah              ; success: ah=0, failure: ah<>0
            jnz     f_init
            mov     emsdst.emsh,dx     ; EMS handle
            inc     ah                 ; ah=1 indicates EMS swapping
            mov     emsdst.emst,ah     ; dst = EMS
xe_init:    mov     sw_type,ah
            clc
            ret     xems_free          ; release unused variables

; finally try file swapping
f_init:     cld
            mov     si,o               ; copy ASCIIZ temp path
            lea     di,tempname
            mov     dx,di
            mov     cx,0028h
            rep movsw
            mov     ah,5ah             ; create temporary file
            push    ds
            push    ss
            pop     ds
            int     21h
            pop     ds
            mov     bx,ax              ; bx = file handle
            mov     sw_type,2          ; indicate file swapping
            ret

;           close and release swap device

sw_done:    cmp     sw_type,1          ; test type
            jb      x_done             ;                     XMS
            je      e_done             ;                     EMS
                                       ;                     file
            mov     ah,3eh             ; close handle
            int     21h
            jc      f_done0
            lea     dx,tempname
            mov     ah,41h             ; delete file
            push    ds
            push    ss
            pop     ds
            int     21h
            pop     ds
f_done0:    ret

x_done:     mov     dx,xmssrc.xmsh     ; get
            or      dx,xmsdst.xmsh     ;     XMS handle
            mov     ah,0ah             ; XMS deallocate
x_call:     call    xmscall
            xchg    al,bl              ; save error code
            cmp     bl,1               ; clear/set carry
            ret

e_done:     mov     dx,emssrc.emsh     ; get
            or      dx,emsdst.emsh     ;     EMS handle
            mov     ah,45h             ; EMS deallocate
e_call:     int     67h
            mov     bl,ah
            shl     bl,1               ; clear/set carry
            ret

sw_init     endp

            assume  ds:NOTHING

sw_out      proc    near

;           swap out                     di points to parameter block

            call    sw_io              ; setup and test type
            ja      f_out              ;                     file
            je      e_out              ;                     EMS
                                       ;                     XMS
            mov     xmsdst.xmso,di     ; XMS lo offset
x_out0:     mov     xmsdst.xmss,bx     ; destination hi offset/segment
            mov     xmssrc.xmss,si     ; source hi offset/segment
            mov     ah,0bh             ; XMS move
            lea     si,xems_l
            push    ss
            pop     ds
            jmp     x_call

e_out:      mov     emsdst.emso,bx     ; EMS offset
e_out0:     mov     emsdst.emsp,di     ; destination page/segment
            mov     emssrc.emsp,si     ; source page/segment
            mov     ax,5700h           ; EMS move
            lea     si,xems_l
            push    ss
            pop     ds
            jmp     e_call

e_in:       cmp     al,emsdst.emst     ; first input?
            je      e_in0              ;              no
            xchg    al,emsdst.emst     ; dst = mem
            xchg    al,emssrc.emst     ; src = EMS
            mov     emsdst.emso,ax     ; clear dst offset
            xchg    ax,emsdst.emsh     ; clear dst handle
            xchg    ax,emssrc.emsh     ; set src handle
e_in0:      mov     emssrc.emso,bx     ; EMS offset
            xchg    di,si              ; EMS page <=> mem segment
            jmp     e_out0

;           swap in                      di points to parameter block

sw_in:      call    sw_io              ; setup and test type
            ja      f_in               ;                     file
            je      e_in               ;                     EMS
                                       ;                     XMS
            cmp     ax,xmsdst.xmsh     ; first input?
            je      x_in0              ;              no
            mov     xmsdst.xmso,ax     ; clear dst offset
            xchg    ax,xmsdst.xmsh     ; clear dst handle
            xchg    ax,xmssrc.xmsh     ; set src handle
x_in0:      mov     xmssrc.xmso,di     ; XMS lo offset
            xchg    bx,si              ; XMS hi offset <=> mem segment
            jmp     x_out0

f_out:      mov     io_cmd,40h         ; write to file
f_out0:     mov     ax,0400h           ; 0400h paras = 16kB
            cmp     ax,di
            jna     f_out1
            mov     ax,di              ; read/write at most 16kB
f_out1:     sub     di,ax
            mov     ds,si
            add     si,ax
            mov     cx,16
            mul     cx
            mov     cx,ax
            mov     ah,io_cmd
            int     21h
            jc      f_out3             ; any error?
            cmp     ax,cx
            jnb     f_out2             ; all bytes transferred?
            mov     ax,03ffh
            jmp     short f_out3
f_out2:     or      di,di
            jnz     f_out0             ; more to do?
f_out3:     ret

f_in:       mov     io_cmd,3fh         ; read from file
            mov     cx,dx
            mov     dx,ax
            mov     ax,4200h           ; move file pointer
            int     21h
            jnc     f_out0
            ret

;           common setup for sw_out and sw_in

sw_io:      mov     ax,blk_off         ; ax = para offset
            mov     si,blk_seg         ; si = starting segment
            mov     di,blk_cnt         ; di = para count
            or      di,di
            jz      no_io              ; nothing to do
            mov     cx,16
            mul     cx                 ; dx:ax = byte offset
            cmp     sw_type,1          ; test type
            ja      f_io0              ;           file
            jb      x_io               ;           XMS
            mov     bx,4000h           ;           EMS
            div     bx                 ; dx:ax = offset:page
x_io:       xchg    ax,di
            mov     bx,dx              ; dx:ax => bx:di
            mul     cx
            mov     xems_h,dx          ; store
            mov     xems_l,ax          ;       byte count
            xor     ax,ax
            cmp     sw_type,1          ; test type (again)
f_io0:      ret

no_io:      pop     ax
            ret                        ; exit sw_in/sw_out

sw_out      endp

sw_clos     proc    near

;           temporarily close swap device

            cmp     sw_type,1          ; test type
            ja      f_clos             ;           file
xe_clos:    clc                        ;           XMS/EMS
            ret
f_clos:     mov     ah,3eh             ; close handle
            int     21h
            ret

;           reopen swap device

sw_open:    cmp     sw_type,1          ; test type
            jna     xe_clos            ;           XMS/EMS
            lea     dx,tempname        ;           file
            mov     ax,3d00h           ; open handle
            push    ss
            pop     ds
            int     21h
            mov     bx,ax              ; bx = file handle
            ret

sw_clos     endp

CODE        ends

            end
