# Copyright (C) 2000 - Martin Strauss - under terms of GPL
##############################################################
# search routine
# ok !
proc InitSearch {} {
 global T
 if ![winfo exists .wsearch] then {
  toplevel .wsearch
  wm title .wsearch $T(wsearch-titel)

  entry .wsearch.text1 -width 20 -relief sunken -background White
  entry .wsearch.text2 -width 20 -relief sunken -background White

  global wsearch_gb
  checkbutton .wsearch.butgb -variable wsearch_gb -text $T(wsearch-case-sensitive)

  button .wsearch.but1 -text $T(wsearch-top) -command {
   if $FocusEditorFlag then {
    focus $FocusEditor.te.edit1
    set Text [.wsearch.text1 get]
    if !$wsearch_gb then {set comm "-nocase --"} else {set comm "--"}
    set ksp [$FocusEditor.te.edit1 search $comm $Text 1.0]
    if {$ksp != ""} then {
     $FocusEditor.te.edit1 mark set insert $ksp
     $FocusEditor.te.edit1 see insert
     $FocusEditor.te.edit1 tag remove sel 1.0 end
     $FocusEditor.te.edit1 tag add sel insert insert+[string length $Text]c
     event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
  }}}
  frame .wsearch.f1

  button .wsearch.f1.but2 -text $T(wsearch-down) -command {
   if $FocusEditorFlag then {
    focus $FocusEditor.te.edit1
    set Text [.wsearch.text1 get]
    if !$wsearch_gb then {set comm "-nocase --"} else {set comm "--"}
    set ksp [$FocusEditor.te.edit1 search $comm $Text insert+1c]
    if {$ksp != ""} then {
    $FocusEditor.te.edit1 mark set insert $ksp
     $FocusEditor.te.edit1 see insert
     $FocusEditor.te.edit1 tag remove sel 1.0 end
     $FocusEditor.te.edit1 tag add sel insert insert+[string length $Text]c
     event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
   }}}

  button .wsearch.f1.but3 -text $T(wsearch-up) -command {
   if $FocusEditorFlag then {
    focus $FocusEditor.te.edit1
    set Text [.wsearch.text1 get]
    if {$Text != ""} then {
     if !$wsearch_gb then {set comm "-nocase --"} else {set comm "--"}
     set ksp [$FocusEditor.te.edit1 search -backwards $comm $Text insert]
     if {$ksp != ""} then {
      $FocusEditor.te.edit1 mark set insert $ksp
      $FocusEditor.te.edit1 see insert
      $FocusEditor.te.edit1 tag remove sel 1.0 end
      $FocusEditor.te.edit1 tag add sel insert insert+[string length $Text]c
      event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
   }}}}

  frame .wsearch.f2

  button .wsearch.f2.but4 -text $T(wsearch-replace) -command {
   if $FocusEditorFlag then {
    focus $FocusEditor.te.edit1
    set FIND [.wsearch.text1 get]
    set FIND_L [string length $FIND]
    if {$FIND != ""} then { 
     set NOW [$FocusEditor.te.edit1 get insert "insert + $FIND_L chars"]
     if ![string compare $NOW $FIND] then {
      # Ersetzt
      undo_switch $FocusEditor.te.edit1 "Save {insert \"insert + $FIND_L chars\"} Delete UndoBegin"
      set REPLACE [.wsearch.text2 get]
      $FocusEditor.te.edit1 insert insert $REPLACE
      $FocusEditor.te.edit1 see insert
      undo_switch $FocusEditor.te.edit1 {UndoEnd Save UndoMax}
      event generate $FocusEditor.te.edit1 <<Modified>>
     }
     # Sucht
     if !$wsearch_gb then {set comm "-nocase --"} else {set comm "--"}
     set ksp [$FocusEditor.te.edit1 search $comm $FIND insert]
     if {$ksp != ""} then {
      $FocusEditor.te.edit1 mark set insert $ksp
      $FocusEditor.te.edit1 see insert
      $FocusEditor.te.edit1 tag remove sel 1.0 end
      $FocusEditor.te.edit1 tag add sel insert insert+[string length $FIND]c
      $FocusEditor.te.edit1 mark set sel.first insert
      event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
  }}}}

  button .wsearch.f2.but5 -text $T(wsearch-all) -command {
   if $FocusEditorFlag then {
    focus $FocusEditor.te.edit1
    set FIND [.wsearch.text1 get]
    set FIND_L [string length "$FIND"]
    if {$FIND != ""} then { 
     set REPLACE [.wsearch.text2 get]
     set modifiedflag 0
     if !$wsearch_gb then {set comm "-nocase --"} else {set comm "--"}
     undo_switch $FocusEditor.te.edit1 Save
     set startindex [$FocusEditor.te.edit1 index insert]
     set nowindex 1.0
     while {$nowindex != ""} {
      $FocusEditor.te.edit1 mark set insert $nowindex
      set NOW [$FocusEditor.te.edit1 get insert "insert + $FIND_L chars"]
      if ![string compare $NOW $FIND] then {
       # Ersetzt
       undo_switch $FocusEditor.te.edit1 "{insert \"insert + $FIND_L chars\"} Delete UndoBegin"
       $FocusEditor.te.edit1 insert insert $REPLACE
       undo_switch $FocusEditor.te.edit1 {UndoEnd Save}
       set startindex [$FocusEditor.te.edit1 index insert]
       set modifiedflag 1
      }
      # Sucht
      set nowindex [$FocusEditor.te.edit1 search $comm $FIND insert end]
     }
     $FocusEditor.te.edit1 mark set insert $startindex
     if $modifiedflag {
      event generate $FocusEditor.te.edit1 <<Modified>>
     }
     event generate $FocusEditor.te.edit1 <<Position_tail>> -when tail
    }
   }
  }

  button .wsearch.butQ -text $T(quit) -command {
   destroy .wsearch
  }
  pack  .wsearch.f1.but2 -side left
  pack .wsearch.f1.but3 -side right
  pack .wsearch.f2.but4 .wsearch.f2.but5 -side left
  pack .wsearch.text1 .wsearch.but1 .wsearch.f1 .wsearch.butgb .wsearch.text2\
.wsearch.f2 .wsearch.butQ
  wm minsize . 1 1
  bind .wsearch <<Help>> {Help tcltexed_hlp $T(wsearch-Help)}
  bind .wsearch <Control-c> {
   destroy .wsearch
  }
  wm resizable .wsearch 0 0
  COLOR .wsearch
  .wsearch.text1 configure -background White
  .wsearch.text2 configure -background White
  menu .wsearch.text1.pop_menu 
  .wsearch.text1.pop_menu add command -label $T(pop_menu-Cut) -command "event generate .wsearch.text1 <<Cut>>"
  .wsearch.text1.pop_menu add command -label $T(pop_menu-Copy) -command "event generate wsearch.text1 <<Copy>>"
  .wsearch.text1.pop_menu add command -label $T(pop_menu-Paste) -command "event generate .wsearch.text1 <<Paste>>"
  .wsearch.text1.pop_menu add command -label $T(pop_menu-Clear) -command "event generate .wsearch.text1 <<Clear>>"
  menu .wsearch.text2.pop_menu 
  .wsearch.text2.pop_menu add command -label $T(pop_menu-Cut) -command "event generate .wsearch.text2 <<Cut>>"
  .wsearch.text2.pop_menu add command -label $T(pop_menu-Copy) -command "event generate .wsearch.text2 <<Copy>>"
  .wsearch.text2.pop_menu add command -label $T(pop_menu-Paste) -command "event generate .wsearch.text2 <<Paste>>"
  .wsearch.text2.pop_menu add command -label $T(pop_menu-Clear) -command "event generate .wsearch.text2 <<Clear>>"

  bind .wsearch.text1 <Button-3> "tk_popup .wsearch.text1.pop_menu \[winfo pointerx .wsearch\] \[winfo pointery .wsearch\]"
  bind .wsearch.text2 <Button-3> "tk_popup .wsearch.text2.pop_menu \[winfo pointerx .wsearch\] \[winfo pointery .wsearch\]"

 } else {focus .wsearch}
}
