package com.dickimawbooks.jmakepdfx;

import java.io.*;

public class ProcessInputReaderThread extends Thread
{
   public ProcessInputReaderThread(Jmakepdfx application, Process process,
      ProcessListener listener)
   {
      super();
      app = application;
      this.process = process;
      this.listener = listener;
   }

   public void run()
   {
      BufferedReader in = null;
      BufferedReader err = null;

      try
      {
         in = new BufferedReader(new InputStreamReader(process.getInputStream()));

         String line;
         int lineNum = 0;

         Jmakepdfx.checkForInterrupt();

         while ((line = in.readLine()) != null)
         {
            lineNum++;
            listener.processLine(lineNum, line);

            Jmakepdfx.checkForInterrupt();
         }

         err = new BufferedReader(new InputStreamReader(process.getErrorStream()));

         lineNum = 0;

         Jmakepdfx.checkForInterrupt();

         while ((line = err.readLine()) != null)
         {
            lineNum++;
            listener.processErrorLine(lineNum, line);
            Jmakepdfx.checkForInterrupt();
         }
      }
      catch (Exception e)
      {
         InterruptTimerTask interruptor = listener.getInterruptor();

         if (interruptor != null)
         {
            switch (interruptor.getStatus())
            {
               case InterruptTimerTask.STATUS_ABORT:
                  listener.error(new CancelledException());
               return;
               case InterruptTimerTask.STATUS_TIMEDOUT:
                 listener.error(new CancelledException(
                    Jmakepdfx.getLabelWithValue("error.timedout", 
                       ""+app.getMaxProcessTime())));
               return;
            }
         }

         listener.error(e);
      }
      finally
      {
         if (in != null)
         {
            try
            {
               in.close();
            }
            catch (IOException e)
            {
               listener.error(e);
            }

            in = null;
         }

         if (err != null)
         {
            try
            {
               err.close();
            }
            catch (IOException e)
            {
               listener.error(e);
            }

            err = null;
         }
      }
   }

   private Process process;
   private ProcessListener listener;
   private Jmakepdfx app;
}
