package com.dickimawbooks.jmakepdfx;

import java.io.*;

/**
 * Filter for pdf files. Recognised extensions: pdf.
 */
public class PdfFileFilter extends javax.swing.filechooser.FileFilter
{
   /**
    * Creates a Pdf/LaPdf file filter with default description.
    */
   public PdfFileFilter()
   {
      this(Jmakepdfx.getLabel("filter.pdf"));
   }

   /**
    * Creates a PDF file filter with given description.
    */
   public PdfFileFilter(String description)
   {
      super();

      this.description = description;
   }

   /**
    * Determines whether given file is accepted by this filter.
    */
   public boolean accept(File f)
   {
      if (f.isDirectory()) return true;

      String name = f.getName().toLowerCase();

      if (name.endsWith(".pdf"))
      {
         return true;
      }
      
      return false;
   }

   /**
    * Gets the description of this filter.
    */
   public String getDescription()
   {
      return description;
   }

   public String getDefaultExtension()
   {
      return "pdf";
   }

   private String description;
}
