/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.AuxBibGlsOptions;
import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.auxfile.AuxParser;
import com.dickimawbooks.texparserlib.latex.Input;
import java.io.IOException;
import java.nio.charset.Charset;

public class BibGlsAuxParser
extends AuxParser {
    private Bib2Gls bib2gls;
    private boolean bibglsInputFound = false;

    public BibGlsAuxParser(Bib2Gls bib2Gls, Charset charset) throws IOException {
        super((TeXApp)bib2Gls, charset);
        this.bib2gls = bib2Gls;
    }

    protected void addPredefined() {
        super.addPredefined();
        this.putControlSequence((ControlSequence)new Input("@bibgls@input", 1, false){

            protected boolean doInput(TeXParser teXParser, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
                BibGlsAuxParser.this.bibglsInputFound = true;
                return super.doInput(teXParser, teXObject, teXObjectList);
            }
        });
        this.putControlSequence((ControlSequence)new Input("@input", 1, false){

            protected boolean isInputEnabled() {
                switch (BibGlsAuxParser.this.bib2gls.getAuxInputAction()) {
                    case FOLLOW: {
                        return true;
                    }
                    case SKIP_AFTER_BIBGLSAUX: {
                        return !BibGlsAuxParser.this.bibglsInputFound;
                    }
                    case SKIP: {
                        return false;
                    }
                }
                assert (false) : "Unknown aux input action";
                return true;
            }

            public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
                if (this.isInputEnabled()) {
                    super.process(teXParser, teXObjectList);
                } else {
                    this.popArg(teXParser, teXObjectList);
                }
            }
        });
        this.putControlSequence((ControlSequence)new AuxBibGlsOptions(this.bib2gls));
        this.addAuxCommand("glsxtr@resource", 2);
        this.addAuxCommand("glsxtr@fields", 1);
        this.addAuxCommand("glsxtr@record", 5);
        this.addAuxCommand("glsxtr@recordsee", 2);
        this.addAuxCommand("glsxtr@record@nameref", 8);
        this.addAuxCommand("glsxtr@select@entry", 5);
        this.addAuxCommand("glsxtr@select@entry@nameref", 8);
        this.addAuxCommand("glsxtr@texencoding", 1);
        this.addAuxCommand("glsxtr@langtag", 1);
        this.addAuxCommand("glsxtr@shortcutsval", 1);
        this.addAuxCommand("glsxtr@pluralsuffixes", 4);
        this.addAuxCommand("@glsxtr@altmodifier", 1);
        this.addAuxCommand("@glsxtr@newglslike", 2);
        this.addAuxCommand("@glsxtr@newglslikefamily", 8);
        this.addAuxCommand("@glsxtr@prefixlabellist", 1);
        this.addAuxCommand("@glsxtr@multientry", 4);
        this.addAuxCommand("@glsxtr@mglsrefs", 1);
        this.addAuxCommand("@glsxtr@mglslike", 1);
        this.addAuxCommand("@mfu@excls", 1);
        this.addAuxCommand("@mfu@blockers", 1);
        this.addAuxCommand("@mfu@mappings", 1);
        this.addAuxCommand("@newglossary", 4);
    }
}

