/*
    Copyright (C) 2013-2022 Nicola L.C. Talbot
    www.dickimaw-books.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
package com.dickimawbooks.texparserlib.latex;

import java.io.IOException;
import java.util.Vector;

import com.dickimawbooks.texparserlib.*;

public class FontShapeDeclaration extends Declaration
{
   public FontShapeDeclaration(String name, int shapeId)
   {
      super(name);
      this.orgShape = TeXFontShape.INHERIT;

      switch (shapeId)
      {
         case TeXSettings.INHERIT:
           shape = TeXFontShape.INHERIT;
         break;
         case TeXSettings.SHAPE_UP:
           shape = TeXFontShape.UP;
         break;
         case TeXSettings.SHAPE_IT:
           shape = TeXFontShape.IT;
         break;
         case TeXSettings.SHAPE_SC:
           shape = TeXFontShape.SC;
         break;
         case TeXSettings.SHAPE_EM:
           shape = TeXFontShape.EM;
         break;
         default:
            throw new IllegalArgumentException("Invalid shape ID: "+shapeId);
      }
   }

   public FontShapeDeclaration(String name, TeXFontShape shape)
   {
      super(name);
      this.shape = shape;
      this.orgShape = TeXFontShape.INHERIT;
   }

   @Override
   public Object clone()
   {
      return new FontShapeDeclaration(getName(), shape);
   }

   @Override
   public boolean canExpand()
   {
      return false;
   }

   @Override
   public TeXObjectList expandonce(TeXParser parser, TeXObjectList list)
      throws IOException
   {
      return null;
   }

   @Override
   public TeXObjectList expandonce(TeXParser parser)
      throws IOException
   {
      return null;
   }

   @Override
   public TeXObjectList expandfully(TeXParser parser, TeXObjectList list)
      throws IOException
   {
      return null;
   }

   @Override
   public TeXObjectList expandfully(TeXParser parser)
      throws IOException
   {
      return null;
   }

   @Override
   public void process(TeXParser parser) throws IOException
   {
      TeXSettings settings = parser.getSettings();

      orgShape = settings.getCurrentFontShape();

      settings.setFontShape(shape);
   }

   @Override
   public void process(TeXParser parser, TeXObjectList stack) throws IOException
   {
      process(parser);
   }

   @Override
   public void end(TeXParser parser, TeXObjectList stack) throws IOException
   {
      TeXSettings settings = parser.getSettings();
      settings.setFontShape(orgShape);
   }

   @Override
   public boolean isModeSwitcher()
   {
      return false;
   }

   public TeXFontShape getShape()
   {
      return shape;
   }

   private String name;
   private TeXFontShape shape, orgShape;
}
