
; Datei: DVIPRN.S
; Autor: Ingo Eichenseher
; Letzte Aenderung: 09.04.1991 07:29


mfpvec		equ		$100		; Interruptvector table for mfp
_hz_200		equ		$4BA		; Anzahl der 200Hz Interrupts
psg			equ		$FF8800		; Sound chip
mfp			equ		$FFFA01		; Multi functional peripheral chip
gpip		equ		$FFFA01		; General purpose interrupt port
aer			equ		$FFFA03		; Active edge register
ddr			equ		$FFFA05		; Data direction register
ierb		equ		$FFFA09		; Interrupt enable register B
iprb		equ		$FFFA0D		; Interrupt pending register B
isrb		equ		$FFFA11		; Interrupt service register B
imrb		equ		$FFFA15		; Interrupt mask register B

buf_size	equ		16384
wait_time	equ		2000		; ca. 10 Sekunden

			export	dviprn, install, destall
			
			code

install:	tst.l	old_trap
			bne.b	no_install
			pea		trap_rout
			move.w	#35,-(sp)		; trap #3
			move.w	#5,-(sp)
			trap	#13
			addq	#8,sp
			move.l	d0,old_trap
			pea		init
			move.w	#$26,-(sp)
			trap	#14
			addq	#6,sp
no_install:	rts
			
destall:	tst.l	old_trap
			beq.b	no_destall
			move.l	old_trap,-(sp)
			move.w	#35,-(sp)		; trap #3
			move.w	#5,-(sp)
			trap	#13
			clr.l	old_trap
			addq	#8,sp
			pea		exit
			move.w	#$26,-(sp)
			trap	#14
			addq	#6,sp
no_destall:	rts

macro		inc		reg
			local	ok
			addq	#1,reg
			cmp		#buf_size,reg
			blt.b	ok
			clr		reg
ok:
endm
			
dviprn:		trap	#3
			rts

			super
trap_rout:	movem.l	d1-d2/a0-a2,-(sp)
			move.w	sr,save_sr
			move.w	#$2700,sr

			btst.b	#0,gpip
			bne.b	buffered
			tst.b	ready
			bne		direct

buffered:	clr.b	ready
			move.w	in_ptr,d1
			inc		d1
			cmp		out_ptr,d1
			bne.b	time_ok

			move.l	_hz_200,d2
			add.l	#wait_time,d2
			move.w	save_sr,sr
			
wait_buf:	cmp		out_ptr,d1
			bne.b	time_ok
			cmp.l	_hz_200,d2
			bcc.b	wait_buf
			clr		in_ptr
			clr		out_ptr
			st.b	ready
			movem.l	(sp)+,d1-d2/a0-a2
			moveq	#-1,d0
			rte

time_ok:	move.w	#$2700,sr
			lea		buffer,a0
			move.w	in_ptr,d2
			move.b	d0,0(a0,d2.w)
			move.w	d1,in_ptr
			clr.l	d0
			movem.l	(sp)+,d1-d2/a0-a2
			rte
			
direct:		clr.b	ready
			lea		psg,a0		; psg Register select
			move.b	#15,(a0)	; select register #15 (=Port B)
			move.b	d0,2(a0)	; move data to port B
			move.b	#14,(a0)	; select register #14 (=Port A)
			move.b	(a0),d1		; read Port A
			bclr	#5,d1		; clear data strobe bit
			move.b	d1,2(a0)	; write Port A
			bset	#5,d1		; set data strobe bit
			move.b	d1,2(a0)	; write Port A
			clr.l	d0
			movem.l	(sp)+,d1-d2/a0-a2
			rte

			user
			
init:		lea		psg,a0		; psg Register select
			move.b	#7,(a0)		; select Register #7
			move.b	(a0),d1		; get Register #7
			or.b	#$80,d1		; set bit for Port B output
			move.b	d1,2(a0)	; write to psg write register
			
			clr		in_ptr
			clr		out_ptr
			st.b	ready

			move.l	mfpvec,oldmfpv
			move.l	#busyint,mfpvec
			bclr.b	#0,aer		; interrupt at high->low for busy
			bclr.b	#0,ddr		; select busy for input
			bset.b	#0,ierb		; enable interrupt
			bset.b	#0,imrb		; another enable
			move.b	#-2,iprb
			move.b	#-2,isrb
			rts
			
			super
exit:		movem.l	d0/d1,-(sp)
exitl:		move.l	_hz_200,d1
			add.l	#wait_time,d1
			move.w	out_ptr,d0
exitl1:		tst.b	ready
			bne.b	exit1
			cmp.w	out_ptr,d0
			bne.b	exitl
			cmp.l	_hz_200,d1
			bcc.b	exitl1	
exit1:		bclr.b	#0,ierb
			move.l	oldmfpv,mfpvec
			movem.l	(sp)+,d0/d1
			rts

busyint:	movem.l	d0/d1/a0,-(sp)
			move	out_ptr,d1
			cmp		in_ptr,d1
			seq.b	ready
			beq.b	buf_empty
			lea		buffer,a0
			move.b	0(a0,d1.w),d0
			inc		d1
			move	d1,out_ptr
			
			lea		psg,a0		; psg Register select
			move.b	#15,(a0)	; select register #15 (=Port B)
			move.b	d0,2(a0)	; move data to port B
			move.b	#14,(a0)	; select register #14 (=Port A)
			move.b	(a0),d1		; read Port A
			bclr	#5,d1		; clear data strobe bit
			move.b	d1,2(a0)	; write Port A
			bset	#5,d1		; set data strobe bit
			move.b	d1,2(a0)	; write Port A
			
buf_empty:	move.b	#-2,isrb
			movem.l	(sp)+,d0/d1/a0
			rte
			
			user
			
			bss			

old_trap:	ds.l	1
oldmfpv:	ds.l	1
in_ptr:		ds.w	1
out_ptr:	ds.w	1
save_sr:	ds.w	1
buffer:		ds.b	buf_size
cdata:		ds.b	1
ready:		ds.b	1

			end		
