# -*- perl -*-

use strict;
use Set::IntSpan 1.17;

my $N = 1;
sub Not { print "not " }
sub OK  { print "ok ", $N++, "\n" }

my @Island = 
#		      cover     holes
    (['  -   	  ', '  -   ', '  -   ',],
     [' (-)  	  ', ' (-)  ', '  -   ',],
     [' (-1,9-)   ', ' (-)  ', ' 2-8  ',],
     [' (-0  	  ', ' (-0  ', '  -   ',],
     [' (-0,5-9   ', ' (-9  ', ' 1-4  ',],
     [' 0-)  	  ', ' 0-)  ', '  -   ',],
     [' 0-5,9-)	  ', ' 0-)  ', ' 6-8  ',],
     ['  1   	  ', '  1   ', '  -   ',],
     ['  5   	  ', '  5   ', '  -   ',],
     [' 1,3,5	  ', ' 1-5  ', ' 2,4  ',],
     [' 1,3-5	  ', ' 1-5  ', ' 2    ',],
     ['-1-5  	  ', '-1-5  ', '  -   ',],
     );


my @Inset = 
(
    [ ' - ', -2, ' - ' ],
    [ ' - ', -1, ' - ' ],
    [ ' - ',  0, ' - ' ],
    [ ' - ',  1, ' - ' ],
    [ ' - ',  2, ' - ' ],

    [ '(-)', -2, '(-)' ],
    [ '(-)', -1, '(-)' ],
    [ '(-)',  0, '(-)' ],
    [ '(-)',  1, '(-)' ],
    [ '(-)',  2, '(-)' ],

    [ '(-0', -2, '(-2 ' ],
    [ '(-0', -1, '(-1 ' ],
    [ '(-0',  0, '(-0 ' ],
    [ '(-0',  1, '(--1' ],
    [ '(-0',  2, '(--2' ],

    [ '0-)', -2, '-2-)' ],
    [ '0-)', -1, '-1-)' ],
    [ '0-)',  0, ' 0-)' ],
    [ '0-)',  1, ' 1-)' ],
    [ '0-)',  2, ' 2-)' ],

    [ '0,2-3,6-8,12-15,20-24,30-35'  , -2, '-2-26,28-37' ],
    [ '0,2-3,6-8,12-15,20-24,30-35'  , -1, '-1-9,11-16,19-25,29-36' ],
    [ '0,2-3,6-8,12-15,20-24,30-35'  ,  0, '0,2-3,6-8,12-15,20-24,30-35' ],
    [ '0,2-3,6-8,12-15,20-24,30-35'  ,  1, '7,13-14,21-23,31-34' ],
    [ '0,2-3,6-8,12-15,20-24,30-35'  ,  2, '22,32-33' ],

    [ '(-0,2-3,6-8,12-15,20-24,30-35', -2, '(-26,28-37' ],
    [ '(-0,2-3,6-8,12-15,20-24,30-35', -1, '(-9,11-16,19-25,29-36' ],
    [ '(-0,2-3,6-8,12-15,20-24,30-35',  0, '(-0,2-3,6-8,12-15,20-24,30-35' ],
    [ '(-0,2-3,6-8,12-15,20-24,30-35',  1, '(--1,7,13-14,21-23,31-34' ],
    [ '(-0,2-3,6-8,12-15,20-24,30-35',  2, '(--2,22,32-33' ],

    [ '0,2-3,6-8,12-15,20-24,30-)'   , -2, '-2-26,28-)' ],
    [ '0,2-3,6-8,12-15,20-24,30-)'   , -1, '-1-9,11-16,19-25,29-)' ],
    [ '0,2-3,6-8,12-15,20-24,30-)'   ,  0, '0,2-3,6-8,12-15,20-24,30-)' ],
    [ '0,2-3,6-8,12-15,20-24,30-)'   ,  1, '7,13-14,21-23,31-)' ],
    [ '0,2-3,6-8,12-15,20-24,30-)'   ,  2, '22,32-)' ],

);

print "1..", 2 * (@Island+1) + (@Inset+2), "\n";

Cover();
Holes();
Inset(); 

sub Cover
{
    print "#cover\n";

    for my $t (@Island)
    {
	my $set      = new Set::IntSpan $t->[0];
	my $expected = new Set::IntSpan $t->[1];
	my $result   = $set->cover;

	printf "#%-12s %-12s -> %s\n", 'cover', $set->run_list, $result->run_list;
	$result->equal($expected) or Not; OK;
    }

    Set::IntSpan->new->extent->empty or Not; OK;
}

sub Holes
{
    print "#holes\n";

    for my $t (@Island)
    {
	my $set      = new Set::IntSpan $t->[0];
	my $expected = new Set::IntSpan $t->[2];
	my $result   = $set->holes;

	printf "#%-12s %-12s -> %s\n", 'holes', $set->run_list, $result->run_list;
	$result->equal($expected) or Not; OK;
    }

    Set::IntSpan->new->holes->empty or Not; OK;
}

sub Inset
{
    print "#inset\n";

    for my $t (@Inset)
    {
	my $set      = new Set::IntSpan $t->[0];
	my $n        = $t->[1];
	my $expected = new Set::IntSpan $t->[2];
	my $result   = $set->inset($n);
	
	printf "#%-12s %-12s %d -> %s\n", 'inset', $set->run_list, $n, $result->run_list;
	$result->equal($expected) or Not; OK;
    }

    Set::IntSpan->new('1-3')->pad (1)->size==5 or Not; OK;
    Set::IntSpan->new('1-3')->trim(1)->size==1 or Not; OK;
}
