/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_QuickTip({"alternateClassNames":[],"aliases":{"widget":["quicktip"]},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.ToolTip","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><a href='#!/api/Ext.Component' rel='Ext.Component' class='docClass'>Ext.Component</a><div class='subclass '><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='docClass'>Ext.BoxComponent</a><div class='subclass '><a href='#!/api/Ext.Container' rel='Ext.Container' class='docClass'>Ext.Container</a><div class='subclass '><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='docClass'>Ext.Panel</a><div class='subclass '><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='docClass'>Ext.Tip</a><div class='subclass '><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='docClass'>Ext.ToolTip</a><div class='subclass '><strong>Ext.QuickTip</strong></div></div></div></div></div></div></div></div><h4>Files</h4><div class='dependency'><a href='source/QuickTip.html#Ext-QuickTip' target='_blank'>QuickTip.js</a></div></pre><div class='doc-contents'><p>A specialized tooltip class for tooltips that can be specified in markup and automatically managed by the global\n<a href=\"#!/api/Ext.QuickTips\" rel=\"Ext.QuickTips\" class=\"docClass\">Ext.QuickTips</a> instance.  See the QuickTips class header for additional usage details and examples.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-activeItem' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-activeItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-activeItem' class='name expandable'>activeItem</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>A string component id or the numeric index of the component that should be initially activated within the\ncontainer's...</div><div class='long'><p>A string component id or the numeric index of the component that should be initially activated within the\ncontainer's layout on render.  For example, activeItem: 'item-1' or activeItem: 0 (index 0 = the first\nitem in the container's collection).  activeItem only applies to layout styles that can display\nitems one at a time (like <a href=\"#!/api/Ext.layout.AccordionLayout\" rel=\"Ext.layout.AccordionLayout\" class=\"docClass\">Ext.layout.AccordionLayout</a>, <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a> and\n<a href=\"#!/api/Ext.layout.FitLayout\" rel=\"Ext.layout.FitLayout\" class=\"docClass\">Ext.layout.FitLayout</a>).  Related to <a href=\"#!/api/Ext.layout.ContainerLayout-property-activeItem\" rel=\"Ext.layout.ContainerLayout-property-activeItem\" class=\"docClass\">Ext.layout.ContainerLayout.activeItem</a>.</p>\n</div></div></div><div id='cfg-allowDomMove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-allowDomMove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-allowDomMove' class='name expandable'>allowDomMove</a><span> : Boolean</span></div><div class='description'><div class='short'>Whether the component can move the Dom node when rendering (defaults to true). ...</div><div class='long'><p>Whether the component can move the Dom node when rendering (defaults to true).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-anchor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-anchor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-anchor' class='name expandable'>anchor</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use an Anc...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use an <b><a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">AnchorLayout</a> (or subclass thereof).</b>\nbased layout manager, for example:<div class=\"mdetail-params\"><ul>\n<li><a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a></li>\n<li>specifying <code>layout: 'anchor' // or 'form', or 'absolute'</code></li>\n</ul></div></p>\n\n\n<p>See <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>.<a href=\"#!/api/Ext.layout.AnchorLayout-cfg-anchor\" rel=\"Ext.layout.AnchorLayout-cfg-anchor\" class=\"docClass\">anchor</a> also.</p>\n\n</div></div></div><div id='cfg-anchorOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-anchorOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-anchorOffset' class='name expandable'>anchorOffset</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>A numeric pixel value used to offset the\ndefault position of the anchor arrow (defaults to 0). ...</div><div class='long'><p>A numeric pixel value used to offset the\ndefault position of the anchor arrow (defaults to 0).  When the anchor\nposition is on the top or bottom of the tooltip, <code>anchorOffset</code>\nwill be used as a horizontal offset.  Likewise, when the anchor position\nis on the left or right side, <code>anchorOffset</code> will be used as\na vertical offset.</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='cfg-anchorToTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-anchorToTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-anchorToTarget' class='name expandable'>anchorToTarget</a><span> : Boolean</span></div><div class='description'><div class='short'>True to anchor the tooltip to the target\nelement, false to anchor it relative to the mouse coordinates (defaults\nto t...</div><div class='long'><p>True to anchor the tooltip to the target\nelement, false to anchor it relative to the mouse coordinates (defaults\nto true).  When <code>anchorToTarget</code> is true, use\n<code><a href=\"#!/api/Ext.ToolTip-cfg-defaultAlign\" rel=\"Ext.ToolTip-cfg-defaultAlign\" class=\"docClass\">defaultAlign</a></code> to control tooltip alignment to the\ntarget element.  When <code>anchorToTarget</code> is false, use\n<code>anchorPosition</code> instead to control alignment.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-animCollapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-animCollapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-animCollapse' class='name expandable'>animCollapse</a><span> : Boolean</span></div><div class='description'><div class='short'>true to animate the transition when the panel is collapsed, false to skip the\nanimation (defaults to true if the Ext....</div><div class='long'><p><code>true</code> to animate the transition when the panel is collapsed, <code>false</code> to skip the\nanimation (defaults to <code>true</code> if the <a href=\"#!/api/Ext.Fx\" rel=\"Ext.Fx\" class=\"docClass\">Ext.Fx</a> class is available, otherwise <code>false</code>).</p>\n</div></div></div><div id='cfg-applyTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-applyTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-applyTo' class='name expandable'>applyTo</a><span> : Mixed</span></div><div class='description'><div class='short'>The id of the node, a DOM node or an existing Element corresponding to a DIV that is already present in\nthe document ...</div><div class='long'><p>The id of the node, a DOM node or an existing Element corresponding to a DIV that is already present in\nthe document that specifies some panel-specific structural markup.  When <code>applyTo</code> is used,\nconstituent parts of the panel can be specified by CSS class name within the main element, and the panel\nwill automatically create those components from that markup. Any required components not specified in the\nmarkup will be autogenerated if necessary.</p>\n\n\n<p>The following class names are supported (baseCls will be replaced by <a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a>):</p>\n\n\n<ul><li>baseCls + '-header'</li>\n<li>baseCls + '-header-text'</li>\n<li>baseCls + '-bwrap'</li>\n<li>baseCls + '-tbar'</li>\n<li>baseCls + '-body'</li>\n<li>baseCls + '-bbar'</li>\n<li>baseCls + '-footer'</li></ul>\n\n\n<p>Using this config, a call to render() is not required.  If applyTo is specified, any value passed for\n<a href=\"#!/api/Ext.Panel-cfg-renderTo\" rel=\"Ext.Panel-cfg-renderTo\" class=\"docClass\">renderTo</a> will be ignored and the target element's parent node will automatically be used as the\npanel's container.</p>\n\n<p>Overrides: <a href='#!/api/Ext.Component-cfg-applyTo' rel='Ext.Component-cfg-applyTo' class='docClass'>Ext.Component.applyTo</a></p></div></div></div><div id='cfg-autoDestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-autoDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-autoDestroy' class='name expandable'>autoDestroy</a><span> : Boolean</span></div><div class='description'><div class='short'>If true the container will automatically destroy any contained component that is removed from it, else\ndestruction mu...</div><div class='long'><p>If true the container will automatically destroy any contained component that is removed from it, else\ndestruction must be handled manually (defaults to true).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-autoHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-autoHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-autoHeight' class='name expandable'>autoHeight</a><span> : Boolean</span></div><div class='description'><div class='short'>true to use height:'auto', false to use fixed height (defaults to false). ...</div><div class='long'><p><code>true</code> to use height:'auto', <code>false</code> to use fixed height (defaults to <code>false</code>).\n<b>Note</b>: Setting <code>autoHeight: true</code> means that the browser will manage the panel's height\nbased on its contents, and that Ext will not manage it at all. If the panel is within a layout that\nmanages dimensions (<code>fit</code>, <code>border</code>, etc.) then setting <code>autoHeight: true</code>\ncan cause issues with scrolling and will not generally work as expected since the panel will take\non the height of its contents rather than the height required by the Ext layout.</p>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-cfg-autoHeight' rel='Ext.BoxComponent-cfg-autoHeight' class='docClass'>Ext.BoxComponent.autoHeight</a></p></div></div></div><div id='cfg-autoHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-autoHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-autoHeight' class='name expandable'>autoHeight</a><span> : Boolean</span></div><div class='description'><div class='short'>true to use height:'auto', false to use fixed height (defaults to false). ...</div><div class='long'><p><code>true</code> to use height:'auto', <code>false</code> to use fixed height (defaults to <code>false</code>).\n<b>Note</b>: Setting <code>autoHeight: true</code> means that the browser will manage the panel's height\nbased on its contents, and that Ext will not manage it at all. If the panel is within a layout that\nmanages dimensions (<code>fit</code>, <code>border</code>, etc.) then setting <code>autoHeight: true</code>\ncan cause issues with scrolling and will not generally work as expected since the panel will take\non the height of its contents rather than the height required by the Ext layout.</p>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.Panel-cfg-autoHeight' rel='Ext.Panel-cfg-autoHeight' class='docClass'>Ext.Panel.autoHeight</a></p></div></div></div><div id='cfg-autoHide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-autoHide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-autoHide' class='name expandable'>autoHide</a><span> : Boolean</span></div><div class='description'><div class='short'>True to automatically hide the tooltip after the\nmouse exits the target element or after the dismissDelay\nhas expired...</div><div class='long'><p>True to automatically hide the tooltip after the\nmouse exits the target element or after the <code><a href=\"#!/api/Ext.ToolTip-cfg-dismissDelay\" rel=\"Ext.ToolTip-cfg-dismissDelay\" class=\"docClass\">dismissDelay</a></code>\nhas expired if set (defaults to true).  If <code>closable = true</code>\na close tool button will be rendered into the tooltip header.</p>\n</div></div></div><div id='cfg-autoLoad' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-autoLoad' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-autoLoad' class='name expandable'>autoLoad</a><span> : Object/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>A valid url spec according to the Updater Ext.Updater.update method. ...</div><div class='long'><p>A valid url spec according to the Updater <a href=\"#!/api/Ext.Updater-event-update\" rel=\"Ext.Updater-event-update\" class=\"docClass\">Ext.Updater.update</a> method.\nIf autoLoad is not null, the panel will attempt to load its contents\nimmediately upon render.<p>\nThe URL will become the default URL for this panel's <a href=\"#!/api/Ext.Panel-property-body\" rel=\"Ext.Panel-property-body\" class=\"docClass\">body</a> element,\nso it may be refreshed at any time.</p></p>\n</div></div></div><div id='cfg-autoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoScroll' class='name expandable'>autoScroll</a><span> : Boolean</span></div><div class='description'><div class='short'>true to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, false...</div><div class='long'><p><code>true</code> to use overflow:'auto' on the components layout element and show scroll bars automatically when\nnecessary, <code>false</code> to clip any overflowing content (defaults to <code>false</code>).</p>\n</div></div></div><div id='cfg-autoShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-autoShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-autoShow' class='name expandable'>autoShow</a><span> : Boolean</span></div><div class='description'><div class='short'>True if the component should check for hidden classes (e.g. ...</div><div class='long'><p>True if the component should check for hidden classes (e.g. 'x-hidden' or 'x-hide-display') and remove\nthem on render (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-autoWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-autoWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-autoWidth' class='name expandable'>autoWidth</a><span> : Boolean</span></div><div class='description'><div class='short'>True to use width:'auto', false to use fixed width (or allow it to be managed by its parent\nContainer's layout manager. ...</div><div class='long'><p>True to use width:'auto', false to use fixed width (or allow it to be managed by its parent\nContainer's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>. Defaults to false.</p>\n\n\n<p><b>Note</b>: Although many components  inherit this config option, not all will\nfunction as expected with a width of 'auto'. Setting autoWidth:true means that the\nbrowser will manage width based on the element's contents, and that Ext will not manage it at all.</p>\n\n\n<p>If the <i>browser</i> is managing the width, be aware that resizes performed by the browser in response\nto changes within the structure of the Component cannot be detected. Therefore changes to the width might\nresult in elements needing to be synchronized with the new width. For example, where the target element is:</p>\n\n\n<pre><code>&lt;div id='grid-container' style='margin-left:25%;width:50%'>&lt;/div>\n</code></pre>\n\n\n<p>A Panel rendered into that target element must listen for browser window resize in order to relay its\nchild items when the browser changes its width:</p>\n\n<pre><code>var myPanel = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    renderTo: 'grid-container',\n    monitorResize: true, // relay on browser resize\n    title: 'Panel',\n    height: 400,\n    autoWidth: true,\n    layout: 'hbox',\n    layoutConfig: {\n        align: 'stretch'\n    },\n    defaults: {\n        flex: 1\n    },\n    items: [{\n        title: 'Box 1',\n    }, {\n        title: 'Box 2'\n    }, {\n        title: 'Box 3'\n    }],\n});\n</code></pre>\n\n</div></div></div><div id='cfg-baseCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-baseCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-baseCls' class='name expandable'>baseCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The base CSS class to apply to this panel's element (defaults to 'x-panel'). ...</div><div class='long'><p>The base CSS class to apply to this panel's element (defaults to <code>'x-panel'</code>).</p>\n\n<p>Another option available by default is to specify <code>'x-plain'</code> which strips all styling\nexcept for required attributes for Ext layouts to function (e.g. overflow:hidden).\nSee <code><a href=\"#!/api/Ext.Panel-cfg-unstyled\" rel=\"Ext.Panel-cfg-unstyled\" class=\"docClass\">unstyled</a></code> also.</p>\n\n<p>Defaults to: <code>'x-panel'</code></p></div></div></div><div id='cfg-baseCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-baseCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-baseCls' class='name expandable'>baseCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The base CSS class to apply to this panel's element (defaults to 'x-panel'). ...</div><div class='long'><p>The base CSS class to apply to this panel's element (defaults to <code>'x-panel'</code>).</p>\n\n<p>Another option available by default is to specify <code>'x-plain'</code> which strips all styling\nexcept for required attributes for Ext layouts to function (e.g. overflow:hidden).\nSee <code><a href=\"#!/api/Ext.Tip-cfg-unstyled\" rel=\"Ext.Tip-cfg-unstyled\" class=\"docClass\">unstyled</a></code> also.</p>\n\n<p>Defaults to: <code>'x-tip'</code></p><p>Overrides: <a href='#!/api/Ext.Panel-cfg-baseCls' rel='Ext.Panel-cfg-baseCls' class='docClass'>Ext.Panel.baseCls</a></p></div></div></div><div id='cfg-bbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-bbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-bbar' class='name expandable'>bbar</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>The bottom toolbar of the panel. ...</div><div class='long'><p>The bottom toolbar of the panel. This can be a <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a> object, a toolbar config, or an array of\nbuttons/button configs to be added to the toolbar.  Note that this is not available as a property after render.\nTo access the bottom toolbar after render, use <a href=\"#!/api/Ext.Panel-method-getBottomToolbar\" rel=\"Ext.Panel-method-getBottomToolbar\" class=\"docClass\">getBottomToolbar</a>.</p>\n\n\n<p><b>Note:</b> Although a Toolbar may contain Field components, these will <b>not</b> be updated by a load\nof an ancestor FormPanel. A Panel's toolbars are not part of the standard Container->Component hierarchy, and\nso are not scanned to collect form items. However, the values <b>will</b> be submitted because form\nsubmission parameters are collected from the DOM tree.</p>\n\n</div></div></div><div id='cfg-bbarCfg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-bbarCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-bbarCfg' class='name expandable'>bbarCfg</a><span> : Object</span></div><div class='description'><div class='short'>A DomHelper element specification object specifying the element structure\nof this Panel's bbar Element. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> element specification object specifying the element structure\nof this Panel's <a href=\"#!/api/Ext.Panel-cfg-bbar\" rel=\"Ext.Panel-cfg-bbar\" class=\"docClass\">bbar</a> Element.  See <code><a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a></code> also.</p>\n\n</div></div></div><div id='cfg-bodyBorder' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-bodyBorder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-bodyBorder' class='name expandable'>bodyBorder</a><span> : Boolean</span></div><div class='description'><div class='short'>True to display an interior border on the body element of the panel, false to hide it (defaults to true). ...</div><div class='long'><p>True to display an interior border on the body element of the panel, false to hide it (defaults to true).\nThis only applies when <a href=\"#!/api/Ext.Panel-cfg-border\" rel=\"Ext.Panel-cfg-border\" class=\"docClass\">border</a> == true.  If border == true and bodyBorder == false, the border will display\nas a 1px wide inset border, giving the entire body element an inset appearance.</p>\n</div></div></div><div id='cfg-bodyCfg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-bodyCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-bodyCfg' class='name expandable'>bodyCfg</a><span> : Object</span></div><div class='description'><div class='short'>A DomHelper element specification object may be specified for any\nPanel Element. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> element specification object may be specified for any\nPanel Element.</p>\n\n\n<p>By default, the Default element in the table below will be used for the html markup to\ncreate a child element with the commensurate Default class name (<code>baseCls</code> will be\nreplaced by <code><a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a></code>):</p>\n\n\n<pre>Panel      Default  Default             Custom      Additional       Additional\nElement    element  class               element     class            style\n========   ==========================   =========   ==============   ===========\n<a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a>     div      <a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a>+'-header'   <a href=\"#!/api/Ext.Panel-cfg-headerCfg\" rel=\"Ext.Panel-cfg-headerCfg\" class=\"docClass\">headerCfg</a>   headerCssClass   headerStyle\n<a href=\"#!/api/Ext.Panel-property-bwrap\" rel=\"Ext.Panel-property-bwrap\" class=\"docClass\">bwrap</a>      div      <a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a>+'-bwrap'     <a href=\"#!/api/Ext.Panel-cfg-bwrapCfg\" rel=\"Ext.Panel-cfg-bwrapCfg\" class=\"docClass\">bwrapCfg</a>    bwrapCssClass    bwrapStyle\n+ tbar     div      <a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a>+'-tbar'       <a href=\"#!/api/Ext.Panel-cfg-tbarCfg\" rel=\"Ext.Panel-cfg-tbarCfg\" class=\"docClass\">tbarCfg</a>     tbarCssClass     tbarStyle\n+ <a href=\"#!/api/Ext.Panel-property-body\" rel=\"Ext.Panel-property-body\" class=\"docClass\">body</a>     div      <a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a>+'-body'       <a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a>     <a href=\"#!/api/Ext.Panel-cfg-bodyCssClass\" rel=\"Ext.Panel-cfg-bodyCssClass\" class=\"docClass\">bodyCssClass</a>     <a href=\"#!/api/Ext.Panel-cfg-bodyStyle\" rel=\"Ext.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a>\n+ bbar     div      <a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a>+'-bbar'       <a href=\"#!/api/Ext.Panel-cfg-bbarCfg\" rel=\"Ext.Panel-cfg-bbarCfg\" class=\"docClass\">bbarCfg</a>     bbarCssClass     bbarStyle\n+ <a href=\"#!/api/Ext.Panel-cfg-footer\" rel=\"Ext.Panel-cfg-footer\" class=\"docClass\">footer</a>   div      <a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a>+'-footer'   <a href=\"#!/api/Ext.Panel-cfg-footerCfg\" rel=\"Ext.Panel-cfg-footerCfg\" class=\"docClass\">footerCfg</a>   footerCssClass   footerStyle\n</pre>\n\n\n<p>Configuring a Custom element may be used, for example, to force the <a href=\"#!/api/Ext.Panel-property-body\" rel=\"Ext.Panel-property-body\" class=\"docClass\">body</a> Element\nto use a different form of markup than is created by default. An example of this might be\nto <a href=\"#!/api/Ext.Element-method-createChild\" rel=\"Ext.Element-method-createChild\" class=\"docClass\">create a child</a> Panel containing a custom content, such as\na header, or forcing centering of all Panel content by having the body be a &lt;center&gt;\nelement:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'Message Title',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 200, height: 130,\n    <b>bodyCfg</b>: {\n        tag: 'center',\n        cls: 'x-panel-body',  // Default class not applied if Custom element specified\n        html: 'Message'\n    },\n    footerCfg: {\n        tag: 'h2',\n        cls: 'x-panel-footer',        // same as the Default class\n        html: 'footer html'\n    },\n    footerCssClass: 'custom-footer', // additional css class, see addClass\n    footerStyle:    'background-color:red' // see <a href=\"#!/api/Ext.Panel-cfg-bodyStyle\" rel=\"Ext.Panel-cfg-bodyStyle\" class=\"docClass\">bodyStyle</a>\n});\n</code></pre>\n\n\n<p>The example above also explicitly creates a <code><a href=\"#!/api/Ext.Panel-cfg-footer\" rel=\"Ext.Panel-cfg-footer\" class=\"docClass\">footer</a></code> with custom markup and\nstyling applied.</p>\n\n</div></div></div><div id='cfg-bodyCssClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-bodyCssClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-bodyCssClass' class='name expandable'>bodyCssClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Additional css class selector to be applied to the body element in the format expected by\nExt.Element.addClass (defau...</div><div class='long'><p>Additional css class selector to be applied to the <a href=\"#!/api/Ext.Panel-property-body\" rel=\"Ext.Panel-property-body\" class=\"docClass\">body</a> element in the format expected by\n<a href=\"#!/api/Ext.Element-method-addClass\" rel=\"Ext.Element-method-addClass\" class=\"docClass\">Ext.Element.addClass</a> (defaults to null). See <a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a>.</p>\n</div></div></div><div id='cfg-bodyStyle' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-bodyStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-bodyStyle' class='name expandable'>bodyStyle</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Custom CSS styles to be applied to the body element in the format expected by\nExt.Element.applyStyles (defaults to nu...</div><div class='long'><p>Custom CSS styles to be applied to the <a href=\"#!/api/Ext.Panel-property-body\" rel=\"Ext.Panel-property-body\" class=\"docClass\">body</a> element in the format expected by\n<a href=\"#!/api/Ext.Element-method-applyStyles\" rel=\"Ext.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a> (defaults to null). See <a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a>.</p>\n</div></div></div><div id='cfg-border' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-border' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-border' class='name expandable'>border</a><span> : Boolean</span></div><div class='description'><div class='short'>True to display the borders of the panel's body element, false to hide them (defaults to true). ...</div><div class='long'><p>True to display the borders of the panel's body element, false to hide them (defaults to true).  By default,\nthe border is a 2px wide inset border, but this can be further altered by setting <a href=\"#!/api/Ext.Panel-cfg-bodyBorder\" rel=\"Ext.Panel-cfg-bodyBorder\" class=\"docClass\">bodyBorder</a> to false.</p>\n</div></div></div><div id='cfg-boxMaxHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxHeight' class='name expandable'>boxMaxHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMaxWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMaxWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMaxWidth' class='name expandable'>boxMaxWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The maximum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinHeight' class='name expandable'>boxMinHeight</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its height to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its height to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-boxMinWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-boxMinWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-boxMinWidth' class='name expandable'>boxMinWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum value in pixels which this BoxComponent will set its width to. ...</div><div class='long'><p>The minimum value in pixels which this BoxComponent will set its width to.</p>\n\n\n<p><b>Warning:</b> This will override any size management applied by layout managers.</p>\n\n</div></div></div><div id='cfg-bubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-bubbleEvents' class='name expandable'>bubbleEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should be bubbled to any parent container. ...</div><div class='long'><p>An array of events that, when fired, should be bubbled to any parent container.\nSee <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">Ext.util.Observable.enableBubble</a>.\nDefaults to <code>['add', 'remove']</code>.\n\n</p><p>Defaults to: <code>['add', 'remove']</code></p><p>Overrides: <a href='#!/api/Ext.Component-cfg-bubbleEvents' rel='Ext.Component-cfg-bubbleEvents' class='docClass'>Ext.Component.bubbleEvents</a></p></div></div></div><div id='cfg-bufferResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-bufferResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-bufferResize' class='name expandable'>bufferResize</a><span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>When set to true (50 milliseconds) or a number of milliseconds, the layout assigned for this container will buffer\nth...</div><div class='long'><p>When set to true (50 milliseconds) or a number of milliseconds, the layout assigned for this container will buffer\nthe frequency it calculates and does a re-layout of components. This is useful for heavy containers or containers\nwith a large quantity of sub-components for which frequent layout calls would be expensive. Defaults to <code>50</code>.</p>\n<p>Defaults to: <code>50</code></p></div></div></div><div id='cfg-buttonAlign' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-buttonAlign' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-buttonAlign' class='name expandable'>buttonAlign</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The alignment of any buttons added to this panel. ...</div><div class='long'><p>The alignment of any <a href=\"#!/api/Ext.Panel-property-buttons\" rel=\"Ext.Panel-property-buttons\" class=\"docClass\">buttons</a> added to this panel.  Valid values are <code>'right'</code>,\n<code>'left'</code> and <code>'center'</code> (defaults to <code>'right'</code>).</p>\n<p>Defaults to: <code>'right'</code></p></div></div></div><div id='cfg-buttons' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-buttons' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-buttons' class='name expandable'>buttons</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>buttons will be used as items for the toolbar in\nthe footer (fbar). ...</div><div class='long'><p><code>buttons</code> will be used as <code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> for the toolbar in\nthe footer (<code><a href=\"#!/api/Ext.Panel-cfg-fbar\" rel=\"Ext.Panel-cfg-fbar\" class=\"docClass\">fbar</a></code>). Typically the value of this configuration property will be\nan array of <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>s or <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a> configuration objects.\nIf an item is configured with <code>minWidth</code> or the Panel is configured with <code>minButtonWidth</code>,\nthat width will be applied to the item.</p>\n</div></div></div><div id='cfg-bwrapCfg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-bwrapCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-bwrapCfg' class='name expandable'>bwrapCfg</a><span> : Object</span></div><div class='description'><div class='short'>A DomHelper element specification object specifying the element structure\nof this Panel's bwrap Element. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> element specification object specifying the element structure\nof this Panel's <a href=\"#!/api/Ext.Panel-property-bwrap\" rel=\"Ext.Panel-property-bwrap\" class=\"docClass\">bwrap</a> Element.  See <code><a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a></code> also.</p>\n\n</div></div></div><div id='cfg-clearCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-clearCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-clearCls' class='name expandable'>clearCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide...</div><div class='long'><p>The CSS class used to to apply to the special clearing div rendered\ndirectly after each form field wrapper to provide field clearing (defaults to\n<tt>'x-form-clear-left'</tt>).</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container\n\n\n<p>which has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout\nmanager (e.g. <a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>) and either a\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> is specified or <tt>isFormField=true</tt> is specified.</p><br></p>\n\n<p>See <a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a> also.</p>\n\n</div></div></div><div id='cfg-closable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-closable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-closable' class='name not-expandable'>closable</a><span> : Boolean</span></div><div class='description'><div class='short'><p>True to render a close tool button into the tooltip header (defaults to false).</p>\n</div><div class='long'><p>True to render a close tool button into the tooltip header (defaults to false).</p>\n<p>Overrides: <a href='#!/api/Ext.Panel-cfg-closable' rel='Ext.Panel-cfg-closable' class='docClass'>Ext.Panel.closable</a></p></div></div></div><div id='cfg-cls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-cls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-cls' class='name expandable'>cls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element (defaults to ''). ...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element (defaults to '').  This can be\nuseful for adding customized styles to the component or any of its children using standard CSS rules.</p>\n</div></div></div><div id='cfg-collapseFirst' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-collapseFirst' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-collapseFirst' class='name expandable'>collapseFirst</a><span> : Boolean</span></div><div class='description'><div class='short'>true to make sure the collapse/expand toggle button always renders first (to the left of)\nany other tools in the pane...</div><div class='long'><p><code>true</code> to make sure the collapse/expand toggle button always renders first (to the left of)\nany other tools in the panel's title bar, <code>false</code> to render it last (defaults to <code>true</code>).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-collapsed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-collapsed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-collapsed' class='name expandable'>collapsed</a><span> : Boolean</span></div><div class='description'><div class='short'>true to render the panel collapsed, false to render it expanded (defaults to\nfalse). ...</div><div class='long'><p><code>true</code> to render the panel collapsed, <code>false</code> to render it expanded (defaults to\n<code>false</code>).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-collapsedCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-collapsedCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-collapsedCls' class='name expandable'>collapsedCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A CSS class to add to the panel's element after it has been collapsed (defaults to\n'x-panel-collapsed'). ...</div><div class='long'><p>A CSS class to add to the panel's element after it has been collapsed (defaults to\n<code>'x-panel-collapsed'</code>).</p>\n<p>Defaults to: <code>'x-panel-collapsed'</code></p></div></div></div><div id='cfg-collapsible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-collapsible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-collapsible' class='name expandable'>collapsible</a><span> : Boolean</span></div><div class='description'><div class='short'>True to make the panel collapsible and have the expand/collapse toggle button automatically rendered into\nthe header ...</div><div class='long'><p>True to make the panel collapsible and have the expand/collapse toggle button automatically rendered into\nthe header tool button area, false to keep the panel statically sized with no button (defaults to false).</p>\n</div></div></div><div id='cfg-contentEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-contentEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-contentEl' class='name expandable'>contentEl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. Specify an existing HTML element, or the <code>id</code> of an existing HTML element to use as the content\nfor this component.</p>\n\n\n<ul>\n<li><b>Description</b> :\n<div class=\"sub-desc\">This config option is used to take an existing HTML element and place it in the layout element\nof a new component (it simply moves the specified DOM element <i>after the Component is rendered</i> to use as the content.</div></li>\n<li><b>Notes</b> :\n<div class=\"sub-desc\">The specified HTML element is appended to the layout element of the component <i>after any configured\n<a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">HTML</a> has been inserted</i>, and so the document will not contain this element at the time the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a> event is fired.</div>\n<div class=\"sub-desc\">The specified HTML element used will not participate in any <code><b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></b></code>\nscheme that the Component may use. It is just HTML. Layouts operate on child <code><b><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></b></code>.</div>\n<div class=\"sub-desc\">Add either the <code>x-hidden</code> or the <code>x-hide-display</code> CSS class to\nprevent a brief flicker of the content before it is rendered to the panel.</div></li>\n</ul>\n\n</div></div></div><div id='cfg-ctCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ctCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ctCls' class='name expandable'>ctCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's container. ...</div><div class='long'><p>An optional extra CSS class that will be added to this component's container. This can be useful for\nadding customized styles to the container or any of its children using standard CSS rules.  See\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a>.<a href=\"#!/api/Ext.layout.ContainerLayout-cfg-extraCls\" rel=\"Ext.layout.ContainerLayout-cfg-extraCls\" class=\"docClass\">extraCls</a> also.</p>\n\n\n<p><b>Note</b>: <tt>ctCls</tt> defaults to <tt>''</tt> except for the following class\nwhich assigns a value by default:\n<div class=\"mdetail-params\"><ul>\n<li>Box Layout : <tt>'x-box-layout-ct'</tt></li>\n</ul></div>\nTo configure the above Class with an extra CSS class append to the default.  For example,\nfor BoxLayout (Hbox and Vbox):\n<pre><code>ctCls: 'x-box-layout-ct custom-class'\n</code></pre>\n</p>\n\n</div></div></div><div id='cfg-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-data' class='name not-expandable'>data</a><span> : Mixed</span></div><div class='description'><div class='short'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to\nupdate the content area of the Component.</p>\n</div><div class='long'><p>The initial set of data to apply to the <code><a href=\"#!/api/Ext.Component-cfg-tpl\" rel=\"Ext.Component-cfg-tpl\" class=\"docClass\">tpl</a></code> to\nupdate the content area of the Component.</p>\n</div></div></div><div id='cfg-defaultAlign' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-defaultAlign' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-defaultAlign' class='name expandable'>defaultAlign</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Experimental. ...</div><div class='long'><p><b>Experimental</b>. The default <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">Ext.Element.alignTo</a> anchor position value\nfor this tip relative to its element of origin (defaults to \"tl-bl?\").</p>\n<p>Defaults to: <code>&quot;tl-bl?&quot;</code></p></div></div></div><div id='cfg-defaultType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-defaultType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-defaultType' class='name expandable'>defaultType</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default xtype of child Components to create in this Container when\na child item is specified as a raw configurati...</div><div class='long'><p>The default <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">xtype</a> of child Components to create in this Container when\na child item is specified as a raw configuration object, rather than as an instantiated Component.</p>\n\n\n<p>Defaults to <code>'panel'</code>, except <a href=\"#!/api/Ext.menu.Menu\" rel=\"Ext.menu.Menu\" class=\"docClass\">Ext.menu.Menu</a> which defaults to <code>'menuitem'</code>,\nand <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a> and <a href=\"#!/api/Ext.ButtonGroup\" rel=\"Ext.ButtonGroup\" class=\"docClass\">Ext.ButtonGroup</a> which default to <code>'button'</code>.</p>\n\n<p>Defaults to: <code>'panel'</code></p></div></div></div><div id='cfg-defaults' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-defaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-defaults' class='name expandable'>defaults</a><span> : Object|<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>This option is a means of applying default settings to all added items whether added through the items\nconfig or via ...</div><div class='long'><p>This option is a means of applying default settings to all added items whether added through the <a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a>\nconfig or via the <a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">add</a> or <a href=\"#!/api/Ext.Container-method-insert\" rel=\"Ext.Container-method-insert\" class=\"docClass\">insert</a> methods.</p>\n\n\n<p>If an added item is a config object, and <b>not</b> an instantiated Component, then the default properties are\nunconditionally applied. If the added item <b>is</b> an instantiated Component, then the default properties are\napplied conditionally so as not to override existing properties in the item.</p>\n\n\n<p>If the defaults option is specified as a function, then the function will be called using this Container as the\nscope (<code>this</code> reference) and passing the added item as the first parameter. Any resulting object\nfrom that call is then applied to the item as default properties.</p>\n\n\n<p>For example, to automatically apply padding to the body of each of a set of\ncontained <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a> items, you could pass: <code>defaults: {bodyStyle:'padding:15px'}</code>.</p>\n\n\n<p>Usage:</p>\n\n\n<pre><code>defaults: {               // defaults are applied to items, not the container\n    autoScroll:true\n},\nitems: [\n    {\n        xtype: 'panel',   // defaults <b>do not</b> have precedence over\n        id: 'panel1',     // options in config objects, so the defaults\n        autoScroll: false // will not be applied here, panel1 will be autoScroll:false\n    },\n    new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({       // defaults <b>do</b> have precedence over options\n        id: 'panel2',     // options in components, so the defaults\n        autoScroll: false // will be applied here, panel2 will be autoScroll:true.\n    })\n]\n</code></pre>\n\n</div></div></div><div id='cfg-delegate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-delegate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-delegate' class='name expandable'>delegate</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional. ...</div><div class='long'><p>Optional. A <a href=\"#!/api/Ext.DomQuery\" rel=\"Ext.DomQuery\" class=\"docClass\">DomQuery</a>\nselector which allows selection of individual elements within the\n<code><a href=\"#!/api/Ext.ToolTip-cfg-target\" rel=\"Ext.ToolTip-cfg-target\" class=\"docClass\">target</a></code> element to trigger showing and hiding the\nToolTip as the mouse moves within the target.</p>\n\n\n<p>When specified, the child element of the target which caused a show\nevent is placed into the <code><a href=\"#!/api/Ext.ToolTip-property-triggerElement\" rel=\"Ext.ToolTip-property-triggerElement\" class=\"docClass\">triggerElement</a></code> property\nbefore the ToolTip is shown.</p>\n\n\n<p>This may be useful when a Component has regular, repeating elements\nin it, each of which need a Tooltip which contains information specific\nto that element. For example:</p>\n\n\n<pre><code>var myGrid = new Ext.grid.gridPanel(gridConfig);\nmyGrid.on('render', function(grid) {\n    var store = grid.getStore();  // Capture the Store.\n    var view = grid.getView();    // Capture the GridView.\n    myGrid.tip = new <a href=\"#!/api/Ext.ToolTip\" rel=\"Ext.ToolTip\" class=\"docClass\">Ext.ToolTip</a>({\n        target: view.mainBody,    // The overall target element.\n        delegate: '.x-grid3-row', // Each grid row causes its own seperate show and hide.\n        trackMouse: true,         // Moving within the row should not hide the tip.\n        renderTo: document.body,  // Render immediately so that tip.body can be\n                                  //  referenced prior to the first show.\n        listeners: {              // Change content dynamically depending on which element\n                                  //  triggered the show.\n            beforeshow: function updateTipBody(tip) {\n                var rowIndex = view.findRowIndex(tip.triggerElement);\n                tip.body.dom.innerHTML = 'Over Record ID ' + store.getAt(rowIndex).id;\n            }\n        }\n    });\n});\n</code></pre>\n\n</div></div></div><div id='cfg-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-disabled' class='name expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'>Render this panel disabled (default is false). ...</div><div class='long'><p>Render this panel disabled (default is <code>false</code>). An important note when using the disabled\nconfig on panels is that IE will often fail to initialize the disabled mask element correectly if\nthe panel's layout has not yet completed by the time the Panel is disabled during the render process.\nIf you experience this issue, you may need to instead use the <a href=\"#!/api/Ext.Panel-event-afterlayout\" rel=\"Ext.Panel-event-afterlayout\" class=\"docClass\">afterlayout</a> event to initialize\nthe disabled state:</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    ...\n    listeners: {\n        'afterlayout': {\n            fn: function(p){\n                p.disable();\n            },\n            single: true // important, as many layouts can occur\n        }\n    }\n});\n</code></pre>\n\n<p>Overrides: <a href='#!/api/Ext.Component-cfg-disabled' rel='Ext.Component-cfg-disabled' class='docClass'>Ext.Component.disabled</a></p></div></div></div><div id='cfg-disabledClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-disabledClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-disabledClass' class='name expandable'>disabledClass</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>CSS class added to the component when it is disabled (defaults to 'x-item-disabled'). ...</div><div class='long'><p>CSS class added to the component when it is disabled (defaults to 'x-item-disabled').</p>\n<p>Defaults to: <code>''</code></p><p>Overrides: <a href='#!/api/Ext.Component-cfg-disabledClass' rel='Ext.Component-cfg-disabledClass' class='docClass'>Ext.Component.disabledClass</a></p></div></div></div><div id='cfg-dismissDelay' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-dismissDelay' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-dismissDelay' class='name expandable'>dismissDelay</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Delay in milliseconds before the tooltip\nautomatically hides (defaults to 5000). ...</div><div class='long'><p>Delay in milliseconds before the tooltip\nautomatically hides (defaults to 5000). To disable automatic hiding, set\ndismissDelay = 0.</p>\n<p>Defaults to: <code>5000</code></p></div></div></div><div id='cfg-draggable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-draggable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-draggable' class='name expandable'>draggable</a><span> : Boolean/Object</span></div><div class='description'><div class='short'>true to enable dragging of this Panel (defaults to false). ...</div><div class='long'><p><code>true</code> to enable dragging of this Panel (defaults to <code>false</code>).</p>\n\n\n<p>For custom drag/drop implementations, an <b>Ext.Panel.DD</b> config could also be passed\nin this config instead of <code>true</code>. Ext.Panel.DD is an internal, undocumented class which\nmoves a proxy Element around in place of the Panel's element, but provides no other behaviour\nduring dragging or on drop. It is a subclass of <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a>, so behaviour may be\nadded by implementing the interface methods of <a href=\"#!/api/Ext.dd.DragDrop\" rel=\"Ext.dd.DragDrop\" class=\"docClass\">Ext.dd.DragDrop</a> e.g.:\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'Drag me',\n    x: 100,\n    y: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    floating: true,\n    frame: true,\n    width: 400,\n    height: 200,\n    draggable: {\n//      Config option of Ext.Panel.DD class.\n//      It&#39;s a floating Panel, so do not show a placeholder proxy in the original position.\n        insertProxy: false,\n\n//      Called for each mousemove event while dragging the DD object.\n        onDrag : function(e){\n//          Record the x,y position of the drag proxy so that we can\n//          position the Panel at end of drag.\n            var pel = this.proxy.getEl();\n            this.x = pel.getLeft(true);\n            this.y = pel.getTop(true);\n\n//          Keep the Shadow aligned if there is one.\n            var s = this.panel.getEl().shadow;\n            if (s) {\n                s.realign(this.x, this.y, pel.getWidth(), pel.getHeight());\n            }\n        },\n\n//      Called on the mouseup event.\n        endDrag : function(e){\n            this.panel.setPosition(this.x, this.y);\n        }\n    }\n}).show();\n</code></pre>\n\n</p></div></div></div><div id='cfg-elements' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-elements' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-elements' class='name expandable'>elements</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A comma-delimited list of panel elements to initialize when the panel is rendered. ...</div><div class='long'><p>A comma-delimited list of panel elements to initialize when the panel is rendered.  Normally, this list will be\ngenerated automatically based on the items added to the panel at config time, but sometimes it might be useful to\nmake sure a structural element is rendered even if not specified at config time (for example, you may want\nto add a button or toolbar dynamically after the panel has been rendered).  Adding those elements to this\nlist will allocate the required placeholders in the panel when it is rendered.  Valid values are<div class=\"mdetail-params\"><ul>\n<li><code>header</code></li>\n<li><code>tbar</code> (top bar)</li>\n<li><code>body</code></li>\n<li><code>bbar</code> (bottom bar)</li>\n<li><code>footer</code></li>\n</ul></div>\nDefaults to '<code>body</code>'.</p>\n<p>Defaults to: <code>'body'</code></p></div></div></div><div id='cfg-fbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-fbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-fbar' class='name expandable'>fbar</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>A Toolbar object, a Toolbar config, or an array of\nButtons/Button configs, describing a Toolbar to be rendered into t...</div><div class='long'><p>A <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Toolbar</a> object, a Toolbar config, or an array of\n<a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Button</a>s/<a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Button</a> configs, describing a <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Toolbar</a> to be rendered into this Panel's footer element.</p>\n\n\n<p>After render, the <code>fbar</code> property will be an <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Toolbar</a> instance.</p>\n\n\n<p>If <code><a href=\"#!/api/Ext.Panel-property-buttons\" rel=\"Ext.Panel-property-buttons\" class=\"docClass\">buttons</a></code> are specified, they will supersede the <code>fbar</code> configuration property.</p>\n\n\n<p>The Panel's <code><a href=\"#!/api/Ext.Panel-cfg-buttonAlign\" rel=\"Ext.Panel-cfg-buttonAlign\" class=\"docClass\">buttonAlign</a></code> configuration affects the layout of these items, for example:</p>\n\n<pre><code>var w = new <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>({\n    height: 250,\n    width: 500,\n    bbar: new <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a>({\n        items: [{\n            text: 'bbar Left'\n        },'->',{\n            text: 'bbar Right'\n        }]\n    }),\n    <a href=\"#!/api/Ext.Panel-cfg-buttonAlign\" rel=\"Ext.Panel-cfg-buttonAlign\" class=\"docClass\">buttonAlign</a>: 'left', // anything but 'center' or 'right' and you can use '-', and '->'\n                                  // to control the alignment of fbar items\n    fbar: [{\n        text: 'fbar Left'\n    },'->',{\n        text: 'fbar Right'\n    }]\n}).show();\n</code></pre>\n\n\n<p><b>Note:</b> Although a Toolbar may contain Field components, these will <b>not</b> be updated by a load\nof an ancestor FormPanel. A Panel's toolbars are not part of the standard Container->Component hierarchy, and\nso are not scanned to collect form items. However, the values <b>will</b> be submitted because form\nsubmission parameters are collected from the DOM tree.</p>\n\n</div></div></div><div id='cfg-fieldLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-fieldLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-fieldLabel' class='name expandable'>fieldLabel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The label text to display next to this Component (defaults to ''). ...</div><div class='long'><p>The label text to display next to this Component (defaults to '').</p>\n\n\n<br><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\n\n\n<p>has been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p><br></p>\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-flex' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-flex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-flex' class='name expandable'>flex</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered\nby a Container which has been configured to use a BoxL...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered\nby a Container which has been configured to use a <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a>.</b>\nEach child Component with a <code>flex</code> property will be flexed either vertically (by a VBoxLayout)\nor horizontally (by an HBoxLayout) according to the item's <b>relative</b> <code>flex</code> value\ncompared to the sum of all Components with <code>flex</code> value specified. Any child items that have\neither a <code>flex = 0</code> or <code>flex = undefined</code> will not be 'flexed' (the initial size will not be changed).\n\n</p></div></div></div><div id='cfg-floating' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-floating' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-floating' class='name expandable'>floating</a><span> : Mixed</span></div><div class='description'><div class='short'>This property is used to configure the underlying Ext.Layer. ...</div><div class='long'><p>This property is used to configure the underlying <a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">Ext.Layer</a>. Acceptable values for this\nconfiguration property are:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><b><code>false</code></b> : <b>Default.</b><div class=\"sub-desc\">Display the panel inline where it is\nrendered.</div></li>\n<li><b><code>true</code></b> : <div class=\"sub-desc\">Float the panel (absolute position it with automatic\nshimming and shadow).<ul>\n<div class=\"sub-desc\">Setting floating to true will create an <a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">Ext.Layer</a> for this panel and display the\npanel at negative offsets so that it is hidden.</div>\n<div class=\"sub-desc\">Since the panel will be absolute positioned, the position must be set explicitly\n<i>after</i> render (e.g., <code>myPanel.setPosition(100,100);</code>).</div>\n<div class=\"sub-desc\"><b>Note</b>: when floating a panel you should always assign a fixed width,\notherwise it will be auto width and will expand to fill to the right edge of the viewport.</div>\n</ul></div></li>\n<li><b><code><a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">object</a></code></b> : <div class=\"sub-desc\">The specified object will be used\nas the configuration object for the <a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">Ext.Layer</a> that will be created.</div></li>\n</ul></div>\n\n</div></div></div><div id='cfg-floating' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-floating' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-floating' class='name expandable'>floating</a><span> : Mixed</span></div><div class='description'><div class='short'>This property is used to configure the underlying Ext.Layer. ...</div><div class='long'><p>This property is used to configure the underlying <a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">Ext.Layer</a>. Acceptable values for this\nconfiguration property are:</p>\n\n\n<div class=\"mdetail-params\"><ul>\n<li><b><code>false</code></b> : <b>Default.</b><div class=\"sub-desc\">Display the panel inline where it is\nrendered.</div></li>\n<li><b><code>true</code></b> : <div class=\"sub-desc\">Float the panel (absolute position it with automatic\nshimming and shadow).<ul>\n<div class=\"sub-desc\">Setting floating to true will create an <a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">Ext.Layer</a> for this panel and display the\npanel at negative offsets so that it is hidden.</div>\n<div class=\"sub-desc\">Since the panel will be absolute positioned, the position must be set explicitly\n<i>after</i> render (e.g., <code>myPanel.setPosition(100,100);</code>).</div>\n<div class=\"sub-desc\"><b>Note</b>: when floating a panel you should always assign a fixed width,\notherwise it will be auto width and will expand to fill to the right edge of the viewport.</div>\n</ul></div></li>\n<li><b><code><a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">object</a></code></b> : <div class=\"sub-desc\">The specified object will be used\nas the configuration object for the <a href=\"#!/api/Ext.Layer\" rel=\"Ext.Layer\" class=\"docClass\">Ext.Layer</a> that will be created.</div></li>\n</ul></div>\n\n<p>Defaults to: <code>{shadow: true, shim: true, useDisplay: true, constrain: false}</code></p><p>Overrides: <a href='#!/api/Ext.Panel-cfg-floating' rel='Ext.Panel-cfg-floating' class='docClass'>Ext.Panel.floating</a></p></div></div></div><div id='cfg-footer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-footer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-footer' class='name expandable'>footer</a><span> : Boolean</span></div><div class='description'><div class='short'>true to create the footer element explicitly, false to skip creating it. ...</div><div class='long'><p><code>true</code> to create the footer element explicitly, false to skip creating it. The footer\nwill be created automatically if <code><a href=\"#!/api/Ext.Panel-property-buttons\" rel=\"Ext.Panel-property-buttons\" class=\"docClass\">buttons</a></code> or a <code><a href=\"#!/api/Ext.Panel-cfg-fbar\" rel=\"Ext.Panel-cfg-fbar\" class=\"docClass\">fbar</a></code> have\nbeen configured.  See <code><a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a></code> for an example.</p>\n</div></div></div><div id='cfg-footerCfg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-footerCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-footerCfg' class='name expandable'>footerCfg</a><span> : Object</span></div><div class='description'><div class='short'>A DomHelper element specification object specifying the element structure\nof this Panel's footer Element. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> element specification object specifying the element structure\nof this Panel's <a href=\"#!/api/Ext.Panel-cfg-footer\" rel=\"Ext.Panel-cfg-footer\" class=\"docClass\">footer</a> Element.  See <code><a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a></code> also.</p>\n\n</div></div></div><div id='cfg-forceLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-forceLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-forceLayout' class='name expandable'>forceLayout</a><span> : Boolean</span></div><div class='description'><div class='short'>If true the container will force a layout initially even if hidden or collapsed. ...</div><div class='long'><p>If true the container will force a layout initially even if hidden or collapsed. This option\nis useful for forcing forms to render in collapsed or hidden containers. (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-frame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-frame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-frame' class='name expandable'>frame</a><span> : Boolean</span></div><div class='description'><div class='short'>private panel overrides\n\nfalse by default to render with plain 1px square borders. ...</div><div class='long'><p>private panel overrides</p>\n\n<p><code>false</code> by default to render with plain 1px square borders. <code>true</code> to render with\n9 elements, complete with custom rounded corners (also see <a href=\"#!/api/Ext.Element-method-boxWrap\" rel=\"Ext.Element-method-boxWrap\" class=\"docClass\">Ext.Element.boxWrap</a>).</p>\n\n<p>The template generated for each condition is depicted below:</p>\n\n\n<pre><code>\n// frame = false\n&lt;div id=\"developer-specified-id-goes-here\" class=\"x-panel\">\n\n    &lt;div class=\"x-panel-header\">&lt;span class=\"x-panel-header-text\">Title: (frame:false)&lt;/span>&lt;/div>\n\n    &lt;div class=\"x-panel-bwrap\">\n        &lt;div class=\"x-panel-body\">&lt;p>html value goes here&lt;/p>&lt;/div>\n    &lt;/div>\n&lt;/div>\n\n// frame = true (create 9 elements)\n&lt;div id=\"developer-specified-id-goes-here\" class=\"x-panel\">\n    &lt;div class=\"x-panel-tl\">&lt;div class=\"x-panel-tr\">&lt;div class=\"x-panel-tc\">\n        &lt;div class=\"x-panel-header\">&lt;span class=\"x-panel-header-text\">Title: (frame:true)&lt;/span>&lt;/div>\n    &lt;/div>&lt;/div>&lt;/div>\n\n    &lt;div class=\"x-panel-bwrap\">\n        &lt;div class=\"x-panel-ml\">&lt;div class=\"x-panel-mr\">&lt;div class=\"x-panel-mc\">\n            &lt;div class=\"x-panel-body\">&lt;p>html value goes here&lt;/p>&lt;/div>\n        &lt;/div>&lt;/div>&lt;/div>\n\n        &lt;div class=\"x-panel-bl\">&lt;div class=\"x-panel-br\">&lt;div class=\"x-panel-bc\"/>\n        &lt;/div>&lt;/div>&lt;/div>\n&lt;/div>\n</code></pre>\n\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.Panel-cfg-frame' rel='Ext.Panel-cfg-frame' class='docClass'>Ext.Panel.frame</a></p></div></div></div><div id='cfg-frame' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-frame' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-frame' class='name expandable'>frame</a><span> : Boolean</span></div><div class='description'><div class='short'>false by default to render with plain 1px square borders. ...</div><div class='long'><p><code>false</code> by default to render with plain 1px square borders. <code>true</code> to render with\n9 elements, complete with custom rounded corners (also see <a href=\"#!/api/Ext.Element-method-boxWrap\" rel=\"Ext.Element-method-boxWrap\" class=\"docClass\">Ext.Element.boxWrap</a>).</p>\n\n<p>The template generated for each condition is depicted below:</p>\n\n\n<pre><code>\n// frame = false\n&lt;div id=\"developer-specified-id-goes-here\" class=\"x-panel\">\n\n    &lt;div class=\"x-panel-header\">&lt;span class=\"x-panel-header-text\">Title: (frame:false)&lt;/span>&lt;/div>\n\n    &lt;div class=\"x-panel-bwrap\">\n        &lt;div class=\"x-panel-body\">&lt;p>html value goes here&lt;/p>&lt;/div>\n    &lt;/div>\n&lt;/div>\n\n// frame = true (create 9 elements)\n&lt;div id=\"developer-specified-id-goes-here\" class=\"x-panel\">\n    &lt;div class=\"x-panel-tl\">&lt;div class=\"x-panel-tr\">&lt;div class=\"x-panel-tc\">\n        &lt;div class=\"x-panel-header\">&lt;span class=\"x-panel-header-text\">Title: (frame:true)&lt;/span>&lt;/div>\n    &lt;/div>&lt;/div>&lt;/div>\n\n    &lt;div class=\"x-panel-bwrap\">\n        &lt;div class=\"x-panel-ml\">&lt;div class=\"x-panel-mr\">&lt;div class=\"x-panel-mc\">\n            &lt;div class=\"x-panel-body\">&lt;p>html value goes here&lt;/p>&lt;/div>\n        &lt;/div>&lt;/div>&lt;/div>\n\n        &lt;div class=\"x-panel-bl\">&lt;div class=\"x-panel-br\">&lt;div class=\"x-panel-bc\"/>\n        &lt;/div>&lt;/div>&lt;/div>\n&lt;/div>\n</code></pre>\n\n</div></div></div><div id='cfg-header' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-header' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-header' class='name expandable'>header</a><span> : Boolean</span></div><div class='description'><div class='short'>true to create the Panel's header element explicitly, false to skip creating\nit. ...</div><div class='long'><p><code>true</code> to create the Panel's header element explicitly, <code>false</code> to skip creating\nit.  If a <code><a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a></code> is set the header will be created automatically, otherwise it will not.\nIf a <code><a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a></code> is set but <code>header</code> is explicitly set to <code>false</code>, the header\nwill not be rendered.</p>\n</div></div></div><div id='cfg-headerAsText' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-headerAsText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-headerAsText' class='name expandable'>headerAsText</a><span> : Boolean</span></div><div class='description'><div class='short'>true to display the panel title in the header,\nfalse to hide it (defaults to true). ...</div><div class='long'><p><code>true</code> to display the panel <code><a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a></code> in the <code><a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a></code>,\n<code>false</code> to hide it (defaults to <code>true</code>).</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-headerCfg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-headerCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-headerCfg' class='name expandable'>headerCfg</a><span> : Object</span></div><div class='description'><div class='short'>A DomHelper element specification object specifying the element structure\nof this Panel's header Element. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> element specification object specifying the element structure\nof this Panel's <a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a> Element.  See <code><a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a></code> also.</p>\n\n</div></div></div><div id='cfg-height' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-height' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-height' class='name expandable'>height</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The height of this component in pixels (defaults to auto). ...</div><div class='long'><p>The height of this component in pixels (defaults to auto).\n<b>Note</b> to express this dimension as a percentage or offset see Ext.Component.anchor.</p>\n</div></div></div><div id='cfg-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>Render this component hidden (default is false). ...</div><div class='long'><p>Render this component hidden (default is false). If <tt>true</tt>, the\n<a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method will be called internally.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-hideBorders' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-hideBorders' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-hideBorders' class='name expandable'>hideBorders</a><span> : Boolean</span></div><div class='description'><div class='short'>True to hide the borders of each contained component, false to defer to the component's existing\nborder settings (def...</div><div class='long'><p>True to hide the borders of each contained component, false to defer to the component's existing\nborder settings (defaults to false).</p>\n</div></div></div><div id='cfg-hideCollapseTool' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-hideCollapseTool' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-hideCollapseTool' class='name not-expandable'>hideCollapseTool</a><span> : Boolean</span></div><div class='description'><div class='short'><p><code>true</code> to hide the expand/collapse toggle button when <code><a href=\"#!/api/Ext.Panel-cfg-collapsible\" rel=\"Ext.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> == true</code>,\n<code>false</code> to display it (defaults to <code>false</code>).</p>\n</div><div class='long'><p><code>true</code> to hide the expand/collapse toggle button when <code><a href=\"#!/api/Ext.Panel-cfg-collapsible\" rel=\"Ext.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> == true</code>,\n<code>false</code> to display it (defaults to <code>false</code>).</p>\n</div></div></div><div id='cfg-hideDelay' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-hideDelay' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-hideDelay' class='name expandable'>hideDelay</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Delay in milliseconds after the mouse exits the\ntarget element but before the tooltip actually hides (defaults to 200). ...</div><div class='long'><p>Delay in milliseconds after the mouse exits the\ntarget element but before the tooltip actually hides (defaults to 200).\nSet to 0 for the tooltip to hide immediately.</p>\n<p>Defaults to: <code>200</code></p></div></div></div><div id='cfg-hideLabel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideLabel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideLabel' class='name expandable'>hideLabel</a><span> : Boolean</span></div><div class='description'><div class='short'>true to completely hide the label element\n(label and separator). ...</div><div class='long'><p><tt>true</tt> to completely hide the label element\n(<a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">label</a> and <a href=\"#!/api/Ext.Component-cfg-labelSeparator\" rel=\"Ext.Component-cfg-labelSeparator\" class=\"docClass\">separator</a>). Defaults to <tt>false</tt>.\nBy default, even if you do not specify a <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt> the space will still be\nreserved so that the field will line up with other fields that do have labels.\nSetting this to <tt>true</tt> will cause the field to not reserve that space.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield'\n        hideLabel: true\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-hideMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideMode' class='name expandable'>hideMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>How this component should be hidden. ...</div><div class='long'><p>How this component should be hidden. Supported values are <tt>'visibility'</tt>\n(css visibility), <tt>'offsets'</tt> (negative offset position) and <tt>'display'</tt>\n(css display).</p>\n\n\n<br><p><b>Note</b>: the default of <tt>'display'</tt> is generally preferred\n\n\n<p>since items are automatically laid out when they are first shown (no sizing\nis done while hidden).</p></p>\n<p>Defaults to: <code>'display'</code></p></div></div></div><div id='cfg-hideParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-hideParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-hideParent' class='name expandable'>hideParent</a><span> : Boolean</span></div><div class='description'><div class='short'>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the...</div><div class='long'><p>True to hide and show the component's container when hide/show is called on the component, false to hide\nand show the component itself (defaults to false).  For example, this can be used as a shortcut for a hide\nbutton on a window by setting hide:true on the button when adding it to its parent container.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-html' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-html' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-html' class='name expandable'>html</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span></div><div class='description'><div class='short'>An HTML fragment, or a DomHelper specification to use as the layout element\ncontent (defaults to ''). ...</div><div class='long'><p>An HTML fragment, or a <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> specification to use as the layout element\ncontent (defaults to ''). The HTML content is added after the component is rendered,\nso the document will not contain this HTML at the time the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a> event is fired.\nThis content is inserted into the body <i>before</i> any configured <a href=\"#!/api/Ext.Component-cfg-contentEl\" rel=\"Ext.Component-cfg-contentEl\" class=\"docClass\">contentEl</a> is appended.</p>\n</div></div></div><div id='cfg-iconCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-iconCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-iconCls' class='name expandable'>iconCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The CSS class selector that specifies a background image to be used as the header icon (defaults to ''). ...</div><div class='long'><p>The CSS class selector that specifies a background image to be used as the header icon (defaults to '').</p>\n\n<p>An example of specifying a custom icon class would be something like:\n</p>\n\n\n<pre><code>// specify the property in the config for the class:\n     ...\n     iconCls: 'my-icon'\n\n// css class that specifies background image to be used as the icon image:\n.my-icon { background-image: url(../images/my-icon.gif) 0 6px no-repeat !important; }\n</code></pre>\n\n</div></div></div><div id='cfg-id' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id of this component (defaults to an auto-assigned id). ...</div><div class='long'><p>The <b>unique</b> id of this component (defaults to an <a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">auto-assigned id</a>).\nYou should assign an id if you need to be able to access the component later and you do\nnot have an object reference available (e.g., using <a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>).</p>\n\n\n<p>Note that this id will also be used as the element id for the containing HTML element\nthat is rendered to the page for this component. This allows you to write id-based CSS\nrules to style the specific instance of this component uniquely, and also to select\nsub-elements using this component's id as the parent.</p>\n\n\n<p><b>Note</b>: to avoid complications imposed by a unique <tt>id</tt> also see\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n</div></div></div><div id='cfg-interceptTitles' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-cfg-interceptTitles' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-cfg-interceptTitles' class='name expandable'>interceptTitles</a><span> : Boolean</span></div><div class='description'><div class='short'>True to automatically use the element's DOM title value if available (defaults to false). ...</div><div class='long'><p>True to automatically use the element's DOM title value if available (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-itemCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemCls' class='name expandable'>itemCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this Component is rendered by a Container which\nhas been configured to use the Fo...</div><div class='long'><p><b>Note</b>: this config is only used when this Component is rendered by a Container which\nhas been configured to use the <b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">FormLayout</a></b> layout manager (e.g.\n<a href=\"#!/api/Ext.form.FormPanel\" rel=\"Ext.form.FormPanel\" class=\"docClass\">Ext.form.FormPanel</a> or specifying <tt>layout:'form'</tt>).</p>\n\n\n<br>\n\n\n<p>An additional CSS class to apply to the div wrapping the form item\nelement of this field.  If supplied, <tt>itemCls</tt> at the <b>field</b> level will override\nthe default <tt>itemCls</tt> supplied at the <b>container</b> level. The value specified for\n<tt>itemCls</tt> will be added to the default class (<tt>'x-form-item'</tt>).</p>\n\n\n<p>Since it is applied to the item wrapper (see\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>), it allows\nyou to write standard CSS rules that can apply to the field, the label (if specified), or\nany other element within the markup for the field.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.</p><br>\n\n\n<p>Example use:</p>\n\n<pre><code>// Apply a style to the field&#39;s label:\n&lt;style>\n    .required .x-form-item-label {font-weight:bold;color:red;}\n&lt;/style>\n\nnew Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        itemCls: 'required' //this label will be styled\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Favorite Color'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-itemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-itemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-itemId' class='name expandable'>itemId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An itemId can be used as an alternative way to get a reference to a component\nwhen no object reference is available. ...</div><div class='long'><p>An <tt>itemId</tt> can be used as an alternative way to get a reference to a component\nwhen no object reference is available.  Instead of using an <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> with\n<a href=\"#!/api/Ext\" rel=\"Ext\" class=\"docClass\">Ext</a>.<a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">getCmp</a>, use <code>itemId</code> with\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a> which will retrieve\n<code>itemId</code>'s or <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt>'s. Since <code>itemId</code>'s are an index to the\ncontainer's internal MixedCollection, the <code>itemId</code> is scoped locally to the container --\navoiding potential conflicts with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a> which requires a <b>unique</b>\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({ //\n    <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 300,\n    <a href=\"#!/api/Ext.Component-cfg-renderTo\" rel=\"Ext.Component-cfg-renderTo\" class=\"docClass\">renderTo</a>: document.body,\n    <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a>: 'auto',\n    <a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a>: [\n        {\n            itemId: 'p1',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 1',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        },\n        {\n            itemId: 'p2',\n            <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a>: 'Panel 2',\n            <a href=\"#!/api/Ext.BoxComponent-cfg-height\" rel=\"Ext.BoxComponent-cfg-height\" class=\"docClass\">height</a>: 150\n        }\n    ]\n})\np1 = c.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p1'); // not the same as <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp()</a>\np2 = p1.<a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a>.<a href=\"#!/api/Ext.Container-method-getComponent\" rel=\"Ext.Container-method-getComponent\" class=\"docClass\">getComponent</a>('p2'); // reference via a sibling\n</code></pre>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></tt> and <code><a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a></code>.</p>\n\n\n<p><b>Note</b>: to access the container of an item see <tt><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></tt>.</p>\n\n</div></div></div><div id='cfg-items' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-items' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-items' class='name expandable'>items</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>** IMPORTANT: be sure to specify a &lt;code&gt;layout&lt;/code&gt; if needed ! **\n\n\nA single item, or an array of chi...</div><div class='long'><pre><b>** IMPORTANT</b>: be sure to <b><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">specify a &lt;code&gt;layout&lt;/code&gt;</a> if needed ! **</b></pre>\n\n\n<p>A single item, or an array of child Components to be added to this container,\nfor example:</p>\n\n\n<pre><code>// specifying a single item\nitems: {...},\nlayout: 'fit',    // specify a layout!\n\n// specifying multiple items\nitems: [{...}, {...}],\nlayout: 'anchor', // specify a layout!\n</code></pre>\n\n\n<p>Each item may be:</p>\n\n\n<div><ul class=\"mdetail-params\">\n<li>any type of object based on <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></li>\n<li>a fully instanciated object or</li>\n<li>an object literal that:</li>\n<div><ul class=\"mdetail-params\">\n<li>has a specified <code><a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">xtype</a></code></li>\n<li>the <a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">Ext.Component.xtype</a> specified is associated with the Component\ndesired and should be chosen from one of the available xtypes as listed\nin <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</li>\n<li>If an <code><a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">xtype</a></code> is not explicitly\nspecified, the <a href=\"#!/api/Ext.Container-cfg-defaultType\" rel=\"Ext.Container-cfg-defaultType\" class=\"docClass\">defaultType</a> for that Container is used.</li>\n<li>will be \"lazily instanciated\", avoiding the overhead of constructing a fully\ninstanciated Component object</li>\n</ul></div></ul></div>\n\n\n<p><b>Notes</b>:</p>\n\n\n<div><ul class=\"mdetail-params\">\n<li>Ext uses lazy rendering. Child Components will only be rendered\nshould it become necessary. Items are automatically laid out when they are first\nshown (no sizing is done while hidden), or in response to a <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> call.</li>\n<li>Do not specify <code><a href=\"#!/api/Ext.Panel-cfg-contentEl\" rel=\"Ext.Panel-cfg-contentEl\" class=\"docClass\">contentEl</a></code>/\n<code><a href=\"#!/api/Ext.Panel-cfg-html\" rel=\"Ext.Panel-cfg-html\" class=\"docClass\">html</a></code> with <code>items</code>.</li>\n</ul></div>\n\n</div></div></div><div id='cfg-keys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-keys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-keys' class='name expandable'>keys</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>A Ext.KeyMap config object (in the format expected by Ext.KeyMap.addBinding\nused to assign custom key handling to thi...</div><div class='long'><p>A <a href=\"#!/api/Ext.KeyMap\" rel=\"Ext.KeyMap\" class=\"docClass\">Ext.KeyMap</a> config object (in the format expected by <a href=\"#!/api/Ext.KeyMap-method-addBinding\" rel=\"Ext.KeyMap-method-addBinding\" class=\"docClass\">Ext.KeyMap.addBinding</a>\nused to assign custom key handling to this panel (defaults to <code>null</code>).</p>\n</div></div></div><div id='cfg-labelSeparator' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelSeparator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelSeparator' class='name expandable'>labelSeparator</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The separator to display after the text of each\nfieldLabel. ...</div><div class='long'><p>The separator to display after the text of each\n<tt><a href=\"#!/api/Ext.Component-cfg-fieldLabel\" rel=\"Ext.Component-cfg-fieldLabel\" class=\"docClass\">fieldLabel</a></tt>.  This property may be configured at various levels.\nThe order of precedence is:\n<div class=\"mdetail-params\"><ul>\n<li>field / component level</li>\n<li>container level</li>\n<li><a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">layout level</a> (defaults to colon <tt>':'</tt>)</li>\n</ul></div>\nTo display no separator for this field's label specify empty string ''.</p>\n\n\n<br><p><b>Note</b>: see the note for <tt><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></tt>.</p><br>\n\n\n<p>Also see <tt><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></tt> and\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    layoutConfig: {\n        labelSeparator: '~'   // layout config has lowest priority (defaults to ':')\n    },\n    <a href=\"#!/api/Ext.layout.FormLayout-cfg-labelSeparator\" rel=\"Ext.layout.FormLayout-cfg-labelSeparator\" class=\"docClass\">labelSeparator</a>: '>>',     // config at container level\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Field 1',\n        labelSeparator: '...' // field/component level config supersedes others\n    },{\n        xtype: 'textfield',\n        fieldLabel: 'Field 2' // labelSeparator will be '='\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-labelStyle' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-labelStyle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-labelStyle' class='name expandable'>labelStyle</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A CSS style specification string to apply directly to this field's\nlabel. ...</div><div class='long'><p>A CSS style specification string to apply directly to this field's\nlabel.  Defaults to the container's labelStyle value if set (e.g.,\n<tt><a href=\"#!/api/Ext.layout.FormLayout-property-labelStyle\" rel=\"Ext.layout.FormLayout-property-labelStyle\" class=\"docClass\">Ext.layout.FormLayout.labelStyle</a></tt> , or '').</p>\n\n\n<br><p><b>Note</b>: see the note for <code><a href=\"#!/api/Ext.Component-cfg-clearCls\" rel=\"Ext.Component-cfg-clearCls\" class=\"docClass\">clearCls</a></code>.</p><br>\n\n\n<p>Also see <code><a href=\"#!/api/Ext.Component-cfg-hideLabel\" rel=\"Ext.Component-cfg-hideLabel\" class=\"docClass\">hideLabel</a></code> and\n<code><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>.<a href=\"#!/api/Ext.layout.FormLayout-property-fieldTpl\" rel=\"Ext.layout.FormLayout-property-fieldTpl\" class=\"docClass\">fieldTpl</a>.</code></p>\n\n\n<p>Example use:</p>\n\n<pre><code>new Ext.FormPanel({\n    height: 100,\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    items: [{\n        xtype: 'textfield',\n        fieldLabel: 'Name',\n        labelStyle: 'font-weight:bold;'\n    }]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-layout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-layout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-layout' class='name expandable'>layout</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object</span></div><div class='description'><div class='short'>*Important: In order for child items to be correctly sized and\npositioned, typically a layout manager must be specifi...</div><div class='long'><p><b>*Important</b>: In order for child items to be correctly sized and\npositioned, typically a layout manager <b>must</b> be specified through\nthe <code>layout</code> configuration option.</p>\n\n\n<br><p>The sizing and positioning of child items is the responsibility of\n\n\n<p>the Container's layout manager which creates and manages the type of layout\nyou have in mind.  For example:</p></p>\n\n<pre><code>new <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>({\n    width:300, height: 300,\n    layout: 'fit', // explicitly set layout manager: override the default (layout:'auto')\n    items: [{\n        title: 'Panel inside a Window'\n    }]\n}).show();\n</code></pre>\n\n\n<p>If the <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> configuration is not explicitly specified for\na general purpose container (e.g. Container or Panel) the\n<a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">default layout manager</a> will be used\nwhich does nothing but render child components sequentially into the\nContainer (no sizing or positioning will be performed in this situation).\nSome container classes implicitly specify a default layout\n(e.g. FormPanel specifies <code>layout:'form'</code>). Other specific\npurpose classes internally specify/manage their internal layout (e.g.\nGridPanel, TabPanel, TreePanel, Toolbar, Menu, etc.).</p>\n\n\n<br><p><b><code>layout</code></b> may be specified as either as an Object or\n\n\n<p>as a String:</p><div><ul class=\"mdetail-params\"></p>\n\n<p><li><u>Specify as an Object</u></li></p>\n\n<div><ul class=\"mdetail-params\">\n<li>Example usage:</li>\n<pre><code>layout: {\n    type: 'vbox',\n    padding: '5',\n    align: 'left'\n}\n</code></pre>\n\n<li><code><b>type</b></code></li>\n<br/><p>The layout type to be used for this container.  If not specified,\na default <a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a> will be created and used.</p>\n<br/><p>Valid layout <code>type</code> values are:</p>\n<div class=\"sub-desc\"><ul class=\"mdetail-params\">\n<li><code><b><a href=\"#!/api/Ext.layout.AbsoluteLayout\" rel=\"Ext.layout.AbsoluteLayout\" class=\"docClass\">absolute</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.AccordionLayout\" rel=\"Ext.layout.AccordionLayout\" class=\"docClass\">accordion</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">anchor</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">auto</a></b></code> &nbsp;&nbsp;&nbsp; <b>Default</b></li>\n<li><code><b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">border</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">card</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.ColumnLayout\" rel=\"Ext.layout.ColumnLayout\" class=\"docClass\">column</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.FitLayout\" rel=\"Ext.layout.FitLayout\" class=\"docClass\">fit</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">form</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.HBoxLayout\" rel=\"Ext.layout.HBoxLayout\" class=\"docClass\">hbox</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.MenuLayout\" rel=\"Ext.layout.MenuLayout\" class=\"docClass\">menu</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.TableLayout\" rel=\"Ext.layout.TableLayout\" class=\"docClass\">table</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.ToolbarLayout\" rel=\"Ext.layout.ToolbarLayout\" class=\"docClass\">toolbar</a></b></code></li>\n<li><code><b><a href=\"#!/api/Ext.layout.VBoxLayout\" rel=\"Ext.layout.VBoxLayout\" class=\"docClass\">vbox</a></b></code></li>\n</ul></div>\n\n<li>Layout specific configuration properties</li>\n<br/><p>Additional layout specific configuration properties may also be\nspecified. For complete details regarding the valid config options for\neach layout type, see the layout class corresponding to the <code>type</code>\nspecified.</p>\n\n</ul></div>\n\n\n<p><li><u>Specify as a String</u></li></p>\n\n<div><ul class=\"mdetail-params\">\n<li>Example usage:</li>\n<pre><code>layout: 'vbox',\nlayoutConfig: {\n    padding: '5',\n    align: 'left'\n}\n</code></pre>\n<li><code><b>layout</b></code></li>\n<br/><p>The layout <code>type</code> to be used for this container (see list\nof valid layout type values above).</p><br/>\n<li><code><b><a href=\"#!/api/Ext.Container-cfg-layoutConfig\" rel=\"Ext.Container-cfg-layoutConfig\" class=\"docClass\">layoutConfig</a></b></code></li>\n<br/><p>Additional layout specific configuration properties. For complete\ndetails regarding the valid config options for each layout type, see the\nlayout class corresponding to the <code>layout</code> specified.</p>\n</ul></div>\n\n\n<p></ul></div></p>\n</div></div></div><div id='cfg-layoutConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-layoutConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-layoutConfig' class='name not-expandable'>layoutConfig</a><span> : Object</span></div><div class='description'><div class='short'><p>This is a config object containing properties specific to the chosen\n<b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b> if <b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b>\nhas been specified as a <i>string</i>.</p></p>\n</div><div class='long'><p>This is a config object containing properties specific to the chosen\n<b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b> if <b><code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code></b>\nhas been specified as a <i>string</i>.</p></p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div><div id='cfg-margins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-margins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-margins' class='name expandable'>margins</a><span> : Object</span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nor one of the two <b><a href=\"#!/api/Ext.layout.BoxLayout\" rel=\"Ext.layout.BoxLayout\" class=\"docClass\">BoxLayout</a> subclasses.</b></p>\n\n\n<p>An object containing margins to apply to this BoxComponent in the\nformat:</p>\n\n\n<pre><code>{\n    top: (top margin),\n    right: (right margin),\n    bottom: (bottom margin),\n    left: (left margin)\n}</code></pre>\n\n\n<p>May also be a string containing space-separated, numeric margin values. The order of the\nsides associated with each value matches the way CSS processes margin values:</p>\n\n\n<p><div class=\"mdetail-params\"><ul>\n<li>If there is only one value, it applies to all sides.</li>\n<li>If there are two values, the top and bottom borders are set to the first value and the\nright and left are set to the second.</li>\n<li>If there are three values, the top is set to the first value, the left and right are set\nto the second, and the bottom is set to the third.</li>\n<li>If there are four values, they apply to the top, right, bottom, and left, respectively.</li>\n</ul></div></p>\n\n\n<p>Defaults to:</p>\n\n\n<pre><code>{top:0, right:0, bottom:0, left:0}\n</code></pre>\n\n</div></div></div><div id='cfg-maskDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-maskDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-maskDisabled' class='name expandable'>maskDisabled</a><span> : Boolean</span></div><div class='description'><div class='short'>true to mask the panel when it is disabled, false to not mask it (defaults\nto true). ...</div><div class='long'><p><code>true</code> to mask the panel when it is <a href=\"#!/api/Ext.Panel-cfg-disabled\" rel=\"Ext.Panel-cfg-disabled\" class=\"docClass\">disabled</a>, <code>false</code> to not mask it (defaults\nto <code>true</code>).  Either way, the panel will always tell its contained elements to disable themselves\nwhen it is disabled, but masking the panel can provide an additional visual cue that the panel is\ndisabled.</p>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='cfg-maxWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-maxWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-maxWidth' class='name expandable'>maxWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The maximum width of the tip in pixels (defaults to 300). ...</div><div class='long'><p>The maximum width of the tip in pixels (defaults to 300).  The maximum supported value is 500.</p>\n<p>Defaults to: <code>300</code></p></div></div></div><div id='cfg-minButtonWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-minButtonWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-minButtonWidth' class='name expandable'>minButtonWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Minimum width in pixels of all buttons in this panel (defaults to 75) ...</div><div class='long'><p>Minimum width in pixels of all <a href=\"#!/api/Ext.Panel-property-buttons\" rel=\"Ext.Panel-property-buttons\" class=\"docClass\">buttons</a> in this panel (defaults to <code>75</code>)</p>\n<p>Defaults to: <code>75</code></p></div></div></div><div id='cfg-minWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-minWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-minWidth' class='name expandable'>minWidth</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The minimum width of the tip in pixels (defaults to 40). ...</div><div class='long'><p>The minimum width of the tip in pixels (defaults to 40).</p>\n<p>Defaults to: <code>40</code></p></div></div></div><div id='cfg-monitorResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-cfg-monitorResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-cfg-monitorResize' class='name expandable'>monitorResize</a><span> : Boolean</span></div><div class='description'><div class='short'>True to automatically monitor window resize events to handle anything that is sensitive to the current size\nof the vi...</div><div class='long'><p>True to automatically monitor window resize events to handle anything that is sensitive to the current size\nof the viewport.  This value is typically managed by the chosen <code><a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a></code> and should not need\nto be set manually.</p>\n</div></div></div><div id='cfg-mouseOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-mouseOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-mouseOffset' class='name not-expandable'>mouseOffset</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'><p>An XY offset from the mouse position where the\ntooltip should be shown (defaults to [15,18]).</p>\n</div><div class='long'><p>An XY offset from the mouse position where the\ntooltip should be shown (defaults to [15,18]).</p>\n</div></div></div><div id='cfg-overCls' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-overCls' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-overCls' class='name expandable'>overCls</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and...</div><div class='long'><p>An optional extra CSS class that will be added to this component's Element when the mouse moves\nover the Element, and removed when the mouse moves out. (defaults to '').  This can be\nuseful for adding customized 'active' or 'hover' styles to the component or any of its children using standard CSS rules.</p>\n</div></div></div><div id='cfg-padding' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-padding' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-padding' class='name expandable'>padding</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A shortcut for setting a padding style on the body element. ...</div><div class='long'><p>A shortcut for setting a padding style on the body element. The value can either be\na number to be applied to all sides, or a normal css string describing padding.\nDefaults to <tt>undefined</tt>.</p>\n</div></div></div><div id='cfg-pageX' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageX' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageX' class='name not-expandable'>pageX</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level x coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-pageY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-pageY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-pageY' class='name not-expandable'>pageY</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The page level y coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-plugins' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-plugins' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-plugins' class='name expandable'>plugins</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An object or array of objects that will provide custom functionality for this component. ...</div><div class='long'><p>An object or array of objects that will provide custom functionality for this component.  The only\nrequirement for a valid plugin is that it contain an init method that accepts a reference of type <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.\nWhen a component is created, if any plugins are available, the component will call the init method on each\nplugin, passing a reference to itself.  Each plugin can then call methods or respond to events on the\ncomponent as needed to provide its functionality.</p>\n</div></div></div><div id='cfg-preventBodyReset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-preventBodyReset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-preventBodyReset' class='name expandable'>preventBodyReset</a><span> : Boolean</span></div><div class='description'><div class='short'>Defaults to false. ...</div><div class='long'><p>Defaults to <code>false</code>.  When set to <code>true</code>, an extra css class <code>'x-panel-normal'</code>\nwill be added to the panel's element, effectively applying css styles suggested by the W3C\n(see http://www.w3.org/TR/CSS21/sample.html) to the Panel's <b>body</b> element (not the header,\nfooter, etc.).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-ptype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ptype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ptype' class='name expandable'>ptype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered ptype to create. ...</div><div class='long'><p>The registered <tt>ptype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a Plugin is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>ptype</tt> will be looked up at render time up to determine what\ntype of Plugin to create.<br><br>\nIf you create your own Plugins, you may register them using\n<a href=\"#!/api/Ext.ComponentMgr-method-registerPlugin\" rel=\"Ext.ComponentMgr-method-registerPlugin\" class=\"docClass\">Ext.ComponentMgr.registerPlugin</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-ref' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-ref' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-ref' class='name expandable'>ref</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A path specification, relative to the Component's ownerCt\nspecifying into which ancestor Container to place a named r...</div><div class='long'><p>A path specification, relative to the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>\nspecifying into which ancestor Container to place a named reference to this Component.</p>\n\n\n<p>The ancestor axis can be traversed by using '/' characters in the path.\nFor example, to put a reference to a Toolbar Button into <i>the Panel which owns the Toolbar</i>:</p>\n\n\n<pre><code>var myGrid = new <a href=\"#!/api/Ext.grid.EditorGridPanel\" rel=\"Ext.grid.EditorGridPanel\" class=\"docClass\">Ext.grid.EditorGridPanel</a>({\n    title: 'My EditorGridPanel',\n    store: myStore,\n    colModel: myColModel,\n    tbar: [{\n        text: 'Save',\n        handler: saveChanges,\n        disabled: true,\n        ref: '../saveButton'\n    }],\n    listeners: {\n        afteredit: function() {\n//          The button reference is in the GridPanel\n            myGrid.saveButton.enable();\n        }\n    }\n});\n</code></pre>\n\n\n<p>In the code above, if the <code>ref</code> had been <code>'saveButton'</code>\nthe reference would have been placed into the Toolbar. Each '/' in the <code>ref</code>\nmoves up one level from the Component's <code><a href=\"#!/api/Ext.Component-property-ownerCt\" rel=\"Ext.Component-property-ownerCt\" class=\"docClass\">ownerCt</a></code>.</p>\n\n\n<p>Also see the <code><a href=\"#!/api/Ext.Component-event-added\" rel=\"Ext.Component-event-added\" class=\"docClass\">added</a></code> and <code><a href=\"#!/api/Ext.Component-event-removed\" rel=\"Ext.Component-event-removed\" class=\"docClass\">removed</a></code> events.</p>\n\n</div></div></div><div id='cfg-region' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-region' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-region' class='name expandable'>region</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is rendered\nby a Container which has been configured to use the <b><a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a></b>\nlayout manager (e.g. specifying <tt>layout:'border'</tt>).</p>\n\n\n<br>\n\n\n<p>See <a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">Ext.layout.BorderLayout</a> also.</p>\n\n</div></div></div><div id='cfg-renderTo' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-renderTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-renderTo' class='name expandable'>renderTo</a><span> : Mixed</span></div><div class='description'><div class='short'>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into. ...</div><div class='long'><p>Specify the id of the element, a DOM element or an existing Element that this component\nwill be rendered into.</p>\n\n\n<div><ul>\n<li><b>Notes</b> : <ul>\n<div class=\"sub-desc\">Do <u>not</u> use this option if the Component is to be a child item of\na <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>. It is the responsibility of the\n<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>'s <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout manager</a>\nto render and manage its child items.</div>\n<div class=\"sub-desc\">When using this config, a call to render() is not required.</div>\n</ul></li>\n</ul></div>\n\n\n<p>See <tt><a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a></tt> also.</p>\n\n</div></div></div><div id='cfg-resizeEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-resizeEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-resizeEvent' class='name expandable'>resizeEvent</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The event to listen to for resizing in layouts. ...</div><div class='long'><p>The event to listen to for resizing in layouts. Defaults to <tt>'bodyresize'</tt>.</p>\n<p>Defaults to: <code>'bodyresize'</code></p><p>Overrides: <a href='#!/api/Ext.Container-cfg-resizeEvent' rel='Ext.Container-cfg-resizeEvent' class='docClass'>Ext.Container.resizeEvent</a></p></div></div></div><div id='cfg-shadow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-shadow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-shadow' class='name expandable'>shadow</a><span> : Boolean/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>True or \"sides\" for the default effect, \"frame\" for 4-way shadow, and \"drop\"\nfor bottom-right shadow (defaults to \"si...</div><div class='long'><p>True or \"sides\" for the default effect, \"frame\" for 4-way shadow, and \"drop\"\nfor bottom-right shadow (defaults to \"sides\").</p>\n<p>Defaults to: <code>&quot;sides&quot;</code></p><p>Overrides: <a href='#!/api/Ext.Panel-cfg-shadow' rel='Ext.Panel-cfg-shadow' class='docClass'>Ext.Panel.shadow</a></p></div></div></div><div id='cfg-shadowOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-shadowOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-shadowOffset' class='name expandable'>shadowOffset</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The number of pixels to offset the shadow if displayed (defaults to 4). ...</div><div class='long'><p>The number of pixels to offset the shadow if displayed (defaults to <code>4</code>). Note that this\noption only applies when <code><a href=\"#!/api/Ext.Panel-cfg-floating\" rel=\"Ext.Panel-cfg-floating\" class=\"docClass\">floating</a> = true</code>.</p>\n</div></div></div><div id='cfg-shim' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-shim' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-shim' class='name expandable'>shim</a><span> : Boolean</span></div><div class='description'><div class='short'>false to disable the iframe shim in browsers which need one (defaults to true). ...</div><div class='long'><p><code>false</code> to disable the iframe shim in browsers which need one (defaults to <code>true</code>).\nNote that this option only applies when <code><a href=\"#!/api/Ext.Panel-cfg-floating\" rel=\"Ext.Panel-cfg-floating\" class=\"docClass\">floating</a> = true</code>.</p>\n</div></div></div><div id='cfg-showDelay' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-showDelay' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-showDelay' class='name expandable'>showDelay</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Delay in milliseconds before the tooltip displays\nafter the mouse enters the target element (defaults to 500) ...</div><div class='long'><p>Delay in milliseconds before the tooltip displays\nafter the mouse enters the target element (defaults to 500)</p>\n<p>Defaults to: <code>500</code></p></div></div></div><div id='cfg-stateEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateEvents' class='name expandable'>stateEvents</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). ...</div><div class='long'><p>An array of events that, when fired, should trigger this component to\nsave its state (defaults to none). <code>stateEvents</code> may be any type\nof event supported by this component, including browser or custom events\n(e.g., <tt>['click', 'customerchange']</tt>).</p>\n\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateId' class='name expandable'>stateId</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, o...</div><div class='long'><p>The unique id for this component to use for state management purposes\n(defaults to the component id if one was set, otherwise null if the\ncomponent is using a generated id).</p>\n\n<p>See <code><a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a></code> for an explanation of saving and\nrestoring Component state.</p>\n\n</div></div></div><div id='cfg-stateful' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-stateful' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-stateful' class='name expandable'>stateful</a><span> : Boolean</span></div><div class='description'><div class='short'>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. ...</div><div class='long'><p>A flag which causes the Component to attempt to restore the state of\ninternal properties from a saved state on startup. The component must have\neither a <code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code> or <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> assigned\nfor state to be managed. Auto-generated ids are not guaranteed to be stable\nacross page loads and cannot be relied upon to save and restore the same\nstate for a component.<p>\n<p>For state saving to work, the state manager's provider must have been\nset to an implementation of <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> which overrides the\n<a href=\"#!/api/Ext.state.Provider-method-set\" rel=\"Ext.state.Provider-method-set\" class=\"docClass\">set</a> and <a href=\"#!/api/Ext.state.Provider-method-get\" rel=\"Ext.state.Provider-method-get\" class=\"docClass\">get</a>\nmethods to save and recall name/value pairs. A built-in implementation,\n<a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a> is available.</p>\n<p>To set the state provider for the current page:</p>\n<pre><code><a href=\"#!/api/Ext.state.Manager-method-setProvider\" rel=\"Ext.state.Manager-method-setProvider\" class=\"docClass\">Ext.state.Manager.setProvider</a>(new <a href=\"#!/api/Ext.state.CookieProvider\" rel=\"Ext.state.CookieProvider\" class=\"docClass\">Ext.state.CookieProvider</a>({\n    expires: new Date(new Date().getTime()+(1000*60*60*24*7)), //7 days from now\n}));\n</code></pre>\n<p>A stateful Component attempts to save state when one of the events\nlisted in the <code><a href=\"#!/api/Ext.Component-cfg-stateEvents\" rel=\"Ext.Component-cfg-stateEvents\" class=\"docClass\">stateEvents</a></code> configuration fires.</p>\n<p>To save state, a stateful Component first serializes its state by\ncalling <b><code>getState</code></b>. By default, this function does\nnothing. The developer must provide an implementation which returns an\nobject hash which represents the Component's restorable state.</p>\n<p>The value yielded by getState is passed to <a href=\"#!/api/Ext.state.Manager-method-set\" rel=\"Ext.state.Manager-method-set\" class=\"docClass\">Ext.state.Manager.set</a>\nwhich uses the configured <a href=\"#!/api/Ext.state.Provider\" rel=\"Ext.state.Provider\" class=\"docClass\">Ext.state.Provider</a> to save the object\nkeyed by the Component's <code>stateId</code>, or, if that is not\nspecified, its <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>During construction, a stateful Component attempts to <i>restore</i>\nits state by calling <a href=\"#!/api/Ext.state.Manager-method-get\" rel=\"Ext.state.Manager-method-get\" class=\"docClass\">Ext.state.Manager.get</a> passing the\n<code><a href=\"#!/api/Ext.Component-cfg-stateId\" rel=\"Ext.Component-cfg-stateId\" class=\"docClass\">stateId</a></code>, or, if that is not specified, the\n<code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code>.</p>\n<p>The resulting object is passed to <b><code>applyState</code></b>.\nThe default implementation of <code>applyState</code> simply copies\nproperties into the object, but a developer may override this to support\nmore behaviour.</p>\n<p>You can perform extra processing on state save and restore by attaching\nhandlers to the <a href=\"#!/api/Ext.Component-event-beforestaterestore\" rel=\"Ext.Component-event-beforestaterestore\" class=\"docClass\">beforestaterestore</a>, <a href=\"#!/api/Ext.Component-event-staterestore\" rel=\"Ext.Component-event-staterestore\" class=\"docClass\">staterestore</a>,\n<a href=\"#!/api/Ext.Component-event-beforestatesave\" rel=\"Ext.Component-event-beforestatesave\" class=\"docClass\">beforestatesave</a> and <a href=\"#!/api/Ext.Component-event-statesave\" rel=\"Ext.Component-event-statesave\" class=\"docClass\">statesave</a> events.</p>\n\n</p></p></div></div></div><div id='cfg-style' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-style' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-style' class='name expandable'>style</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>A custom style specification to be applied to this component's Element. ...</div><div class='long'><p>A custom style specification to be applied to this component's Element.  Should be a valid argument to\n<a href=\"#!/api/Ext.Element-method-applyStyles\" rel=\"Ext.Element-method-applyStyles\" class=\"docClass\">Ext.Element.applyStyles</a>.</p>\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'Some Title',\n    renderTo: <a href=\"#!/api/Ext-method-getBody\" rel=\"Ext-method-getBody\" class=\"docClass\">Ext.getBody</a>(),\n    width: 400, height: 300,\n    layout: 'form',\n    items: [{\n        xtype: 'textarea',\n        style: {\n            width: '95%',\n            marginBottom: '10px'\n        }\n    },\n        new <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a>({\n            text: 'Send',\n            minWidth: '100',\n            style: {\n                marginBottom: '10px'\n            }\n        })\n    ]\n});\n</code></pre>\n\n</div></div></div><div id='cfg-tabTip' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-tabTip' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-tabTip' class='name expandable'>tabTip</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Note: this config is only used when this BoxComponent is a child item of a TabPanel. ...</div><div class='long'><p><b>Note</b>: this config is only used when this BoxComponent is a child item of a TabPanel.</p>\n\n\n<p>A string to be used as innerHTML (html tags are accepted) to show in a tooltip when mousing over\nthe associated tab selector element. <a href=\"#!/api/Ext.QuickTips\" rel=\"Ext.QuickTips\" class=\"docClass\">Ext.QuickTips</a>.init()\nmust be called in order for the tips to render.</p>\n</div></div></div><div id='cfg-target' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-cfg-target' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-cfg-target' class='name not-expandable'>target</a><span> : Mixed</span></div><div class='description'><div class='short'><p>The target HTMLElement, <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> or id to associate with this quicktip (defaults to the document).</p>\n</div><div class='long'><p>The target HTMLElement, <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> or id to associate with this quicktip (defaults to the document).</p>\n<p>Overrides: <a href='#!/api/Ext.ToolTip-cfg-target' rel='Ext.ToolTip-cfg-target' class='docClass'>Ext.ToolTip.target</a></p></div></div></div><div id='cfg-tbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-tbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-tbar' class='name expandable'>tbar</a><span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>The top toolbar of the panel. ...</div><div class='long'><p>The top toolbar of the panel. This can be a <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a> object, a toolbar config, or an array of\nbuttons/button configs to be added to the toolbar.  Note that this is not available as a property after render.\nTo access the top toolbar after render, use <a href=\"#!/api/Ext.Panel-method-getTopToolbar\" rel=\"Ext.Panel-method-getTopToolbar\" class=\"docClass\">getTopToolbar</a>.</p>\n\n\n<p><b>Note:</b> Although a Toolbar may contain Field components, these will <b>not</b> be updated by a load\nof an ancestor FormPanel. A Panel's toolbars are not part of the standard Container->Component hierarchy, and\nso are not scanned to collect form items. However, the values <b>will</b> be submitted because form\nsubmission parameters are collected from the DOM tree.</p>\n\n</div></div></div><div id='cfg-tbarCfg' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-tbarCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-tbarCfg' class='name expandable'>tbarCfg</a><span> : Object</span></div><div class='description'><div class='short'>A DomHelper element specification object specifying the element structure\nof this Panel's tbar Element. ...</div><div class='long'><p>A <a href=\"#!/api/Ext.DomHelper\" rel=\"Ext.DomHelper\" class=\"docClass\">DomHelper</a> element specification object specifying the element structure\nof this Panel's <a href=\"#!/api/Ext.Panel-cfg-tbar\" rel=\"Ext.Panel-cfg-tbar\" class=\"docClass\">tbar</a> Element.  See <code><a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a></code> also.</p>\n\n</div></div></div><div id='cfg-title' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-title' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-title' class='name expandable'>title</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The title text to be used as innerHTML (html tags are accepted) to display in the panel\nheader (defaults to ''). ...</div><div class='long'><p>The title text to be used as innerHTML (html tags are accepted) to display in the panel\n<code><a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a></code> (defaults to ''). When a <code>title</code> is specified the\n<code><a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a></code> element will automatically be created and displayed unless\n<a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a> is explicitly set to <code>false</code>.  If you do not want to specify a\n<code>title</code> at config time, but you may want one later, you must either specify a non-empty\n<code>title</code> (a blank space ' ' will do) or <code>header:true</code> so that the container\nelement will get created.</p>\n</div></div></div><div id='cfg-titleCollapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-titleCollapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-titleCollapse' class='name expandable'>titleCollapse</a><span> : Boolean</span></div><div class='description'><div class='short'>true to allow expanding and collapsing the panel (when collapsible = true)\nby clicking anywhere in the header bar, fa...</div><div class='long'><p><code>true</code> to allow expanding and collapsing the panel (when <code><a href=\"#!/api/Ext.Panel-cfg-collapsible\" rel=\"Ext.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> = true</code>)\nby clicking anywhere in the header bar, <code>false</code>) to allow it only by clicking to tool button\n(defaults to <code>false</code>)). If this panel is a child item of a border layout also see the\n<a href=\"#!/api/Ext.layout.BorderLayout.Region\" rel=\"Ext.layout.BorderLayout.Region\" class=\"docClass\">BorderLayout.Region</a>\n<code><a href=\"#!/api/Ext.layout.BorderLayout.Region-cfg-floatable\" rel=\"Ext.layout.BorderLayout.Region-cfg-floatable\" class=\"docClass\">floatable</a></code> config option.</p>\n</div></div></div><div id='cfg-toolTemplate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-toolTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-toolTemplate' class='name expandable'>toolTemplate</a><span> : <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>/<a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></span></div><div class='description'><div class='short'>A Template used to create tools in the header Element. ...</div><div class='long'><p>A Template used to create <a href=\"#!/api/Ext.Panel-cfg-tools\" rel=\"Ext.Panel-cfg-tools\" class=\"docClass\">tools</a> in the <a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a> Element. Defaults to:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>('&lt;div class=\"x-tool x-tool-{id}\">&amp;#160;&lt;/div>')</code></pre>\n\n\n<p>This may may be overridden to provide a custom DOM structure for tools based upon a more\ncomplex XTemplate. The template's data is a single tool configuration object (Not the entire Array)\nas specified in <a href=\"#!/api/Ext.Panel-cfg-tools\" rel=\"Ext.Panel-cfg-tools\" class=\"docClass\">tools</a>.  In the following example an &lt;a> tag is used to provide a\nvisual indication when hovering over the tool:</p>\n\n\n<pre><code>var win = new <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>({\n    tools: [{\n        id: 'download',\n        href: '/MyPdfDoc.pdf'\n    }],\n    toolTemplate: new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n        '&lt;tpl if=\"id==\\'download\\'\">',\n            '&lt;a class=\"x-tool x-tool-pdf\" href=\"{href}\">&lt;/a>',\n        '&lt;/tpl>',\n        '&lt;tpl if=\"id!=\\'download\\'\">',\n            '&lt;div class=\"x-tool x-tool-{id}\">&amp;#160;&lt;/div>',\n        '&lt;/tpl>'\n    ),\n    width:500,\n    height:300,\n    closeAction:'hide'\n});</code></pre>\n\n\n<p>Note that the CSS class 'x-tool-pdf' should have an associated style rule which provides an\nappropriate background image, something like:</p>\n\n\n\n\n<pre><code>    a.x-tool-pdf {background-image: url(../shared/extjs/images/pdf.gif)!important;}\n    </code></pre>\n\n</div></div></div><div id='cfg-tools' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-tools' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-tools' class='name expandable'>tools</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of tool button configs to be added to the header tool area. ...</div><div class='long'><p>An array of tool button configs to be added to the header tool area. When rendered, each tool is\nstored as an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> referenced by a public property called <code><b></b>tools.<i>&lt;tool-type&gt;</i></code></p>\n\n<p>Each tool config may contain the following properties:\n<div class=\"mdetail-params\"><ul>\n<li><b>id</b> : String<div class=\"sub-desc\"><b>Required.</b> The type\nof tool to create. By default, this assigns a CSS class of the form <code>x-tool-<i>&lt;tool-type&gt;</i></code> to the\nresulting tool Element. Ext provides CSS rules, and an icon sprite containing images for the tool types listed below.\nThe developer may implement custom tools by supplying alternate CSS rules and background images:\n<ul>\n<div class=\"x-tool x-tool-toggle\" style=\"float:left; margin-right:5;\"> </div><div><code> toggle</code> (Created by default when <a href=\"#!/api/Ext.Panel-cfg-collapsible\" rel=\"Ext.Panel-cfg-collapsible\" class=\"docClass\">collapsible</a> is <code>true</code>)</div>\n<div class=\"x-tool x-tool-close\" style=\"float:left; margin-right:5;\"> </div><div><code> close</code></div>\n<div class=\"x-tool x-tool-minimize\" style=\"float:left; margin-right:5;\"> </div><div><code> minimize</code></div>\n<div class=\"x-tool x-tool-maximize\" style=\"float:left; margin-right:5;\"> </div><div><code> maximize</code></div>\n<div class=\"x-tool x-tool-restore\" style=\"float:left; margin-right:5;\"> </div><div><code> restore</code></div>\n<div class=\"x-tool x-tool-gear\" style=\"float:left; margin-right:5;\"> </div><div><code> gear</code></div>\n<div class=\"x-tool x-tool-pin\" style=\"float:left; margin-right:5;\"> </div><div><code> pin</code></div>\n<div class=\"x-tool x-tool-unpin\" style=\"float:left; margin-right:5;\"> </div><div><code> unpin</code></div>\n<div class=\"x-tool x-tool-right\" style=\"float:left; margin-right:5;\"> </div><div><code> right</code></div>\n<div class=\"x-tool x-tool-left\" style=\"float:left; margin-right:5;\"> </div><div><code> left</code></div>\n<div class=\"x-tool x-tool-up\" style=\"float:left; margin-right:5;\"> </div><div><code> up</code></div>\n<div class=\"x-tool x-tool-down\" style=\"float:left; margin-right:5;\"> </div><div><code> down</code></div>\n<div class=\"x-tool x-tool-refresh\" style=\"float:left; margin-right:5;\"> </div><div><code> refresh</code></div>\n<div class=\"x-tool x-tool-minus\" style=\"float:left; margin-right:5;\"> </div><div><code> minus</code></div>\n<div class=\"x-tool x-tool-plus\" style=\"float:left; margin-right:5;\"> </div><div><code> plus</code></div>\n<div class=\"x-tool x-tool-help\" style=\"float:left; margin-right:5;\"> </div><div><code> help</code></div>\n<div class=\"x-tool x-tool-search\" style=\"float:left; margin-right:5;\"> </div><div><code> search</code></div>\n<div class=\"x-tool x-tool-save\" style=\"float:left; margin-right:5;\"> </div><div><code> save</code></div>\n<div class=\"x-tool x-tool-print\" style=\"float:left; margin-right:5;\"> </div><div><code> print</code></div>\n</ul></div></li>\n<li><b>handler</b> : Function<div class=\"sub-desc\"><b>Required.</b> The function to\ncall when clicked. Arguments passed are:<ul>\n<li><b>event</b> : <a href=\"#!/api/Ext.EventObject\" rel=\"Ext.EventObject\" class=\"docClass\">Ext.EventObject</a><div class=\"sub-desc\">The click event.</div></li>\n<li><b>toolEl</b> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a><div class=\"sub-desc\">The tool Element.</div></li>\n<li><b>panel</b> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class=\"sub-desc\">The host Panel</div></li>\n<li><b>tc</b> : Object<div class=\"sub-desc\">The tool configuration object</div></li>\n</ul></div></li>\n<li><b>stopEvent</b> : Boolean<div class=\"sub-desc\">Defaults to true. Specify as false to allow click event to propagate.</div></li>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope in which to call the handler.</div></li>\n<li><b>qtip</b> : String/Object<div class=\"sub-desc\">A tip string, or\na config argument to <a href=\"#!/api/Ext.QuickTip-method-register\" rel=\"Ext.QuickTip-method-register\" class=\"docClass\">Ext.QuickTip.register</a></div></li>\n<li><b>hidden</b> : Boolean<div class=\"sub-desc\">True to initially render hidden.</div></li>\n<li><b>on</b> : Object<div class=\"sub-desc\">A listener config object specifiying\nevent listeners in the format of an argument to <a href=\"#!/api/Ext.Panel-method-addListener\" rel=\"Ext.Panel-method-addListener\" class=\"docClass\">addListener</a></div></li>\n</ul></div>\n<p>Note that, apart from the toggle tool which is provided when a panel is collapsible, these\ntools only provide the visual button. Any required functionality must be provided by adding\nhandlers that implement the necessary behavior.</p>\n<p>Example usage:</p>\n<pre><code>tools:[{\n    id:'refresh',\n    qtip: 'Refresh form Data',\n    // hidden:true,\n    handler: function(event, toolEl, panel){\n        // refresh logic\n    }\n},\n{\n    id:'help',\n    qtip: 'Get Help',\n    handler: function(event, toolEl, panel){\n        // whatever\n    }\n}]\n</code></pre>\n<p>For the custom id of <code>'help'</code> define two relevant css classes with a link to\na 15x15 image:</p>\n<pre><code>.x-tool-help {background-image: url(images/help.png);}\n.x-tool-help-over {background-image: url(images/help_over.png);}\n// if using an image sprite:\n.x-tool-help {background-image: url(images/help.png) no-repeat 0 0;}\n.x-tool-help-over {background-position:-15px 0;}\n</code></pre>\n\n</p></div></div></div><div id='cfg-tpl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-tpl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-tpl' class='name expandable'>tpl</a><span> : Mixed</span></div><div class='description'><div class='short'>An Ext.Template, Ext.XTemplate\nor an array of strings to form an Ext.XTemplate. ...</div><div class='long'><p>An <bold><a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a></bold>, <bold><a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></bold>\nor an array of strings to form an <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>.\nUsed in conjunction with the <code><a href=\"#!/api/Ext.Component-cfg-data\" rel=\"Ext.Component-cfg-data\" class=\"docClass\">data</a></code> and\n<code><a href=\"#!/api/Ext.Component-cfg-tplWriteMode\" rel=\"Ext.Component-cfg-tplWriteMode\" class=\"docClass\">tplWriteMode</a></code> configurations.</p>\n</div></div></div><div id='cfg-tplWriteMode' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-tplWriteMode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-tplWriteMode' class='name expandable'>tplWriteMode</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The Ext.(X)Template method to use when\nupdating the content area of the Component. ...</div><div class='long'><p>The Ext.(X)Template method to use when\nupdating the content area of the Component. Defaults to <tt>'overwrite'</tt>\n(see <code><a href=\"#!/api/Ext.XTemplate-method-overwrite\" rel=\"Ext.XTemplate-method-overwrite\" class=\"docClass\">Ext.XTemplate.overwrite</a></code>).</p>\n<p>Defaults to: <code>'overwrite'</code></p></div></div></div><div id='cfg-trackMouse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-cfg-trackMouse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-cfg-trackMouse' class='name expandable'>trackMouse</a><span> : Boolean</span></div><div class='description'><div class='short'>True to have the tooltip follow the mouse as it\nmoves over the target element (defaults to false). ...</div><div class='long'><p>True to have the tooltip follow the mouse as it\nmoves over the target element (defaults to false).</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-unstyled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-cfg-unstyled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-cfg-unstyled' class='name expandable'>unstyled</a><span> : Boolean</span></div><div class='description'><div class='short'>Overrides the baseCls setting to baseCls = 'x-plain' which renders\nthe panel unstyled except for required attributes ...</div><div class='long'><p>Overrides the <code><a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a></code> setting to <code><a href=\"#!/api/Ext.Panel-cfg-baseCls\" rel=\"Ext.Panel-cfg-baseCls\" class=\"docClass\">baseCls</a> = 'x-plain'</code> which renders\nthe panel unstyled except for required attributes for Ext layouts to function (e.g. overflow:hidden).</p>\n</div></div></div><div id='cfg-width' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-cfg-width' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-cfg-width' class='name expandable'>width</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>Width in pixels of the tip (defaults to auto). ...</div><div class='long'><p>Width in pixels of the tip (defaults to auto).  Width will be ignored if it exceeds the bounds of\n<a href=\"#!/api/Ext.Tip-cfg-minWidth\" rel=\"Ext.Tip-cfg-minWidth\" class=\"docClass\">minWidth</a> or <a href=\"#!/api/Ext.Tip-cfg-maxWidth\" rel=\"Ext.Tip-cfg-maxWidth\" class=\"docClass\">maxWidth</a>.  The maximum supported value is 500.</p>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-cfg-width' rel='Ext.BoxComponent-cfg-width' class='docClass'>Ext.BoxComponent.width</a></p></div></div></div><div id='cfg-x' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-x' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-x' class='name not-expandable'>x</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local x (left) coordinate for this component if contained within a positioning container.</p>\n</div></div></div><div id='cfg-xtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-cfg-xtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-cfg-xtype' class='name expandable'>xtype</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The registered xtype to create. ...</div><div class='long'><p>The registered <tt>xtype</tt> to create. This config option is not used when passing\na config object into a constructor. This config option is used only when\nlazy instantiation is being used, and a child item of a Container is being\nspecified not as a fully instantiated Component, but as a <i>Component config\nobject</i>. The <tt>xtype</tt> will be looked up at render time up to determine what\ntype of child Component to create.<br><br>\nThe predefined xtypes are listed <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">here</a>.</p>\n\n<br><br>\n\n\n<p>If you subclass Components to create your own Components, you may register\nthem using <a href=\"#!/api/Ext.ComponentMgr-method-registerType\" rel=\"Ext.ComponentMgr-method-registerType\" class=\"docClass\">Ext.ComponentMgr.registerType</a> in order to be able to\ntake advantage of lazy instantiation and rendering.</p>\n</div></div></div><div id='cfg-y' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-cfg-y' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-cfg-y' class='name not-expandable'>y</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div><div class='long'><p>The local y (top) coordinate for this component if contained within a positioning container.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-autoRender' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-property-autoRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-property-autoRender' class='name expandable'>autoRender</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-body' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-body' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-body' class='name expandable'>body</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Panel's body Element which may be used to contain HTML content. ...</div><div class='long'><p>The Panel's body <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> which may be used to contain HTML content.\nThe content may be specified in the <a href=\"#!/api/Ext.Panel-cfg-html\" rel=\"Ext.Panel-cfg-html\" class=\"docClass\">html</a> config, or it may be loaded using the\nautoLoad config, or through the Panel's <a href=\"#!/api/Ext.Panel-method-getUpdater\" rel=\"Ext.Panel-method-getUpdater\" class=\"docClass\">Updater</a>. Read-only.</p>\n\n<p>If this is used to load visible HTML elements in either way, then\nthe Panel may not be used as a Layout for hosting nested Panels.</p>\n\n\n<p>If this Panel is intended to be used as the host of a Layout (See <a href=\"#!/api/Ext.Panel-cfg-layout\" rel=\"Ext.Panel-cfg-layout\" class=\"docClass\">layout</a>\nthen the body Element must not be loaded or changed - it is under the control\nof the Panel's Layout.\n<br><p><b>Note</b>: see the Note for <code><a href=\"#!/api/Ext.Component-property-el\" rel=\"Ext.Component-property-el\" class=\"docClass\">el</a></code> also.</p>\n\n</p></div></div></div><div id='property-boxReady' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-property-boxReady' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-property-boxReady' class='name expandable'>boxReady</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, set in afterRender to signify that the component has been rendered ...</div><div class='long'><p>private, set in afterRender to signify that the component has been rendered</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-buttons' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-buttons' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-buttons' class='name expandable'>buttons</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>This Panel's Array of buttons as created from the buttons\nconfig property. ...</div><div class='long'><p>This Panel's Array of buttons as created from the <code><a href=\"#!/api/Ext.Panel-property-buttons\" rel=\"Ext.Panel-property-buttons\" class=\"docClass\">buttons</a></code>\nconfig property. Read only.</p>\n</div></div></div><div id='property-bwrap' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-bwrap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-bwrap' class='name expandable'>bwrap</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Panel's bwrap Element used to contain other Panel elements\n(tbar, body, bbar, footer). ...</div><div class='long'><p>The Panel's bwrap <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a> used to contain other Panel elements\n(tbar, body, bbar, footer). See <a href=\"#!/api/Ext.Panel-cfg-bodyCfg\" rel=\"Ext.Panel-cfg-bodyCfg\" class=\"docClass\">bodyCfg</a>. Read-only.</p>\n</div></div></div><div id='property-closeAction' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-property-closeAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-property-closeAction' class='name expandable'>closeAction</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'hide'</code></p></div></div></div><div id='property-collapseDefaults' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-collapseDefaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-collapseDefaults' class='name expandable'>collapseDefaults</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>{duration: 0.25}</code></p></div></div></div><div id='property-collapseEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-collapseEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-collapseEl' class='name expandable'>collapseEl</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'bwrap'</code></p></div></div></div><div id='property-collapsed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-collapsed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-collapsed' class='name expandable'>collapsed</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this panel is collapsed. ...</div><div class='long'><p>True if this panel is collapsed. Read-only.</p>\n</div></div></div><div id='property-constrainPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-property-constrainPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-property-constrainPosition' class='name expandable'>constrainPosition</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-dd' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-dd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-dd' class='name expandable'>dd</a><span> : <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a></span></div><div class='description'><div class='short'>If this Panel is configured draggable, this property will contain\nan instance of Ext.dd.DragSource which handles drag...</div><div class='long'><p>If this Panel is configured <a href=\"#!/api/Ext.Panel-cfg-draggable\" rel=\"Ext.Panel-cfg-draggable\" class=\"docClass\">draggable</a>, this property will contain\nan instance of <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a> which handles dragging the Panel.</p>\n\n\n<p>The developer must provide implementations of the abstract methods of <a href=\"#!/api/Ext.dd.DragSource\" rel=\"Ext.dd.DragSource\" class=\"docClass\">Ext.dd.DragSource</a>\nin order to supply behaviour for each stage of the drag/drop process. See <a href=\"#!/api/Ext.Panel-cfg-draggable\" rel=\"Ext.Panel-cfg-draggable\" class=\"docClass\">draggable</a>.</p>\n</div></div></div><div id='property-deferHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-deferHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-deferHeight' class='name expandable'>deferHeight</a><span> : Boolean</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private, notify box this class will handle heights ...</div><div class='long'><p>private, notify box this class will handle heights</p>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.BoxComponent-property-deferHeight' rel='Ext.BoxComponent-property-deferHeight' class='docClass'>Ext.BoxComponent.deferHeight</a></p></div></div></div><div id='property-disabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-disabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-disabled' class='name expandable'>disabled</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component is disabled. ...</div><div class='long'><p>True if this component is disabled. Read-only.</p>\n</div></div></div><div id='property-el' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-el' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-el' class='name expandable'>el</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Ext.Element which encapsulates this Component. ...</div><div class='long'><p>The <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component. Read-only.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <code><a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a></code> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.util.Observable-cfg-listeners\" rel=\"Ext.util.Observable-cfg-listeners\" class=\"docClass\">listeners</a>\nconfig for a suggestion, or use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n\n<p>See also <tt><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">getEl</a></tt></p>\n\n</div></div></div><div id='property-expandDefaults' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-expandDefaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-expandDefaults' class='name expandable'>expandDefaults</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>{duration: 0.25}</code></p></div></div></div><div id='property-footer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-footer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-footer' class='name expandable'>footer</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Panel's footer Element. ...</div><div class='long'><p>The Panel's footer <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a>. Read-only.</p>\n\n<p>This Element is used to house the Panel's <code><a href=\"#!/api/Ext.Panel-property-buttons\" rel=\"Ext.Panel-property-buttons\" class=\"docClass\">buttons</a></code> or <code><a href=\"#!/api/Ext.Panel-cfg-fbar\" rel=\"Ext.Panel-cfg-fbar\" class=\"docClass\">fbar</a></code>.</p>\n\n\n<br><p><b>Note</b>: see the Note for <code><a href=\"#!/api/Ext.Component-property-el\" rel=\"Ext.Component-property-el\" class=\"docClass\">el</a></code> also.</p>\n\n</div></div></div><div id='property-header' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-header' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-header' class='name expandable'>header</a><span> : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span></div><div class='description'><div class='short'>The Panel's header Element. ...</div><div class='long'><p>The Panel's header <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Element</a>. Read-only.</p>\n\n<p>This Element is used to house the <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a> and <a href=\"#!/api/Ext.Panel-cfg-tools\" rel=\"Ext.Panel-cfg-tools\" class=\"docClass\">tools</a></p>\n\n\n<br><p><b>Note</b>: see the Note for <code><a href=\"#!/api/Ext.Component-property-el\" rel=\"Ext.Component-property-el\" class=\"docClass\">el</a></code> also.</p>\n\n</div></div></div><div id='property-hidden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-property-hidden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-property-hidden' class='name expandable'>hidden</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component is hidden. ...</div><div class='long'><p>True if this component is hidden. Read-only.</p>\n<p>Defaults to: <code>true</code></p><p>Overrides: <a href='#!/api/Ext.Component-property-hidden' rel='Ext.Component-property-hidden' class='docClass'>Ext.Component.hidden</a></p></div></div></div><div id='property-initialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-initialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-initialConfig' class='name expandable'>initialConfig</a><span> : Object</span></div><div class='description'><div class='short'>This Component's initial configuration specification. ...</div><div class='long'><p>This Component's initial configuration specification. Read-only.</p>\n</div></div></div><div id='property-items' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-property-items' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-property-items' class='name not-expandable'>items</a><span> : MixedCollection</span></div><div class='description'><div class='short'><p>The collection of components in this container as a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></p>\n</div><div class='long'><p>The collection of components in this container as a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></p>\n</div></div></div><div id='property-ownerCt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-ownerCt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-ownerCt' class='name expandable'>ownerCt</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>This Component's owner Container (defaults to undefined, and is set automatically when\nthis Component is added to a C...</div><div class='long'><p>This Component's owner <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> (defaults to undefined, and is set automatically when\nthis Component is added to a Container).  Read-only.</p>\n\n<p><b>Note</b>: to access items within the Container see <tt><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></tt>.</p>\n\n</div></div></div><div id='property-quickShowInterval' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-property-quickShowInterval' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-property-quickShowInterval' class='name expandable'>quickShowInterval</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>250</code></p></div></div></div><div id='property-refOwner' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-refOwner' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-refOwner' class='name expandable'>refOwner</a><span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span></div><div class='description'><div class='short'>The ancestor Container into which the ref reference was inserted if this Component\nis a child of a Container, and has...</div><div class='long'><p>The ancestor Container into which the <a href=\"#!/api/Ext.Component-cfg-ref\" rel=\"Ext.Component-cfg-ref\" class=\"docClass\">ref</a> reference was inserted if this Component\nis a child of a Container, and has been configured with a <code>ref</code>.</p>\n</div></div></div><div id='property-rendered' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-property-rendered' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-property-rendered' class='name expandable'>rendered</a><span> : Boolean</span></div><div class='description'><div class='short'>True if this component has been rendered. ...</div><div class='long'><p>True if this component has been rendered. Read-only.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-slideAnchor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-slideAnchor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-slideAnchor' class='name expandable'>slideAnchor</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>'t'</code></p></div></div></div><div id='property-tagConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-property-tagConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-property-tagConfig' class='name expandable'>tagConfig</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>{namespace: &quot;ext&quot;, attribute: &quot;qtip&quot;, width: &quot;qwidth&quot;, target: &quot;target&quot;, title: &quot;qtitle&quot;, hide: &quot;hide&quot;, cls: &quot;qclass&quot;, align: &quot;qalign&quot;, anchor: &quot;anchor&quot;}</code></p></div></div></div><div id='property-targetCounter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-property-targetCounter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-property-targetCounter' class='name expandable'>targetCounter</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-toolTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-property-toolTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-property-toolTarget' class='name expandable'>toolTarget</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>protected - these could be used to customize the behavior of the window,\nbut changing them would not be useful withou...</div><div class='long'><p>protected - these could be used to customize the behavior of the window,\nbut changing them would not be useful without further mofifications and\ncould lead to unexpected or undesirable results.</p>\n<p>Defaults to: <code>'header'</code></p></div></div></div><div id='property-triggerElement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-property-triggerElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-property-triggerElement' class='name expandable'>triggerElement</a><span> : DOMElement</span></div><div class='description'><div class='short'>When a Tooltip is configured with the delegate\noption to cause selected child elements of the target\nElement to each ...</div><div class='long'><p>When a Tooltip is configured with the <code><a href=\"#!/api/Ext.ToolTip-cfg-delegate\" rel=\"Ext.ToolTip-cfg-delegate\" class=\"docClass\">delegate</a></code>\noption to cause selected child elements of the <code><a href=\"#!/api/Ext.ToolTip-cfg-target\" rel=\"Ext.ToolTip-cfg-target\" class=\"docClass\">target</a></code>\nElement to each trigger a seperate show event, this property is set to\nthe DOM element which triggered the show.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.QuickTip-method-constructor' class='name expandable'>Ext.QuickTip</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.QuickTip\" rel=\"Ext.QuickTip\" class=\"docClass\">Ext.QuickTip</a></div><div class='description'><div class='short'>Create a new Tip ...</div><div class='long'><p>Create a new Tip</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The configuration options</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.QuickTip\" rel=\"Ext.QuickTip\" class=\"docClass\">Ext.QuickTip</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.ToolTip-method-constructor' rel='Ext.ToolTip-method-constructor' class='docClass'>Ext.ToolTip.constructor</a></p></div></div></div><div id='method-add' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-add' class='name expandable'>add</a>( <span class='pre'>component</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Adds Component(s) to this Container. ...</div><div class='long'><p>Adds <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a>(s) to this Container.</p>\n\n\n<br><p><b>Description</b></u> :\n\n\n<div><ul class=\"mdetail-params\">\n<li>Fires the <a href=\"#!/api/Ext.Container-event-beforeadd\" rel=\"Ext.Container-event-beforeadd\" class=\"docClass\">beforeadd</a> event before adding</li>\n<li>The Container's <a href=\"#!/api/Ext.Container-cfg-defaults\" rel=\"Ext.Container-cfg-defaults\" class=\"docClass\">default config values</a> will be applied\naccordingly (see <code><a href=\"#!/api/Ext.Container-cfg-defaults\" rel=\"Ext.Container-cfg-defaults\" class=\"docClass\">defaults</a></code> for details).</li>\n<li>Fires the <a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">add</a> event after the component has been added.</li>\n</ul></div>\n\n\n<br><p><b>Notes</b></u> :\n\n\n<div><ul class=\"mdetail-params\">\n<li>If the Container is <i>already rendered</i> when <code>add</code>\nis called, you may need to call <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which causes\nany unrendered child Components to be rendered. This is required so that you can\n<code>add</code> multiple child components if needed while only refreshing the layout\nonce. For example:\n<pre><code>var tb = new <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a>();\ntb.render(document.body);  // toolbar is rendered\ntb.add({text:'Button 1'}); // add multiple items (<a href=\"#!/api/Ext.Container-cfg-defaultType\" rel=\"Ext.Container-cfg-defaultType\" class=\"docClass\">defaultType</a> for <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Toolbar</a> is 'button')\ntb.add({text:'Button 2'});\ntb.<a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a>();             // refresh the layout\n</code></pre></li>\n<li><i>Warning:</i> Containers directly managed by the BorderLayout layout manager\nmay not be removed or added.  See the Notes for <a href=\"#!/api/Ext.layout.BorderLayout\" rel=\"Ext.layout.BorderLayout\" class=\"docClass\">BorderLayout</a>\nfor more details.</li>\n</ul></div>\n\n</p></p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>component</span> : ...Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Either one or more Components to add or an Array of Components to add.  See\n<code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> for additional information.</p>\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The Components that were added.</p>\n</div></li></ul></div></div></div><div id='method-addButton' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-addButton' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-addButton' class='name expandable'>addButton</a>( <span class='pre'>config, handler, scope</span> ) : <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></div><div class='description'><div class='short'>Adds a button to this panel. ...</div><div class='long'><p>Adds a button to this panel.  Note that this method must be called prior to rendering.  The preferred\napproach is to add buttons via the <a href=\"#!/api/Ext.Panel-property-buttons\" rel=\"Ext.Panel-property-buttons\" class=\"docClass\">buttons</a> config.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/Object<div class='sub-desc'><p>A valid <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a> config.  A string will become the text for a default\nbutton config, an object will be treated as a button config object.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called on button <a href=\"#!/api/Ext.Button-event-click\" rel=\"Ext.Button-event-click\" class=\"docClass\">Ext.Button.click</a></p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the button handler function is executed. Defaults to the Button.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Ext.Button</a></span><div class='sub-desc'><p>The button that was added</p>\n</div></li></ul></div></div></div><div id='method-addClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-addClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-addClass' class='name expandable'>addClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Adds a CSS class to the component's underlying element. ...</div><div class='long'><p>Adds a CSS class to the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to add</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-addTool' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-addTool' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-addTool' class='name expandable'>addTool</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-adjustBodyHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-adjustBodyHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-adjustBodyHeight' class='name expandable'>adjustBodyHeight</a>( <span class='pre'>h</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>deprecate ...</div><div class='long'><p>deprecate</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>h</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-adjustBodyWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-adjustBodyWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-adjustBodyWidth' class='name expandable'>adjustBodyWidth</a>( <span class='pre'>w</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-adjustPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-adjustPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-adjustPosition' class='name expandable'>adjustPosition</a>( <span class='pre'>x, y</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.BoxComponent-method-adjustPosition' rel='Ext.BoxComponent-method-adjustPosition' class='docClass'>Ext.BoxComponent.adjustPosition</a></p></div></div></div><div id='method-adjustSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-adjustSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-adjustSize' class='name expandable'>adjustSize</a>( <span class='pre'>w, h</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>h</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterCollapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-afterCollapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-afterCollapse' class='name expandable'>afterCollapse</a>( <span class='pre'>anim</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anim</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterEffect' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-afterEffect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-afterEffect' class='name expandable'>afterEffect</a>( <span class='pre'>anim</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anim</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterExpand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-afterExpand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-afterExpand' class='name expandable'>afterExpand</a>( <span class='pre'>anim</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anim</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterRender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-afterRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-afterRender' class='name expandable'>afterRender</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.Tip-method-afterRender' rel='Ext.Tip-method-afterRender' class='docClass'>Ext.Tip.afterRender</a></p></div></div></div><div id='method-applyDefaults' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-applyDefaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-applyDefaults' class='name expandable'>applyDefaults</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyToMarkup' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-applyToMarkup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-applyToMarkup' class='name expandable'>applyToMarkup</a>( <span class='pre'>el</span> )</div><div class='description'><div class='short'>Apply this component to existing markup that is valid. ...</div><div class='long'><p>Apply this component to existing markup that is valid. With this function, no call to render() is required.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-beforeDestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-beforeDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-beforeDestroy' class='name expandable'>beforeDestroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.Panel-method-beforeDestroy' rel='Ext.Panel-method-beforeDestroy' class='docClass'>Ext.Panel.beforeDestroy</a></p></div></div></div><div id='method-beforeEffect' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-beforeEffect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-beforeEffect' class='name expandable'>beforeEffect</a>( <span class='pre'>anim</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>anim</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-bubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-bubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-bubble' class='name expandable'>bubble</a>( <span class='pre'>fn, [scope], [args]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Bubbles up the component/container heirarchy, calling the specified function with each component. ...</div><div class='long'><p>Bubbles up the component/container heirarchy, calling the specified function with each component. The scope (<i>this</i>) of\nfunction call will be the scope provided or the current component. The arguments to the function\nwill be the args provided or the current component. If the function returns false at any point,\nthe bubble is stopped.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope of the function (defaults to current node)</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (default to passing the current component)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-canLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-canLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-canLayout' class='name expandable'>canLayout</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>We can only lay out if there is a view area in which to layout. ...</div><div class='long'><p>We can only lay out if there is a view area in which to layout.\ndisplay:none on the layout target, <em>or any of its parent elements</em> will mean it has no view area.</p>\n</div></div></div><div id='method-cancelShow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-cancelShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-cancelShow' class='name expandable'>cancelShow</a>( <span class='pre'>el</span> )</div><div class='description'><div class='short'>Hides a visible tip or cancels an impending show for a particular element. ...</div><div class='long'><p>Hides a visible tip or cancels an impending show for a particular element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : String/HTMLElement/Element<div class='sub-desc'><p>The element that is the target of the tip.</p>\n</div></li></ul></div></div></div><div id='method-cascade' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-cascade' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-cascade' class='name expandable'>cascade</a>( <span class='pre'>fn, [scope], [args]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Cascades down the component/container heirarchy from this component (called first), calling the specified function wi...</div><div class='long'><p>Cascades down the component/container heirarchy from this component (called first), calling the specified function with\neach component. The scope (<i>this</i>) of\nfunction call will be the scope provided or the current component. The arguments to the function\nwill be the args provided or the current component. If the function returns false at any point,\nthe cascade is stopped on that branch.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope of the function (defaults to current component)</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (defaults to passing the current component)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-clearTimer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-clearTimer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-clearTimer' class='name expandable'>clearTimer</a>( <span class='pre'>name</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-clearTimers' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-clearTimers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-clearTimers' class='name expandable'>clearTimers</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-cloneConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-cloneConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-cloneConfig' class='name expandable'>cloneConfig</a>( <span class='pre'>overrides</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Clone the current component using the original config values passed into this instance by default. ...</div><div class='long'><p>Clone the current component using the original config values passed into this instance by default.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>overrides</span> : Object<div class='sub-desc'><p>A new config containing any properties to override in the cloned version.\nAn id property can be passed on this object, otherwise one will be generated to avoid duplicates.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>clone The cloned copy of this component</p>\n</div></li></ul></div></div></div><div id='method-collapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-collapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-collapse' class='name expandable'>collapse</a>( <span class='pre'>animate</span> ) : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Collapses the panel body so that it becomes hidden. ...</div><div class='long'><p>Collapses the panel body so that it becomes hidden.  Fires the <a href=\"#!/api/Ext.Panel-event-beforecollapse\" rel=\"Ext.Panel-event-beforecollapse\" class=\"docClass\">beforecollapse</a> event which will\ncancel the collapse action if it returns false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : Boolean<div class='sub-desc'><p>True to animate the transition, else false (defaults to the value of the\n<a href=\"#!/api/Ext.Panel-cfg-animCollapse\" rel=\"Ext.Panel-cfg-animCollapse\" class=\"docClass\">animCollapse</a> panel config)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-createClasses' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-createClasses' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-createClasses' class='name expandable'>createClasses</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-createComponent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-createComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-createComponent' class='name expandable'>createComponent</a>( <span class='pre'>config, defaultType</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>defaultType</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createEffect' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-createEffect' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-createEffect' class='name expandable'>createEffect</a>( <span class='pre'>a, cb, scope</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private - wraps up an animation param with internal callbacks ...</div><div class='long'><p>private - wraps up an animation param with internal callbacks</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>a</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>cb</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createElement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-createElement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-createElement' class='name expandable'>createElement</a>( <span class='pre'>name, pnode</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>pnode</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createFbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-createFbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-createFbar' class='name expandable'>createFbar</a>( <span class='pre'>fbar</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fbar</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createGhost' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-createGhost' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-createGhost' class='name expandable'>createGhost</a>( <span class='pre'>cls, useShim, appendTo</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>useShim</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>appendTo</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createToolHandler' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-createToolHandler' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-createToolHandler' class='name expandable'>createToolHandler</a>( <span class='pre'>t, tc, overCls, panel</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>t</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>tc</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>overCls</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>panel</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createToolbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-createToolbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-createToolbar' class='name expandable'>createToolbar</a>( <span class='pre'>tb, options</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tb</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-delayHide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-delayHide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-delayHide' class='name expandable'>delayHide</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-delayShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-delayShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-delayShow' class='name expandable'>delayShow</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the c...</div><div class='long'><p>Destroys this component by purging any event listeners, removing the component's element from the DOM,\nremoving the component from its <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a> (if applicable) and unregistering it from\n<a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>.  Destruction is generally handled automatically by the framework and this method\nshould usually not need to be called directly.</p>\n</div></div></div><div id='method-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-disable' class='name expandable'>disable</a>( <span class='pre'>silent</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Disable this component and fire the 'disable' event. ...</div><div class='long'><p>Disable this component and fire the 'disable' event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-doAutoLoad' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-doAutoLoad' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-doAutoLoad' class='name expandable'>doAutoLoad</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-doAutoWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-method-doAutoWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-method-doAutoWidth' class='name expandable'>doAutoWidth</a>( <span class='pre'>adjust</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>protected ...</div><div class='long'><p>protected</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>adjust</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-doEnable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-doEnable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-doEnable' class='name expandable'>doEnable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-doLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-doLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-doLayout' class='name expandable'>doLayout</a>( <span class='pre'>[shallow], [force]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Force this container's layout to be recalculated. ...</div><div class='long'><p>Force this container's layout to be recalculated. A call to this function is required after adding a new component\nto an already rendered container, or possibly after changing sizing/position properties of child components.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>True to only calc the layout of this component, and let child components auto\ncalc layouts as required (defaults to false, which calls doLayout recursively for each subcontainer)</p>\n</div></li><li><span class='pre'>force</span> : Boolean (optional)<div class='sub-desc'><p>True to force a layout to occur, even if the item is hidden.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-doRemove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-doRemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-doRemove' class='name expandable'>doRemove</a>( <span class='pre'>c, autoDestroy</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>autoDestroy</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-enable' class='name expandable'>enable</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Enable this component and fire the 'enable' event. ...</div><div class='long'><p>Enable this component and fire the 'enable' event.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-expand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-expand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-expand' class='name expandable'>expand</a>( <span class='pre'>animate</span> ) : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Expands the panel body so that it becomes visible. ...</div><div class='long'><p>Expands the panel body so that it becomes visible.  Fires the <a href=\"#!/api/Ext.Panel-event-beforeexpand\" rel=\"Ext.Panel-event-beforeexpand\" class=\"docClass\">beforeexpand</a> event which will\ncancel the expand action if it returns false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : Boolean<div class='sub-desc'><p>True to animate the transition, else false (defaults to the value of the\n<a href=\"#!/api/Ext.Panel-cfg-animCollapse\" rel=\"Ext.Panel-cfg-animCollapse\" class=\"docClass\">animCollapse</a> panel config)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-find' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-find' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-find' class='name expandable'>find</a>( <span class='pre'>prop, value</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Find a component under this container at any level by property ...</div><div class='long'><p>Find a component under this container at any level by property</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>prop</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of Ext.Components</p>\n</div></li></ul></div></div></div><div id='method-findBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-findBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-findBy' class='name expandable'>findBy</a>( <span class='pre'>fn, [scope]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Find a component under this container at any level by a custom function. ...</div><div class='long'><p>Find a component under this container at any level by a custom function. If the passed function returns\ntrue, the component will be included in the results. The passed function is called with the arguments (component, this container).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of Ext.Components</p>\n</div></li></ul></div></div></div><div id='method-findById' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-findById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-findById' class='name expandable'>findById</a>( <span class='pre'>id</span> ) : Object<strong class='deprecated signature' >deprecated</strong></div><div class='description'><div class='short'>Find a component under this container at any level by id ...</div><div class='long'><p>Find a component under this container at any level by id</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>Fairly useless method, since you can just use <a href=\"#!/api/Ext-method-getCmp\" rel=\"Ext-method-getCmp\" class=\"docClass\">Ext.getCmp</a>. Should be removed for 4.0\nIf you need to test if an id belongs to a container, you can use getCmp and findParent*.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-findByType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-findByType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-findByType' class='name expandable'>findByType</a>( <span class='pre'>xtype, [shallow]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Find a component under this container at any level by xtype or class ...</div><div class='long'><p>Find a component under this container at any level by xtype or class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Class<div class='sub-desc'><p>The xtype string for a component, or the class of the component directly</p>\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of Ext.Components</p>\n</div></li></ul></div></div></div><div id='method-findParentBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentBy' class='name expandable'>findParentBy</a>( <span class='pre'>fn</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by a custom function. ...</div><div class='long'><p>Find a container above this component at any level by a custom function. If the passed function returns\ntrue, the container will be returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The custom function to call with the arguments (container, this component).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container for which the custom function returns true</p>\n</div></li></ul></div></div></div><div id='method-findParentByType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-findParentByType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-findParentByType' class='name expandable'>findParentByType</a>( <span class='pre'>xtype, [shallow]</span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Find a container above this component at any level by xtype or class ...</div><div class='long'><p>Find a container above this component at any level by xtype or class</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>The first Container which matches the given xtype or class</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.util.Observable-method-enableBubble\" rel=\"Ext.util.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-focus' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-focus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-focus' class='name expandable'>focus</a>( <span class='pre'>[selectText], [delay]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Try to focus this component. ...</div><div class='long'><p>Try to focus this component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selectText</span> : Boolean (optional)<div class='sub-desc'><p>If applicable, true to also select the text in this component</p>\n</div></li><li><span class='pre'>delay</span> : Boolean/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Delay the focus this number of milliseconds (true for 10 milliseconds)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-get' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-get' class='name expandable'>get</a>( <span class='pre'>key</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='deprecated signature' >deprecated</strong></div><div class='description'><div class='short'>Get a component contained by this container (alias for items.get(key)) ...</div><div class='long'><p>Get a component contained by this container (alias for items.get(key))</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>Should be removed in 4.0, since getComponent does the same thing.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index or id of the component</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-getAnchorAlign' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-getAnchorAlign' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-getAnchorAlign' class='name expandable'>getAnchorAlign</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getAnchorPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-getAnchorPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-getAnchorPosition' class='name expandable'>getAnchorPosition</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getBottomToolbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getBottomToolbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getBottomToolbar' class='name expandable'>getBottomToolbar</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a></div><div class='description'><div class='short'>Returns the toolbar from the bottom (bbar) section of the panel. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">toolbar</a> from the bottom (<code><a href=\"#!/api/Ext.Panel-cfg-bbar\" rel=\"Ext.Panel-cfg-bbar\" class=\"docClass\">bbar</a></code>) section of the panel.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a></span><div class='sub-desc'><p>The toolbar</p>\n</div></li></ul></div></div></div><div id='method-getBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getBox' class='name expandable'>getBox</a>( <span class='pre'>[local]</span> ) : Object</div><div class='description'><div class='short'>Gets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Gets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>box An object in the format {x, y, width, height}</p>\n</div></li></ul></div></div></div><div id='method-getBubbleTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getBubbleTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getBubbleTarget' class='name expandable'>getBubbleTarget</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></div><div class='description'><div class='short'>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy. ...</div><div class='long'><p>Provides the link for Observable's fireEvent method to bubble up the ownership hierarchy.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></span><div class='sub-desc'><p>the Container which owns this Component.</p>\n</div></li></ul></div></div></div><div id='method-getComponent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-getComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-getComponent' class='name expandable'>getComponent</a>( <span class='pre'>comp</span> ) : Object</div><div class='description'><div class='short'>Examines this container's items property\nand gets a direct child component of this container. ...</div><div class='long'><p>Examines this container's <code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> <b>property</b>\nand gets a direct child component of this container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>comp</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>This parameter may be any of the following:</p>\n\n<div><ul class=\"mdetail-params\">\n<li>a <b><code>String</code></b> : representing the <code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code>\nor <code><a href=\"#!/api/Ext.Component-cfg-id\" rel=\"Ext.Component-cfg-id\" class=\"docClass\">id</a></code> of the child component </li>\n<li>a <b><code>Number</code></b> : representing the position of the child component\nwithin the <code><a href=\"#!/api/Ext.Container-property-items\" rel=\"Ext.Container-property-items\" class=\"docClass\">items</a></code> <b>property</b></li>\n</ul></div>\n\n\n<p>For additional information see <a href=\"#!/api/Ext.util.MixedCollection-method-get\" rel=\"Ext.util.MixedCollection-method-get\" class=\"docClass\">Ext.util.MixedCollection.get</a>.\n\n</p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> The component (if found).</p>\n</div></li></ul></div></div></div><div id='method-getComponentId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-getComponentId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-getComponentId' class='name expandable'>getComponentId</a>( <span class='pre'>comp</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private - used as the key lookup function for the items collection ...</div><div class='long'><p>private - used as the key lookup function for the items collection</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>comp</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getContentTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getContentTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getContentTarget' class='name expandable'>getContentTarget</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getEl' class='name expandable'>getEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the Ext.Element which encapsulates this Component. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> which encapsulates this Component.</p>\n\n\n<p>This will <i>usually</i> be a &lt;DIV> element created by the class's onRender method, but\nthat may be overridden using the <a href=\"#!/api/Ext.Component-cfg-autoEl\" rel=\"Ext.Component-cfg-autoEl\" class=\"docClass\">autoEl</a> config.</p>\n\n\n<br><p><b>Note</b>: this element will not be available until this Component has been rendered.</p><br>\n\n\n<p>To add listeners for <b>DOM events</b> to this Component (as opposed to listeners\nfor this Component's own Observable events), see the <a href=\"#!/api/Ext.Component-cfg-listeners\" rel=\"Ext.Component-cfg-listeners\" class=\"docClass\">listeners</a> config for a suggestion,\nor use a render listener directly:</p>\n\n\n<pre><code>new <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>({\n    title: 'The Clickable Panel',\n    listeners: {\n        render: function(p) {\n            // Append the Panel to the click handler&#39;s argument list.\n            p.getEl().on('click', handlePanelClick.createDelegate(null, [p], true));\n        },\n        single: true  // Remove the listener after first invocation\n    }\n});\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which encapsulates this Component.</p>\n</div></li></ul></div></div></div><div id='method-getFooterToolbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getFooterToolbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getFooterToolbar' class='name expandable'>getFooterToolbar</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a></div><div class='description'><div class='short'>Returns the toolbar from the footer (fbar) section of the panel. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">toolbar</a> from the footer (<code><a href=\"#!/api/Ext.Panel-cfg-fbar\" rel=\"Ext.Panel-cfg-fbar\" class=\"docClass\">fbar</a></code>) section of the panel.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a></span><div class='sub-desc'><p>The toolbar</p>\n</div></li></ul></div></div></div><div id='method-getFrameHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getFrameHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getFrameHeight' class='name expandable'>getFrameHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the height in pixels of the framing elements of this panel (including any top and bottom bars and\nheader and ...</div><div class='long'><p>Returns the height in pixels of the framing elements of this panel (including any top and bottom bars and\nheader and footer elements, but not including the body height).  To retrieve the body height see <a href=\"#!/api/Ext.Panel-method-getInnerHeight\" rel=\"Ext.Panel-method-getInnerHeight\" class=\"docClass\">getInnerHeight</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The frame height</p>\n</div></li></ul></div></div></div><div id='method-getFrameWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getFrameWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getFrameWidth' class='name expandable'>getFrameWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the width in pixels of the framing elements of this panel (not including the body width). ...</div><div class='long'><p>Returns the width in pixels of the framing elements of this panel (not including the body width).  To\nretrieve the body width see <a href=\"#!/api/Ext.Panel-method-getInnerWidth\" rel=\"Ext.Panel-method-getInnerWidth\" class=\"docClass\">getInnerWidth</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The frame width</p>\n</div></li></ul></div></div></div><div id='method-getHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getHeight' class='name expandable'>getHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current height of the component's underlying element. ...</div><div class='long'><p>Gets the current height of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getId' class='name expandable'>getId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the id of this component or automatically generates and\nreturns an id if an id is not defined yet:\n\n'ext-comp...</div><div class='long'><p>Returns the <code>id</code> of this component or automatically generates and\nreturns an <code>id</code> if an <code>id</code> is not defined yet:</p>\n\n<pre><code>'ext-comp-' + (++<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.AUTO_ID)\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>id</p>\n</div></li></ul></div></div></div><div id='method-getInnerHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getInnerHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getInnerHeight' class='name expandable'>getInnerHeight</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the height in pixels of the body element (not including the height of any framing elements). ...</div><div class='long'><p>Returns the height in pixels of the body element (not including the height of any framing elements).\nFor the frame height see <a href=\"#!/api/Ext.Panel-method-getFrameHeight\" rel=\"Ext.Panel-method-getFrameHeight\" class=\"docClass\">getFrameHeight</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The body height</p>\n</div></li></ul></div></div></div><div id='method-getInnerWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getInnerWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getInnerWidth' class='name expandable'>getInnerWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the width in pixels of the body element (not including the width of any framing elements). ...</div><div class='long'><p>Returns the width in pixels of the body element (not including the width of any framing elements).\nFor the frame width see <a href=\"#!/api/Ext.Panel-method-getFrameWidth\" rel=\"Ext.Panel-method-getFrameWidth\" class=\"docClass\">getFrameWidth</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The body width</p>\n</div></li></ul></div></div></div><div id='method-getItemId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getItemId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getItemId' class='name expandable'>getItemId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the itemId of this component. ...</div><div class='long'><p>Returns the <code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> of this component.  If an\n<code><a href=\"#!/api/Ext.Component-cfg-itemId\" rel=\"Ext.Component-cfg-itemId\" class=\"docClass\">itemId</a></code> was not assigned through configuration the\n<code>id</code> is returned using <code><a href=\"#!/api/Ext.Component-method-getId\" rel=\"Ext.Component-method-getId\" class=\"docClass\">getId</a></code>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getKeyMap' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getKeyMap' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getKeyMap' class='name expandable'>getKeyMap</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-getLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-getLayout' class='name expandable'>getLayout</a>( <span class='pre'></span> ) : ContainerLayout</div><div class='description'><div class='short'>Returns the layout currently in use by the container. ...</div><div class='long'><p>Returns the layout currently in use by the container.  If the container does not currently have a layout\nset, a default <a href=\"#!/api/Ext.layout.ContainerLayout\" rel=\"Ext.layout.ContainerLayout\" class=\"docClass\">Ext.layout.ContainerLayout</a> will be created and set as the container's layout.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>ContainerLayout</span><div class='sub-desc'><p>layout The container's layout</p>\n</div></li></ul></div></div></div><div id='method-getLayoutTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getLayoutTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getLayoutTarget' class='name expandable'>getLayoutTarget</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>private\n\nReturns the Element to be used to contain the child Components of this Container. ...</div><div class='long'><p>private</p>\n\n<p>Returns the Element to be used to contain the child Components of this Container.</p>\n\n\n<p>An implementation is provided which returns the Container's <a href=\"#!/api/Ext.Panel-method-getEl\" rel=\"Ext.Panel-method-getEl\" class=\"docClass\">Element</a>, but\nif there is a more complex structure to a Container, this may be overridden to return\nthe element into which the <a href=\"#!/api/Ext.Panel-cfg-layout\" rel=\"Ext.Panel-cfg-layout\" class=\"docClass\">layout</a> renders child Components.</p>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element to render child Components into.</p>\n\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Container-method-getLayoutTarget' rel='Ext.Container-method-getLayoutTarget' class='docClass'>Ext.Container.getLayoutTarget</a></p></div></div></div><div id='method-getMouseOffset' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-getMouseOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-getMouseOffset' class='name expandable'>getMouseOffset</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getOffsets' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-getOffsets' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-getOffsets' class='name expandable'>getOffsets</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getOuterSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getOuterSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getOuterSize' class='name expandable'>getOuterSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element, including space taken by its margins. ...</div><div class='long'><p>Gets the current size of the component's underlying element, including space taken by its margins.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width + left/right margins), height: (element height + top/bottom margins)}</p>\n</div></li></ul></div></div></div><div id='method-getPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getPosition' class='name expandable'>getPosition</a>( <span class='pre'>[local]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Gets the current XY position of the component's underlying element. ...</div><div class='long'><p>Gets the current XY position of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>local</span> : Boolean (optional)<div class='sub-desc'><p>If true the element's left and top are returned instead of page XY (defaults to false)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>The XY position of the element (e.g., [100, 200])</p>\n</div></li></ul></div></div></div><div id='method-getResizeEl' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getResizeEl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getResizeEl' class='name expandable'>getResizeEl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Returns the outermost Element of this Component which defines the Components overall size. ...</div><div class='long'><p>Returns the outermost Element of this Component which defines the Components overall size.</p>\n\n\n<p><i>Usually</i> this will return the same Element as <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code>,\nbut in some cases, a Component may have some more wrapping Elements around its main\nactive Element.</p>\n\n\n<p>An example is a ComboBox. It is encased in a <i>wrapping</i> Element which\ncontains both the <code>&lt;input></code> Element (which is what would be returned\nby its <code><a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">getEl</a></code> method, <i>and</i> the trigger button Element.\nThis Element is returned as the <code>resizeEl</code>.\n\n</p><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The Element which is to be resized by size managing layouts.</p>\n</div></li></ul></div></div></div><div id='method-getSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getSize' class='name expandable'>getSize</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Gets the current size of the component's underlying element. ...</div><div class='long'><p>Gets the current size of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>An object containing the element's size {width: (element width), height: (element height)}</p>\n</div></li></ul></div></div></div><div id='method-getTargetXY' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-getTargetXY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-getTargetXY' class='name expandable'>getTargetXY</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getTipCfg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-getTipCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-getTipCfg' class='name expandable'>getTipCfg</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTool' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getTool' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getTool' class='name expandable'>getTool</a>( <span class='pre'>id</span> ) : Object</div><div class='description'><div class='short'>Retrieve a tool by id. ...</div><div class='long'><p>Retrieve a tool by id.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>tool</p>\n</div></li></ul></div></div></div><div id='method-getToolbarHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getToolbarHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getToolbarHeight' class='name expandable'>getToolbarHeight</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-getTopToolbar' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getTopToolbar' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getTopToolbar' class='name expandable'>getTopToolbar</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a></div><div class='description'><div class='short'>Returns the toolbar from the top (tbar) section of the panel. ...</div><div class='long'><p>Returns the <a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">toolbar</a> from the top (<code><a href=\"#!/api/Ext.Panel-cfg-tbar\" rel=\"Ext.Panel-cfg-tbar\" class=\"docClass\">tbar</a></code>) section of the panel.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a></span><div class='sub-desc'><p>The toolbar</p>\n</div></li></ul></div></div></div><div id='method-getUpdater' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-getUpdater' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-getUpdater' class='name expandable'>getUpdater</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a></div><div class='description'><div class='short'>Get the Ext.Updater for this panel. ...</div><div class='long'><p>Get the <a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a> for this panel. Enables you to perform Ajax updates of this panel's body.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Updater\" rel=\"Ext.Updater\" class=\"docClass\">Ext.Updater</a></span><div class='sub-desc'><p>The Updater</p>\n</div></li></ul></div></div></div><div id='method-getWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-getWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-getWidth' class='name expandable'>getWidth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Gets the current width of the component's underlying element. ...</div><div class='long'><p>Gets the current width of the component's underlying element.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXType' class='name expandable'>getXType</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Gets the xtype for this component as registered with Ext.ComponentMgr. ...</div><div class='long'><p>Gets the xtype for this component as registered with <a href=\"#!/api/Ext.ComponentMgr\" rel=\"Ext.ComponentMgr\" class=\"docClass\">Ext.ComponentMgr</a>. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header. Example usage:</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXType());  // alerts 'textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype</p>\n</div></li></ul></div></div></div><div id='method-getXTypes' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-getXTypes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-getXTypes' class='name expandable'>getXTypes</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns this Component's xtype hierarchy as a slash-delimited string. ...</div><div class='long'><p>Returns this Component's xtype hierarchy as a slash-delimited string. For a list of all\navailable xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nalert(t.getXTypes());  // alerts 'component/box/field/textfield'\n</code></pre>\n\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The xtype hierarchy string</p>\n</div></li></ul></div></div></div><div id='method-hasLayoutPending' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-hasLayoutPending' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-hasLayoutPending' class='name expandable'>hasLayoutPending</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-hide' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-hide' class='name expandable'>hide</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>inherit docs\n\nHides this tooltip if visible. ...</div><div class='long'><p>inherit docs</p>\n\n<p>Hides this tooltip if visible.</p>\n<p>Overrides: <a href='#!/api/Ext.ToolTip-method-hide' rel='Ext.ToolTip-method-hide' class='docClass'>Ext.ToolTip.hide</a></p></div></div></div><div id='method-initComponent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-initComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-initComponent' class='name expandable'>initComponent</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.ToolTip-method-initComponent' rel='Ext.ToolTip-method-initComponent' class='docClass'>Ext.ToolTip.initComponent</a></p></div></div></div><div id='method-initDraggable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-method-initDraggable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-method-initDraggable' class='name expandable'>initDraggable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.Panel-method-initDraggable' rel='Ext.Panel-method-initDraggable' class='docClass'>Ext.Panel.initDraggable</a></p></div></div></div><div id='method-initEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-initEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-initEvents' class='name expandable'>initEvents</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-initItems' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-initItems' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-initItems' class='name expandable'>initItems</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-initRef' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-initRef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-initRef' class='name expandable'>initRef</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to establish a reference to a component. ...</div><div class='long'><p>Method to establish a reference to a component.</p>\n</div></div></div><div id='method-initTarget' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-initTarget' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-initTarget' class='name expandable'>initTarget</a>( <span class='pre'>t</span> )</div><div class='description'><div class='short'>Binds this ToolTip to the specified element. ...</div><div class='long'><p>Binds this ToolTip to the specified element. The tooltip will be displayed when the mouse moves over the element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>t</span> : Mixed<div class='sub-desc'><p>The Element, HtmlElement, or ID of an element to bind to</p>\n</div></li></ul></div></div></div><div id='method-insert' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-insert' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-insert' class='name expandable'>insert</a>( <span class='pre'>index, component</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Inserts a Component into this Container at a specified index. ...</div><div class='long'><p>Inserts a Component into this Container at a specified index. Fires the\n<a href=\"#!/api/Ext.Container-event-beforeadd\" rel=\"Ext.Container-event-beforeadd\" class=\"docClass\">beforeadd</a> event before inserting, then fires the <a href=\"#!/api/Ext.Container-event-add\" rel=\"Ext.Container-event-add\" class=\"docClass\">add</a> event after the\nComponent has been inserted.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the Component will be inserted\ninto the Container's items collection</p>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The child Component to insert.<br><br>\nExt uses lazy rendering, and will only render the inserted Component should\nit become necessary.<br><br>\nA Component config object may be passed in order to avoid the overhead of\nconstructing a real Component object if lazy rendering might mean that the\ninserted Component will not be rendered immediately. To take advantage of\nthis 'lazy instantiation', set the <a href=\"#!/api/Ext.Component-cfg-xtype\" rel=\"Ext.Component-cfg-xtype\" class=\"docClass\">Ext.Component.xtype</a> config\nproperty to the registered type of the Component wanted.<br><br>\nFor a list of all available xtypes, see <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>component The Component (or config object) that was\ninserted with the Container's default config values applied.</p>\n</div></li></ul></div></div></div><div id='method-isVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isVisible' class='name expandable'>isVisible</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this component is visible. ...</div><div class='long'><p>Returns true if this component is visible.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component is visible, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isXType' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-isXType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-isXType' class='name expandable'>isXType</a>( <span class='pre'>xtype, [shallow]</span> ) : Boolean</div><div class='description'><div class='short'>Tests whether or not this Component is of a specific xtype. ...</div><div class='long'><p>Tests whether or not this Component is of a specific xtype. This can test whether this Component is descended\nfrom the xtype (default) or whether it is directly of the xtype specified (shallow = true).</p>\n\n\n<p><b>If using your own subclasses, be aware that a Component must register its own xtype\nto participate in determination of inherited xtypes.</b></p>\n\n\n<p>For a list of all available xtypes, see the <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> header.</p>\n\n\n<p>Example usage:</p>\n\n\n<pre><code>var t = new <a href=\"#!/api/Ext.form.TextField\" rel=\"Ext.form.TextField\" class=\"docClass\">Ext.form.TextField</a>();\nvar isText = t.isXType('textfield');        // true\nvar isBoxSubclass = t.isXType('box');       // true, descended from BoxComponent\nvar isBoxInstance = t.isXType('box', true); // false, not a direct BoxComponent instance\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : String/Ext.Component/Class<div class='sub-desc'><p>The xtype to check for this Component. Note that the the component can either be an instance\nor a component class:</p>\n\n<pre><code>var c = new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>();\nconsole.log(c.isXType(c));\nconsole.log(c.isXType(<a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>));\n</code></pre>\n\n</div></li><li><span class='pre'>shallow</span> : Boolean (optional)<div class='sub-desc'><p>False to check whether this Component is descended from the xtype (this is\nthe default), or true to check whether this Component is directly of the specified xtype.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if this component descends from the specified xtype, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-load' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-load' class='name expandable'>load</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Loads this content panel immediately with content returned from an XHR call. ...</div><div class='long'><p>Loads this content panel immediately with content returned from an XHR call.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A config object containing any of the following options:</p>\n\n<pre><code>panel.load({\n    url: 'your-url.php',\n    params: {param1: 'foo', param2: 'bar'}, // or a URL encoded string\n    callback: yourFunction,\n    scope: yourObject, // optional scope for the callback\n    discardUrl: false,\n    nocache: false,\n    text: 'Loading...',\n    timeout: 30,\n    scripts: false\n});\n</code></pre>\n\n\n<p>The only required property is url. The optional properties nocache, text and scripts\nare shorthand for disableCaching, indicatorText and loadScripts and are used to set their\nassociated property on this panel Updater instance.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-lookupComponent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-lookupComponent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-lookupComponent' class='name expandable'>lookupComponent</a>( <span class='pre'>comp</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>comp</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-makeFloating' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-makeFloating' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-makeFloating' class='name expandable'>makeFloating</a>( <span class='pre'>cfg</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mon' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mon' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mon' class='name expandable'>mon</a>( <span class='pre'>item, ename, fn, scope, opt</span> )</div><div class='description'><div class='short'>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. ...</div><div class='long'><p>Adds listeners to any Observable object (or Elements) which are automatically removed when this Component\nis destroyed. Usage:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), 'selectionchange', handleSelectionChange, null, {buffer: 50});\n</pre>\n\n\n<p></code></p>\n\n<p>or:</p>\n\n\n<p><code></p>\n\n<pre>myGridPanel.mon(myGridPanel.getSelectionModel(), {\n    selectionchange: handleSelectionChange,\n    buffer: 50\n});\n</pre>\n\n\n<p></code></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item to which to add a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li><li><span class='pre'>opt</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> options.</p>\n</div></li></ul></div></div></div><div id='method-mun' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-mun' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-mun' class='name expandable'>mun</a>( <span class='pre'>item, ename, fn, scope</span> )</div><div class='description'><div class='short'>Removes listeners that were added by the mon method. ...</div><div class='long'><p>Removes listeners that were added by the <a href=\"#!/api/Ext.Component-method-mon\" rel=\"Ext.Component-method-mon\" class=\"docClass\">mon</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Observable|Element<div class='sub-desc'><p>The item from which to remove a listener/listeners.</p>\n</div></li><li><span class='pre'>ename</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The event name, or an object containing event name properties.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the handler function.</p>\n</div></li><li><span class='pre'>scope</span> : Object<div class='sub-desc'><p>Optional. If the <code>ename</code> parameter was an event name, this\nis the scope (<code>this</code> reference) in which the handler function is executed.</p>\n</div></li></ul></div></div></div><div id='method-nextSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-nextSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-nextSibling' class='name expandable'>nextSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the next component in the owning container ...</div><div class='long'><p>Returns the next component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onAdd' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-onAdd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onAdd' class='name expandable'>onAdd</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onAdded' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-onAdded' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onAdded' class='name expandable'>onAdded</a>( <span class='pre'>container, pos</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private\n\nMethod to manage awareness of when components are added to their\nrespective Container, firing an added event. ...</div><div class='long'><p>private</p>\n\n<p>Method to manage awareness of when components are added to their\nrespective Container, firing an added event.\nReferences are established at add time rather than at render time.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>pos</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Component-method-onAdded' rel='Ext.Component-method-onAdded' class='docClass'>Ext.Component.onAdded</a></p></div></div></div><div id='method-onBeforeAdd' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-onBeforeAdd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onBeforeAdd' class='name expandable'>onBeforeAdd</a>( <span class='pre'>item</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onBodyResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-onBodyResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-onBodyResize' class='name expandable'>onBodyResize</a>( <span class='pre'>w, h</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>h</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onCollapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-onCollapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-onCollapse' class='name expandable'>onCollapse</a>( <span class='pre'>doAnim, animArg</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>doAnim</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>animArg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onDestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-onDestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-onDestroy' class='name expandable'>onDestroy</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onDisable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-onDisable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-onDisable' class='name expandable'>onDisable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.Panel-method-onDisable' rel='Ext.Panel-method-onDisable' class='docClass'>Ext.Panel.onDisable</a></p></div></div></div><div id='method-onDocMouseDown' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-onDocMouseDown' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-onDocMouseDown' class='name expandable'>onDocMouseDown</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onEnable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-onEnable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-onEnable' class='name expandable'>onEnable</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-onExpand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-onExpand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-onExpand' class='name expandable'>onExpand</a>( <span class='pre'>doAnim, animArg</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>doAnim</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>animArg</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onHide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-onHide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-onHide' class='name expandable'>onHide</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.Panel-method-onHide' rel='Ext.Panel-method-onHide' class='docClass'>Ext.Panel.onHide</a></p></div></div></div><div id='method-onLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-onLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-onLayout' class='name expandable'>onLayout</a>( <span class='pre'>shallow, force</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>shallow</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>force</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Container-method-onLayout' rel='Ext.Container-method-onLayout' class='docClass'>Ext.Container.onLayout</a></p></div></div></div><div id='method-onMouseMove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-onMouseMove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-onMouseMove' class='name expandable'>onMouseMove</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-onPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-onPosition' class='name expandable'>onPosition</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.BoxComponent-method-onPosition' rel='Ext.BoxComponent-method-onPosition' class='docClass'>Ext.BoxComponent.onPosition</a></p></div></div></div><div id='method-onRemove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-onRemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-onRemove' class='name expandable'>onRemove</a>( <span class='pre'>c</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>c</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onRemoved' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-onRemoved' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-onRemoved' class='name expandable'>onRemoved</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. ...</div><div class='long'><p>Method to manage awareness of when components are removed from their\nrespective Container, firing an removed event. References are properly\ncleaned up after removing a component from its owning container.</p>\n</div></div></div><div id='method-onRender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-onRender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-onRender' class='name expandable'>onRender</a>( <span class='pre'>ct, position</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ct</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>position</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Panel-method-onRender' rel='Ext.Panel-method-onRender' class='docClass'>Ext.Panel.onRender</a></p></div></div></div><div id='method-onResize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-onResize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-onResize' class='name expandable'>onResize</a>( <span class='pre'>adjWidth, adjHeight, rawWidth, rawHeight</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>adjWidth</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>adjHeight</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rawWidth</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>rawHeight</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.BoxComponent-method-onResize' rel='Ext.BoxComponent-method-onResize' class='docClass'>Ext.BoxComponent.onResize</a></p></div></div></div><div id='method-onShow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-onShow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-onShow' class='name expandable'>onShow</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<p>Overrides: <a href='#!/api/Ext.Panel-method-onShow' rel='Ext.Panel-method-onShow' class='docClass'>Ext.Panel.onShow</a></p></div></div></div><div id='method-onTargetOut' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-onTargetOut' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-onTargetOut' class='name expandable'>onTargetOut</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.ToolTip-method-onTargetOut' rel='Ext.ToolTip-method-onTargetOut' class='docClass'>Ext.ToolTip.onTargetOut</a></p></div></div></div><div id='method-onTargetOver' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-onTargetOver' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-onTargetOver' class='name expandable'>onTargetOver</a>( <span class='pre'>e</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>e</span> : Object<div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.ToolTip-method-onTargetOver' rel='Ext.ToolTip-method-onTargetOver' class='docClass'>Ext.ToolTip.onTargetOver</a></p></div></div></div><div id='method-previousSibling' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-previousSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-previousSibling' class='name expandable'>previousSibling</a>( <span class='pre'></span> ) : Object</div><div class='description'><div class='short'>Returns the previous component in the owning container ...</div><div class='long'><p>Returns the previous component in the owning container</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></p>\n</div></li></ul></div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-register' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-register' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-register' class='name expandable'>register</a>( <span class='pre'>config</span> )</div><div class='description'><div class='short'>Configures a new quick tip instance and assigns it to a target element. ...</div><div class='long'><p>Configures a new quick tip instance and assigns it to a target element.  The following config values are\nsupported (for example usage, see the <a href=\"#!/api/Ext.QuickTips\" rel=\"Ext.QuickTips\" class=\"docClass\">Ext.QuickTips</a> class header):</p>\n\n<div class=\"mdetail-params\"><ul>\n<li>autoHide</li>\n<li>cls</li>\n<li>dismissDelay (overrides the singleton value)</li>\n<li>target (required)</li>\n<li>text (required)</li>\n<li>title</li>\n<li>width</li></ul></div>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>The config object</p>\n</div></li></ul></div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-remove' class='name expandable'>remove</a>( <span class='pre'>component, [autoDestroy]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></div><div class='description'><div class='short'>Removes a component from this container. ...</div><div class='long'><p>Removes a component from this container.  Fires the <a href=\"#!/api/Ext.Container-event-beforeremove\" rel=\"Ext.Container-event-beforeremove\" class=\"docClass\">beforeremove</a> event before removing, then fires\nthe <a href=\"#!/api/Ext.Container-method-remove\" rel=\"Ext.Container-method-remove\" class=\"docClass\">remove</a> event after the component has been removed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>component</span> : Component/String<div class='sub-desc'><p>The component reference or id to remove.</p>\n</div></li><li><span class='pre'>autoDestroy</span> : Boolean (optional)<div class='sub-desc'><p>True to automatically invoke the removed Component's <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">Ext.Component.destroy</a> function.\nDefaults to the value of this Container's <a href=\"#!/api/Ext.Container-cfg-autoDestroy\" rel=\"Ext.Container-cfg-autoDestroy\" class=\"docClass\">autoDestroy</a> config.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>component The Component that was removed.</p>\n</div></li></ul></div></div></div><div id='method-removeAll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-removeAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-removeAll' class='name expandable'>removeAll</a>( <span class='pre'>[autoDestroy]</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Removes all components from this container. ...</div><div class='long'><p>Removes all components from this container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>autoDestroy</span> : Boolean (optional)<div class='sub-desc'><p>True to automatically invoke the removed Component's <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">Ext.Component.destroy</a> function.\nDefaults to the value of this Container's <a href=\"#!/api/Ext.Container-cfg-autoDestroy\" rel=\"Ext.Container-cfg-autoDestroy\" class=\"docClass\">autoDestroy</a> config.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>Array of the destroyed components</p>\n</div></li></ul></div></div></div><div id='method-removeClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-removeClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-removeClass' class='name expandable'>removeClass</a>( <span class='pre'>cls</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes a CSS class from the component's underlying element. ...</div><div class='long'><p>Removes a CSS class from the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>The CSS class name to remove</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-render' class='name expandable'>render</a>( <span class='pre'>[container], [position]</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Render this Component into the passed HTML element. ...</div><div class='long'><p>Render this Component into the passed HTML element.</p>\n\n\n<p><b>If you are using a <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a> object to house this Component, then\ndo not use the render method.</b></p>\n\n\n<p>A Container's child Components are rendered by that Container's\n<a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager when the Container is first rendered.</p>\n\n\n<p>Certain layout managers allow dynamic addition of child components. Those that do\ninclude <a href=\"#!/api/Ext.layout.CardLayout\" rel=\"Ext.layout.CardLayout\" class=\"docClass\">Ext.layout.CardLayout</a>, <a href=\"#!/api/Ext.layout.AnchorLayout\" rel=\"Ext.layout.AnchorLayout\" class=\"docClass\">Ext.layout.AnchorLayout</a>,\n<a href=\"#!/api/Ext.layout.FormLayout\" rel=\"Ext.layout.FormLayout\" class=\"docClass\">Ext.layout.FormLayout</a>, <a href=\"#!/api/Ext.layout.TableLayout\" rel=\"Ext.layout.TableLayout\" class=\"docClass\">Ext.layout.TableLayout</a>.</p>\n\n\n<p>If the Container is already rendered when a new child Component is added, you may need to call\nthe Container's <a href=\"#!/api/Ext.Container-method-doLayout\" rel=\"Ext.Container-method-doLayout\" class=\"docClass\">doLayout</a> to refresh the view which causes any\nunrendered child Components to be rendered. This is required so that you can add multiple\nchild components if needed while only refreshing the layout once.</p>\n\n\n<p>When creating complex UIs, it is important to remember that sizing and positioning\nof child items is the responsibility of the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> manager.\nIf you expect child items to be sized in response to user interactions, you must\nconfigure the Container with a layout manager which creates and manages the type of layout you\nhave in mind.</p>\n\n\n<p><b>Omitting the Container's <a href=\"#!/api/Ext.Container-cfg-layout\" rel=\"Ext.Container-cfg-layout\" class=\"docClass\">layout</a> config means that a basic\nlayout manager is used which does nothing but render child components sequentially into the\nContainer. No sizing or positioning will be performed in this situation.</b></p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>container</span> : Element/HTMLElement/String (optional)<div class='sub-desc'><p>The element this Component should be\nrendered into. If it is being created from existing markup, this should be omitted.</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>The element ID or DOM node index within the container <b>before</b>\nwhich this component will be inserted (defaults to appending to the end of the container)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setAutoScroll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setAutoScroll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setAutoScroll' class='name expandable'>setAutoScroll</a>( <span class='pre'>scroll</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the overflow on the content element of the component. ...</div><div class='long'><p>Sets the overflow on the content element of the component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scroll</span> : Boolean<div class='sub-desc'><p>True to allow the Component to auto scroll.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setDisabled' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setDisabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setDisabled' class='name expandable'>setDisabled</a>( <span class='pre'>disabled</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function for setting disabled/enabled by boolean. ...</div><div class='long'><p>Convenience function for setting disabled/enabled by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>disabled</span> : Boolean<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setHeight' class='name expandable'>setHeight</a>( <span class='pre'>height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the height of the component. ...</div><div class='long'><p>Sets the height of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style.</li>\n<li><i>undefined</i> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setIconClass' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-setIconClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-setIconClass' class='name expandable'>setIconClass</a>( <span class='pre'>cls</span> )</div><div class='description'><div class='short'>Sets the CSS class that provides the icon image for this panel. ...</div><div class='long'><p>Sets the CSS class that provides the icon image for this panel.  This method will replace any existing\nicon class if one has already been set and fire the <a href=\"#!/api/Ext.Panel-event-iconchange\" rel=\"Ext.Panel-event-iconchange\" class=\"docClass\">iconchange</a> event after completion.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new CSS class name</p>\n</div></li></ul></div></div></div><div id='method-setLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-setLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-setLayout' class='name expandable'>setLayout</a>( <span class='pre'>layout</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>layout</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setPagePosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-setPagePosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-setPagePosition' class='name expandable'>setPagePosition</a>( <span class='pre'>x, y</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>private\n\nSets the page XY position of the component. ...</div><div class='long'><p>private</p>\n\n<p>Sets the page XY position of the component.  To set the left and top instead, use <a href=\"#!/api/Ext.ToolTip-method-setPosition\" rel=\"Ext.ToolTip-method-setPosition\" class=\"docClass\">setPosition</a>.\nThis method fires the <a href=\"#!/api/Ext.ToolTip-event-move\" rel=\"Ext.ToolTip-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n\n\n\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n\n\n\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n\n\n\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.BoxComponent-method-setPagePosition' rel='Ext.BoxComponent-method-setPagePosition' class='docClass'>Ext.BoxComponent.setPagePosition</a></p></div></div></div><div id='method-setPosition' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setPosition' class='name expandable'>setPosition</a>( <span class='pre'>left, top</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the left and top of the component. ...</div><div class='long'><p>Sets the left and top of the component.  To set the page XY position instead, use <a href=\"#!/api/Ext.BoxComponent-method-setPagePosition\" rel=\"Ext.BoxComponent-method-setPagePosition\" class=\"docClass\">setPagePosition</a>.\nThis method fires the <a href=\"#!/api/Ext.BoxComponent-event-move\" rel=\"Ext.BoxComponent-event-move\" class=\"docClass\">move</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>left</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new left</p>\n</div></li><li><span class='pre'>top</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new top</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setSize' class='name expandable'>setSize</a>( <span class='pre'>width, height</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width and height of this BoxComponent. ...</div><div class='long'><p>Sets the width and height of this BoxComponent. This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event. This method can accept\neither width and height as separate arguments, or you can pass a size object like <code>{width:10, height:20}</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n<li>A size object in the format <code>{width: widthValue, height: heightValue}</code>.</li>\n<li><code>undefined</code> to leave the width unchanged.</li>\n</ul></div></p>\n</div></li><li><span class='pre'>height</span> : Mixed<div class='sub-desc'><p>The new height to set (not required if a size object is passed as the first arg).\nThis may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new height in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">Ext.Element.defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS height style. Animation may <b>not</b> be used.</li>\n<li><code>undefined</code> to leave the height unchanged.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setTitle' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-setTitle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-setTitle' class='name expandable'>setTitle</a>( <span class='pre'>title, [iconCls]</span> ) : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the title text for the panel and optionally the icon class. ...</div><div class='long'><p>Sets the title text for the panel and optionally the <a href=\"#!/api/Ext.Panel-cfg-iconCls\" rel=\"Ext.Panel-cfg-iconCls\" class=\"docClass\">icon class</a>.</p>\n\n\n<p>In order to be able to set the title, a header element must have been created\nfor the Panel. This is triggered either by configuring the Panel with a non-blank <code><a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">title</a></code>,\nor configuring it with <code><b><a href=\"#!/api/Ext.Panel-property-header\" rel=\"Ext.Panel-property-header\" class=\"docClass\">header</a>: true</b></code>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>title</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The title text to set</p>\n</div></li><li><span class='pre'>iconCls</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p><a href=\"#!/api/Ext.Panel-cfg-iconCls\" rel=\"Ext.Panel-cfg-iconCls\" class=\"docClass\">iconCls</a> A user-defined CSS class that provides the icon image for this panel</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setVisible' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-setVisible' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-setVisible' class='name expandable'>setVisible</a>( <span class='pre'>visible</span> ) : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Convenience function to hide or show this component by boolean. ...</div><div class='long'><p>Convenience function to hide or show this component by boolean.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>visible</span> : Boolean<div class='sub-desc'><p>True to show, false to hide</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setWidth' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-setWidth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-setWidth' class='name expandable'>setWidth</a>( <span class='pre'>width</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the width of the component. ...</div><div class='long'><p>Sets the width of the component.  This method fires the <a href=\"#!/api/Ext.BoxComponent-event-resize\" rel=\"Ext.BoxComponent-event-resize\" class=\"docClass\">resize</a> event.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>width</span> : Mixed<div class='sub-desc'><p>The new width to set. This may be one of:<div class=\"mdetail-params\"><ul>\n<li>A Number specifying the new width in the <a href=\"#!/api/Ext.BoxComponent-method-getEl\" rel=\"Ext.BoxComponent-method-getEl\" class=\"docClass\">Element</a>'s <a href=\"#!/api/Ext.Element-property-defaultUnit\" rel=\"Ext.Element-property-defaultUnit\" class=\"docClass\">defaultUnit</a>s (by default, pixels).</li>\n<li>A String used to set the CSS width style.</li>\n</ul></div></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-shouldBufferLayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-method-shouldBufferLayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-method-shouldBufferLayout' class='name expandable'>shouldBufferLayout</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-show' class='name expandable'>show</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Shows this tooltip at the current event target XY position. ...</div><div class='long'><p>Shows this tooltip at the current event target XY position.</p>\n<p>Overrides: <a href='#!/api/Ext.Component-method-show' rel='Ext.Component-method-show' class='docClass'>Ext.Component.show</a></p></div></div></div><div id='method-showAt' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-showAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-showAt' class='name expandable'>showAt</a>( <span class='pre'>xy</span> )</div><div class='description'><div class='short'>inherit docs\n\nShows this tip at the specified XY position. ...</div><div class='long'><p>inherit docs</p>\n\n<p>Shows this tip at the specified XY position.  Example usage:</p>\n\n<pre><code>// Show the tip at x:50 and y:100\ntip.showAt([50,100]);\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xy</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>An array containing the x and y coordinates</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.ToolTip-method-showAt' rel='Ext.ToolTip-method-showAt' class='docClass'>Ext.ToolTip.showAt</a></p></div></div></div><div id='method-showBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Tip' rel='Ext.Tip' class='defined-in docClass'>Ext.Tip</a><br/><a href='source/Tip.html#Ext-Tip-method-showBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Tip-method-showBy' class='name expandable'>showBy</a>( <span class='pre'>el, [position]</span> )</div><div class='description'><div class='short'>Experimental. ...</div><div class='long'><p><b>Experimental</b>. Shows this tip at a position relative to another element using a standard <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">Ext.Element.alignTo</a>\nanchor position value.  Example usage:</p>\n\n<pre><code>// Show the tip at the default position ('tl-br?')\ntip.showBy('my-el');\n\n// Show the tip's top-left corner anchored to the element's top-right corner\ntip.showBy('my-el', 'tl-tr');\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>An HTMLElement, <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> or string id of the target element to align to</p>\n</div></li><li><span class='pre'>position</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A valid <a href=\"#!/api/Ext.Element-method-alignTo\" rel=\"Ext.Element-method-alignTo\" class=\"docClass\">Ext.Element.alignTo</a> anchor position (defaults to 'tl-br?' or\n<a href=\"#!/api/Ext.Tip-cfg-defaultAlign\" rel=\"Ext.Tip-cfg-defaultAlign\" class=\"docClass\">defaultAlign</a> if specified).</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-syncAnchor' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.ToolTip' rel='Ext.ToolTip' class='defined-in docClass'>Ext.ToolTip</a><br/><a href='source/ToolTip.html#Ext-ToolTip-method-syncAnchor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ToolTip-method-syncAnchor' class='name expandable'>syncAnchor</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-syncHeight' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-syncHeight' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-syncHeight' class='name expandable'>syncHeight</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-syncShadow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-syncShadow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-syncShadow' class='name expandable'>syncShadow</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-syncSize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-syncSize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-syncSize' class='name expandable'>syncSize</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Force the component's size to recalculate based on the underlying element's current height and width. ...</div><div class='long'><p>Force the component's size to recalculate based on the underlying element's current height and width.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-toggleCollapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-method-toggleCollapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-method-toggleCollapse' class='name expandable'>toggleCollapse</a>( <span class='pre'>animate</span> ) : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Shortcut for performing an expand or collapse based on the current state of the panel. ...</div><div class='long'><p>Shortcut for performing an <a href=\"#!/api/Ext.Panel-event-expand\" rel=\"Ext.Panel-event-expand\" class=\"docClass\">expand</a> or <a href=\"#!/api/Ext.Panel-event-collapse\" rel=\"Ext.Panel-event-collapse\" class=\"docClass\">collapse</a> based on the current state of the panel.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>animate</span> : Boolean<div class='sub-desc'><p>True to animate the transition, else false (defaults to the value of the\n<a href=\"#!/api/Ext.Panel-cfg-animCollapse\" rel=\"Ext.Panel-cfg-animCollapse\" class=\"docClass\">animCollapse</a> panel config)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-unregister' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.QuickTip'>Ext.QuickTip</span><br/><a href='source/QuickTip.html#Ext-QuickTip-method-unregister' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.QuickTip-method-unregister' class='name expandable'>unregister</a>( <span class='pre'>el</span> )</div><div class='description'><div class='short'>Removes this quick tip from its element and destroys it. ...</div><div class='long'><p>Removes this quick tip from its element and destroys it.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : String/HTMLElement/Element<div class='sub-desc'><p>The element from which the quick tip is to be removed.</p>\n</div></li></ul></div></div></div><div id='method-update' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-method-update' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-method-update' class='name expandable'>update</a>( <span class='pre'>htmlOrData, loadScripts, callback</span> )</div><div class='description'><div class='short'>Update the content area of a component. ...</div><div class='long'><p>Update the content area of a component.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>htmlOrData</span> : Mixed<div class='sub-desc'><p>If this component has been configured with a template via the tpl config\nthen it will use this argument as data to populate the template.\nIf this component was not configured with a template, the components\ncontent area will be updated via <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> update</p>\n</div></li><li><span class='pre'>loadScripts</span> : Boolean<div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Defaults to false</p>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>(optional) Only legitimate when using the html configuration. Callback to execute when scripts have finished loading</p>\n</div></li></ul></div></div></div><div id='method-updateBox' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-method-updateBox' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-method-updateBox' class='name expandable'>updateBox</a>( <span class='pre'>box</span> ) : <a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Sets the current box measurements of the component's underlying element. ...</div><div class='long'><p>Sets the current box measurements of the component's underlying element.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>box</span> : Object<div class='sub-desc'><p>An object in the format {x, y, width, height}</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.BoxComponent\" rel=\"Ext.BoxComponent\" class=\"docClass\">Ext.BoxComponent</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-activate' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-activate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-activate' class='name expandable'>activate</a>( <span class='pre'>p</span> )</div><div class='description'><div class='short'>Fires after the Panel has been visually activated. ...</div><div class='long'><p>Fires after the Panel has been visually activated.\nNote that Panels do not directly support being activated, but some Panel subclasses\ndo (like <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>). Panels which are child Components of a TabPanel fire the\nactivate and deactivate events under the control of the TabPanel.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>The Panel that has been activated.</p>\n</div></li></ul></div></div></div><div id='event-add' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-event-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-add' class='name expandable'>add</a>( <span class='pre'>this, component, index</span> )</div><div class='description'><div class='short'>@bubbles\nFires after any Ext.Component is added or inserted into the container. ...</div><div class='long'><p>@bubbles\nFires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component that was added</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the component was added to the container's items collection</p>\n</div></li></ul></div></div></div><div id='event-added' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-added' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-added' class='name expandable'>added</a>( <span class='pre'>this, ownerCt, index</span> )</div><div class='description'><div class='short'>Fires when a component is added to an Ext.Container ...</div><div class='long'><p>Fires when a component is added to an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">number</a><div class='sub-desc'><p>Position at which the component was added</p>\n</div></li></ul></div></div></div><div id='event-afterlayout' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-event-afterlayout' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-afterlayout' class='name expandable'>afterlayout</a>( <span class='pre'>this, layout</span> )</div><div class='description'><div class='short'>Fires when the components in this container are arranged by the associated layout manager. ...</div><div class='long'><p>Fires when the components in this container are arranged by the associated layout manager.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>layout</span> : ContainerLayout<div class='sub-desc'><p>The ContainerLayout implementation for this container</p>\n</div></li></ul></div></div></div><div id='event-afterrender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-afterrender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-afterrender' class='name expandable'>afterrender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component rendering is finished. ...</div><div class='long'><p>Fires after the component rendering is finished.</p>\n\n\n<p>The afterrender event is fired after this Component has been <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>, been postprocesed\nby any afterRender method defined for the Component, and, if <a href=\"#!/api/Ext.Component-cfg-stateful\" rel=\"Ext.Component-cfg-stateful\" class=\"docClass\">stateful</a>, after state\nhas been restored.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeadd' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-event-beforeadd' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-beforeadd' class='name expandable'>beforeadd</a>( <span class='pre'>this, component, index</span> )</div><div class='description'><div class='short'>Fires before any Ext.Component is added or inserted into the container. ...</div><div class='long'><p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is added or inserted into the container.\nA handler can return false to cancel the add.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component being added</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index at which the component will be added to the container's items collection</p>\n</div></li></ul></div></div></div><div id='event-beforeclose' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-beforeclose' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-beforeclose' class='name expandable'>beforeclose</a>( <span class='pre'>p</span> )</div><div class='description'><div class='short'>Fires before the Panel is closed. ...</div><div class='long'><p>Fires before the Panel is closed.  Note that Panels do not directly support being closed, but some\nPanel subclasses do (like <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>) or a Panel within a <a href=\"#!/api/Ext.TabPanel\" rel=\"Ext.TabPanel\" class=\"docClass\">Ext.TabPanel</a>.  This event only\napplies to such subclasses.\nA handler can return false to cancel the close.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>The Panel being closed.</p>\n</div></li></ul></div></div></div><div id='event-beforecollapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-beforecollapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-beforecollapse' class='name expandable'>beforecollapse</a>( <span class='pre'>p, animate</span> )</div><div class='description'><div class='short'>Fires before the Panel is collapsed. ...</div><div class='long'><p>Fires before the Panel is collapsed.  A handler can return false to cancel the collapse.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>the Panel being collapsed.</p>\n</div></li><li><span class='pre'>animate</span> : Boolean<div class='sub-desc'><p>True if the collapse is animated, else false.</p>\n</div></li></ul></div></div></div><div id='event-beforedestroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforedestroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforedestroy' class='name expandable'>beforedestroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is destroyed. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed. Return false from an event handler to stop the <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeexpand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-beforeexpand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-beforeexpand' class='name expandable'>beforeexpand</a>( <span class='pre'>p, animate</span> )</div><div class='description'><div class='short'>Fires before the Panel is expanded. ...</div><div class='long'><p>Fires before the Panel is expanded.  A handler can return false to cancel the expand.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>The Panel being expanded.</p>\n</div></li><li><span class='pre'>animate</span> : Boolean<div class='sub-desc'><p>True if the expand is animated, else false.</p>\n</div></li></ul></div></div></div><div id='event-beforehide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforehide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforehide' class='name expandable'>beforehide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is hidden by calling the hide method. ...</div><div class='long'><p>Fires before the component is hidden by calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.\nReturn false from an event handler to stop the hide.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeremove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-event-beforeremove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-beforeremove' class='name expandable'>beforeremove</a>( <span class='pre'>this, component</span> )</div><div class='description'><div class='short'>Fires before any Ext.Component is removed from the container. ...</div><div class='long'><p>Fires before any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.  A handler can return\nfalse to cancel the remove.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component being removed</p>\n</div></li></ul></div></div></div><div id='event-beforerender' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforerender' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforerender' class='name expandable'>beforerender</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is rendered. ...</div><div class='long'><p>Fires before the component is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>. Return false from an\nevent handler to stop the <a href=\"#!/api/Ext.Component-method-render\" rel=\"Ext.Component-method-render\" class=\"docClass\">render</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforeshow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforeshow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforeshow' class='name expandable'>beforeshow</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires before the component is shown by calling the show method. ...</div><div class='long'><p>Fires before the component is shown by calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.\nReturn false from an event handler to stop the show.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-beforestaterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestaterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestaterestore' class='name expandable'>beforestaterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is restored. ...</div><div class='long'><p>Fires before the state of the component is restored. Return false from an event handler to stop the restore.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. If this\nevent is not vetoed, then the state object is passed to <b><tt>applyState</tt></b>. By default,\nthat simply copies property values into this Component. The method maybe overriden to\nprovide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-beforestatesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-beforestatesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-beforestatesave' class='name expandable'>beforestatesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires before the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires before the state of the component is saved to the configured state provider. Return false to stop the save.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div><div id='event-bodyresize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-bodyresize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-bodyresize' class='name expandable'>bodyresize</a>( <span class='pre'>p, width, height</span> )</div><div class='description'><div class='short'>Fires after the Panel has been resized. ...</div><div class='long'><p>Fires after the Panel has been resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>the Panel which has been resized.</p>\n</div></li><li><span class='pre'>width</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The Panel body's new width.</p>\n</div></li><li><span class='pre'>height</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The Panel body's new height.</p>\n</div></li></ul></div></div></div><div id='event-close' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-close' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-close' class='name expandable'>close</a>( <span class='pre'>p</span> )</div><div class='description'><div class='short'>Fires after the Panel is closed. ...</div><div class='long'><p>Fires after the Panel is closed.  Note that Panels do not directly support being closed, but some\nPanel subclasses do (like <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>) or a Panel within a <a href=\"#!/api/Ext.TabPanel\" rel=\"Ext.TabPanel\" class=\"docClass\">Ext.TabPanel</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>The Panel that has been closed.</p>\n</div></li></ul></div></div></div><div id='event-collapse' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-collapse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-collapse' class='name expandable'>collapse</a>( <span class='pre'>p</span> )</div><div class='description'><div class='short'>Fires after the Panel has been collapsed. ...</div><div class='long'><p>Fires after the Panel has been collapsed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>the Panel that has been collapsed.</p>\n</div></li></ul></div></div></div><div id='event-deactivate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-deactivate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-deactivate' class='name expandable'>deactivate</a>( <span class='pre'>p</span> )</div><div class='description'><div class='short'>Fires after the Panel has been visually deactivated. ...</div><div class='long'><p>Fires after the Panel has been visually deactivated.\nNote that Panels do not directly support being deactivated, but some Panel subclasses\ndo (like <a href=\"#!/api/Ext.Window\" rel=\"Ext.Window\" class=\"docClass\">Ext.Window</a>). Panels which are child Components of a TabPanel fire the\nactivate and deactivate events under the control of the TabPanel.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>The Panel that has been deactivated.</p>\n</div></li></ul></div></div></div><div id='event-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-destroy' class='name expandable'>destroy</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is destroyed. ...</div><div class='long'><p>Fires after the component is <a href=\"#!/api/Ext.Component-event-destroy\" rel=\"Ext.Component-event-destroy\" class=\"docClass\">destroy</a>ed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-disable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-disable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-disable' class='name expandable'>disable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is disabled. ...</div><div class='long'><p>Fires after the component is disabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-enable' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-enable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-enable' class='name expandable'>enable</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is enabled. ...</div><div class='long'><p>Fires after the component is enabled.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-expand' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-expand' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-expand' class='name expandable'>expand</a>( <span class='pre'>p</span> )</div><div class='description'><div class='short'>Fires after the Panel has been expanded. ...</div><div class='long'><p>Fires after the Panel has been expanded.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>The Panel that has been expanded.</p>\n</div></li></ul></div></div></div><div id='event-hide' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-hide' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-hide' class='name expandable'>hide</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is hidden. ...</div><div class='long'><p>Fires after the component is hidden.\nFires after the component is hidden when calling the <a href=\"#!/api/Ext.Component-method-hide\" rel=\"Ext.Component-method-hide\" class=\"docClass\">hide</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-iconchange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-iconchange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-iconchange' class='name expandable'>iconchange</a>( <span class='pre'>p, newIcon, oldIcon</span> )</div><div class='description'><div class='short'>Fires after the Panel icon class has been set or changed. ...</div><div class='long'><p>Fires after the Panel icon class has been <a href=\"#!/api/Ext.Panel-cfg-iconCls\" rel=\"Ext.Panel-cfg-iconCls\" class=\"docClass\">set</a> or <a href=\"#!/api/Ext.Panel-method-setIconClass\" rel=\"Ext.Panel-method-setIconClass\" class=\"docClass\">changed</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>the Panel which has had its <a href=\"#!/api/Ext.Panel-cfg-iconCls\" rel=\"Ext.Panel-cfg-iconCls\" class=\"docClass\">icon class</a> changed.</p>\n</div></li><li><span class='pre'>newIcon</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new icon class.</p>\n</div></li><li><span class='pre'>oldIcon</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The old icon class.</p>\n</div></li></ul></div></div></div><div id='event-move' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-move' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-move' class='name expandable'>move</a>( <span class='pre'>this, x, y</span> )</div><div class='description'><div class='short'>Fires after the component is moved. ...</div><div class='long'><p>Fires after the component is moved.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>x</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new x position</p>\n</div></li><li><span class='pre'>y</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The new y position</p>\n</div></li></ul></div></div></div><div id='event-remove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Container' rel='Ext.Container' class='defined-in docClass'>Ext.Container</a><br/><a href='source/Container.html#Ext-Container-event-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Container-event-remove' class='name expandable'>remove</a>( <span class='pre'>this, component</span> )</div><div class='description'><div class='short'>@bubbles\nFires after any Ext.Component is removed from the container. ...</div><div class='long'><p>@bubbles\nFires after any <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> is removed from the container.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'>\n</div></li><li><span class='pre'>component</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'><p>The component that was removed</p>\n</div></li></ul></div></div></div><div id='event-removed' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-removed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-removed' class='name expandable'>removed</a>( <span class='pre'>this, ownerCt</span> )</div><div class='description'><div class='short'>Fires when a component is removed from an Ext.Container ...</div><div class='long'><p>Fires when a component is removed from an <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>ownerCt</span> : <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a><div class='sub-desc'><p>Container which holds the component</p>\n</div></li></ul></div></div></div><div id='event-render' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-render' class='name expandable'>render</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component markup is rendered. ...</div><div class='long'><p>Fires after the component markup is <a href=\"#!/api/Ext.Component-property-rendered\" rel=\"Ext.Component-property-rendered\" class=\"docClass\">rendered</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-resize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.BoxComponent' rel='Ext.BoxComponent' class='defined-in docClass'>Ext.BoxComponent</a><br/><a href='source/BoxComponent.html#Ext-BoxComponent-event-resize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.BoxComponent-event-resize' class='name expandable'>resize</a>( <span class='pre'>this, adjWidth, adjHeight, rawWidth, rawHeight</span> )</div><div class='description'><div class='short'>Fires after the component is resized. ...</div><div class='long'><p>Fires after the component is resized.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>adjWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted width that was set</p>\n</div></li><li><span class='pre'>adjHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The box-adjusted height that was set</p>\n</div></li><li><span class='pre'>rawWidth</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The width that was originally specified</p>\n</div></li><li><span class='pre'>rawHeight</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The height that was originally specified</p>\n</div></li></ul></div></div></div><div id='event-show' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-show' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-show' class='name expandable'>show</a>( <span class='pre'>this</span> )</div><div class='description'><div class='short'>Fires after the component is shown when calling the show method. ...</div><div class='long'><p>Fires after the component is shown when calling the <a href=\"#!/api/Ext.Component-method-show\" rel=\"Ext.Component-method-show\" class=\"docClass\">show</a> method.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='event-staterestore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-staterestore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-staterestore' class='name expandable'>staterestore</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is restored. ...</div><div class='long'><p>Fires after the state of the component is restored.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values returned from the StateProvider. This is passed\nto <b><tt>applyState</tt></b>. By default, that simply copies property values into this\nComponent. The method maybe overriden to provide custom state restoration.</p>\n</div></li></ul></div></div></div><div id='event-statesave' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Component' rel='Ext.Component' class='defined-in docClass'>Ext.Component</a><br/><a href='source/Component.html#Ext-Component-event-statesave' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Component-event-statesave' class='name expandable'>statesave</a>( <span class='pre'>this, state</span> )</div><div class='description'><div class='short'>Fires after the state of the component is saved to the configured state provider. ...</div><div class='long'><p>Fires after the state of the component is saved to the configured state provider.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>this</span> : <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a><div class='sub-desc'>\n</div></li><li><span class='pre'>state</span> : Object<div class='sub-desc'><p>The hash of state values. This is determined by calling\n<b><tt>getState()</tt></b> on the Component. This method must be provided by the\ndeveloper to return whetever representation of state is required, by default, <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\nhas a null implementation.</p>\n</div></li></ul></div></div></div><div id='event-titlechange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Panel' rel='Ext.Panel' class='defined-in docClass'>Ext.Panel</a><br/><a href='source/Panel.html#Ext-Panel-event-titlechange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Panel-event-titlechange' class='name expandable'>titlechange</a>( <span class='pre'>p, The</span> )</div><div class='description'><div class='short'>Fires after the Panel title has been set or changed. ...</div><div class='long'><p>Fires after the Panel title has been <a href=\"#!/api/Ext.Panel-cfg-title\" rel=\"Ext.Panel-cfg-title\" class=\"docClass\">set</a> or <a href=\"#!/api/Ext.Panel-method-setTitle\" rel=\"Ext.Panel-method-setTitle\" class=\"docClass\">changed</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>p</span> : <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a><div class='sub-desc'><p>the Panel which has had its title changed.</p>\n</div></li><li><span class='pre'>The</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>new title.</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable","Ext.Component","Ext.BoxComponent","Ext.Container","Ext.Panel","Ext.Tip","Ext.ToolTip"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"QuickTip.html#Ext-QuickTip","filename":"QuickTip.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.Tip","meta":{"private":true},"name":"autoRender","id":"property-autoRender"},{"tagname":"property","owner":"Ext.Panel","meta":{},"name":"body","id":"property-body"},{"tagname":"property","owner":"Ext.BoxComponent","meta":{"private":true},"name":"boxReady","id":"property-boxReady"},{"tagname":"property","owner":"Ext.Panel","meta":{},"name":"buttons","id":"property-buttons"},{"tagname":"property","owner":"Ext.Panel","meta":{},"name":"bwrap","id":"property-bwrap"},{"tagname":"property","owner":"Ext.Tip","meta":{"private":true},"name":"closeAction","id":"property-closeAction"},{"tagname":"property","owner":"Ext.Panel","meta":{"private":true},"name":"collapseDefaults","id":"property-collapseDefaults"},{"tagname":"property","owner":"Ext.Panel","meta":{"private":true},"name":"collapseEl","id":"property-collapseEl"},{"tagname":"property","owner":"Ext.Panel","meta":{},"name":"collapsed","id":"property-collapsed"},{"tagname":"property","owner":"Ext.ToolTip","meta":{"private":true},"name":"constrainPosition","id":"property-constrainPosition"},{"tagname":"property","owner":"Ext.Panel","meta":{},"name":"dd","id":"property-dd"},{"tagname":"property","owner":"Ext.Panel","meta":{"private":true},"name":"deferHeight","id":"property-deferHeight"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"disabled","id":"property-disabled"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"el","id":"property-el"},{"tagname":"property","owner":"Ext.Panel","meta":{"private":true},"name":"expandDefaults","id":"property-expandDefaults"},{"tagname":"property","owner":"Ext.Panel","meta":{},"name":"footer","id":"property-footer"},{"tagname":"property","owner":"Ext.Panel","meta":{},"name":"header","id":"property-header"},{"tagname":"property","owner":"Ext.Tip","meta":{},"name":"hidden","id":"property-hidden"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"initialConfig","id":"property-initialConfig"},{"tagname":"property","owner":"Ext.Container","meta":{},"name":"items","id":"property-items"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"ownerCt","id":"property-ownerCt"},{"tagname":"property","owner":"Ext.Tip","meta":{"private":true},"name":"quickShowInterval","id":"property-quickShowInterval"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"refOwner","id":"property-refOwner"},{"tagname":"property","owner":"Ext.Component","meta":{},"name":"rendered","id":"property-rendered"},{"tagname":"property","owner":"Ext.Panel","meta":{"private":true},"name":"slideAnchor","id":"property-slideAnchor"},{"tagname":"property","owner":"Ext.QuickTip","meta":{"private":true},"name":"tagConfig","id":"property-tagConfig"},{"tagname":"property","owner":"Ext.ToolTip","meta":{"private":true},"name":"targetCounter","id":"property-targetCounter"},{"tagname":"property","owner":"Ext.Panel","meta":{"private":true},"name":"toolTarget","id":"property-toolTarget"},{"tagname":"property","owner":"Ext.ToolTip","meta":{},"name":"triggerElement","id":"property-triggerElement"}],"cfg":[{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"activeItem","id":"cfg-activeItem"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"allowDomMove","id":"cfg-allowDomMove"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"anchor","id":"cfg-anchor"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"anchorOffset","id":"cfg-anchorOffset"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"anchorToTarget","id":"cfg-anchorToTarget"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"animCollapse","id":"cfg-animCollapse"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"applyTo","id":"cfg-applyTo"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"autoDestroy","id":"cfg-autoDestroy"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"autoHeight","id":"cfg-autoHeight"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"autoHeight","id":"cfg-autoHeight"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"autoHide","id":"cfg-autoHide"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"autoLoad","id":"cfg-autoLoad"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoScroll","id":"cfg-autoScroll"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"autoShow","id":"cfg-autoShow"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"autoWidth","id":"cfg-autoWidth"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"baseCls","id":"cfg-baseCls"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"baseCls","id":"cfg-baseCls"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"bbar","id":"cfg-bbar"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"bbarCfg","id":"cfg-bbarCfg"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"bodyBorder","id":"cfg-bodyBorder"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"bodyCfg","id":"cfg-bodyCfg"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"bodyCssClass","id":"cfg-bodyCssClass"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"bodyStyle","id":"cfg-bodyStyle"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"border","id":"cfg-border"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxHeight","id":"cfg-boxMaxHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMaxWidth","id":"cfg-boxMaxWidth"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinHeight","id":"cfg-boxMinHeight"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"boxMinWidth","id":"cfg-boxMinWidth"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"bubbleEvents","id":"cfg-bubbleEvents"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"bufferResize","id":"cfg-bufferResize"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"buttonAlign","id":"cfg-buttonAlign"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"buttons","id":"cfg-buttons"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"bwrapCfg","id":"cfg-bwrapCfg"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"clearCls","id":"cfg-clearCls"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"closable","id":"cfg-closable"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"cls","id":"cfg-cls"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"collapseFirst","id":"cfg-collapseFirst"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"collapsed","id":"cfg-collapsed"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"collapsedCls","id":"cfg-collapsedCls"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"collapsible","id":"cfg-collapsible"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"contentEl","id":"cfg-contentEl"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ctCls","id":"cfg-ctCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"data","id":"cfg-data"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"defaultAlign","id":"cfg-defaultAlign"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"defaultType","id":"cfg-defaultType"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"defaults","id":"cfg-defaults"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"delegate","id":"cfg-delegate"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"disabled","id":"cfg-disabled"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"disabledClass","id":"cfg-disabledClass"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"dismissDelay","id":"cfg-dismissDelay"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"draggable","id":"cfg-draggable"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"elements","id":"cfg-elements"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"fbar","id":"cfg-fbar"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"fieldLabel","id":"cfg-fieldLabel"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"flex","id":"cfg-flex"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"floating","id":"cfg-floating"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"floating","id":"cfg-floating"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"footer","id":"cfg-footer"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"footerCfg","id":"cfg-footerCfg"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"forceLayout","id":"cfg-forceLayout"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"frame","id":"cfg-frame"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"frame","id":"cfg-frame"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"header","id":"cfg-header"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"headerAsText","id":"cfg-headerAsText"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"headerCfg","id":"cfg-headerCfg"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"height","id":"cfg-height"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hidden","id":"cfg-hidden"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"hideBorders","id":"cfg-hideBorders"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"hideCollapseTool","id":"cfg-hideCollapseTool"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"hideDelay","id":"cfg-hideDelay"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideLabel","id":"cfg-hideLabel"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideMode","id":"cfg-hideMode"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"hideParent","id":"cfg-hideParent"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"html","id":"cfg-html"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"iconCls","id":"cfg-iconCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"id","id":"cfg-id"},{"tagname":"cfg","owner":"Ext.QuickTip","meta":{},"name":"interceptTitles","id":"cfg-interceptTitles"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemCls","id":"cfg-itemCls"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"itemId","id":"cfg-itemId"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"items","id":"cfg-items"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"keys","id":"cfg-keys"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelSeparator","id":"cfg-labelSeparator"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"labelStyle","id":"cfg-labelStyle"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"layout","id":"cfg-layout"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"layoutConfig","id":"cfg-layoutConfig"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"margins","id":"cfg-margins"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"maskDisabled","id":"cfg-maskDisabled"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"maxWidth","id":"cfg-maxWidth"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"minButtonWidth","id":"cfg-minButtonWidth"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"minWidth","id":"cfg-minWidth"},{"tagname":"cfg","owner":"Ext.Container","meta":{},"name":"monitorResize","id":"cfg-monitorResize"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"mouseOffset","id":"cfg-mouseOffset"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"overCls","id":"cfg-overCls"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"padding","id":"cfg-padding"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageX","id":"cfg-pageX"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"pageY","id":"cfg-pageY"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"plugins","id":"cfg-plugins"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"preventBodyReset","id":"cfg-preventBodyReset"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ptype","id":"cfg-ptype"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"ref","id":"cfg-ref"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"region","id":"cfg-region"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"renderTo","id":"cfg-renderTo"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"resizeEvent","id":"cfg-resizeEvent"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"shadow","id":"cfg-shadow"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"shadowOffset","id":"cfg-shadowOffset"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"shim","id":"cfg-shim"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"showDelay","id":"cfg-showDelay"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateEvents","id":"cfg-stateEvents"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateId","id":"cfg-stateId"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"stateful","id":"cfg-stateful"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"style","id":"cfg-style"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"tabTip","id":"cfg-tabTip"},{"tagname":"cfg","owner":"Ext.QuickTip","meta":{},"name":"target","id":"cfg-target"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"tbar","id":"cfg-tbar"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"tbarCfg","id":"cfg-tbarCfg"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"title","id":"cfg-title"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"titleCollapse","id":"cfg-titleCollapse"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"toolTemplate","id":"cfg-toolTemplate"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"tools","id":"cfg-tools"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"tpl","id":"cfg-tpl"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"tplWriteMode","id":"cfg-tplWriteMode"},{"tagname":"cfg","owner":"Ext.ToolTip","meta":{},"name":"trackMouse","id":"cfg-trackMouse"},{"tagname":"cfg","owner":"Ext.Panel","meta":{},"name":"unstyled","id":"cfg-unstyled"},{"tagname":"cfg","owner":"Ext.Tip","meta":{},"name":"width","id":"cfg-width"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"x","id":"cfg-x"},{"tagname":"cfg","owner":"Ext.Component","meta":{},"name":"xtype","id":"cfg-xtype"},{"tagname":"cfg","owner":"Ext.BoxComponent","meta":{},"name":"y","id":"cfg-y"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.QuickTip","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"add","id":"method-add"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"addButton","id":"method-addButton"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"addClass","id":"method-addClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"addTool","id":"method-addTool"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"adjustBodyHeight","id":"method-adjustBodyHeight"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"adjustBodyWidth","id":"method-adjustBodyWidth"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"adjustPosition","id":"method-adjustPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"private":true},"name":"adjustSize","id":"method-adjustSize"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"afterCollapse","id":"method-afterCollapse"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"afterEffect","id":"method-afterEffect"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"afterExpand","id":"method-afterExpand"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"afterRender","id":"method-afterRender"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"applyDefaults","id":"method-applyDefaults"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"applyToMarkup","id":"method-applyToMarkup"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"beforeDestroy","id":"method-beforeDestroy"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"beforeEffect","id":"method-beforeEffect"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"bubble","id":"method-bubble"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"canLayout","id":"method-canLayout"},{"tagname":"method","owner":"Ext.QuickTip","meta":{},"name":"cancelShow","id":"method-cancelShow"},{"tagname":"method","owner":"Ext.Container","meta":{"chainable":true},"name":"cascade","id":"method-cascade"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"clearTimer","id":"method-clearTimer"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"clearTimers","id":"method-clearTimers"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"cloneConfig","id":"method-cloneConfig"},{"tagname":"method","owner":"Ext.Panel","meta":{"chainable":true},"name":"collapse","id":"method-collapse"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"createClasses","id":"method-createClasses"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"createComponent","id":"method-createComponent"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"createEffect","id":"method-createEffect"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"createElement","id":"method-createElement"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"createFbar","id":"method-createFbar"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"createGhost","id":"method-createGhost"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"createToolHandler","id":"method-createToolHandler"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"createToolbar","id":"method-createToolbar"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"delayHide","id":"method-delayHide"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"delayShow","id":"method-delayShow"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"disable","id":"method-disable"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"doAutoLoad","id":"method-doAutoLoad"},{"tagname":"method","owner":"Ext.Tip","meta":{"private":true},"name":"doAutoWidth","id":"method-doAutoWidth"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"doEnable","id":"method-doEnable"},{"tagname":"method","owner":"Ext.Container","meta":{"chainable":true},"name":"doLayout","id":"method-doLayout"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"doRemove","id":"method-doRemove"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"enable","id":"method-enable"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.Panel","meta":{"chainable":true},"name":"expand","id":"method-expand"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"find","id":"method-find"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"findBy","id":"method-findBy"},{"tagname":"method","owner":"Ext.Container","meta":{"deprecated":{"text":"Fairly useless method, since you can just use Ext.getCmp. Should be removed for 4.0\nIf you need to test if an id belongs to a container, you can use getCmp and findParent*."}},"name":"findById","id":"method-findById"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"findByType","id":"method-findByType"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentBy","id":"method-findParentBy"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"findParentByType","id":"method-findParentByType"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"focus","id":"method-focus"},{"tagname":"method","owner":"Ext.Container","meta":{"deprecated":{"text":"Should be removed in 4.0, since getComponent does the same thing."}},"name":"get","id":"method-get"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"getAnchorAlign","id":"method-getAnchorAlign"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"getAnchorPosition","id":"method-getAnchorPosition"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getBottomToolbar","id":"method-getBottomToolbar"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getBox","id":"method-getBox"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getBubbleTarget","id":"method-getBubbleTarget"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"getComponent","id":"method-getComponent"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"getComponentId","id":"method-getComponentId"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"getContentTarget","id":"method-getContentTarget"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getEl","id":"method-getEl"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getFooterToolbar","id":"method-getFooterToolbar"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getFrameHeight","id":"method-getFrameHeight"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getFrameWidth","id":"method-getFrameWidth"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getHeight","id":"method-getHeight"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getId","id":"method-getId"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getInnerHeight","id":"method-getInnerHeight"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getInnerWidth","id":"method-getInnerWidth"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getItemId","id":"method-getItemId"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"getKeyMap","id":"method-getKeyMap"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"getLayout","id":"method-getLayout"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getLayoutTarget","id":"method-getLayoutTarget"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"getMouseOffset","id":"method-getMouseOffset"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"getOffsets","id":"method-getOffsets"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getOuterSize","id":"method-getOuterSize"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getPosition","id":"method-getPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getResizeEl","id":"method-getResizeEl"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getSize","id":"method-getSize"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"getTargetXY","id":"method-getTargetXY"},{"tagname":"method","owner":"Ext.QuickTip","meta":{"private":true},"name":"getTipCfg","id":"method-getTipCfg"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getTool","id":"method-getTool"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"getToolbarHeight","id":"method-getToolbarHeight"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getTopToolbar","id":"method-getTopToolbar"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"getUpdater","id":"method-getUpdater"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{},"name":"getWidth","id":"method-getWidth"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXType","id":"method-getXType"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"getXTypes","id":"method-getXTypes"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"hasLayoutPending","id":"method-hasLayoutPending"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.QuickTip","meta":{},"name":"hide","id":"method-hide"},{"tagname":"method","owner":"Ext.QuickTip","meta":{"private":true},"name":"initComponent","id":"method-initComponent"},{"tagname":"method","owner":"Ext.Tip","meta":{"private":true},"name":"initDraggable","id":"method-initDraggable"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"initEvents","id":"method-initEvents"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"initItems","id":"method-initItems"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"initRef","id":"method-initRef"},{"tagname":"method","owner":"Ext.ToolTip","meta":{},"name":"initTarget","id":"method-initTarget"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"insert","id":"method-insert"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isVisible","id":"method-isVisible"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"isXType","id":"method-isXType"},{"tagname":"method","owner":"Ext.Panel","meta":{"chainable":true},"name":"load","id":"method-load"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"lookupComponent","id":"method-lookupComponent"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"makeFloating","id":"method-makeFloating"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mon","id":"method-mon"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"mun","id":"method-mun"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"nextSibling","id":"method-nextSibling"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onAdd","id":"method-onAdd"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onAdded","id":"method-onAdded"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onBeforeAdd","id":"method-onBeforeAdd"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"onBodyResize","id":"method-onBodyResize"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"onCollapse","id":"method-onCollapse"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"onDestroy","id":"method-onDestroy"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"onDisable","id":"method-onDisable"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"onDocMouseDown","id":"method-onDocMouseDown"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"onEnable","id":"method-onEnable"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"onExpand","id":"method-onExpand"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"onHide","id":"method-onHide"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"onLayout","id":"method-onLayout"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"onMouseMove","id":"method-onMouseMove"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"onPosition","id":"method-onPosition"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"onRemove","id":"method-onRemove"},{"tagname":"method","owner":"Ext.Component","meta":{"private":true},"name":"onRemoved","id":"method-onRemoved"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"onRender","id":"method-onRender"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"onResize","id":"method-onResize"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"onShow","id":"method-onShow"},{"tagname":"method","owner":"Ext.QuickTip","meta":{"private":true},"name":"onTargetOut","id":"method-onTargetOut"},{"tagname":"method","owner":"Ext.QuickTip","meta":{"private":true},"name":"onTargetOver","id":"method-onTargetOver"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"previousSibling","id":"method-previousSibling"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.QuickTip","meta":{},"name":"register","id":"method-register"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"remove","id":"method-remove"},{"tagname":"method","owner":"Ext.Container","meta":{},"name":"removeAll","id":"method-removeAll"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"removeClass","id":"method-removeClass"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"render","id":"method-render"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setAutoScroll","id":"method-setAutoScroll"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setDisabled","id":"method-setDisabled"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setHeight","id":"method-setHeight"},{"tagname":"method","owner":"Ext.Panel","meta":{},"name":"setIconClass","id":"method-setIconClass"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"setLayout","id":"method-setLayout"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"chainable":true},"name":"setPagePosition","id":"method-setPagePosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setPosition","id":"method-setPosition"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setSize","id":"method-setSize"},{"tagname":"method","owner":"Ext.Panel","meta":{"chainable":true},"name":"setTitle","id":"method-setTitle"},{"tagname":"method","owner":"Ext.Component","meta":{"chainable":true},"name":"setVisible","id":"method-setVisible"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"setWidth","id":"method-setWidth"},{"tagname":"method","owner":"Ext.Container","meta":{"private":true},"name":"shouldBufferLayout","id":"method-shouldBufferLayout"},{"tagname":"method","owner":"Ext.ToolTip","meta":{},"name":"show","id":"method-show"},{"tagname":"method","owner":"Ext.QuickTip","meta":{},"name":"showAt","id":"method-showAt"},{"tagname":"method","owner":"Ext.Tip","meta":{},"name":"showBy","id":"method-showBy"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.ToolTip","meta":{"private":true},"name":"syncAnchor","id":"method-syncAnchor"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"syncHeight","id":"method-syncHeight"},{"tagname":"method","owner":"Ext.Panel","meta":{"private":true},"name":"syncShadow","id":"method-syncShadow"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"syncSize","id":"method-syncSize"},{"tagname":"method","owner":"Ext.Panel","meta":{"chainable":true},"name":"toggleCollapse","id":"method-toggleCollapse"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"},{"tagname":"method","owner":"Ext.QuickTip","meta":{},"name":"unregister","id":"method-unregister"},{"tagname":"method","owner":"Ext.Component","meta":{},"name":"update","id":"method-update"},{"tagname":"method","owner":"Ext.BoxComponent","meta":{"chainable":true},"name":"updateBox","id":"method-updateBox"}],"event":[{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"activate","id":"event-activate"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"add","id":"event-add"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"added","id":"event-added"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"afterlayout","id":"event-afterlayout"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"afterrender","id":"event-afterrender"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"beforeadd","id":"event-beforeadd"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"beforeclose","id":"event-beforeclose"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"beforecollapse","id":"event-beforecollapse"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforedestroy","id":"event-beforedestroy"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"beforeexpand","id":"event-beforeexpand"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforehide","id":"event-beforehide"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"beforeremove","id":"event-beforeremove"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforerender","id":"event-beforerender"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforeshow","id":"event-beforeshow"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestaterestore","id":"event-beforestaterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"beforestatesave","id":"event-beforestatesave"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"bodyresize","id":"event-bodyresize"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"close","id":"event-close"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"collapse","id":"event-collapse"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"deactivate","id":"event-deactivate"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"destroy","id":"event-destroy"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"disable","id":"event-disable"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"enable","id":"event-enable"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"expand","id":"event-expand"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"hide","id":"event-hide"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"iconchange","id":"event-iconchange"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"move","id":"event-move"},{"tagname":"event","owner":"Ext.Container","meta":{},"name":"remove","id":"event-remove"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"removed","id":"event-removed"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"render","id":"event-render"},{"tagname":"event","owner":"Ext.BoxComponent","meta":{},"name":"resize","id":"event-resize"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"show","id":"event-show"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"staterestore","id":"event-staterestore"},{"tagname":"event","owner":"Ext.Component","meta":{},"name":"statesave","id":"event-statesave"},{"tagname":"event","owner":"Ext.Panel","meta":{},"name":"titlechange","id":"event-titlechange"}],"css_mixin":[]},"inheritable":null,"private":null,"component":true,"name":"Ext.QuickTip","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.QuickTip","mixins":[],"mixedInto":[]});