/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTileSelf
implements Tile {
    private final LivingSpace livingSpace1;
    private final Message message;
    private final Skin skin;
    private final ISkinParam skinParam;

    public CommunicationTileSelf(LivingSpace livingSpace, Message message, Skin skin, ISkinParam iSkinParam) {
        this.livingSpace1 = livingSpace;
        this.message = message;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    private Component getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        arrowConfiguration = arrowConfiguration.self();
        Component component = this.skin.createComponent(ComponentType.ARROW, arrowConfiguration, this.skinParam, this.message.getLabel());
        return component;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getPoint1(stringBounder).getCurrentValue();
        Area area = new Area(dimension2D.getWidth(), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        component.drawU(uGraphic, area, new SimpleContext2D(false));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        LivingSpace livingSpace = this.livingSpace1.getNext();
        if (livingSpace != null) {
            livingSpace.getPosB().ensureBiggerThan(this.getMaxX(stringBounder));
        }
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getPoint1(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        return this.livingSpace1.getPosC(stringBounder).addFixed(d);
    }
}

