# Generated by default/object.tt
package Paws::SSMIncidents::ResourcePolicy;
  use Moose;
  has PolicyDocument => (is => 'ro', isa => 'Str', request_name => 'policyDocument', traits => ['NameInRequest'], required => 1);
  has PolicyId => (is => 'ro', isa => 'Str', request_name => 'policyId', traits => ['NameInRequest'], required => 1);
  has RamResourceShareRegion => (is => 'ro', isa => 'Str', request_name => 'ramResourceShareRegion', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::ResourcePolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::ResourcePolicy object:

  $service_obj->Method(Att1 => { PolicyDocument => $value, ..., RamResourceShareRegion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::ResourcePolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->PolicyDocument

=head1 DESCRIPTION

The resource policy that allows Incident Manager to perform actions on
resources on your behalf.

=head1 ATTRIBUTES


=head2 B<REQUIRED> PolicyDocument => Str

The JSON blob that describes the policy.


=head2 B<REQUIRED> PolicyId => Str

The ID of the resource policy.


=head2 B<REQUIRED> RamResourceShareRegion => Str

The Region that policy allows resources to be used in.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

