/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.lexicon;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import opennlp.grok.datarep.MorphItem;
import opennlp.grok.lexicon.XtagMorphDataIntf;

class XtagMorphDataDB
implements XtagMorphDataIntf {
    Connection C;
    String[] macros = new String[32];

    XtagMorphDataDB() {
    }

    public boolean init(Properties g) {
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (Exception E) {
            System.err.println("Unable to load driver.");
            return false;
        }
        String host = g.getProperty("host");
        String db = "jdbc:mysql://" + host + "/xtagmorph?user=jdbc";
        if (host != null) {
            try {
                this.C = DriverManager.getConnection(db);
            }
            catch (SQLException E) {
                System.out.println("SQLException: " + E.getMessage());
                return false;
            }
        } else {
            return false;
        }
        try {
            Statement stmt = this.C.createStatement();
            String query = "Select * from macros";
            ResultSet RS = stmt.executeQuery(query);
            while (RS.next()) {
                this.macros[RS.getInt((String)"bit")] = RS.getString("macro");
            }
        }
        catch (SQLException E) {
            E.printStackTrace();
            return false;
        }
        return true;
    }

    private Collection collect(ResultSet RS) {
        ArrayList<MorphItem> list = new ArrayList<MorphItem>();
        try {
            while (RS.next()) {
                MorphItem mi = new MorphItem();
                mi.setWord(RS.getString("word"));
                mi.setStem(RS.getString("stem"));
                mi.setPOS(RS.getString("pos"));
                boolean inf = false;
                int bits = RS.getInt("macros");
                int i = 0;
                while (i < this.macros.length) {
                    if ((bits & 1) == 1) {
                        mi.addMacro("@" + this.macros[i]);
                        if (this.macros[i].equals("INF")) {
                            inf = true;
                        }
                    }
                    bits >>= 1;
                    ++i;
                }
                list.add(mi);
                if (!inf) continue;
                MorphItem mi2 = mi.copy();
                mi2.removeMacro("@INF");
                mi2.addMacro("@not-3sg");
                mi2.addMacro("@PRES");
                list.add(mi2);
            }
        }
        catch (SQLException E) {
            E.printStackTrace();
            return list;
        }
        return list;
    }

    public Collection getMorphItems(String word) {
        try {
            Statement stmt = this.C.createStatement();
            String query = "select * from morphs where STRCMP(word, \"" + word + "\")=0";
            ResultSet RS = stmt.executeQuery(query);
            return this.collect(RS);
        }
        catch (SQLException E) {
            E.printStackTrace();
            return null;
        }
    }

    public Collection getHeadMorphs(String word) {
        try {
            Statement stmt = this.C.createStatement();
            String query = "select * from morphs where stem=\"" + word + "\"";
            ResultSet RS = stmt.executeQuery(query);
            return this.collect(RS);
        }
        catch (SQLException E) {
            E.printStackTrace();
            return null;
        }
    }
}

